/*
 * C Language interface.  SUN.
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#ifdef THREEHEAD
#include "scib.h"
#endif /* THREEHEAD */
#include "ugpib.h"

#ifdef V403
#define Ioctl(f,c,a) ioctl((f),IOC_INOUT|((sizeof *(a)&IOCPARM_MASK)<<16)|(c),(a))
#else
#define Ioctl(f,c,a) ioctl((f),_IOC_INOUT|((sizeof *(a)&_IOCPARM_MASK)<<16)|(c),(a))
#endif V403

extern errno;
#ifdef THREEHEAD
extern unsigned int ibsta, ibcnt, iberr;
#else
unsigned int ibsta,ibcnt,iberr;
#endif /* THREEHEAD */

static struct ibarg ibarg;
static struct ibinfo ibinfo;
static char *devnam();
/*488.2*/
#define MAX_BRDS 4
static int b_desc[MAX_BRDS]={-1,-1,-1,-1};
static unsigned int retval;          /* FindRQS or PPoll return value */


/*
 * common function to set up ioctl, make call
 * and set global variables
 */
static fn2(code, f, ibarg) struct ibarg ibarg;{

	if (Ioctl(f, code, &ibarg) < 0)
		return oserr();
	ibcnt = ibarg.ibcnt;
	iberr = ibarg.iberr;
        if ((code == FINDRQS) || (code == PPOLL)){
                retval = ibarg.n;
        }
	return ibsta = ibarg.ibsta;
}
/*
 * operating system error:
 *      error code EDVR indicates OS error code is in ibcnt
 */
static oserr() {
	iberr = EDVR;
	ibcnt = errno;
	return ibsta = ERR;
}
/*
 * GPIB error return
 */
static error(n) {
	iberr = n;
	ibcnt = 0;
	return ibsta = ERR|CMPL;
}

/* used by 488 functions to update the buffer and count in ibarg */
static fn (code, f, buf, v) char *buf; {
        ibarg.buf = (long)buf;
        ibarg.n = v;
        return fn2(code,f,ibarg);       /* fn2 calls ioctl */
}

/*
 * ibfind opens a device name for reading and writing.
 * The file descriptor is the return value.
 * The handler determines board/device number based on
 * UNIX minor device number.
 */
ibfind  (bdname) char bdname[]; {
        int filedesc;
        filedesc = devopen(bdname,2);
	return filedesc;
}

static char *db;   /* dummy buffer (compiles to correct size for table) */

/* devopen calls the UNIX open function. The file decriptor returned is
 * added to [BRD|DEV]HANDLE before it is passed back to the user to distinguish
 * it from 488.2 calls.  If this is a board open call, put the fd in the array
 */
static devopen (bdname, ioperm) char bdname[]; {
        int fd, chkdev; /* if chkdev == MAX_BRDS -- is a device
                                     >=0 && <= 3 -- board number
                        */
        fd = open(devnam(bdname,&chkdev),ioperm);
        if (fd != -1){
	        fn(IBSTAT,  fd, db, 0);
                if ((chkdev < MAX_BRDS) && (chkdev >= 0)){
                        b_desc[chkdev] = fd;  /* board open, put fd in array */
                        fd = BRDHANDLE + chkdev;
                                        /* to distinguish it from a 488.2 call*/
                }
                else fd += DEVHANDLE;           /* device name */
        }
	else {
           ibsta= ERR;
           ibcnt= errno;
           iberr= EDVR;
        }
        return fd;
}

/*
 * Takes a name and returns the name prepended with /dev/ if necessary.
 */
static char *devnam (name,chkdev) char name[]; int *chkdev; {
	static char slashdev[]="/dev/xxxxxxxxxxxxxx";
	static char prependdev[]="/dev/gpibx";
	register char *p, *p1, brdch[2];
	int i;

	p1= name;
	if (strncmp("/dev/",p1,5) == 0){
                p = name;               /* is this a board or device name? */
                for (i=0;i<5;i++)
                        *p++;
                if (strncmp("gpib",p,4) == 0){
                        brdch[0] = name[9];
                        brdch[1] = '\0';
                        *chkdev = atoi(brdch);
                }
                else *chkdev = MAX_BRDS;
		return p1;
	}

        if (strncmp("gpib",p1,4) == 0){ /* is this a board or device name? */
                brdch[0] = name[4];
                brdch[1] = '\0';
                *chkdev = atoi(brdch);
        }
        else *chkdev = MAX_BRDS;
	for (p = &slashdev[5]; p < &slashdev[19]; )
		if ((*p++ = *p1++) == '\0')
			break;
	return slashdev;
}


/* calls the UNIX close function. If this is a board call, delete the entry
 * from the board array.
 */
static devclose ( fd ) {
        int i, brdfd;

        if ((fd >= BRDHANDLE) && (fd < BRDHANDLE + MAX_BRDS)){
                fd -= BRDHANDLE;
                brdfd = b_desc[fd];     /* get board fd from array */
                b_desc[fd] = -1;
                close(brdfd);
        }
        else if (fd >= DEVHANDLE){
                fd -= DEVHANDLE;
                close(fd);
        }
}




ibdev (index,pad,sad,tmo,eot,eos) {

	register short err=0;
	struct device device;
	register struct device *d= &device;
	char bdname[18];
        unsigned char buf[DNMSZ];
	int g, tmpg;
	struct ibarg ibarg;

	if (index == 0 || index == 1)
		sprintf(bdname, "/dev/gpib%d",index);
	else 
		return error(EARG);

	if ((g=devopen(bdname,2)) < 0) 
		return oserr();

	tmpg= g;
	getfd(&g);
	ibarg.bufch= buf;
	fn2(FINDDEV, g, ibarg);
	devclose(tmpg);
	if (buf[0] == 0) {		/* Can't get an unopen device */
		err = 1;
		return oserr();
	}
	sprintf(bdname, "/dev/%s", buf);
	if ((g=devopen(bdname,2)) < 0)
		return oserr ();

        tmpg = g;
        getfd(&g);
	/* determine type of access */
	if (Ioctl(g,IBGET,&device))
		return oserr();
	if (pad > 036) {		/* primary address */
		iberr = EARG;	
		ibsta = ERR|CMPL;
	}
	else 	d->d_pad = pad;
	if ((sad < 0140 || sad > 0176) && sad != ALL_SAD && sad != NO_SAD) {
		iberr = EARG;
		ibsta = ERR|CMPL;
	}
	else 	d->d_sad = sad;
	if (tmo < 0 || tmo > T1000s){
		iberr = EARG;
		ibsta = ERR|CMPL;
	}
	else	d->d_tmo = tmo;
	if (eot)
		d->d_uflags |= EOT;
	else	d->d_uflags &= ~EOT;
	if ((eos>>8)&~EOSM) {
		iberr = EARG;
		ibsta = ERR|CMPL;
	}
	else {
		d->d_uflags = (d->d_uflags & ~EOSM)|(eos?(eos>>8):0);
		d->d_eos = eos&0xFF;
	}
	if (Ioctl(g,IBSET,&device))
		return oserr();
	return (tmpg);
}
	
ibln (g,pad,sad,listen) short *listen;
{
	short psad=0;
	
        getfd(&g);
	psad = (pad & 0xff)|((sad << 8)&0xff00);	
	return fn(IBLN, g, (char *)listen, psad);
}

/*
 * file I/O routines:
 */

#define FBSIZE  512             /* size of buffer for file I/O */
static char buf[FBSIZE*2];

/*
 * write file.
 * double buffering is used not for improved throughput, but
 * for determining the last buffer before it is sent.
 */
ibwrtf(g, file) char file[]; {
	int f, i, cnt[2], total=0, tmpg;
	struct board board;
	ushort wrtfail=0, sta=0, err=0;
	char eot;

	if ((f=open(file, 0)) < 0)
		return oserr();
	tmpg = g;
	getfd(&g);
	if (Ioctl(g,IBGET,&board)<0)    /* get eot mode */
		goto bad;
	eot = board.b_uflags & EOT;     /* save it */
	board.b_uflags &= ~EOT;         /* clear it */
	if (Ioctl(g,IBSET,&board)<0)
		goto bad;
	board.b_uflags |= eot;          /* restore it */

	i= 0;
	if ((cnt[0]=read(f, buf, FBSIZE)) < 0) {
		oserr();
		goto bad;
	}
	while (cnt[i]) {
		i= !i ;
		if ((cnt[i]=read(f, &buf[i*FBSIZE], FBSIZE)) < 0) {
			oserr();
			goto bad;
		}
		if (cnt[i] == 0)  /* then the previous read reached the eof */
			if (Ioctl(g,IBSET,&board)<0)    /* restore eot mode */
				goto bad;
		if ((sta=ibwrt(tmpg, &buf[!i * FBSIZE], cnt[!i])) & ERR) {
			wrtfail = 1;
			err = iberr;
			goto bad;
		}
		total += ibcnt;
	}
	goto ret;
bad:    Ioctl(g,IBSET,&board);  /* restore eot mode */
	ibeot(tmpg, eot);
	if (wrtfail) {		/* restore the write fail status and err */
		ibsta = sta;
		iberr = err;
	}
ret:    close(f);
	ibcnt = total;
	return ibsta;
}

/*
 * read file.
 */
ibrdf(g, file) char file[]; {
	int f, total=0;

	if ((f=creat(file, 0644)) < 0)
		return error(EFSO);
	do {    if (ibrd(g, buf, FBSIZE*2) & ERR)
			goto bad;
		if (write (f, buf, ibcnt) != ibcnt)
			goto bad;
		total += ibcnt;
	} while ((ibsta & END) == 0);
bad:    close(f);;
	ibcnt = total;
	return ibsta;
}


/* this function determines whether the input parameter is for a device name,
 * a board name, or a 488.2 style board name (eg: ibtmo (0,13)).
 * If this is a board name, get the file descriptor from the board array.
 * If this is a 488.2 style descriptor, and the board is unopened, open it.
 */
void getfd ( fd ) int *fd; {
        int brdfd;

        if (*fd >= DEVHANDLE){          /* get device fd */
                *fd -= DEVHANDLE;
        }
        else if ((*fd >= BRDHANDLE) && (*fd < BRDHANDLE + MAX_BRDS)){
                *fd -= BRDHANDLE;
                *fd = b_desc[*fd];      /*get board fd from array */
        }
        else if ((*fd >= 0) && (*fd < MAX_BRDS))
                if (b_desc[*fd] != -1){
                        *fd = b_desc[*fd];
                }
                else {
                        brdfd = dev2open(*fd,2);
                        b_desc[*fd] = brdfd;
                        *fd = brdfd;
                }
}

static dev2open ( brdnum, ioperm) {
        char brdch;
        static char boardname[]="/dev/gpibx";
        int fd;

        brdch = toascii(brdnum + 48);   /* convert board number to ascii */
        boardname[9] = brdch;
        fd = open(boardname,ioperm);
        return fd;
}

/*
 * ibbna changes a device's access board.
 */
ibbna(g,bname) char bname[]; {
	struct device device;
	struct stat sbuf;
	int n, chkdev;
	char *p;

	chkdev = -1;
	getfd(&g);
	if (Ioctl(g,IBINFO,&ibinfo)<0)
		return oserr();
	if (ibinfo.isdev==0)                     /* g a device index ? */
		return error(ECAP);
	if (stat(devnam(bname,&chkdev),&sbuf) < 0)      /* stat board name */
		return error(EARG);

	n = 255-minor(sbuf.st_rdev);
	if (n >= ibinfo.bcnt)                   /* board index? */
		return error(EARG);
	if (Ioctl(g,IBGET,&device)<0)
		return oserr();
	iberr = device.d_bna;           /* previous value */
	device.d_bna = n;
	if (Ioctl(g,IBSET,&device)<0)
		return oserr();
	ibcnt = 0;
	return ibsta=CMPL;
}


/*
 *    Function: cnvrt2int
 *
 *    This function takes a null terminated string and converts the ASCII
 *    integer contained in the string into an integer.  The range is
 *    -32767 to 32767.
 *    The value -32768 is returned if an error in conversion occurs.
 *
 */
#define NumBASE   10    /* Convert to base 10. */

static int cnvrt2int(sp)
u_char *sp;

{
   int     digit   = 0;       /* numeric value of ASCII digit  */
   int     valid   = 1;       /* Is the conversion ok?         */
   int     n       = 0;       /* accumulator for number        */
   int     sign;              /* Sign value of the number.     */

   /*  Skip any leading white space (as defined by the 488.2 spec).
    */
   while ( (*sp <= 0x09) ||
          ((*sp >= 0x0B) && (*sp <= 0x20))) {
      sp++;
   };

   /*  Check for a negative number.
    */
   if (*sp == '-') {
      sign = -1;
      sp++;
   }
   else {
      sign = 1;
   }

   /*  For each character in the string convert it into an integer.  Keep
    *  the running total in 'n'.  If an error occurs while trying to convert
    *  a number, exit the loop.
    *  NOTE: We should stay in this loop while the character is not NULL,
    *        while the character is valid, and while the character is not
    *        a new-line.
    */
   while ((*sp) && (*sp != '\n') && valid) {
      digit = 0;
      valid = 0;
      while (digit < NumBASE) {
         if (*sp == (u_char)(digit+0x30)) {
            n = (n * NumBASE) + digit;
            valid = 1;
            break;
         }
         else {
            digit++;
         }
      }
      sp++;
   }

   if (valid) {
      return (sign * n);
   }
   else {
      return -32768;
   }
}  /* end cnvrt2int */


static int tmpg;   /* holds fd for a ibonl call; used by devclose */

ibdiag  (g, buf, cnt) char *buf;{ getfd(&g); return fn(IBDIAG,  g, buf, cnt);  }
ibrd    (g, buf, cnt) char *buf; long cnt;{ 
	getfd(&g);
	read(g, buf, cnt);
	return fn(IBSTAT,  g, db, 0);
}
ibrda   (g, buf, cnt) char *buf;long cnt;{ return error(ECAP); }
ibwrt   (g, buf, cnt) char *buf; long cnt;{
	getfd(&g);
	write(g, buf, cnt);
	return fn(IBSTAT,  g, db, 0);
}
ibwrta  (g, buf, cnt) char *buf; long cnt;{ return error(ECAP);		    }
ibcmda  (g, buf, cnt) char *buf; long cnt;{ return error(ECAP);		    }
ibcmd   (g, buf, cnt) char *buf; long cnt;{ getfd(&g); return fn(IBCMD,  g, buf, cnt);   }
ibtrg   (g)                     { getfd(&g); return fn(IBTRG,  g, db, 0);      }
ibclr   (g)                     { getfd(&g); return fn(IBCLR,  g, db, 0);      }
ibpct   (g)                     { getfd(&g); return fn(IBPCT,  g, db, 0);      }
ibllo   (g)                     { getfd(&g); return fn(IBLLO,  g, db, 0);      }
ibloc   (g)                     { getfd(&g); return fn(IBLOC,  g, db, 0);      }
ibrsp   (g, buf) char *buf;     { getfd(&g); return fn(IBRSP,  g, buf, 0);     }
ibrsv   (g, v)                  { getfd(&g); return fn(IBRSV,  g, db, v);      }
ibwait  (g, mask)               { getfd(&g); return fn(IBWAIT, g, db, mask);   }
ibrpp   (g, buf) char *buf;     { getfd(&g); return fn(IBRPP,  g, buf, 0);     }
ibsic   (g, v)                  { getfd(&g); return fn(IBSIC,  g, db, v);      }
ibsre   (g, v)                  { getfd(&g); return fn(IBSRE,  g, db, v);      }
ibonl   (g, v)                  { tmpg = g; getfd(&g); fn(IBONL,  g, db, v);
				  if (v==0 && (ibsta&ERR)==0)
				    devclose(tmpg);  return (ibsta=CMPL); }
ibgts   (g, v)                  { getfd(&g); return fn(IBGTS,  g, db, v);      }
ibcac   (g, v)                  { getfd(&g); return fn(IBCAC,  g, db, v);      }
ibpoke  (g, pv)                 { getfd(&g); return fn(IBPOKE, g, db, pv);     }
ibsgnl  (g, v)                  { getfd(&g); return fn(IBSGNL, g, db, v);      }
ibrsc   (g, v)                  { getfd(&g); return fn(IBRSC,  g, db, v);      }
iblines (g, buf) short *buf;	{ getfd(&g); return fn(IBSLINE, g, buf, 0);    }
ibxtrc  (g, buf, cnt) char *buf;{ getfd(&g); return fn(IBXTRC, g, buf, cnt);   }

ibppc   (g, v)                  { getfd(&g); return fn(IBPPC,  g, db, v);      }
ibist	(g, v)			{ getfd(&g); return fn(IBSIST,  g, db, v);     }
ibeot   (g, v)                  { getfd(&g); return fn(IBEOT,  g, db, v);      }
ibpad   (g, v)            	{ getfd(&g); return fn(IBPAD,  g, db, v);      }
ibsad   (g, v)                  { getfd(&g); return fn(IBSAD,  g, db, v);      }
ibdma   (g, v)                  { getfd(&g); return fn(IBDMA,  g, db, v);      }
ibeos   (g, v)                  { getfd(&g); return fn(IBEOS,  g, db, v);      }
ibtmo   (g, v)                  { getfd(&g); return fn(IBTMO,  g, db, v);      }

int ibask(g, o, v) int o, *v;  {	int tmp;
					getfd(&g); 
				  	ibarg.n1 = o;
					ibarg.buf= (long)v;
					tmp=fn2(IBASK,g,ibarg);
				  	return tmp;			}

int ibconfig(g, o, v) int o, v;  {	getfd(&g); 
				  	ibarg.n1 = o;
				  	ibarg.n2 = v;
				  	return fn2(IBCONFIG,g,ibarg);      }


/* NI-488.2 functions */
static ushort templist[2]={NOADDR,NOADDR};
/* array passed by special case functions
				  * the address is passed in the first position
				  * of the array, second position is NOADDR.
				  */
static int tmpb;		 /* temporary hold for the board descriptor */

void AllSpoll		(b,taddrs,res) ushort taddrs[], res[]; {
			getfd(&b);
			ibarg.buf1 = taddrs;
			ibarg.buf2 = res;
			fn2(ALLSPOLL,b,ibarg);
			res = ibarg.buf2;
} 
void DevClearList	(b,addrlist) ushort addrlist[]; {
			getfd(&b);
			ibarg.buf1 = addrlist;
			fn2(DEVCLEARLIST,b,ibarg);
}
void DevClear		(b,addr) ushort addr; {
			/* calls DevClearList */
			templist[0] = addr;
			DevClearList(b,templist);
}		
void EnableLocal	(b,laddrs) ushort laddrs[]; {
			getfd(&b);
			ibarg.buf1 = laddrs;
			fn2(ENABLELOCAL,b,ibarg);
}
void EnableRemote	(b,laddrs) ushort laddrs[]; {
			getfd(&b);
			ibarg.buf1 = laddrs;
			fn2(ENABLEREMOTE,b,ibarg);
}
void FindRQS		(b,taddrs,dev_stat) ushort taddrs[], *dev_stat; {
			getfd(&b);
			ibarg.buf1 = taddrs;
			fn2(FINDRQS,b,ibarg);
			if (dev_stat)
				*dev_stat = retval;
} 
void FindLstn		(b,addrlist,reslist,limit) ushort addrlist[], reslist[], 
									limit; {
			getfd(&b);
			ibarg.buf1 = addrlist;
			ibarg.buf2 = reslist;
			ibarg.n = limit;
			fn2(FINDLSTN,b,ibarg);
			reslist = ibarg.buf2;
} 
void PassControl	(b,talker) ushort talker; {
			getfd(&b);
			ibarg.n = talker;
			fn2(PASSCONTROL,b,ibarg);
}	
void PPollConfig	(b,laddr,dataline,sense) ushort laddr, dataline, sense; {
			getfd(&b);
			ibarg.n = laddr;
			ibarg.n1 = dataline;
			ibarg.n2 = sense;
			fn2(PPOLLCONFIG,b,ibarg);
}
void PPollUnconfig	(b,laddrs) ushort laddrs[]; {
			getfd(&b);
			ibarg.buf1 = laddrs;
			fn2(PPOLLUNCONFIG,b,ibarg);
}	
void PPoll 		(b,res_ptr) ushort *res_ptr; {
			getfd(&b);
			fn2(PPOLL,b,ibarg);
			if (res_ptr)
				*res_ptr = retval;
}
void ReadStatusByte	(b,talker,result) ushort talker, *result; {
			/* calls AllSpoll */
			ushort resultlist[1];   /*result passed back in array */ 
			templist[0] = talker;
			AllSpoll(b,templist,resultlist);
			if (result)
				*result = resultlist[0];
} 
void Receive            (b,talker,buf,cnt,eotmode) ushort talker; u_char *buf;
                                                u_int cnt; ushort eotmode; {
int tmpsta,tmpcnt;
                        tmpb = b;
                        getfd(&b);
                        ibarg.n = talker;
                        ibarg.bufch = buf;
                        ibarg.lcnt = cnt;
                        ibarg.n1 = eotmode;
                        fn2(RECEIVE,b,ibarg);
                        if (iberr == EARG)
                                return;
                        if (ERR&ibrd(tmpb,(char *)buf,cnt)) return;
                        tmpsta= ibsta;
                        tmpcnt= ibcnt;
                        ibeot(tmpb,1);
                        ibeos(tmpb,0);
                        ibsta= tmpsta;
                        ibcnt= tmpcnt;
}       
void RcvRespMsg         (b,buf,cnt,eotmode) u_char *buf; u_int cnt;
                                                        ushort eotmode; {
int tmpsta,tmpcnt;
                        tmpb = b;
                        getfd(&b);
                        ibarg.bufch = buf;
                        ibarg.lcnt = cnt;
                        ibarg.n = eotmode;
                        fn2(RCVRESPMSG,b,ibarg);
                        if (iberr == EARG)
                                return;
                        if (ERR&ibrd(tmpb,(char *)buf,cnt)) return;
                        tmpsta= ibsta;
                        tmpcnt= ibcnt;
                        ibeot(tmpb,1);
                        ibeos(tmpb,0);
                        ibsta= tmpsta;
                        ibcnt= tmpcnt;
}
void ReceiveSetup	(b,talker) ushort talker; {
			getfd(&b);
			ibarg.n = talker;
			fn2(RECEIVESETUP,b,ibarg);
}	
void SendList           (b,listeners,buf,cnt,eotmode) ushort listeners[];
                                u_char *buf; u_int cnt; ushort eotmode; {
int tmpsta,tmpcnt;
 
                        tmpb = b;
                        getfd(&b);
                        ibarg.buf1 = listeners;
                        ibarg.bufch = buf;
                        ibarg.lcnt = cnt;
                        ibarg.n = eotmode;
                        fn2(SENDLIST,b,ibarg);
                        if (iberr == EARG)
                                return;
                        if (eotmode==DABend) ibeot(tmpb,1);
                        else ibeot(tmpb,0);
                        ibeos(tmpb,0);
                        if (ERR&ibwrt(tmpb,(char *)buf,cnt)) return;
                        tmpsta= ibsta;
                        tmpcnt= ibcnt;
                        if (eotmode==NLend) {
                           if (ERR&ibeot(tmpb,1)) return;
                           if (ERR&ibeos(tmpb,0xc0a)) return;
                           if (ERR&ibwrt(tmpb,"\n",1)) return;
                           tmpcnt++;
                        }
                        ibeot(tmpb,1);
                        ibeos(tmpb,0);
                        ibsta= tmpsta;
                        ibcnt= tmpcnt;
        
}        
void Send		(b,listener,buf,cnt,eotmode) ushort listener;
				u_char *buf; uint cnt; ushort eotmode; {
			/* calls SendList */
			templist[0] = listener;
			SendList(b,templist,buf,cnt,eotmode);
}	
void SendCmds		(b,buf,cnt) u_char *buf; u_int cnt; {
			getfd(&b);
			ibarg.buf = (long)buf;
			ibarg.lcnt = cnt;
			fn2(SENDCMDS,b,ibarg);
}	

void SendDataBytes      (b,buf,cnt,eotmode) 
u_char *buf; 
u_int cnt;
ushort eotmode; 
{
    
    int tmpsta,tmpcnt;

    tmpb = b;
    getfd(&b);
    ibarg.bufch = buf;
    ibarg.lcnt = cnt;
    ibarg.n = eotmode;
    fn2(SENDDATABYTES,b,ibarg);
    if (iberr == EARG)
	return;
    if (eotmode==DABend) ibeot(tmpb,1);
    else ibeot(tmpb,0);
    ibeos(tmpb,0);
    if (ERR&ibwrt(tmpb,(char *)buf,cnt)) return;
    tmpsta= ibsta;
    tmpcnt= ibcnt;
    if (eotmode==NLend) {
	if (ERR&ibeot(tmpb,1)) return;
	if (ERR&ibeos(tmpb,0xc0a)) return;
	if (ERR&ibwrt(tmpb,"\n",1)) return;
	tmpcnt++;
    }
    ibeot(tmpb,1);
    ibeos(tmpb,0);
    ibsta= tmpsta;
    ibcnt= tmpcnt;
}

void SendIFC		(b) {
			getfd(&b);
			fn2(SENDIFC,b,ibarg);
}	
void ResetSys		(b,laddrs) ushort laddrs[]; {
			tmpb = b;
			getfd(&b);
			ibarg.buf1 = laddrs;
			fn2(RESETSYS,b,ibarg);
			if (ibsta & ERR)
				return;
 			SendList(tmpb, laddrs, (u_char *)("*RST"), 4, NLend);
}	
void SendLLO		(b) {
			getfd(&b);
			fn2(SENDLLO,b,ibarg);
}	
void SendSetup		(b,listen) ushort listen[]; {
			getfd(&b);
			ibarg.buf1 = listen;
			fn2(SENDSETUP,b,ibarg);
}	
void SetRWLS		(b,laddrs) ushort laddrs[]; {
			getfd(&b);
			ibarg.buf1 = laddrs;
			fn2(SETRWLS,b,ibarg);
}	
void TestSRQ		(b,result) ushort *result; {
			/* calls ibwait */
			ibwait(b, 0);
			if (result)
				*result = (ibsta & SRQI) ? 1 : 0;
}		
void TestSys		(b,addrs,result) ushort addrs[], result[]; {
			u_char res_buf[12];
			u_char old_timo;
			int status, done=0, index=0, failed=0, tmperr;

			if ((!addrs) || (addrs[0] == NOADDR)){
				getfd(&b);
				fn(IBSTAT,b,db,0);
				ibsta |= ERR;
				iberr = EARG;
				return;
			}  
			ibtmo(b,T10s);
			old_timo = iberr;
   			SendList(b, addrs, (u_char *)("*TST?"), 5, NLend);
			SendCmds(b,(u_char *)"?",1);
			while (!done){
				if (addrs[index] == NOADDR) 
					done = 1;
				else {
					Receive(b,addrs[index],res_buf,10,STOPend);
					res_buf[ibcnt] = '\0';
					result[index] = (ushort)cnvrt2int(res_buf);
					if (result[index]) failed++;
					index++;
				}
			}
			tmperr = iberr;
			ibtmo(b,old_timo);	
			iberr = tmperr;
			if (failed)
				ibcnt = failed;
			else	ibcnt = 0;
}	
void TriggerList	(b,laddrs) ushort laddrs[]; {
			getfd(&b);
			ibarg.buf1 = laddrs;
			fn2(TRIGGERLIST,b,ibarg);
}	
void Trigger		(b,laddr) ushort laddr; {
			/* calls TriggerList */
			templist[0] = laddr;
			TriggerList(b,templist);
}	
void WaitSRQ		(b,result) ushort *result; {
			/* calls ibwait */
			ibwait(b, (TIMO|SRQI));
			if (result)
				*result = (ibsta & SRQI) ? 1 : 0;
}


