/*
 *****************************************************************************
 *
 *        Copyright 1989, Xylogics, Inc.  ALL RIGHTS RESERVED.
 *
 * ALL RIGHTS RESERVED. Licensed Material - Property of Xylogics, Inc.
 * This software is made available solely pursuant to the terms of a
 * software license agreement which governs its use.
 * Unauthorized duplication, distribution or sale are strictly prohibited.
 *
 * Module Description::
 *
 * 	%$(Description)$%
 *
 * Original Author: %$(author)$%	Created on: %$(created-on)$%
 *
 * Module Reviewers:
 *
 *	%$(reviewers)$%
 *
 * Revision Control Information:
 *
 * $Header: /annex/common/src/./netadm/RCS/get_tr_cnt.c,v 1.3 1991/04/09 00:12:37 emond Rel $
 *
 * Revision History:
 *
 * $Log: get_tr_cnt.c,v $
 * Revision 1.3  1991/04/09  00:12:37  emond
 * Accommodate generic TLI interface
 *
 * Revision 1.2  89/04/05  12:44:21  loverso
 * Changed copyright notice
 * 
 * Revision 1.1  89/03/27  10:38:24  townsend
 * Initial revision
 * 
 *
 * $Locker:  $
 *
 *****************************************************************************
 */

#define RCSDATE $Date: 1991/04/09 00:12:37 $
#define RCSREV	$Revision: 1.3 $
#define RCSID   "$Header: /annex/common/src/./netadm/RCS/get_tr_cnt.c,v 1.3 1991/04/09 00:12:37 emond Rel $"
#ifndef lint
static char rcsid[] = RCSID;
#endif

/* Include Files */
#include "../inc/config.h"

#include <sys/types.h>
#include <netinet/in.h>
#include <sys/uio.h>
#include "../libannex/api_if.h"

#include "../inc/courier/courier.h"
#include "../inc/erpc/netadmp.h"
#include "netadm.h"
#include "netadm_err.h"

/* External Data Declarations */


/* Defines and Macros */

#define OUTGOING_COUNT  0

/* Structure Definitions */


/* Forward Routine Declarations */


/* Global Data Declarations */


/* Static Declarations */


get_trunk_count(Pinet_addr, type, Pdata)
    struct sockaddr_in *Pinet_addr;
    u_short         type;
    char            *Pdata;

{
    struct iovec    outgoing[OUTGOING_COUNT + 1];

    /* Check *Pinet_addr address family. */

    if (Pinet_addr->sin_family != AF_INET)
        return NAE_ADDR;

    /* Set up outgoing iovecs.
     *  outgoing[0] is only used by erpc_callresp().
     */

    /* Call rpc() to communicate the request to the annex via erpc or srpc. */

    return rpc(Pinet_addr, RPROC_GET_TRUNKS, OUTGOING_COUNT, outgoing,
	       Pdata, type);

}   /* get_trunk_count() */
