/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import com.apple.gui.GUIFactory;
import com.apple.gui.menu.Menu;
import com.apple.util.plist.PropertyListUtilities;
import com.apple.xsr.Resources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class MenuManager {
    public static final String DEFAULT_RESOURCE_PLIST = "com.apple.xsr.resources.UIResources";
    public static final String DEFAULT_MENU_BAR_ID = "default";
    public static final String MENU_ELEMENT_ID = "MENU_ELEMENT_ID";
    private static final Logger logger = Logger.getLogger(class$com$apple$gui$MenuManager != null ? class$com$apple$gui$MenuManager : (class$com$apple$gui$MenuManager = MenuManager.class$("com.apple.gui.MenuManager")));
    private static final MenuManager INSTANCE = new MenuManager();
    private Map menuBarResources;
    private Map registry = new HashMap();
    static /* synthetic */ Class class$com$apple$gui$MenuManager;
    static /* synthetic */ Class class$com$apple$xsr$Resources;

    private MenuManager() {
        String plist = DEFAULT_RESOURCE_PLIST;
        Object o = MenuManager.loadPropertyList(MenuManager.getLoader(this.getClass()), plist);
        if (o != null) {
            this.parseCommonProperties(o);
            try {
                this.menuBarResources = (Map)PropertyListUtilities.extractWithPath(o, "/menu-bars");
            }
            catch (Exception e) {
                logger.error("\"menu-bars\" dictionary not found in " + plist + ". " + e);
            }
        } else {
            logger.error("Failed to load resource plist " + plist);
        }
    }

    public static MenuManager getInstance() {
        return INSTANCE;
    }

    public void register(String id, Action action) {
        if (id == null) {
            throw new NullPointerException("ID cannot be null");
        }
        this.registry.put(id, action);
    }

    public void register(String id, ActionListener listener) {
        if (id == null) {
            throw new NullPointerException("ID cannot be null");
        }
        this.registry.put(id, listener);
    }

    public void register(String id, MenuListener listener) {
        if (id == null) {
            throw new NullPointerException("ID cannot be null");
        }
        this.registry.put(id, listener);
    }

    public JMenuBar newMenuBar() {
        return this.createMenuBar(DEFAULT_MENU_BAR_ID);
    }

    public JMenuBar newMenuBar(String id) {
        return this.createMenuBar(id);
    }

    public EditMenuListener newEditMenuListener(String cutItemId, String copyItemId, String pasteItemId, String selectAllItemId) {
        return new EditMenuListener(cutItemId, copyItemId, pasteItemId, selectAllItemId);
    }

    public CloseWindowListener newCloseWindowListener() {
        return new CloseWindowListener();
    }

    public String getHelpMenuId() {
        return "application.menu.help";
    }

    public static JMenu getMenu(JMenuBar menuBar, String menuId) {
        if (menuBar == null) {
            throw new NullPointerException("menu bar cannot be null");
        }
        if (menuId == null) {
            throw new NullPointerException("menu ID cannot be null");
        }
        MenuElement[] menus = menuBar.getSubElements();
        int i = 0;
        while (i < menus.length) {
            JMenu menu;
            if (menus[i] instanceof JMenu && (menu = (JMenu)menus[i]).getClientProperty(MENU_ELEMENT_ID).equals(menuId)) {
                return menu;
            }
            ++i;
        }
        return null;
    }

    public static JMenuItem getMenuItem(JMenu menu, String menuItemId) {
        if (menu == null) {
            throw new NullPointerException("menu cannot be null");
        }
        if (menuItemId == null) {
            throw new NullPointerException("menu item ID cannot be null");
        }
        Component[] components = menu.getMenuComponents();
        int i = 0;
        while (i < components.length) {
            JMenuItem item;
            if (components[i] instanceof JMenuItem ? (item = (JMenuItem)components[i]).getClientProperty(MENU_ELEMENT_ID).equals(menuItemId) : components[i] instanceof JMenu && (item = MenuManager.getMenuItem((JMenu)components[i], menuItemId)) != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public static void setMenuEnabled(JMenu menu, boolean enabled) {
        if (menu == null) {
            throw new NullPointerException("menu cannot be null");
        }
        if (menu instanceof Menu) {
            menu.setEnabled(enabled);
        } else {
            MenuManager.setMenuEnabledImpl(menu, enabled);
        }
    }

    public static void setMenuEnabledImpl(JMenu menu, boolean enabled) {
        Component[] comps = menu.getMenuComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] instanceof JMenu) {
                MenuManager.setMenuEnabled((JMenu)comps[i], enabled);
            } else if (comps[i] instanceof JMenuItem) {
                Action action = ((JMenuItem)comps[i]).getAction();
                if (action != null) {
                    action.setEnabled(enabled);
                } else {
                    comps[i].setEnabled(enabled);
                }
            } else if (!(comps[i] instanceof JSeparator)) {
                comps[i].setEnabled(enabled);
            }
            ++i;
        }
    }

    public static void setMenuEnabled(JMenuBar menuBar, String menuId, boolean enabled) {
        JMenu menu = MenuManager.getMenu(menuBar, menuId);
        if (menu != null) {
            MenuManager.setMenuEnabled(menu, enabled);
        }
    }

    public static void removeActions(JMenu menu) {
        Component[] comps = menu.getMenuComponents();
        int i = 0;
        while (i < comps.length) {
            JMenuItem item;
            if (comps[i] instanceof JMenu) {
                MenuManager.removeActions((JMenu)comps[i]);
            } else if (comps[i] instanceof JMenuItem && (item = (JMenuItem)comps[i]).getAction() != null) {
                item.setAction(null);
            }
            ++i;
        }
    }

    private void parseCommonProperties(Object o) {
        try {
            String guiFactoryClass = (String)PropertyListUtilities.extractWithPath(o, "/gui-factory");
        }
        catch (Exception exception) {}
    }

    private JMenuBar createMenuBar(String id) {
        Map props = (Map)this.menuBarResources.get(id);
        if (props == null) {
            logger.error("No resources found for menu bar ID \"" + id + "\"");
            return this.newMenuBarInstance();
        }
        String className = null;
        try {
            className = (String)PropertyListUtilities.extractWithPath(props, "/class");
        }
        catch (Exception exception) {}
        JMenuBar menuBar = this.newMenuBarInstance(className);
        try {
            List menus = (List)PropertyListUtilities.extractWithPath(props, "/menus");
            ListIterator iter = menus.listIterator();
            while (iter.hasNext()) {
                Map menuProps = (Map)iter.next();
                JMenu menu = this.createMenu(menuProps);
                menuBar.add(menu);
            }
        }
        catch (Exception e) {
            logger.error("\"menus\" dictionary not found for menu bar ID \"" + id + "\". " + e);
        }
        return menuBar;
    }

    private JMenu createMenu(Map props) {
        if (props == null) {
            throw new NullPointerException("properties map cannot be null");
        }
        String className = null;
        try {
            className = (String)PropertyListUtilities.extractWithPath(props, "/class");
        }
        catch (Exception exception) {}
        JMenu menu = this.newMenuInstance(className);
        this.initGenericMenuItemProperties(menu, props);
        try {
            String mnemonicKey = (String)PropertyListUtilities.extractWithPath(props, "/mnemonic-resource-key");
            menu.setMnemonic(Resources.getInt(mnemonicKey));
        }
        catch (Exception exception) {}
        try {
            Boolean tearOff = (Boolean)PropertyListUtilities.extractWithPath(props, "/is-tear-off");
        }
        catch (Exception exception) {}
        List items = null;
        try {
            items = (List)PropertyListUtilities.extractWithPath(props, "/items");
        }
        catch (Exception exception) {}
        if (items != null) {
            ListIterator iter = items.listIterator();
            while (iter.hasNext()) {
                try {
                    Map itemProps = (Map)iter.next();
                    String type = (String)PropertyListUtilities.extractWithPath(itemProps, "/type");
                    if (type.equals("menu-item")) {
                        JMenuItem item = this.createMenuItem(itemProps);
                        if (this.isExcluded(itemProps)) continue;
                        menu.add(item);
                        continue;
                    }
                    if (type.equals("menu")) {
                        JMenu subMenu = this.createMenu(itemProps);
                        if (this.isExcluded(itemProps)) continue;
                        menu.add(subMenu);
                        continue;
                    }
                    if (type.equals("separator")) {
                        if (this.isExcluded(itemProps)) continue;
                        menu.addSeparator();
                        continue;
                    }
                    logger.warn("Unrecognized menu object type \"" + type + "\"");
                }
                catch (Exception e) {
                    logger.error("Error adding item to menu " + menu.getClientProperty(MENU_ELEMENT_ID) + ": " + e);
                }
            }
        }
        return menu;
    }

    private JMenuItem createMenuItem(Map props) {
        if (props == null) {
            throw new NullPointerException("properties map cannot be null");
        }
        String className = null;
        try {
            className = (String)PropertyListUtilities.extractWithPath(props, "/class");
        }
        catch (Exception exception) {}
        JMenuItem menuItem = this.newMenuItemInstance(className);
        this.initGenericMenuItemProperties(menuItem, props);
        try {
            String acceleratorKey = (String)PropertyListUtilities.extractWithPath(props, "/accelerator-resource-key");
            KeyStroke keyStroke = Resources.getKeyStroke(acceleratorKey);
            if (keyStroke != null) {
                menuItem.setAccelerator(keyStroke);
            } else {
                logger.warn("Accelerator key stroke for menu item \"" + menuItem.getClientProperty(MENU_ELEMENT_ID) + "\" with resource \"" + acceleratorKey + "\" was null");
            }
        }
        catch (Exception exception) {}
        return menuItem;
    }

    private void initGenericMenuItemProperties(JMenuItem item, Map props) {
        Object o;
        if (item == null) {
            throw new NullPointerException("item cannot be null");
        }
        if (props == null) {
            throw new NullPointerException("property map cannot be null");
        }
        String nameKey = null;
        try {
            nameKey = (String)PropertyListUtilities.extractWithPath(props, "/name-resource-key");
            if (nameKey == null || nameKey.length() <= 0) {
                throw new MissingResourceException("Resource content empty", (class$com$apple$xsr$Resources != null ? class$com$apple$xsr$Resources : (class$com$apple$xsr$Resources = MenuManager.class$("com.apple.xsr.Resources"))).getName(), nameKey);
            }
            item.setText(Resources.getString(nameKey));
        }
        catch (NoSuchFieldException e) {
            logger.error("name-resource-key not found for " + item.getClientProperty(MENU_ELEMENT_ID) + " in menu item dictionary. " + e);
        }
        catch (MissingResourceException missingResourceException) {
            logger.error("Resource not found for \"" + nameKey + "\"");
        }
        catch (Exception e) {
            logger.error(e);
        }
        try {
            String actionCommand = (String)PropertyListUtilities.extractWithPath(props, "/action-command-key");
            item.setActionCommand(actionCommand);
        }
        catch (Exception exception) {}
        boolean enabled = true;
        try {
            enabled = (Boolean)PropertyListUtilities.extractWithPath(props, "/enabled");
        }
        catch (Exception exception) {}
        item.setEnabled(enabled);
        String id = null;
        try {
            try {
                id = (String)PropertyListUtilities.extractWithPath(props, "/id");
            }
            catch (Exception exception) {
            }
            Object var7_9 = null;
            if (id == null || id.length() == 0) {
                id = nameKey;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (id == null || id.length() == 0) {
                id = nameKey;
            }
            throw throwable;
        }
        item.putClientProperty(MENU_ELEMENT_ID, id);
        if (id != null && id.length() > 0 && (o = this.registry.get(id)) != null) {
            if (o instanceof Action) {
                item.setAction((Action)o);
            } else if (o instanceof ActionListener) {
                item.addActionListener((ActionListener)o);
            } else if (o instanceof MenuListener) {
                if (item instanceof JMenu) {
                    ((JMenu)item).addMenuListener((MenuListener)o);
                } else {
                    logger.error("Attempt to add MenuListener (" + o.getClass() + ") to a non-menu object " + "(" + item.getClass() + ")");
                }
            } else {
                logger.error("Registered object for \"" + id + "\" is not an Action or valid listener object \"" + o.getClass() + "\"");
            }
        }
    }

    private boolean isExcluded(Map props) {
        List excludeList = null;
        try {
            LookAndFeel laf = UIManager.getLookAndFeel();
            excludeList = (List)PropertyListUtilities.extractWithPath(props, "/excluded-lafs");
            if (excludeList != null && laf != null && excludeList.contains(laf.getID())) {
                return true;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (Exception e) {
            logger.error(e);
        }
        return false;
    }

    private JMenuBar newMenuBarInstance() {
        JMenuBar menuBar = null;
        menuBar = GUIFactory.newMenuBar();
        if (menuBar == null) {
            logger.warn("GUI factory returned a null menu bar. Using JMenuBar instead.");
            menuBar = new JMenuBar();
        }
        return menuBar;
    }

    private JMenuBar newMenuBarInstance(String className) {
        JMenuBar menuBar = null;
        if (className != null && className.length() > 0) {
            try {
                Class<?> c = Class.forName(className);
                menuBar = (JMenuBar)c.newInstance();
            }
            catch (Exception e) {
                menuBar = null;
                logger.warn("Failed to instantiate menu bar class " + className + ": " + e);
            }
        }
        if (menuBar == null) {
            menuBar = this.newMenuBarInstance();
        }
        return menuBar;
    }

    private JMenu newMenuInstance() {
        JMenu menu = null;
        menu = GUIFactory.newMenu();
        if (menu == null) {
            logger.warn("GUI factory returned a null menu. Using JMenu instead.");
            menu = new JMenu();
        }
        return menu;
    }

    private JMenu newMenuInstance(String className) {
        JMenu menu = null;
        if (className != null && className.length() > 0) {
            try {
                Class<?> c = Class.forName(className);
                menu = (JMenu)c.newInstance();
            }
            catch (Exception e) {
                menu = null;
                logger.warn("Failed to instantiate class " + className + ": " + e);
            }
        }
        if (menu == null) {
            menu = this.newMenuInstance();
        }
        return menu;
    }

    private JMenuItem newMenuItemInstance() {
        JMenuItem item = null;
        item = GUIFactory.newMenuItem();
        if (item == null) {
            logger.warn("GUI factory returned a null menu item. Using JMenuItem instead.");
            item = new JMenuItem();
        }
        return item;
    }

    private JMenuItem newMenuItemInstance(String className) {
        JMenuItem item = null;
        if (className != null && className.length() > 0) {
            try {
                Class<?> c = Class.forName(className);
                item = (JMenuItem)c.newInstance();
            }
            catch (Exception e) {
                item = null;
                logger.warn("Failed to instantiate class " + className + ": " + e);
            }
        }
        if (item == null) {
            item = this.newMenuItemInstance();
        }
        return item;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object loadPropertyList(ClassLoader loader, String plist) {
        Object $return;
        String resource = String.valueOf(plist.replace('.', '/')) + ".plist";
        InputStream stream = (InputStream)AccessController.doPrivileged(new 1(loader, resource));
        if (stream == null) return null;
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                $return = PropertyListUtilities.readXML(reader);
                Object var7_6 = null;
                if (reader == null) return $return;
            }
            catch (Exception e) {
                logger.error("Error loading " + plist + ". " + e);
                Object var7_7 = null;
                if (reader == null) return null;
                try {
                    reader.close();
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (reader == null) throw throwable;
            try {}
            catch (IOException iOException) {}
            reader.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        reader.close();
        return $return;
    }

    private static ClassLoader getLoader(Class c) {
        ClassLoader cl;
        ClassLoader classLoader = cl = c == null ? null : c.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static final class 1
    implements PrivilegedAction {
        private final /* synthetic */ String val$resource;
        private final /* synthetic */ ClassLoader val$loader;

        public Object run() {
            if (this.val$loader != null) {
                return this.val$loader.getResourceAsStream(this.val$resource);
            }
            return ClassLoader.getSystemResourceAsStream(this.val$resource);
        }

        /* synthetic */ 1(ClassLoader val$loader, String val$resource) {
            this.val$loader = val$loader;
            this.val$resource = val$resource;
        }
    }

    public static class EditMenuListener
    implements MenuListener {
        protected String cutItemId;
        protected String copyItemId;
        protected String pasteItemId;
        protected String selectAllItemId;
        private Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();

        public EditMenuListener() {
        }

        public EditMenuListener(String cutItemId, String copyItemId, String pasteItemId, String selectAllItemId) {
            this.cutItemId = cutItemId;
            this.copyItemId = copyItemId;
            this.pasteItemId = pasteItemId;
            this.selectAllItemId = selectAllItemId;
        }

        public synchronized void setCutId(String id) {
            this.cutItemId = id;
        }

        public synchronized void setCopyId(String id) {
            this.copyItemId = id;
        }

        public synchronized void setPasteId(String id) {
            this.pasteItemId = id;
        }

        public synchronized void setSelectAllId(String id) {
            this.selectAllItemId = id;
        }

        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            this.updateMenu(menu);
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }

        protected synchronized void updateMenu(JMenu menu) {
            boolean cutEnabled = false;
            boolean copyEnabled = false;
            boolean pasteEnabled = false;
            boolean selectAllEnabled = false;
            JTextComponent tc = this.getFocusedTextComponent(menu);
            if (tc != null) {
                boolean hasContent;
                boolean textSelected = tc.getSelectionStart() != tc.getSelectionEnd();
                boolean editable = tc.isEditable();
                boolean bl = hasContent = tc.getText().length() > 0;
                if (editable) {
                    pasteEnabled = true;
                }
                if (textSelected) {
                    if (!(tc instanceof JPasswordField)) {
                        copyEnabled = true;
                        if (editable) {
                            cutEnabled = true;
                        }
                    } else {
                        copyEnabled = false;
                        cutEnabled = false;
                    }
                    selectAllEnabled = true;
                } else if (hasContent) {
                    selectAllEnabled = true;
                }
            }
            JMenuItem cutItem = MenuManager.getMenuItem(menu, this.cutItemId);
            JMenuItem copyItem = MenuManager.getMenuItem(menu, this.copyItemId);
            JMenuItem pasteItem = MenuManager.getMenuItem(menu, this.pasteItemId);
            JMenuItem selectAllItem = MenuManager.getMenuItem(menu, this.selectAllItemId);
            if (cutItem != null) {
                cutItem.setEnabled(cutEnabled);
            }
            if (copyItem != null) {
                copyItem.setEnabled(copyEnabled);
            }
            if (pasteItem != null) {
                pasteItem.setEnabled(pasteEnabled);
            }
            if (selectAllItem != null) {
                selectAllItem.setEnabled(selectAllEnabled);
            }
        }

        protected JTextComponent getFocusedTextComponent(JComponent comp) {
            Component focusedComp;
            Window window = SwingUtilities.getWindowAncestor(comp);
            if (window != null && (focusedComp = window.getFocusOwner()) != null && focusedComp instanceof JTextComponent) {
                return (JTextComponent)focusedComp;
            }
            return null;
        }

        private boolean clipboardHasContents() {
            if (this.systemClipboard != null) {
                return this.systemClipboard.getContents(null) != null;
            }
            return true;
        }
    }

    public static class CloseWindowListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Component invoker;
            Container parentPopup;
            Window window = null;
            Object source = e.getSource();
            if (source != null && source instanceof JMenuItem && (parentPopup = ((JMenuItem)source).getParent()) != null && parentPopup instanceof JPopupMenu && (invoker = ((JPopupMenu)parentPopup).getInvoker()) != null) {
                window = SwingUtilities.getWindowAncestor(invoker);
            }
            if (window != null) {
                window.dispose();
            }
        }
    }
}

