/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;

public class TextField
extends JTextField {
    public TextField() {
        this(null, null, 0);
    }

    public TextField(int columns) {
        this(null, null, columns);
    }

    public TextField(String text) {
        this(null, text, 0);
    }

    public TextField(String text, int columns) {
        this(null, text, columns);
    }

    public TextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        new TextSelector(this);
    }

    public boolean isFocusTraversable() {
        return this.isEditable();
    }

    static class TextSelector
    extends MouseAdapter
    implements FocusListener,
    CaretListener {
        JTextField textField;
        boolean mouseDown = false;

        public TextSelector(JTextField textField) {
            this.textField = textField;
            textField.addMouseListener(this);
            textField.addFocusListener(this);
            textField.addCaretListener(this);
        }

        public void mousePressed(MouseEvent e) {
            this.mouseDown = true;
        }

        public void mouseReleased(MouseEvent e) {
            this.mouseDown = false;
        }

        public void focusGained(FocusEvent e) {
            if (!this.mouseDown && this.textField.getText() != null) {
                this.textField.setCaretPosition(0);
                this.textField.moveCaretPosition(this.textField.getText().length());
            }
        }

        public void focusLost(FocusEvent e) {
        }

        public void caretUpdate(CaretEvent e) {
            if (e.getDot() != e.getMark()) {
                if (this.textField.isEditable()) {
                    this.textField.getCaret().setVisible(false);
                }
            } else if (this.textField.hasFocus() && this.textField.isEditable()) {
                this.textField.getCaret().setVisible(true);
            }
        }
    }
}

