/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class TextPane
extends JTextPane {
    private static final String REGULAR = "regular";
    private int minimumLines = 0;

    TextPane() {
    }

    TextPane(String text) {
        this.setText(text);
    }

    TextPane(String text, int lines) {
        this.setText(text);
        this.setMinimumLines(lines);
    }

    public void setFont(Font font) {
        StyledDocument doc = this.getStyledDocument();
        if (doc != null) {
            if (doc.getStyle(REGULAR) != null) {
                doc.removeStyle(REGULAR);
            }
            Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
            StyleConstants.setFontFamily(defaultStyle, font.getFamily());
            StyleConstants.setFontSize(defaultStyle, font.getSize());
            StyleConstants.setBold(defaultStyle, font.isBold());
            StyleConstants.setItalic(defaultStyle, font.isItalic());
            doc.addStyle(REGULAR, defaultStyle);
            this.setText(this.getText());
        }
    }

    public void setText(String text) {
        try {
            StyledDocument doc = this.getStyledDocument();
            doc.remove(0, doc.getLength());
            doc.insertString(0, text, doc.getStyle(REGULAR));
        }
        catch (BadLocationException badLocationException) {}
    }

    public void setMinimumLines(int lines) {
        this.minimumLines = lines;
    }

    public Dimension getMinimumSize() {
        Font font;
        StyledDocument doc;
        Dimension result = super.getMinimumSize();
        if (this.minimumLines > 0 && (doc = this.getStyledDocument()) != null && (font = doc.getFont(doc.getStyle(REGULAR))) != null) {
            result = new Dimension(result.width, ((Component)this).getFontMetrics(font).getHeight() * this.minimumLines);
        }
        return result;
    }
}

