/*
 * Decompiled with CFR 0.152.
 */
package com.apple.net.acp;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AcpTextRecord {
    protected static final int STRING_INDEX_ACP_INFO = 0;
    protected static final int STRING_INDEX_ACP_INFO_COMPANION = 1;
    protected static final int STRING_INDEX_NAME = 2;
    protected static final int STRING_INDEX_NAME_COMPANION = 3;
    protected static final String ACP_PROPERTY_ERROR = "errr";
    protected Map properties = new HashMap();
    protected Map companionProperties = new HashMap();

    public AcpTextRecord(byte[] inTextRecord) throws UnsupportedEncodingException {
        this.setTextRecord(inTextRecord);
    }

    public void setTextRecord(byte[] inTextRecord) throws UnsupportedEncodingException {
        Map map = this.properties;
        synchronized (map) {
            this.properties.clear();
            Map map2 = this.companionProperties;
            synchronized (map2) {
                this.companionProperties.clear();
                this.parseTextRecord(inTextRecord);
            }
        }
    }

    public String getPropertyString(String inPropertyCode) {
        return this.getPropertyString(this.properties, inPropertyCode);
    }

    public String getCompanionPropertyString(String inPropertyCode) {
        return this.getPropertyString(this.companionProperties, inPropertyCode);
    }

    protected String getPropertyString(Map inProperties, String inPropertyCode) {
        Map map = inProperties;
        synchronized (map) {
            String $return = (String)inProperties.get(inPropertyCode);
            Object var5_5 = null;
            return $return;
        }
    }

    public int getPropertyInteger(String inPropertyCode, int inDefault) throws NumberFormatException {
        return this.getPropertyInteger(this.properties, inPropertyCode, inDefault);
    }

    public int getCompanionPropertyInteger(String inPropertyCode, int inDefault) throws NumberFormatException {
        return this.getPropertyInteger(this.companionProperties, inPropertyCode, inDefault);
    }

    protected int getPropertyInteger(Map inProperties, String inPropertyCode, int inDefault) throws NumberFormatException {
        Map map = inProperties;
        synchronized (map) {
            String s = this.getPropertyString(inProperties, inPropertyCode);
            int value = s != null ? Integer.decode(s) : inDefault;
            int $return = value;
            Object var6_8 = null;
            return $return;
        }
    }

    public Map properties() {
        Map map = this.properties;
        synchronized (map) {
            Map $return = Collections.unmodifiableMap(Collections.synchronizedMap(this.properties));
            Object var3_3 = null;
            return $return;
        }
    }

    public Map companionProperties() {
        Map map = this.companionProperties;
        synchronized (map) {
            Map $return = Collections.unmodifiableMap(Collections.synchronizedMap(this.companionProperties));
            Object var3_3 = null;
            return $return;
        }
    }

    protected void parseTextRecord(byte[] inTextRecord) throws UnsupportedEncodingException {
        int index = 0;
        int endOffset = inTextRecord.length;
        int offset = 0;
        while (offset < endOffset) {
            byte size = inTextRecord[offset];
            if (size > 0) {
                boolean commaEscaped;
                String entry = new String(inTextRecord, offset + 1, (int)size, "UTF-8");
                switch (index) {
                    case 0: {
                        commaEscaped = true;
                        break;
                    }
                    case 1: {
                        commaEscaped = true;
                        break;
                    }
                    default: {
                        commaEscaped = false;
                    }
                }
                this.parseAcpEntry(entry, index, commaEscaped);
                ++index;
            }
            offset += 1 + size;
        }
    }

    protected void parseAcpEntry(String inString, int inIndex, boolean inCommaEscaped) {
        Map propertiesRef = inIndex % 2 == 0 ? this.properties : this.companionProperties;
        int offset = 0;
        int endOffset = inString.length();
        while (offset < endOffset) {
            int i = inString.indexOf(61, offset);
            if (i < 0) {
                if (inString.equals(ACP_PROPERTY_ERROR)) break;
                throw new IllegalArgumentException("bad name/value pair...missing \"=\" separator");
            }
            String name = inString.substring(offset, i);
            if (name.length() != 4) {
                throw new IllegalArgumentException("property code must be exactly 4 bytes (\"" + name + "\")");
            }
            if (inCommaEscaped) {
                StringBuffer value = new StringBuffer();
                offset = i + 1;
                while (offset < endOffset) {
                    char c = inString.charAt(offset);
                    if (c == ',') {
                        ++offset;
                        break;
                    }
                    if (c == '\\' && (c = inString.charAt(++offset)) != '\\' && c != ',') {
                        throw new IllegalArgumentException("escape sequence for non-comma, non-backslash (\"\\" + String.valueOf(c) + "\")");
                    }
                    value.append(c);
                    ++offset;
                }
                propertiesRef.put(name, value.toString());
                continue;
            }
            propertiesRef.put(name, inString.substring(i + 1, endOffset));
            break;
        }
    }
}

