/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util;

import java.awt.image.RGBImageFilter;

public class ImageUtilities {
    private static final DimmingRGBFilter dimmingFilter = new DimmingRGBFilter();
    private static final WhiteningRGBFilter whiteningFilter = new WhiteningRGBFilter();
    private static final FadingRGBFilter fadingFilter = new FadingRGBFilter();
    private static final InvertingRGBFilter invertingFilter = new InvertingRGBFilter();

    public static RGBImageFilter getDimmingFilterInstance() {
        return dimmingFilter;
    }

    public static RGBImageFilter getWhiteningFilterInstance() {
        return whiteningFilter;
    }

    public static RGBImageFilter getFadingFilterInstance() {
        return fadingFilter;
    }

    public static RGBImageFilter getInvertingFilterInstance() {
        return invertingFilter;
    }

    public static class DimmingRGBFilter
    extends RGBImageFilter {
        private float dimmingFactor = 0.535f;

        public DimmingRGBFilter() {
            this.canFilterIndexColorModel = true;
        }

        public DimmingRGBFilter(float dimmingFactor) {
            this.dimmingFactor = dimmingFactor;
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            int r = (int)((float)(rgb >> 16 & 0xFF) * this.dimmingFactor);
            int g = (int)((float)(rgb >> 8 & 0xFF) * this.dimmingFactor);
            int b = (int)((float)(rgb & 0xFF) * this.dimmingFactor);
            return rgb & 0xFF000000 | r << 16 | g << 8 | b;
        }
    }

    public static class WhiteningRGBFilter
    extends RGBImageFilter {
        public WhiteningRGBFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            return rgb | 0xAAAAAA;
        }
    }

    public static class FadingRGBFilter
    extends RGBImageFilter {
        public FadingRGBFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            int alpha = rgb >> 24 & 0xFE;
            return alpha << 23 | rgb & 0xFFFFFF;
        }
    }

    public static class InvertingRGBFilter
    extends RGBImageFilter {
        public InvertingRGBFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            return rgb & 0xFF000000 | 0xFFFFFF - (rgb & 0xFFFFFF);
        }
    }
}

