/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util;

import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.util.ArrayList;

public class StringUtilities {
    public static final boolean DEBUG = false;
    public static final String US_ASCII_ENCODING = "US-ASCII";
    public static final String ISO_8859_1_ENCODING = "ISO-8859-1";
    public static final String UTF_8_ENCODING = "UTF-8";
    public static final String UTF_16_ENCODING = "UTF-16";
    public static final String UTF_16BE_ENCODING = "UTF-16BE";
    public static final String UTF_16LE_ENCODING = "UTF-16LE";

    public static String replaceAll(String inOriginal, String inSearch, String inReplacement) {
        String result;
        int searchLength = inSearch.length();
        if (searchLength > 0) {
            int end;
            StringBuffer buffer = new StringBuffer(inOriginal.length());
            int start = 0;
            while ((end = inOriginal.indexOf(inSearch, start)) >= 0) {
                if (start < end) {
                    buffer.append(inOriginal.substring(start, end));
                }
                buffer.append(inReplacement);
                start = end + searchLength;
            }
            buffer.append(inOriginal.substring(start));
            result = buffer.toString();
        } else {
            result = inOriginal;
        }
        return result;
    }

    public static String truncateStringToEncodedByteLength(String inString, String inEncoding, int inLength) throws UnsupportedEncodingException {
        while (StringUtilities.encodedByteLength(inString, inEncoding) > inLength) {
            if (inString.length() == 0) {
                throw new IllegalArgumentException("length too small for encoding: " + inLength);
            }
            inString = inString.substring(0, inString.length() - 1);
        }
        return inString;
    }

    public static String appendStringWithMaxEncodedByteLength(String inString, String inAppend, String inEncoding, int inLength) throws UnsupportedEncodingException {
        while (StringUtilities.encodedByteLength(inString, inEncoding) + StringUtilities.encodedByteLength(inAppend, inEncoding) > inLength) {
            if (inString.length() > 0) {
                inString = inString.substring(0, inString.length() - 1);
                continue;
            }
            if (inAppend.length() > 0) {
                inAppend = inAppend.substring(0, inAppend.length() - 1);
                continue;
            }
            throw new IllegalArgumentException("length too small for encoding: " + inLength);
        }
        return String.valueOf(inString) + inAppend;
    }

    public static int encodedByteLength(String inString, String inEncoding) throws UnsupportedEncodingException {
        return inString.getBytes(inEncoding).length;
    }

    /*
     * Unable to fully structure code
     */
    public static int compareNatural(String inLeftSource, String inRightSource, boolean inCaseSensitive) {
        if (inLeftSource == null || inRightSource == null) {
            throw new NullPointerException("source strings cannot be null");
        }
        leftIndex = 0;
        rightIndex = 0;
        leftLength = inLeftSource.length();
        rightLength = inRightSource.length();
        skippedZeros = 0;
        ** GOTO lbl58
        {
            leftChar = inLeftSource.charAt(leftIndex);
            rightChar = inRightSource.charAt(rightIndex);
            if (Character.isDigit(leftChar) && Character.isDigit(rightChar)) ** GOTO lbl23
            if (!inCaseSensitive) {
                leftChar = Character.toLowerCase(leftChar);
                rightChar = Character.toLowerCase(rightChar);
            }
            if (leftChar < rightChar) {
                return -1;
            }
            if (leftChar > rightChar) {
                return 1;
            }
            ++leftIndex;
            ++rightIndex;
            do {
                if (leftIndex < leftLength && rightIndex < rightLength) continue block0;
lbl23:
                // 2 sources

                if (leftIndex == leftLength && rightIndex == rightLength) {
                    return 0;
                }
                if (leftIndex == leftLength) {
                    return -1;
                }
                if (rightIndex != rightLength) ** GOTO lbl31
                return 1;
lbl-1000:
                // 1 sources

                {
                    ++leftIndex;
                    ++skippedZeros;
lbl31:
                    // 2 sources

                    ** while (inLeftSource.charAt((int)leftIndex) == '0' && leftIndex < leftLength - 1 && Character.isDigit((char)inLeftSource.charAt((int)(leftIndex + 1))))
                }
lbl32:
                // 2 sources

                while (inRightSource.charAt(rightIndex) == '0' && rightIndex < rightLength - 1 && Character.isDigit(inRightSource.charAt(rightIndex + 1))) {
                    ++rightIndex;
                    --skippedZeros;
                }
                tempLeftIndex = leftIndex;
                tempRightIndex = rightIndex;
                while (tempLeftIndex < leftLength && Character.isDigit(inLeftSource.charAt(tempLeftIndex)) && tempRightIndex < rightLength && Character.isDigit(inRightSource.charAt(tempRightIndex))) {
                    ++tempLeftIndex;
                    ++tempRightIndex;
                }
                if (tempLeftIndex < leftLength && Character.isDigit(inLeftSource.charAt(tempLeftIndex))) {
                    return 1;
                }
                if (tempRightIndex >= rightLength || !Character.isDigit(inRightSource.charAt(tempRightIndex))) ** GOTO lbl53
                return -1;
lbl-1000:
                // 1 sources

                {
                    leftChar = inLeftSource.charAt(leftIndex);
                    if (leftChar < (rightChar = inRightSource.charAt(rightIndex))) {
                        return -1;
                    }
                    if (leftChar > rightChar) {
                        return 1;
                    }
                    ++leftIndex;
                    ++rightIndex;
lbl53:
                    // 2 sources

                    ** while (leftIndex < tempLeftIndex)
                }
lbl54:
                // 1 sources

                if (skippedZeros < 0) {
                    return -1;
                }
                if (skippedZeros <= 0) continue;
                return 1;
lbl58:
                // 2 sources

            } while (leftIndex < leftLength || rightIndex < rightLength);
        }
        return 0;
    }

    public static Object[] sscanf(String inFormat, String inString) {
        ArrayList<Object> objects = new ArrayList<Object>();
        ParsePosition position = new ParsePosition(0);
        int stringI = 0;
        int formatN = inFormat.length();
        int formatI = 0;
        while (formatI < formatN) {
            block11: {
                char stringC;
                char formatC;
                block10: {
                    formatC = inFormat.charAt(formatI);
                    if (formatC != '%') break block10;
                    formatC = inFormat.charAt(++formatI);
                    switch (formatC) {
                        case 'd': {
                            position.setIndex(stringI);
                            int intValue = StringUtilities.scanDecimalInteger(inString, position);
                            objects.add(new Integer(intValue));
                            stringI = position.getIndex();
                            break block11;
                        }
                        case 'X': 
                        case 'x': {
                            position.setIndex(stringI);
                            int intValue = StringUtilities.scanHexadecimalInteger(inString, position);
                            objects.add(new Integer(intValue));
                            stringI = position.getIndex();
                            break block11;
                        }
                        case 's': {
                            position.setIndex(stringI);
                            String stringValue = StringUtilities.scanString(inString, position);
                            objects.add(stringValue);
                            stringI = position.getIndex();
                            break block11;
                        }
                        case 'q': {
                            position.setIndex(stringI);
                            String stringValue = StringUtilities.scanQuotedString(inString, position);
                            objects.add(stringValue);
                            stringI = position.getIndex();
                            break block11;
                        }
                        case '%': {
                            stringC = inString.charAt(stringI++);
                            if (stringC != formatC) {
                                throw new RuntimeException("format/string mismatch " + formatC + " vs " + stringC);
                            }
                            break block11;
                        }
                        default: {
                            throw new RuntimeException("unknown format specifier: " + formatC);
                        }
                    }
                }
                if ((stringC = inString.charAt(stringI++)) != formatC) {
                    throw new RuntimeException("format/string mismatch " + formatC + " vs " + stringC);
                }
            }
            ++formatI;
        }
        return objects.toArray();
    }

    public static int scanDecimalInteger(String inString, ParsePosition ioPosition) {
        int start;
        StringUtilities.skipLeadingWhiteSpace(inString, ioPosition);
        int i = start = ioPosition.getIndex();
        char c = inString.charAt(i);
        if (c == '-' || Character.isDigit(c)) {
            ++i;
        } else {
            throw new RuntimeException("non-decimal leading character: " + c);
        }
        int n = inString.length();
        while (i < n) {
            c = inString.charAt(i);
            if (!Character.isDigit(c)) break;
            ++i;
        }
        ioPosition.setIndex(i);
        return Integer.parseInt(inString.substring(start, i));
    }

    public static int scanHexadecimalInteger(String inString, ParsePosition ioPosition) {
        boolean negative;
        StringUtilities.skipLeadingWhiteSpace(inString, ioPosition);
        int i = ioPosition.getIndex();
        int n = inString.length();
        char c = inString.charAt(i);
        boolean bl = negative = c == '-';
        if (negative || c == '+') {
            ++i;
        }
        if (n - i >= 2 && inString.charAt(i) == '0' && Character.toLowerCase(inString.charAt(i + 1)) == 'x') {
            i += 2;
        }
        int start = i;
        while (i < n) {
            c = inString.charAt(i);
            if (Character.digit(c, 16) == -1) break;
            ++i;
        }
        ioPosition.setIndex(i);
        int value = Integer.parseInt(inString.substring(start, i), 16);
        if (negative) {
            value = -value;
        }
        return value;
    }

    public static String scanString(String inString, ParsePosition ioPosition) {
        StringUtilities.skipLeadingWhiteSpace(inString, ioPosition);
        int start = ioPosition.getIndex();
        int n = inString.length();
        int i = start;
        while (i < n) {
            if (Character.isWhitespace(inString.charAt(i))) break;
            ++i;
        }
        ioPosition.setIndex(i);
        return inString.substring(start, i);
    }

    public static String scanQuotedString(String inString, ParsePosition ioPosition) {
        StringUtilities.skipLeadingWhiteSpace(inString, ioPosition);
        int start = ioPosition.getIndex();
        char c = inString.charAt(start);
        if (c != '\"') {
            throw new RuntimeException("no leading quote: " + c);
        }
        StringBuffer buffer = new StringBuffer();
        int n = inString.length();
        int i = ++start;
        while (i < n) {
            c = inString.charAt(i);
            if (c == '\\') {
                c = inString.charAt(++i);
            } else if (c == '\"') break;
            buffer.append(c);
            ++i;
        }
        if (i >= n) {
            throw new RuntimeException("no trailing quote");
        }
        ioPosition.setIndex(i + 1);
        return buffer.toString();
    }

    public static void skipLeadingWhiteSpace(String inString, ParsePosition ioPosition) {
        int n = inString.length();
        int i = ioPosition.getIndex();
        while (i < n) {
            if (!Character.isWhitespace(inString.charAt(i))) break;
            ++i;
        }
        ioPosition.setIndex(i);
    }

    public static String sprintf(String inFormat, Object[] inArgs) {
        StringBuffer buffer = new StringBuffer();
        int argIndex = 0;
        int n = inFormat.length();
        int i = 0;
        while (i < n) {
            block14: {
                char c;
                block13: {
                    c = inFormat.charAt(i);
                    if (c != '%') break block13;
                    if (Character.isDigit(c = inFormat.charAt(++i))) {
                        argIndex = Character.digit(c, 10) - 1;
                        if ((c = inFormat.charAt(++i)) != '$') {
                            throw new RuntimeException("expected $ specifier, but got: " + c);
                        }
                        c = inFormat.charAt(++i);
                    }
                    int altForm = 0;
                    while (c == '#') {
                        ++altForm;
                        c = inFormat.charAt(++i);
                    }
                    switch (c) {
                        case 'd': {
                            buffer.append((Integer)inArgs[argIndex++]);
                            break block14;
                        }
                        case 'X': 
                        case 'x': {
                            if (altForm == 1) {
                                buffer.append("0x");
                            }
                            if (c == 'x') {
                                buffer.append(Integer.toHexString((Integer)inArgs[argIndex++]));
                            } else {
                                buffer.append(Integer.toHexString((Integer)inArgs[argIndex++]).toUpperCase());
                            }
                            break block14;
                        }
                        case 's': {
                            buffer.append((String)inArgs[argIndex++]);
                            break block14;
                        }
                        case '%': {
                            buffer.append(c);
                            break block14;
                        }
                        default: {
                            throw new RuntimeException("unknown format specifier: " + c);
                        }
                    }
                }
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void main(String[] inArgs) {
    }
}

