/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util;

import com.apple.util.StringUtilities;
import java.text.ParseException;

public abstract class VersionNumber
implements Comparable {
    public static final boolean DEBUG = false;
    public static final int MAJOR = 0;
    public static final int MINOR = 1;
    public static final int POINT = 2;
    public static final int STAGE = 3;
    public static final int STAGE_SUFFIX = 4;
    protected int major = -1;
    protected int minor = -1;
    protected int point = -1;
    protected String stage = "";
    protected int stageValue = -1;
    protected int stageSuffix = -1;
    protected String versionString;

    private VersionNumber(String version) throws ParseException {
        if (version == null) {
            throw new NullPointerException("version cannot be null");
        }
        this.versionString = version;
        this.parse(this.versionString);
    }

    public static VersionNumber newAppleVersionNumber(String version) throws ParseException {
        return new AppleVersionNumber(null, version);
    }

    public static VersionNumber newAcsVersionNumber(String version) throws ParseException {
        return new AcsVersionNumber(null, version);
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getPointVersion() {
        return this.point;
    }

    public String getStage() {
        return this.stage;
    }

    public int getStageValue() {
        return this.stageValue;
    }

    public int getStageSuffix() {
        return this.stageSuffix;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public int compareTo(VersionNumber n) {
        return StringUtilities.compareNatural(this.versionString, n.versionString, false);
    }

    public int compareTo(Object o) {
        return this.compareTo((VersionNumber)o);
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public String toString() {
        return this.versionString;
    }

    protected abstract void parse(String var1) throws ParseException;

    public static void main(String[] inArgs) {
    }

    /* synthetic */ VersionNumber(1 $0, String $1) throws ParseException {
        this($1);
    }

    private static class AppleVersionNumber
    extends VersionNumber {
        public static final int VERSION_STAGE_DEVELOPMENT = 32;
        public static final int VERSION_STAGE_ALPHA = 64;
        public static final int VERSION_STAGE_BETA = 96;
        public static final int VERSION_STAGE_FINAL = 128;

        private AppleVersionNumber(String version) throws ParseException {
            super(null, version);
        }

        protected void parse(String inString) throws ParseException {
            this.major = 0;
            this.minor = 0;
            this.point = 0;
            this.stage = "f";
            this.stageValue = 128;
            this.stageSuffix = 0;
            int i = 0;
            int n = inString.length();
            while (i < n && Character.isWhitespace(inString.charAt(i))) {
                ++i;
            }
            int tokenStart = i;
            while (i < n && Character.isDigit(inString.charAt(i))) {
                ++i;
            }
            int tokenEnd = i;
            this.major = Integer.parseInt(inString.substring(tokenStart, tokenEnd));
            if (inString.charAt(i) != '.') {
                throw new ParseException("major version must be followed by a dot", 0);
            }
            tokenStart = ++i;
            while (i < n && Character.isDigit(inString.charAt(i))) {
                ++i;
            }
            tokenEnd = i;
            this.minor = Integer.parseInt(inString.substring(tokenStart, tokenEnd));
            if (i < n) {
                boolean hasStage;
                char c;
                if ((c = inString.charAt(i++)) == '.') {
                    tokenStart = i;
                    while (i < n && Character.isDigit(inString.charAt(i))) {
                        ++i;
                    }
                    tokenEnd = i;
                    this.point = Integer.parseInt(inString.substring(tokenStart, tokenEnd));
                    if (i < n) {
                        c = inString.charAt(i++);
                    }
                }
                switch (c) {
                    case 'D': 
                    case 'd': {
                        this.stage = "d";
                        this.stageValue = 32;
                        hasStage = true;
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        this.stage = "a";
                        this.stageValue = 64;
                        hasStage = true;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        this.stage = "b";
                        this.stageValue = 96;
                        hasStage = true;
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        this.stage = "f";
                        this.stageValue = 128;
                        hasStage = true;
                        break;
                    }
                    default: {
                        hasStage = false;
                    }
                }
                if (hasStage) {
                    tokenStart = i;
                    while (i < n && Character.isDigit(inString.charAt(i))) {
                        ++i;
                    }
                    tokenEnd = i;
                    if (tokenStart < tokenEnd) {
                        this.stageSuffix = Integer.parseInt(inString.substring(tokenStart, tokenEnd));
                    }
                }
            }
            if (this.major > 255) {
                throw new ParseException("major must be 0-255", 0);
            }
            if (this.minor > 15) {
                throw new ParseException("minor must be 0-15", 0);
            }
            if (this.point > 15) {
                throw new ParseException("bugFix must be 0-15", 0);
            }
            if (this.stageSuffix > 255) {
                throw new ParseException("revision must be 0-255", 0);
            }
            if (this.stageValue != 32 && this.stageValue != 64 && this.stageValue != 96 && this.stageValue != 128) {
                throw new ParseException("stage must be d, a, b, or f", 0);
            }
        }

        public int compareTo(VersionNumber n) {
            if (this.major > n.getMajorVersion()) {
                return 1;
            }
            if (this.major < n.getMajorVersion()) {
                return -1;
            }
            if (this.minor > n.getMinorVersion()) {
                return 1;
            }
            if (this.minor < n.getMinorVersion()) {
                return -1;
            }
            if (this.point > n.getPointVersion()) {
                return 1;
            }
            if (this.point < n.getPointVersion()) {
                return -1;
            }
            if (this.stageValue > n.getStageValue()) {
                return 1;
            }
            if (this.stageValue < n.getStageValue()) {
                return -1;
            }
            int revision1 = this.stageSuffix;
            int revision2 = n.getStageSuffix();
            if (this.stageValue == 128) {
                if (revision1 == 0) {
                    revision1 = 65535;
                }
                if (revision2 == 0) {
                    revision2 = 65535;
                }
            }
            if (revision1 > revision2) {
                return 1;
            }
            if (revision1 < revision2) {
                return -1;
            }
            return 0;
        }

        /* synthetic */ AppleVersionNumber(1 $0, String $1) throws ParseException {
            this($1);
        }
    }

    private static class AcsVersionNumber
    extends VersionNumber {
        private AcsVersionNumber(String version) throws ParseException {
            super(null, version);
        }

        protected void parse(String version) throws ParseException {
            int index = 0;
            int oldIndex = 0;
            int length = version.length();
            index = version.indexOf(46, oldIndex);
            if (index == -1) {
                throw new ParseException("\"" + version + "\" invalid format (missing decimal point)", oldIndex);
            }
            try {
                this.major = Integer.parseInt(index - oldIndex > 0 ? version.substring(oldIndex, index) : "0");
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("\"" + version + "\" major version is not an integer \"" + version.substring(oldIndex, index) + "\"", oldIndex);
            }
            oldIndex = index + 1;
            try {
                this.minor = Integer.parseInt(length - 1 - oldIndex > 0 ? version.substring(oldIndex, length - 1) : "0");
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("\"" + version + "\" minor version is not an integer \"" + version.substring(oldIndex, length - 1) + "\"", oldIndex);
            }
            this.point = version.charAt(length - 1);
        }

        /* synthetic */ AcsVersionNumber(1 $0, String $1) throws ParseException {
            this($1);
        }
    }

    static class 1 {
        /* synthetic */ 1() {
        }
    }
}

