/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util.plist;

import com.apple.util.Base64Utilities;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class PropertyListUtilities {
    public static final boolean DEBUG = false;
    public static final String PLIST_XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    public static final String PLIST_XML_DOCTYPE = "<!DOCTYPE plist SYSTEM \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n";
    public static final String PLIST_XML_VERSION_BEGIN = "<plist version=\"1.0\">\n";
    public static final String PLIST_XML_VERSION_END = "</plist>\n";
    public static final String PLIST_XML_ARRAY_BEGIN = "<array>\n";
    public static final String PLIST_XML_ARRAY_END = "</array>\n";
    public static final String PLIST_XML_ARRAY_EMPTY = "<array/>\n";
    public static final String PLIST_XML_BOOLEAN_TRUE = "<true/>\n";
    public static final String PLIST_XML_BOOLEAN_FALSE = "<false/>\n";
    public static final String PLIST_XML_DATA_BEGIN = "<data>\n";
    public static final String PLIST_XML_DATA_END = "</data>\n";
    public static final String PLIST_XML_DATE_BEGIN = "<date>";
    public static final String PLIST_XML_DATE_END = "</date>\n";
    public static final String PLIST_XML_DICTIONARY_BEGIN = "<dict>\n";
    public static final String PLIST_XML_DICTIONARY_END = "</dict>\n";
    public static final String PLIST_XML_DICTIONARY_EMPTY = "<dict/>\n";
    public static final String PLIST_XML_KEY_BEGIN = "<key>";
    public static final String PLIST_XML_KEY_END = "</key>\n";
    public static final String PLIST_XML_INTEGER_BEGIN = "<integer>";
    public static final String PLIST_XML_INTEGER_END = "</integer>\n";
    public static final String PLIST_XML_REAL_BEGIN = "<real>";
    public static final String PLIST_XML_REAL_END = "</real>\n";
    public static final String PLIST_XML_STRING_BEGIN = "<string>";
    public static final String PLIST_XML_STRING_END = "</string>\n";
    protected static final String PLIST_DATE_FORMAT = "yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'";

    public static Object createFormatted(String inFormat, Object[] inArgs) {
        return PropertyListUtilities.appendFormatted(null, inFormat, inArgs);
    }

    public static Object appendFormatted(Object inParent, String inFormat, Object[] inArgs) {
        Object obj;
        Map dict;
        ArrayList array;
        LinkedList<Object> parentStack = new LinkedList<Object>();
        if (inParent instanceof ArrayList) {
            array = (ArrayList)inParent;
            dict = null;
        } else if (inParent instanceof Map) {
            dict = (Map)inParent;
            array = null;
        } else {
            array = null;
            dict = null;
        }
        String key = null;
        int argIndex = 0;
        int n = inFormat.length();
        int i = 0;
        while (i < n) {
            char c = inFormat.charAt(i);
            switch (c) {
                case '[': {
                    obj = new ArrayList();
                    if (array != null) {
                        array.add(obj);
                        parentStack.addFirst(array);
                    } else if (dict != null) {
                        if (key == null) {
                            throw new IllegalArgumentException("array begin in dictionary with no previous key");
                        }
                        dict.put(key, obj);
                        parentStack.addFirst(dict);
                        key = null;
                    }
                    array = (ArrayList)obj;
                    dict = null;
                    break;
                }
                case ']': {
                    if (parentStack.size() <= 0) break;
                    obj = parentStack.removeFirst();
                    if (obj instanceof ArrayList) {
                        array = (ArrayList)obj;
                        dict = null;
                        break;
                    }
                    if (obj instanceof Map) {
                        dict = (Map)obj;
                        array = null;
                        break;
                    }
                    throw new IllegalArgumentException("array end with non-container parent");
                }
                case '{': {
                    obj = new HashMap();
                    if (array != null) {
                        array.add(obj);
                        parentStack.addFirst(array);
                    } else if (dict != null) {
                        if (key == null) {
                            throw new IllegalArgumentException("dictionary begin in dictionary with no previous key");
                        }
                        dict.put(key, obj);
                        parentStack.addFirst(dict);
                        key = null;
                    }
                    dict = (Map)obj;
                    array = null;
                    break;
                }
                case '}': {
                    if (parentStack.size() <= 0) break;
                    obj = parentStack.removeFirst();
                    if (obj instanceof ArrayList) {
                        array = (ArrayList)obj;
                        dict = null;
                        break;
                    }
                    if (obj instanceof Map) {
                        dict = (Map)obj;
                        array = null;
                        break;
                    }
                    throw new IllegalArgumentException("dictionary end with non-container parent");
                }
                case 'k': {
                    if (key != null) {
                        throw new IllegalArgumentException("second key found before first key used");
                    }
                    if (dict == null) {
                        throw new IllegalArgumentException("key without parent dictionary");
                    }
                    key = (String)inArgs[argIndex++];
                    break;
                }
                case 'i': {
                    obj = inArgs[argIndex++];
                    if (!(obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long)) {
                        throw new IllegalArgumentException("'i' used with non-Integer arg: " + Integer.toString(argIndex - 1));
                    }
                    if (array != null) {
                        array.add(obj);
                        break;
                    }
                    if (dict == null) break;
                    if (key == null) {
                        throw new IllegalArgumentException("integer in dictionary with no previous key");
                    }
                    dict.put(key, obj);
                    key = null;
                    break;
                }
                case 's': {
                    obj = inArgs[argIndex++];
                    if (!(obj instanceof String)) {
                        throw new IllegalArgumentException("'s' used with non-String arg: " + Integer.toString(argIndex - 1));
                    }
                    if (array != null) {
                        array.add(obj);
                        break;
                    }
                    if (dict == null) break;
                    if (key == null) {
                        throw new IllegalArgumentException("string in dictionary with no previous key");
                    }
                    dict.put(key, obj);
                    key = null;
                    break;
                }
                case 'b': {
                    obj = inArgs[argIndex++];
                    if (!(obj instanceof Boolean)) {
                        throw new IllegalArgumentException("'b' used with non-Boolean arg: " + Integer.toString(argIndex - 1));
                    }
                    if (array != null) {
                        array.add(obj);
                        break;
                    }
                    if (dict == null) break;
                    if (key == null) {
                        throw new IllegalArgumentException("boolean in dictionary with no previous key");
                    }
                    dict.put(key, obj);
                    key = null;
                    break;
                }
                case 'd': {
                    obj = inArgs[argIndex++];
                    if (!(obj instanceof byte[])) {
                        throw new IllegalArgumentException("'b' used with non-byte[] arg: " + Integer.toString(argIndex - 1));
                    }
                    if (array != null) {
                        array.add(obj);
                        break;
                    }
                    if (dict == null) break;
                    if (key == null) {
                        throw new IllegalArgumentException("raw data in dictionary with no previous key");
                    }
                    dict.put(key, obj);
                    key = null;
                    break;
                }
                case 'D': {
                    obj = inArgs[argIndex++];
                    if (!(obj instanceof Date)) {
                        throw new IllegalArgumentException("'b' used with non-Boolean arg: " + Integer.toString(argIndex - 1));
                    }
                    if (array != null) {
                        array.add(obj);
                        break;
                    }
                    if (dict == null) break;
                    if (key == null) {
                        throw new IllegalArgumentException("date in dictionary with no previous key");
                    }
                    dict.put(key, obj);
                    key = null;
                    break;
                }
                case 'o': {
                    obj = inArgs[argIndex++];
                    if (!PropertyListUtilities.isCompatibleObject(obj)) {
                        throw new IllegalArgumentException(String.valueOf(obj.getClass().toString()) + " is not compatible with Property Lists");
                    }
                    if (array != null) {
                        array.add(obj);
                        break;
                    }
                    if (dict == null) break;
                    if (key == null) {
                        throw new IllegalArgumentException("object in dictionary with no previous key");
                    }
                    dict.put(key, obj);
                    key = null;
                    break;
                }
                case '@': {
                    obj = array != null ? array : (dict != null ? dict : null);
                    inArgs[argIndex++] = obj;
                    break;
                }
            }
            ++i;
        }
        obj = array != null ? array : (dict != null ? dict : null);
        return obj;
    }

    public static Object[] extractFormatted(Object inObject, String inString) {
        ArrayList<Object> array = new ArrayList<Object>();
        int n = inString.length();
        int i = 0;
        while (i < n) {
            char c = inString.charAt(i);
            if (c == '<') {
                int j = inString.indexOf(62, i + 1);
                if (j < 0) {
                    throw new IllegalArgumentException("'<' without closing '>'");
                }
                Object obj = PropertyListUtilities.extractOneFormatted(inObject, inString.substring(i + 1, j));
                if (obj == null) {
                    return null;
                }
                array.add(obj);
                i = j;
            }
            ++i;
        }
        return array.toArray();
    }

    protected static Object extractOneFormatted(Object inObject, String inString) {
        if (!(inObject instanceof Map)) {
            throw new IllegalArgumentException("non-container object = \"" + inObject.getClass().toString() + "\"");
        }
        Map dictionary = (Map)inObject;
        Object obj = dictionary.get(inString);
        return obj;
    }

    public static Object extractWithPath(Object inObject, String inPath) throws Exception {
        int i = 0;
        if (inPath.charAt(i) == '/') {
            ++i;
        }
        int n = inPath.length();
        while (i < n) {
            String specifier;
            boolean optional;
            if (inPath.charAt(i) == '?') {
                optional = true;
                ++i;
            } else {
                optional = false;
            }
            int j = inPath.indexOf(47, i);
            if (j >= 0) {
                specifier = inPath.substring(i, j);
                i = j + 1;
            } else {
                specifier = inPath.substring(i);
                i = n;
            }
            inObject = PropertyListUtilities.extractWithSpecifier(inObject, specifier);
            if (inObject != null) continue;
            if (optional) break;
            throw new NoSuchFieldException("require object not found from specifier: " + specifier);
        }
        return inObject;
    }

    public static Object extractWithSpecifier(Object inObject, String inSpecifier) {
        Object obj;
        int i = 0;
        if (inSpecifier.charAt(i) == '[') {
            int j;
            if ((j = inSpecifier.indexOf(93, ++i)) < 0) {
                throw new IllegalArgumentException("'[' without closing ']': " + inSpecifier);
            }
            i = Integer.parseInt(inSpecifier.substring(i, j));
            ArrayList array = (ArrayList)inObject;
            int n = array.size();
            if (i < 0) {
                i = n - 1;
            }
            obj = i >= 0 && i < n ? array.get(i) : null;
        } else {
            Map map = (Map)inObject;
            obj = map.get(inSpecifier);
        }
        return obj;
    }

    public static Object readXML(Reader inReader) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError, ParseException {
        XMLReader reader = PropertyListUtilities.getParser().getXMLReader();
        Handler handler = new Handler();
        reader.setContentHandler(handler);
        reader.setEntityResolver(handler);
        reader.setErrorHandler(handler);
        reader.parse(new InputSource(inReader));
        return handler.postProcess();
    }

    public static void writeXML(Object inObject, Writer inWriter) throws IOException {
        inWriter.write(PLIST_XML_DECLARATION);
        inWriter.write(PLIST_XML_DOCTYPE);
        inWriter.write(PLIST_XML_VERSION_BEGIN);
        PropertyListUtilities.writeXMLLevel(inObject, 0, inWriter);
        inWriter.write(PLIST_XML_VERSION_END);
    }

    protected static void writeXMLLevel(Object inObject, int inDepth, Writer inWriter) throws IOException {
        if (inObject instanceof ArrayList) {
            ArrayList array = (ArrayList)inObject;
            if (array.size() > 0) {
                PropertyListUtilities.writeStringWithIndent(PLIST_XML_ARRAY_BEGIN, inDepth, inWriter);
                Iterator iter = ((AbstractList)array).iterator();
                while (iter.hasNext()) {
                    PropertyListUtilities.writeXMLLevel(iter.next(), inDepth + 1, inWriter);
                }
                PropertyListUtilities.writeStringWithIndent(PLIST_XML_ARRAY_END, inDepth, inWriter);
            } else {
                PropertyListUtilities.writeStringWithIndent(PLIST_XML_ARRAY_EMPTY, inDepth, inWriter);
            }
        } else if (inObject instanceof byte[]) {
            PropertyListUtilities.writeStringWithIndent(PLIST_XML_DATA_BEGIN, inDepth, inWriter);
            inWriter.write(Base64Utilities.encodeLines((byte[])inObject, inDepth));
            PropertyListUtilities.writeStringWithIndent(PLIST_XML_DATA_END, inDepth, inWriter);
        } else if (inObject instanceof Date) {
            SimpleDateFormat plistDateFormat = new SimpleDateFormat(PLIST_DATE_FORMAT);
            plistDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            PropertyListUtilities.writeStringWithIndent(PLIST_XML_DATE_BEGIN, inDepth, inWriter);
            inWriter.write(plistDateFormat.format((Date)inObject));
            inWriter.write(PLIST_XML_DATE_END);
        } else if (inObject instanceof Map) {
            Map dictionary = (Map)inObject;
            if (dictionary.size() > 0) {
                PropertyListUtilities.writeStringWithIndent(PLIST_XML_DICTIONARY_BEGIN, inDepth, inWriter);
                Iterator iter = dictionary.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    PropertyListUtilities.writeStringWithIndent(PLIST_XML_KEY_BEGIN, inDepth + 1, inWriter);
                    PropertyListUtilities.writeMinimallyEscapedXML((String)entry.getKey(), inWriter);
                    inWriter.write(PLIST_XML_KEY_END);
                    PropertyListUtilities.writeXMLLevel(entry.getValue(), inDepth + 1, inWriter);
                    if (!iter.hasNext()) continue;
                    inWriter.write(10);
                }
                PropertyListUtilities.writeStringWithIndent(PLIST_XML_DICTIONARY_END, inDepth, inWriter);
            } else {
                PropertyListUtilities.writeStringWithIndent(PLIST_XML_DICTIONARY_EMPTY, inDepth, inWriter);
            }
        } else if (inObject instanceof Byte || inObject instanceof Short || inObject instanceof Long || inObject instanceof Integer) {
            PropertyListUtilities.writeStringWithIndent(PLIST_XML_INTEGER_BEGIN, inDepth, inWriter);
            inWriter.write(inObject.toString());
            inWriter.write(PLIST_XML_INTEGER_END);
        } else if (inObject instanceof Double) {
            PropertyListUtilities.writeStringWithIndent(PLIST_XML_REAL_BEGIN, inDepth, inWriter);
            inWriter.write(inObject.toString());
            inWriter.write(PLIST_XML_REAL_END);
        } else if (inObject instanceof String) {
            PropertyListUtilities.writeStringWithIndent(PLIST_XML_STRING_BEGIN, inDepth, inWriter);
            PropertyListUtilities.writeMinimallyEscapedXML((String)inObject, inWriter);
            inWriter.write(PLIST_XML_STRING_END);
        } else if (inObject instanceof Boolean) {
            if (((Boolean)inObject).booleanValue()) {
                PropertyListUtilities.writeStringWithIndent(PLIST_XML_BOOLEAN_TRUE, inDepth, inWriter);
            } else {
                PropertyListUtilities.writeStringWithIndent(PLIST_XML_BOOLEAN_FALSE, inDepth, inWriter);
            }
        } else {
            throw new IllegalArgumentException("unexpected object type = \"" + inObject.getClass().toString() + "\"");
        }
    }

    public static void writeStringWithIndent(String inString, int inDepth, Writer inWriter) throws IOException {
        int i = 0;
        while (i < inDepth) {
            inWriter.write(9);
            ++i;
        }
        inWriter.write(inString);
    }

    public static void writeMinimallyEscapedXML(String inString, Writer inWriter) throws IOException {
        int n = inString.length();
        int i = 0;
        while (i < n) {
            char c = inString.charAt(i);
            switch (c) {
                case '&': {
                    inWriter.write("&amp;");
                    break;
                }
                case '<': {
                    inWriter.write("&lt;");
                    break;
                }
                case '>': {
                    inWriter.write("&gt;");
                    break;
                }
                default: {
                    inWriter.write(c);
                    break;
                }
            }
            ++i;
        }
    }

    public static Object deepCopy(Object inObject) {
        Object obj;
        if (inObject instanceof ArrayList) {
            ArrayList oldArray = (ArrayList)inObject;
            ArrayList<Object> newArray = new ArrayList<Object>();
            Iterator iter = ((AbstractList)oldArray).iterator();
            while (iter.hasNext()) {
                newArray.add(PropertyListUtilities.deepCopy(iter.next()));
            }
            obj = newArray;
        } else if (inObject instanceof byte[]) {
            obj = ((byte[])inObject).clone();
        } else if (inObject instanceof Date) {
            obj = ((Date)inObject).clone();
        } else if (inObject instanceof Map) {
            Map oldDict = (Map)inObject;
            HashMap<Object, Object> newDict = new HashMap<Object, Object>();
            Iterator iter = oldDict.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                newDict.put(PropertyListUtilities.deepCopy(entry.getKey()), PropertyListUtilities.deepCopy(entry.getValue()));
            }
            obj = newDict;
        } else if (inObject instanceof Byte) {
            obj = inObject;
        } else if (inObject instanceof Short) {
            obj = inObject;
        } else if (inObject instanceof Integer) {
            obj = inObject;
        } else if (inObject instanceof Long) {
            obj = inObject;
        } else if (inObject instanceof Double) {
            obj = inObject;
        } else if (inObject instanceof String) {
            obj = inObject;
        } else if (inObject instanceof Boolean) {
            obj = inObject;
        } else {
            throw new IllegalArgumentException("unexpected object type = \"" + inObject.getClass().toString() + "\"");
        }
        return obj;
    }

    public static boolean isCompatibleObject(Object inObject) {
        return inObject != null && (inObject instanceof ArrayList || inObject instanceof Boolean || inObject instanceof byte[] || inObject instanceof Date || inObject instanceof Map || inObject instanceof Byte || inObject instanceof Short || inObject instanceof Integer || inObject instanceof Long || inObject instanceof Double || inObject instanceof String);
    }

    protected static SAXParser getParser() throws SAXException, ParserConfigurationException, FactoryConfigurationError {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        return factory.newSAXParser();
    }

    public static void main(String[] inArgs) {
    }

    protected static final class Handler
    extends DefaultHandler {
        public static final String APPLE_PROPERTY_LIST_DTD_URL_PREFIX = "http://www.apple.com/DTDs/PropertyList";
        public static final String APPLE_PROPERTY_LIST_DTD = "<!ENTITY % plistObject \"(array | data | date | dict | real | integer | string | true | false )\" >\n<!ELEMENT plist %plistObject;>\n<!ATTLIST plist version CDATA \"1.0\" >\n<!ELEMENT array (%plistObject;)*>\n<!ELEMENT dict (key, %plistObject;)*>\n<!ELEMENT key (#PCDATA)>\n<!ELEMENT string (#PCDATA)>\n<!ELEMENT data (#PCDATA)>\n<!ELEMENT date (#PCDATA)>\n<!ELEMENT true EMPTY>\n<!ELEMENT false EMPTY>\n<!ELEMENT real (#PCDATA)>\n<!ELEMENT integer (#PCDATA)>";
        protected static final String ELEMENT_NAME_PLIST = "plist";
        protected static final String ELEMENT_NAME_KEY = "key";
        protected static final String ELEMENT_NAME_ARRAY = "array";
        protected static final String ELEMENT_NAME_DATA = "data";
        protected static final String ELEMENT_NAME_DATE = "date";
        protected static final String ELEMENT_NAME_DICTIONARY = "dict";
        protected static final String ELEMENT_NAME_INTEGER = "integer";
        protected static final String ELEMENT_NAME_REAL = "real";
        protected static final String ELEMENT_NAME_STRING = "string";
        protected static final String ELEMENT_NAME_TRUE = "true";
        protected static final String ELEMENT_NAME_FALSE = "false";
        protected Node rootNode;
        protected Node currentNode;

        public void startElement(String inURI, String inName, String inQualifiedName, Attributes inAttributes) {
            Node newNode = new Node();
            if (inName != null && inName.length() > 0) {
                newNode.name = inName;
            } else if (inQualifiedName != null && inQualifiedName.length() > 0) {
                newNode.name = inQualifiedName;
            } else {
                throw new IllegalArgumentException("null or empty XML node name");
            }
            if (this.currentNode != null) {
                newNode.parent = this.currentNode;
                if (this.currentNode.lastChild != null) {
                    this.currentNode.lastChild.next = newNode;
                } else {
                    this.currentNode.firstChild = newNode;
                }
                this.currentNode.lastChild = newNode;
            } else {
                this.rootNode = newNode;
            }
            this.currentNode = newNode;
        }

        public void endElement(String inURI, String inName, String inQualifiedName) {
            if (this.currentNode != null) {
                this.currentNode = this.currentNode.parent;
            }
        }

        public void characters(char[] inCharacters, int inStart, int inLength) {
            if (this.currentNode != null) {
                if (this.currentNode.data == null) {
                    this.currentNode.data = new StringBuffer();
                }
                this.currentNode.data.append(inCharacters, inStart, inLength);
            }
        }

        public Object postProcess() throws ParseException, UnsupportedEncodingException {
            if (this.rootNode == null || !this.rootNode.name.equals(ELEMENT_NAME_PLIST)) {
                throw new IllegalArgumentException("no top-level plist element");
            }
            if (this.rootNode.firstChild == null) {
                throw new IllegalArgumentException("no element underneath plist element");
            }
            return this.postProcessNode(this.rootNode.firstChild);
        }

        public Object postProcessNode(Node inNode) throws ParseException, UnsupportedEncodingException {
            Object object;
            if (inNode.name.equals(ELEMENT_NAME_ARRAY)) {
                ArrayList<Object> array = new ArrayList<Object>();
                Node child = inNode.firstChild;
                while (child != null) {
                    array.add(this.postProcessNode(child));
                    child = child.next;
                }
                object = array;
            } else if (inNode.name.equals(ELEMENT_NAME_DATA)) {
                object = inNode.data != null ? Base64Utilities.decode(inNode.data.toString()) : new byte[]{};
            } else if (inNode.name.equals(ELEMENT_NAME_DATE)) {
                if (inNode.data == null) {
                    throw new IllegalArgumentException("no content for date element");
                }
                SimpleDateFormat plistDateFormat = new SimpleDateFormat(PropertyListUtilities.PLIST_DATE_FORMAT);
                plistDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                object = plistDateFormat.parse(inNode.data.toString());
            } else if (inNode.name.equals(ELEMENT_NAME_DICTIONARY)) {
                HashMap<String, Object> dictionary = new HashMap<String, Object>();
                Node child = inNode.firstChild;
                while (child != null) {
                    if (!child.name.equals(ELEMENT_NAME_KEY)) {
                        throw new IllegalArgumentException("invalid key node type = \"" + child.name + "\"");
                    }
                    if (child.next == null) {
                        throw new IllegalArgumentException("key node without value node following it = \"" + child.name + "\"");
                    }
                    String key = child.data != null ? child.data.toString() : "";
                    dictionary.put(key, this.postProcessNode(child.next));
                    child = child.next;
                    child = child.next;
                }
                object = dictionary;
            } else if (inNode.name.equals(ELEMENT_NAME_INTEGER)) {
                if (inNode.data == null) {
                    throw new IllegalArgumentException("no content for integer element");
                }
                object = Long.valueOf(inNode.data.toString());
            } else if (inNode.name.equals(ELEMENT_NAME_REAL)) {
                if (inNode.data == null) {
                    throw new IllegalArgumentException("no content for real element");
                }
                object = Double.valueOf(inNode.data.toString());
            } else if (inNode.name.equals(ELEMENT_NAME_STRING)) {
                object = inNode.data != null ? (Object)inNode.data.toString() : (Object)"";
            } else if (inNode.name.equals(ELEMENT_NAME_TRUE)) {
                object = Boolean.TRUE;
            } else if (inNode.name.equals(ELEMENT_NAME_FALSE)) {
                object = Boolean.FALSE;
            } else {
                throw new IllegalArgumentException("unexpected node type = \"" + inNode.name + "\"");
            }
            return object;
        }

        public InputSource resolveEntity(String inPublicID, String inSystemID) throws SAXException {
            if (inSystemID.startsWith(APPLE_PROPERTY_LIST_DTD_URL_PREFIX)) {
                return new InputSource(new StringReader(APPLE_PROPERTY_LIST_DTD));
            }
            return null;
        }

        protected Handler() {
        }

        protected static final class Node {
            public Node next;
            public Node parent;
            public Node firstChild;
            public Node lastChild;
            public String name;
            public StringBuffer data;

            protected Node() {
            }
        }
    }
}

