/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util.prefs;

import com.apple.util.plist.PropertyListUtilities;
import com.apple.util.prefs.PreferencesFactory;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Preferences {
    public final Object lock = new Object();
    protected String identifier;
    protected Map dictionary;
    protected Map defaults = new HashMap();
    protected boolean loaded;
    protected int changeCount;
    protected ArrayList preferenceChangeListeners = new ArrayList();

    public static Preferences getPreferences(String inIdentifier) {
        return PreferencesFactory.getPreferences(inIdentifier);
    }

    public Preferences() {
    }

    public Preferences(String inIdentifier) {
        this.identifier = inIdentifier;
    }

    public ArrayList getArray(String inKey, ArrayList inDefault) {
        return (ArrayList)this.get(inKey, inDefault);
    }

    public void setArray(String inKey, ArrayList inArray) {
        this.set(inKey, inArray);
    }

    public boolean getBoolean(String inKey, boolean inDefault) {
        Boolean obj = (Boolean)this.get(inKey, null);
        return obj != null ? obj : inDefault;
    }

    public void setBoolean(String inKey, boolean inBoolean) {
        this.set(inKey, new Boolean(inBoolean));
    }

    public byte[] getData(String inKey, byte[] inDefault) {
        return (byte[])this.get(inKey, inDefault);
    }

    public void setData(String inKey, byte[] inData) {
        this.set(inKey, inData);
    }

    public Date getDate(String inKey, Date inDefault) {
        return (Date)this.get(inKey, inDefault);
    }

    public void setDate(String inKey, Date inDate) {
        this.set(inKey, inDate);
    }

    public Map getDictionary(String inKey, Map inDefault) {
        return (Map)this.get(inKey, inDefault);
    }

    public void setDictionary(String inKey, Map inDictionary) {
        this.set(inKey, inDictionary);
    }

    public byte getByte(String inKey, byte inDefault) {
        Number obj = (Number)this.get(inKey, null);
        return obj != null ? obj.byteValue() : inDefault;
    }

    public void setByte(String inKey, byte inByte) {
        this.set(inKey, new Long(inByte));
    }

    public short getShort(String inKey, short inDefault) {
        Number obj = (Number)this.get(inKey, null);
        return obj != null ? obj.shortValue() : inDefault;
    }

    public void setShort(String inKey, short inShort) {
        this.set(inKey, new Long(inShort));
    }

    public int getInteger(String inKey, int inDefault) {
        Number obj = (Number)this.get(inKey, null);
        return obj != null ? obj.intValue() : inDefault;
    }

    public void setInteger(String inKey, int inInteger) {
        this.set(inKey, new Long(inInteger));
    }

    public long getLong(String inKey, long inDefault) {
        Number obj = (Number)this.get(inKey, null);
        return obj != null ? obj.longValue() : inDefault;
    }

    public void setLong(String inKey, long inValue) {
        this.set(inKey, new Long(inValue));
    }

    public float getFloat(String inKey, float inDefault) {
        Number obj = (Number)this.get(inKey, null);
        return obj != null ? obj.floatValue() : inDefault;
    }

    public void setFloat(String inKey, float inFloat) {
        this.set(inKey, new Double(inFloat));
    }

    public double getDouble(String inKey, double inDefault) {
        Number obj = (Number)this.get(inKey, null);
        return obj != null ? obj.doubleValue() : inDefault;
    }

    public void setDouble(String inKey, double inDouble) {
        this.set(inKey, new Double(inDouble));
    }

    public String getString(String inKey, String inDefault) {
        return (String)this.get(inKey, inDefault);
    }

    public void setString(String inKey, String inString) {
        this.set(inKey, inString);
    }

    public boolean exists(String inKey) {
        Object object = this.lock;
        synchronized (object) {
            this.prepare();
            boolean $return = this.dictionary.get(inKey) != null;
            Object var4_4 = null;
            return $return;
        }
    }

    public Object get(String inKey, Object inDefault) {
        Object object = this.lock;
        synchronized (object) {
            this.prepare();
            Object obj = this.dictionary.get(inKey);
            if (obj == null && (obj = this.defaults.get(inKey)) == null) {
                obj = inDefault;
            }
            if (obj != null) {
                obj = PropertyListUtilities.deepCopy(obj);
            }
            Object $return = obj;
            Object var5_6 = null;
            return $return;
        }
    }

    public Object set(String inKey, Object inObject) {
        Object newObj;
        Object oldObj;
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            this.prepare();
            if (inObject != null) {
                if (!PropertyListUtilities.isCompatibleObject(inObject)) {
                    throw new IllegalArgumentException("object is not plist compatible (" + inObject.getClass().toString() + ")");
                }
                oldObj = this.dictionary.get(inKey);
                if (oldObj == null || !oldObj.equals(inObject)) {
                    newObj = PropertyListUtilities.deepCopy(inObject);
                    oldObj = this.dictionary.put(inKey, newObj);
                    ++this.changeCount;
                    changed = true;
                } else {
                    newObj = null;
                }
            } else {
                oldObj = this.dictionary.remove(inKey);
                if (oldObj != null) {
                    newObj = null;
                    ++this.changeCount;
                    changed = true;
                } else {
                    newObj = null;
                }
            }
        }
        if (changed) {
            this.fireChangeEvent(inKey, oldObj, newObj);
        }
        return oldObj;
    }

    public Object remove(String inKey) {
        Object oldObj;
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            this.prepare();
            oldObj = this.dictionary.remove(inKey);
            if (oldObj != null) {
                ++this.changeCount;
                changed = true;
            }
        }
        if (changed) {
            this.fireChangeEvent(inKey, oldObj, null);
        }
        return oldObj;
    }

    public void synchronize() {
        Object object = this.lock;
        synchronized (object) {
            if (this.changeCount > 0) {
                this.store();
            }
        }
    }

    public void setDefaults(Map inDefaults) {
        Object object = this.lock;
        synchronized (object) {
            this.defaults = (Map)PropertyListUtilities.deepCopy(inDefaults);
        }
    }

    protected void prepare() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.loaded) {
                this.load();
                this.loaded = true;
            }
        }
    }

    public abstract void load();

    public abstract void store();

    public void addPreferenceChangeListener(PreferenceChangeListener inListener) {
        Object object = this.lock;
        synchronized (object) {
            this.preferenceChangeListeners.add(inListener);
        }
    }

    public void removePreferenceChangeListener(PreferenceChangeListener inListener) {
        Object object = this.lock;
        synchronized (object) {
            ((AbstractCollection)this.preferenceChangeListeners).remove(inListener);
        }
    }

    protected void fireChangeEvent(String inKey, Object inOldValue, Object inNewValue) {
        ArrayList preferenceChangeListenersCopy;
        PreferenceChangeEvent event = new PreferenceChangeEvent(this, inKey, inOldValue, inNewValue);
        Object object = this.lock;
        synchronized (object) {
            preferenceChangeListenersCopy = (ArrayList)this.preferenceChangeListeners.clone();
        }
        Iterator iter = ((AbstractList)preferenceChangeListenersCopy).iterator();
        while (iter.hasNext()) {
            PreferenceChangeListener listener = (PreferenceChangeListener)iter.next();
            listener.preferenceChanged(event);
        }
    }

    public static class PreferenceChangeEvent
    extends EventObject {
        protected String key;
        protected Object oldValue;
        protected Object newValue;

        public PreferenceChangeEvent(Preferences inSource, String inKey, Object inOldValue, Object inNewValue) {
            super(inSource);
            this.key = inKey;
            this.oldValue = inOldValue;
            this.newValue = inNewValue;
        }

        public String getKey() {
            return this.key;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }
    }

    public static interface PreferenceChangeListener
    extends EventListener {
        public void preferenceChanged(PreferenceChangeEvent var1);
    }
}

