/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertListener;
import com.apple.xsr.KeyPressForwardingPanel;
import com.apple.xsr.ShadowedPanel;
import com.apple.xsr.StandardAlertPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class AquaAlert
implements KeyListener {
    public static final int DEFAULT_BUTTON_HIT = 1;
    public static final int ALTERNATE_BUTTON_HIT = 2;
    public static final int OTHER_BUTTON_HIT = 3;
    public static final int USER_BUTTON_HIT = 4;
    private static final int frameDuration = 20;
    private static final int frameAngle = 5;
    private static final boolean useDropShadows = true;
    private JButton contentPaneDefaultButton;
    private JButton alertAlternateButton;
    private JButton alertOtherButton;
    private JDialog dialog;
    private JFrame parent;
    private JPanel contentPanel;
    private boolean isSheet;
    private boolean dialogDismissed = false;
    private Object contextInfoObject;
    private Set keyEquivalentsForButtons;
    private final EventListenerList listenerList = new EventListenerList();
    MaskPanel maskPanel;
    ComponentListener resizeListener;
    private static final int INTERBUTTON_SPACING = 12;
    private static final int MIN_VERTICAL_RESIZE_DELTA = 5;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$com$apple$xsr$AquaAlertListener;

    public AquaAlert(JPanel panel, JButton defaultButton, JButton alternateButton, JButton otherButton) {
        this.contentPanel = new KeyPressForwardingPanel(panel, this);
        this.contentPaneDefaultButton = defaultButton;
        this.alertAlternateButton = alternateButton;
        this.alertOtherButton = otherButton;
        this.keyEquivalentsForButtons = null;
        if (defaultButton != null) {
            this.setUpActionListenerForButton(defaultButton, 1);
        }
        if (alternateButton != null) {
            this.setUpActionListenerForButton(alternateButton, 2);
        }
        if (otherButton != null) {
            this.setUpActionListenerForButton(otherButton, 3);
        }
    }

    public static AquaAlert createStandardAquaAlert(String message, String explanation, Image icon, String defaultButtonString, String alternateButtonString, String otherButtonString) {
        StandardAlertPanel standardAlert = new StandardAlertPanel(message, explanation, icon, defaultButtonString, alternateButtonString, otherButtonString);
        AquaAlert theAlert = new AquaAlert(standardAlert, standardAlert.getDefaultButton(), standardAlert.getAlternateButton(), standardAlert.getOtherButton());
        if (defaultButtonString != null) {
            theAlert.associateKeyCodeWithButton(10, 0, 1);
        }
        if (alternateButtonString != null) {
            theAlert.associateKeyCodeWithButton(46, 4, 2);
            theAlert.associateKeyCodeWithButton(27, 0, 2);
        }
        return theAlert;
    }

    private void setUpActionListenerForButton(JButton button, int inButtonReturnType) {
        JButton finalButton = button;
        finalButton.addActionListener(new 1(inButtonReturnType, this));
    }

    private void performButtonOrKeyEquivalentAction(int inButtonReturnType) {
        if (!this.dialogDismissed) {
            if (this.listenerList.getListenerCount() == 0) {
                this.dialogDismissed = true;
                this.dismissSheetOrDialog(inButtonReturnType);
            } else if (this.fireAllowAquaAlertToBeDismissed(inButtonReturnType, this.contextInfoObject)) {
                this.dialogDismissed = true;
                this.dismissSheetOrDialog(inButtonReturnType);
            }
        }
    }

    public Dimension getSize() {
        return new Dimension(this.contentPanel.getWidth(), this.contentPanel.getHeight());
    }

    public void dismissSheetOrDialog(int inButtonReturnType) {
        if (this.isSheet) {
            new AnimateUpThread().sheetClosed(inButtonReturnType);
        } else {
            this.dialog.dispose();
            this.fireAquaAlertDismissed(inButtonReturnType, this.contextInfoObject);
        }
    }

    private void showDialogImpl(JFrame parentFrame, String title) {
        this.isSheet = false;
        this.parent = parentFrame;
        Frame owner = null;
        owner = this.parent instanceof Frame ? this.parent : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = AquaAlert.class$("java.awt.Frame")), this.parent);
        if (this.dialog == null || this.dialog.getOwner() != owner) {
            this.dialog = new JDialog(owner, true);
            ((JPanel)this.dialog.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
            this.dialog.getContentPane().add(this.contentPanel);
            this.dialog.pack();
        }
        if (title != null) {
            this.dialog.setTitle(title);
        }
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(owner);
        JRootPane rootPane = this.contentPanel.getRootPane();
        if (rootPane != null) {
            rootPane.setDefaultButton(this.contentPaneDefaultButton);
        }
        this.requestFocusForAButton();
        this.dialog.show();
    }

    private void showSheetImpl(JFrame parentFrame) {
        if (parentFrame == null) {
            this.showDialogImpl(null, "");
            return;
        }
        this.isSheet = true;
        this.parent = parentFrame;
        this.resizeListener = new 2();
        this.parent.addComponentListener(this.resizeListener);
        this.contentPanel = new ShadowedPanel(this.contentPanel);
        Dimension dim = this.contentPanel.getPreferredSize();
        this.contentPanel.setBounds(this.parent.getSize().width / 2 - dim.width / 2, -dim.height, dim.width, dim.height);
        this.parent.getLayeredPane().add((Component)this.contentPanel, new Integer(1001));
        this.maskPanel = new MaskPanel();
        this.maskPanel.setBounds(0, 0, this.parent.getSize().width, this.parent.getSize().height);
        this.parent.getLayeredPane().add((Component)this.maskPanel, new Integer(1000));
        new AnimateDownThread().start();
    }

    public void showSheet(JFrame parentFrame) {
        this.showSheet(parentFrame, null);
    }

    public void showSheet(JFrame parentFrame, Object contextInfo) {
        this.contextInfoObject = contextInfo;
        this.fireAquaAlertWillBeShown(this.contextInfoObject);
        this.showSheetImpl(parentFrame);
    }

    public void showSheet(JFrame parentFrame, AquaAlertListener alertListener, Object contextInfo) {
        if (alertListener != null) {
            this.addAquaAlertListener(alertListener);
        }
        this.showSheet(parentFrame, contextInfo);
    }

    public void showDialog(JFrame parentFrame, String title) {
        this.showDialog(parentFrame, title, null);
    }

    public void showDialog(JFrame parentFrame, String title, Object contextInfo) {
        this.contextInfoObject = contextInfo;
        this.fireAquaAlertWillBeShown(this.contextInfoObject);
        this.showDialogImpl(parentFrame, title);
    }

    public void showDialog(JFrame parentFrame, String title, AquaAlertListener alertListener, Object contextInfo) {
        if (alertListener != null) {
            this.addAquaAlertListener(alertListener);
        }
        this.showDialog(parentFrame, title, contextInfo);
    }

    public void resizeVertically(int newHeight) {
        this.resizeVertically(newHeight, null);
    }

    public void resizeVertically(int newHeight, Object contextInfo) {
        this.contextInfoObject = contextInfo;
        new AnimateResizeThread(newHeight).start();
    }

    public void resizeVertically(int newHeight, AquaAlertListener alertListener, Object contextInfo) {
        if (alertListener != null) {
            this.addAquaAlertListener(alertListener);
        }
        this.resizeVertically(newHeight, contextInfo);
    }

    public void resizeVertically() {
        this.resizeVertically(null);
    }

    public void resizeVertically(Object contextInfo) {
        this.contextInfoObject = contextInfo;
        Dimension d = this.contentPanel.getPreferredSize();
        if (d != null) {
            new AnimateResizeThread(d.height).start();
        }
    }

    public void resizeVertically(AquaAlertListener alertListener, Object contextInfo) {
        if (alertListener != null) {
            this.addAquaAlertListener(alertListener);
        }
        this.resizeVertically(contextInfo);
    }

    public void addAquaAlertListener(AquaAlertListener listener) {
        Object[] listeners = this.listenerList.getListenerList();
        boolean alreadyInList = false;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i + 1] == listener) {
                alreadyInList = true;
            }
            i -= 2;
        }
        if (!alreadyInList) {
            this.listenerList.add(class$com$apple$xsr$AquaAlertListener != null ? class$com$apple$xsr$AquaAlertListener : (class$com$apple$xsr$AquaAlertListener = AquaAlert.class$("com.apple.xsr.AquaAlertListener")), listener);
        }
    }

    public void removeAquaAlertListener(AquaAlertListener listener) {
        this.listenerList.remove(class$com$apple$xsr$AquaAlertListener != null ? class$com$apple$xsr$AquaAlertListener : (class$com$apple$xsr$AquaAlertListener = AquaAlert.class$("com.apple.xsr.AquaAlertListener")), listener);
    }

    protected void fireAquaAlertWillBeShown(Object context) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$apple$xsr$AquaAlertListener != null ? class$com$apple$xsr$AquaAlertListener : AquaAlert.class$("com.apple.xsr.AquaAlertListener"))) {
                ((AquaAlertListener)listeners[i + 1]).aquaAlertWillBeShown(context);
            }
            i -= 2;
        }
    }

    protected void fireAquaAlertSheetVisible(Object context) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$apple$xsr$AquaAlertListener != null ? class$com$apple$xsr$AquaAlertListener : AquaAlert.class$("com.apple.xsr.AquaAlertListener"))) {
                ((AquaAlertListener)listeners[i + 1]).aquaAlertSheetVisible(context);
            }
            i -= 2;
        }
    }

    protected void fireAquaAlertDismissed(int buttonReturnType, Object context) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$apple$xsr$AquaAlertListener != null ? class$com$apple$xsr$AquaAlertListener : AquaAlert.class$("com.apple.xsr.AquaAlertListener"))) {
                ((AquaAlertListener)listeners[i + 1]).aquaAlertDismissed(buttonReturnType, context);
            }
            i -= 2;
        }
    }

    protected boolean fireAllowAquaAlertToBeDismissed(int buttonReturnType, Object context) {
        Object[] listeners = this.listenerList.getListenerList();
        boolean allow = true;
        int i = listeners.length - 2;
        while (i >= 0) {
            boolean b;
            if (listeners[i] == (class$com$apple$xsr$AquaAlertListener != null ? class$com$apple$xsr$AquaAlertListener : AquaAlert.class$("com.apple.xsr.AquaAlertListener")) && !(b = ((AquaAlertListener)listeners[i + 1]).allowAquaAlertToBeDismissed(buttonReturnType, context))) {
                allow = false;
            }
            i -= 2;
        }
        return allow;
    }

    protected void fireAquaAlertResized(Object context) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$apple$xsr$AquaAlertListener != null ? class$com$apple$xsr$AquaAlertListener : AquaAlert.class$("com.apple.xsr.AquaAlertListener"))) {
                ((AquaAlertListener)listeners[i + 1]).aquaAlertResized(context);
            }
            i -= 2;
        }
    }

    private void requestFocusForAButton() {
        if (this.contentPaneDefaultButton != null) {
            this.contentPaneDefaultButton.requestFocus();
        } else if (this.alertAlternateButton != null) {
            this.alertAlternateButton.requestFocus();
        } else if (this.alertOtherButton != null) {
            this.alertOtherButton.requestFocus();
        }
    }

    void animateDownThread() {
        this.contentPanel.setOpaque(true);
        int slide = 0;
        while (slide <= 90) {
            int xposition = this.contentPanel.getLocation().x;
            int height = this.contentPanel.getHeight();
            this.contentPanel.setLocation(xposition, (int)((double)(-1 - height) + (double)height * Math.sin((double)slide / 180.0 * Math.PI)));
            this.contentPanel.repaint();
            this.doDelay(20);
            slide += 5;
        }
        this.contentPanel.setOpaque(false);
        this.contentPanel.repaint();
        this.parent.getRootPane().setDefaultButton(this.contentPaneDefaultButton);
    }

    void animateUpThread() {
        Rectangle sheetBounds = new Rectangle(this.contentPanel.getLocation(), this.contentPanel.getSize());
        this.contentPanel.setOpaque(true);
        int slide = 0;
        while (slide <= 90) {
            int xposition = this.contentPanel.getLocation().x;
            int height = this.contentPanel.getHeight();
            this.contentPanel.setLocation(xposition, (int)((double)(-1 - height) + (double)height * Math.cos((double)slide / 180.0 * Math.PI)));
            this.contentPanel.repaint();
            this.doDelay(20);
            slide += 5;
        }
        this.parent.removeComponentListener(this.resizeListener);
        this.parent.getLayeredPane().remove(this.maskPanel);
        this.parent.getLayeredPane().remove(this.contentPanel);
        this.parent.repaint(sheetBounds.x, sheetBounds.y, sheetBounds.width, sheetBounds.height);
    }

    void animateResizeThread(int newHeight) {
        int width = this.contentPanel.getWidth();
        int height = this.contentPanel.getHeight();
        int delta = newHeight - height;
        if (Math.abs(delta) < 5) {
            return;
        }
        int slide = 0;
        while (slide <= 90) {
            this.contentPanel.setSize(width, (int)((double)height + (double)delta * Math.sin((double)slide / 180.0 * Math.PI)));
            this.contentPanel.validate();
            this.doDelay(20);
            slide += 5;
        }
    }

    void doDelay(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void addComponent(Component component, Container container, GridBagLayout gbl, GridBagConstraints gbc) {
        gbl.setConstraints(component, gbc);
        container.add(component);
    }

    protected Set keyEquivalentsForButtons() {
        if (this.keyEquivalentsForButtons == null) {
            this.keyEquivalentsForButtons = new HashSet();
        }
        return this.keyEquivalentsForButtons;
    }

    public void associateKeyCodeWithButton(int inKeyCode, int inKeyModifiers, int inButtonIdentifier) {
        KeyButtonAssociation kba = new KeyButtonAssociation(inKeyCode, inKeyModifiers, inButtonIdentifier);
        Set keyEquivs = this.keyEquivalentsForButtons();
        if (keyEquivs.contains(kba)) {
            keyEquivs.remove(kba);
        }
        keyEquivs.add(kba);
    }

    public void associateKeyCodeWithButton(int inKeyCode, int inKeyModifiers, AbstractButton inUserButton) {
        KeyButtonAssociation kba = new KeyButtonAssociation(inKeyCode, inKeyModifiers, inUserButton);
        Set keyEquivs = this.keyEquivalentsForButtons();
        if (keyEquivs.contains(kba)) {
            keyEquivs.remove(kba);
        }
        keyEquivs.add(kba);
    }

    public void keyPressed(KeyEvent inEvent) {
        Iterator iter = this.keyEquivalentsForButtons().iterator();
        while (iter.hasNext()) {
            Object event = iter.next();
            if (!(event instanceof KeyButtonAssociation) || !((KeyButtonAssociation)event).sameAsKeyEvent(inEvent)) continue;
            int buttonType = ((KeyButtonAssociation)event).getButtonType();
            if (buttonType == 4) {
                AbstractButton userButton = ((KeyButtonAssociation)event).getUserButton();
                if (userButton == null) break;
                userButton.doClick();
                break;
            }
            this.performButtonOrKeyEquivalentAction(buttonType);
            break;
        }
    }

    public void keyReleased(KeyEvent inEvent) {
    }

    public void keyTyped(KeyEvent inEvent) {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static /* synthetic */ void access$2(AquaAlert $0) {
        $0.requestFocusForAButton();
    }

    static /* synthetic */ Object access$3(AquaAlert $0) {
        return $0.contextInfoObject;
    }

    private class AnimateDownThread
    extends Thread {
        public void run() {
            AquaAlert.this.animateDownThread();
            SwingUtilities.invokeLater(new 3(this));
        }

        AnimateDownThread() {
        }

        static /* synthetic */ AquaAlert access$0(AnimateDownThread $0) {
            return $0.AquaAlert.this;
        }
    }

    private class AnimateUpThread
    extends Thread {
        private int theButtonReturnType;

        void sheetClosed(int inButtonReturnType) {
            this.theButtonReturnType = inButtonReturnType;
            this.start();
        }

        public void run() {
            AquaAlert.this.animateUpThread();
            SwingUtilities.invokeLater(new 4(this));
        }

        AnimateUpThread() {
        }

        static /* synthetic */ AquaAlert access$0(AnimateUpThread $0) {
            return $0.AquaAlert.this;
        }

        static /* synthetic */ int access$1(AnimateUpThread $0) {
            return $0.theButtonReturnType;
        }
    }

    private class AnimateResizeThread
    extends Thread {
        int newHeight;

        AnimateResizeThread(int newHeight) {
            this.newHeight = newHeight;
        }

        public void run() {
            AquaAlert.this.animateResizeThread(this.newHeight);
            SwingUtilities.invokeLater(new 5(this));
        }

        static /* synthetic */ AquaAlert access$0(AnimateResizeThread $0) {
            return $0.AquaAlert.this;
        }
    }

    private static class MaskPanel
    extends JPanel {
        MaskPanel() {
            this.setOpaque(false);
            this.enableEvents(16L);
        }
    }

    private static class KeyButtonAssociation {
        int keyCode;
        int keyModifiers;
        int buttonType;
        AbstractButton userButton;

        public KeyButtonAssociation(int inKeyCode, int inKeyModifiers, int inButtonType) {
            this.setKeyCode(inKeyCode);
            this.setKeyModifiers(inKeyModifiers);
            this.setButtonType(inButtonType);
        }

        public KeyButtonAssociation(int inKeyCode, int inKeyModifiers, AbstractButton inUserButton) {
            this.setKeyCode(inKeyCode);
            this.setKeyModifiers(inKeyModifiers);
            this.setButtonType(4);
            this.setUserButton(inUserButton);
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public void setKeyCode(int inKeyCode) {
            this.keyCode = inKeyCode;
        }

        public int getKeyModifiers() {
            return this.keyModifiers;
        }

        public void setKeyModifiers(int inKeyModifiers) {
            this.keyModifiers = inKeyModifiers;
        }

        public int getButtonType() {
            return this.buttonType;
        }

        public void setButtonType(int inButtonType) {
            this.buttonType = inButtonType;
        }

        public AbstractButton getUserButton() {
            return this.userButton;
        }

        public void setUserButton(AbstractButton inUserButton) {
            this.userButton = inUserButton;
        }

        public boolean sameAsKeyEvent(KeyEvent inEvent) {
            boolean isEqual = false;
            if (this.keyCode == inEvent.getKeyCode() && this.keyModifiers == inEvent.getModifiers()) {
                isEqual = true;
            }
            return isEqual;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyButtonAssociation)) {
                return false;
            }
            KeyButtonAssociation kba = (KeyButtonAssociation)o;
            return kba.keyCode == this.keyCode && kba.keyModifiers == this.keyModifiers;
        }

        public int hashCode() {
            int result = 13;
            result = 37 * result + this.keyCode;
            result = 37 * result + this.keyModifiers;
            return result;
        }

        public String toString() {
            String s = String.valueOf(this.getClass().getName()) + "[";
            s = String.valueOf(s) + "keyCode=" + this.keyCode + ",";
            s = String.valueOf(s) + "keyModifiers=" + this.keyModifiers + ",";
            s = String.valueOf(s) + "buttonType=" + this.buttonType + ",";
            s = String.valueOf(s) + "userButton=" + this.userButton;
            s = String.valueOf(s) + "]";
            return s;
        }
    }

    private static final class 1
    implements ActionListener {
        private final /* synthetic */ AquaAlert this$0;
        private final /* synthetic */ int val$inButtonReturnType;

        public void actionPerformed(ActionEvent e) {
            this.this$0.performButtonOrKeyEquivalentAction(this.val$inButtonReturnType);
        }

        /* synthetic */ 1(int val$inButtonReturnType, AquaAlert this$0) {
            this.val$inButtonReturnType = val$inButtonReturnType;
            this.this$0 = this$0;
        }
    }

    private final class 2
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            AquaAlert.this.maskPanel.setBounds(0, 0, e.getComponent().getSize().width, e.getComponent().getSize().height);
            AquaAlert.this.contentPanel.setLocation(e.getComponent().getSize().width / 2 - AquaAlert.this.contentPanel.getWidth() / 2, -2);
        }

        /* synthetic */ 2() {
        }
    }
}

