/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.plaf.ViewportUI;
import javax.swing.table.TableColumnModel;

class AquaLinedViewportUI
extends ViewportUI {
    static final Color lightBlue = new Color(0.929f, 0.953f, 0.996f);
    final Color grayVLine = new Color(0.851f, 0.851f, 0.851f);
    JTable table;
    JScrollPane scrollpane;

    AquaLinedViewportUI(JTable table, JScrollPane scrollpane) {
        this.table = table;
        this.scrollpane = scrollpane;
    }

    public void paint(Graphics g, JComponent c) {
        int rowHeight = this.table.getRowHeight();
        int viewWidth = c.getWidth();
        int viewHeight = c.getHeight();
        TableColumnModel model = this.table.getColumnModel();
        int columns = model.getColumnCount();
        Point position = this.scrollpane.getViewport().getViewPosition();
        g.setColor(lightBlue);
        int y = -position.y;
        while (y < viewHeight) {
            g.fillRect(0, y, viewWidth, rowHeight);
            y += rowHeight * 2;
        }
        g.setColor(this.grayVLine);
        int x = -position.x;
        int index = 0;
        while (index < columns) {
            g.drawLine((x += model.getColumn(index).getWidth()) - 1, 0, x - 1, viewHeight);
            ++index;
        }
    }
}

