/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.SOMLocalizer;
import com.apple.xsr.StatusIcon;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.EventListenerList;

public class ArraySelectionPanel
extends JPanel {
    public static final int ARRAY_COUNT = 6;
    public static final int NO_SELECTION = 0;
    public static final int SINGLE_SELECTION = 1;
    public static final int MULTIPLE_SELECTION = 2;
    public static final int STATUS_SELECTION = 3;
    public static final String PROP_ARRAY_INDEX = "ArrayIndex";
    public static final String PROP_ARRAY_SELECTION = "ArraySelection";
    public static final int ICON_SIZE = 12;
    public static final int ICON_HINT = 4;
    private static final Insets labelInsets = new Insets(0, 5, 0, 10);
    private static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    private RaidSystem system;
    private RadioButtonGroup radioGroup;
    private int selectionMode;
    private int count;
    private List arrayLabels = new ArrayList();
    static /* synthetic */ Class class$javax$swing$JRadioButton;
    static /* synthetic */ Class class$javax$swing$JCheckBox;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public ArraySelectionPanel(int inSelectionMode) {
        GUIFactory.configureComponentForPlatform(this);
        this.selectionMode = inSelectionMode;
        this.radioGroup = new RadioButtonGroup();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 2;
        1 actionListener = new 1();
        int column = 0;
        int array = 0;
        while (array < 6) {
            JToggleButton btn;
            ArrayLabel arrayLabel = new ArrayLabel();
            constraints.gridx = column;
            if (this.selectionMode == 3) {
                btn = arrayLabel.createButton(class$javax$swing$JRadioButton != null ? class$javax$swing$JRadioButton : ArraySelectionPanel.class$("javax.swing.JRadioButton"), false);
                this.radioGroup.add(btn);
                this.add((Component)btn, constraints);
                ++constraints.gridx;
                JLabel statusLabel = arrayLabel.createStatusLabel();
                this.add((Component)statusLabel, constraints);
                ++constraints.gridx;
            } else if (this.selectionMode == 1) {
                btn = arrayLabel.createButton(class$javax$swing$JRadioButton != null ? class$javax$swing$JRadioButton : ArraySelectionPanel.class$("javax.swing.JRadioButton"), true);
                this.radioGroup.add(btn);
                this.add((Component)btn, constraints);
                ++constraints.gridx;
            } else if (this.selectionMode == 2) {
                btn = arrayLabel.createButton(class$javax$swing$JCheckBox != null ? class$javax$swing$JCheckBox : ArraySelectionPanel.class$("javax.swing.JCheckBox"), true);
                this.add((Component)btn, constraints);
                ++constraints.gridx;
            }
            JLabel descriptionLabel = arrayLabel.createDescriptionLabel();
            constraints.insets = labelInsets;
            this.add((Component)descriptionLabel, constraints);
            constraints.insets = zeroInsets;
            ++constraints.gridx;
            arrayLabel.addActionListener(actionListener);
            this.arrayLabels.add(arrayLabel);
            ++constraints.gridy;
            if (constraints.gridy == 3) {
                constraints.gridy = 0;
                column += 3;
            }
            ++array;
        }
        constraints.gridx = column + 3;
        constraints.weightx = 1.0;
        this.add(Box.createHorizontalStrut(1), constraints);
        constraints.weightx = 0.0;
    }

    public void setRaidSystem(RaidSystem system) {
        this.system = system;
        this.configureForRaidSystem(this.system);
    }

    public void updatePanel() {
        this.configureForRaidSystem(this.system);
    }

    public void configureForRaidSystem(RaidSystem system) {
        block11: {
            this.resetPanel();
            if (system == null) {
                return;
            }
            boolean[] jbods = new boolean[2];
            Iterator iter = system.getRaidControllers().iterator();
            while (iter.hasNext()) {
                RaidController rc = (RaidController)iter.next();
                if (!rc.getRaidSets().isEmpty() || rc.getJbodMaskEnabled()) continue;
                boolean jbodPresent = false;
                Iterator disksIter = rc.getDisks().iterator();
                while (disksIter.hasNext()) {
                    Disk disk = (Disk)disksIter.next();
                    if (disk.getType() != 3 || disk.getState() != 1) continue;
                    jbodPresent = true;
                    break;
                }
                if (!jbodPresent) continue;
                jbods[rc.getId() == 1 ? 0 : 1] = true;
            }
            if (jbods[0]) {
                try {
                    String desc = Resources.getString("som.jbod.description");
                    this.updateArrayLabel(this.count, -2, desc, 0);
                    ++this.count;
                }
                catch (Exception exception) {}
            }
            Iterator iter2 = system.getRaidSets().iterator();
            while (iter2.hasNext()) {
                RaidSet raidset = (RaidSet)iter2.next();
                String desc = SOMLocalizer.getRaidSetLevelAndCapacity(raidset);
                try {
                    this.updateArrayLabel(this.count, raidset.getId(), desc, raidset.getStatus());
                    ++this.count;
                }
                catch (Exception exception) {}
            }
            if (!jbods[1]) break block11;
            try {
                String desc = Resources.getString("som.jbod.description");
                this.updateArrayLabel(this.count, -3, desc, 0);
                ++this.count;
            }
            catch (Exception exception) {}
        }
    }

    public void resetPanel() {
        Iterator iter = this.arrayLabels.iterator();
        while (iter.hasNext()) {
            ((ArrayLabel)iter.next()).clear();
        }
        this.count = 0;
    }

    public void setArrayIndex(int array) {
        if (array != 0) {
            ArrayLabel label = this.getLabelForArrayId(array);
            if (label != null) {
                label.setSelected(true);
            }
        } else {
            Iterator iter = this.arrayLabels.iterator();
            while (iter.hasNext()) {
                ArrayLabel label = (ArrayLabel)iter.next();
                label.setSelected(false);
            }
        }
    }

    public void setArrayCheckBoxes(List checks) {
        if (checks == null) {
            return;
        }
        int array = 0;
        while (array < checks.size()) {
            ArrayLabel label = this.getLabelForArrayId(array + 1);
            if (label != null) {
                label.setSelected((Boolean)checks.get(array));
            }
            ++array;
        }
    }

    public List getArrayCheckBoxes() {
        return Collections.EMPTY_LIST;
    }

    void updateArrayLabel(int index, int arrayId, String description, int status) {
        if (index < 0 || index > this.arrayLabels.size()) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        ArrayLabel label = (ArrayLabel)this.arrayLabels.get(index);
        if (label == null) {
            throw new NullPointerException("ArrayLabel at index " + index + " is null");
        }
        boolean buttonVisible = this.selectionMode == 1 || this.selectionMode == 2;
        label.setState(arrayId, description, status, buttonVisible);
    }

    protected ArrayLabel getLabelForArrayId(int id) {
        ArrayLabel result = null;
        Iterator iter = this.arrayLabels.iterator();
        while (iter.hasNext()) {
            ArrayLabel al = (ArrayLabel)iter.next();
            if (al.id != id) continue;
            result = al;
            break;
        }
        return result;
    }

    static String[] getArrayDescriptionsFromRaidSystem(RaidSystem rs) {
        Collection sets = rs.getRaidSets();
        String[] descriptions = new String[sets.size()];
        Iterator iter = sets.iterator();
        while (iter.hasNext()) {
            RaidSet raidset = (RaidSet)iter.next();
            descriptions[raidset.getId() - 1] = SOMLocalizer.getRaidSetLevelAndCapacity(raidset);
        }
        return descriptions;
    }

    static int[] getArrayStatusFromRaidSystem(RaidSystem rs) {
        Collection sets = rs.getRaidSets();
        int[] status = new int[sets.size()];
        Iterator iter = sets.iterator();
        while (iter.hasNext()) {
            RaidSet raidset = (RaidSet)iter.next();
            status[raidset.getId() - 1] = raidset.getStatus();
        }
        return status;
    }

    static int[] getArrayLevelsFromRaidSystem(RaidSystem rs) {
        Collection sets = rs.getRaidSets();
        int[] levels = new int[sets.size()];
        Iterator iter = sets.iterator();
        while (iter.hasNext()) {
            int level;
            RaidSet raidset = (RaidSet)iter.next();
            switch (raidset.getRaidLevel()) {
                case 0: {
                    level = 0;
                    break;
                }
                case 1: {
                    level = 1;
                    break;
                }
                case 3: {
                    level = 2;
                    break;
                }
                case 5: {
                    level = 3;
                    break;
                }
                case 6: {
                    level = 4;
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized RAID level: " + raidset.getRaidLevel());
                }
            }
            levels[raidset.getId() - 1] = level;
        }
        return levels;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static class ArrayLabel {
        int id = 0;
        JToggleButton button;
        JLabel descriptionLabel;
        JLabel statusLabel;
        protected MouseListener mouseListener;
        protected boolean displayed = false;
        protected static ImageIcon jbodBadge;
        protected final EventListenerList listenerList = new EventListenerList();
        private static final Color BADGE_COLOR;

        static {
            BADGE_COLOR = Color.getHSBColor(0.0f, 0.0f, 0.38f);
        }

        public void setState(int arrayId, String description, int status, boolean buttonVisible) {
            this.id = arrayId;
            if (this.descriptionLabel != null) {
                this.descriptionLabel.setText(description);
            }
            if (this.statusLabel != null) {
                this.statusLabel.setIcon(StatusIcon.getSmallStatusIconInstance(status));
            }
            if (this.button != null) {
                this.button.setVisible(buttonVisible);
            }
            if (this.displayed) {
                this.updateIcon();
            }
        }

        public void clear() {
            this.id = 0;
            if (this.descriptionLabel != null) {
                this.descriptionLabel.setText("");
                this.descriptionLabel.setIcon(null);
            }
            if (this.statusLabel != null) {
                this.statusLabel.setIcon(null);
            }
            if (this.button != null) {
                this.button.setVisible(false);
            }
        }

        public void setSelected(boolean selected) {
            if (this.button != null) {
                this.button.setSelected(selected);
            }
        }

        public JToggleButton createButton(Class type, boolean visible) {
            if (type == null) {
                throw new IllegalArgumentException("Button type cannot be null");
            }
            if (this.button == null || !this.button.getClass().equals(type)) {
                if (type.equals(class$javax$swing$JRadioButton != null ? class$javax$swing$JRadioButton : (class$javax$swing$JRadioButton = ArraySelectionPanel.class$("javax.swing.JRadioButton")))) {
                    this.button = GUIFactory.newRadioButton();
                } else if (type.equals(class$javax$swing$JCheckBox != null ? class$javax$swing$JCheckBox : (class$javax$swing$JCheckBox = ArraySelectionPanel.class$("javax.swing.JCheckBox")))) {
                    this.button = GUIFactory.newCheckBox();
                } else {
                    throw new IllegalArgumentException("Unsupported button type \"" + type + "\"");
                }
                this.button.addActionListener(new 2(this));
            }
            this.button.setVisible(visible);
            return this.button;
        }

        public JLabel createStatusLabel() {
            if (this.statusLabel == null) {
                this.statusLabel = new JLabel(new ImageIcon(Resources.getImage("icon.status.green")));
                this.statusLabel.addMouseListener(this.getMouseListener());
            }
            return this.statusLabel;
        }

        public JLabel createDescriptionLabel() {
            if (this.descriptionLabel == null) {
                this.descriptionLabel = new JLabel();
                this.descriptionLabel.setFont(GUIFactory.FONT_SMALL);
                this.descriptionLabel.addMouseListener(this.getMouseListener());
                this.descriptionLabel.addAncestorListener(new 3(this));
            }
            return this.descriptionLabel;
        }

        public void addActionListener(ActionListener l) {
            this.listenerList.add(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = ArraySelectionPanel.class$("java.awt.event.ActionListener")), l);
        }

        public void removeActionListener(ActionListener l) {
            this.listenerList.remove(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = ArraySelectionPanel.class$("java.awt.event.ActionListener")), l);
        }

        void fireActionPerformed(ActionEvent event) {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : ArraySelectionPanel.class$("java.awt.event.ActionListener"))) {
                    if (event == null) {
                        String actionCmd = this.button != null && this.button instanceof JCheckBox ? ArraySelectionPanel.PROP_ARRAY_SELECTION : ArraySelectionPanel.PROP_ARRAY_INDEX;
                        event = new ActionEvent(this, 1001, actionCmd);
                    }
                    ((ActionListener)listeners[i + 1]).actionPerformed(event);
                }
                i -= 2;
            }
        }

        protected void updateIcon() {
            if (this.descriptionLabel != null) {
                if (this.id == 0) {
                    this.descriptionLabel.setIcon(null);
                } else {
                    ImageIcon badge = this.createBadge(this.id);
                    if (badge != null) {
                        this.descriptionLabel.setIcon(badge);
                    }
                }
            }
        }

        private ImageIcon createBadge(int arrayId) {
            ImageIcon badge = null;
            if (this.descriptionLabel == null || arrayId == 0) {
                return null;
            }
            if (arrayId > 0 || jbodBadge == null) {
                Image temp = this.descriptionLabel.createImage(10, 11);
                if (temp != null) {
                    Graphics context = temp.getGraphics();
                    context.setColor(BADGE_COLOR);
                    context.fillRect(0, 0, 10, 10);
                    context.setColor(Color.white);
                    context.setFont(GUIFactory.FONT_BADGE);
                    if (arrayId > 0) {
                        context.drawString(String.valueOf(arrayId), 2, 9);
                        badge = new ImageIcon(temp);
                    } else {
                        context.drawString("J", 4, 8);
                        jbodBadge = badge = new ImageIcon(temp);
                    }
                }
            } else {
                badge = jbodBadge;
            }
            return badge;
        }

        private MouseListener getMouseListener() {
            if (this.mouseListener == null) {
                this.mouseListener = new 4(this);
            }
            return this.mouseListener;
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ArrayLabel al = (ArrayLabel)e.getSource();
            ArraySelectionPanel.this.firePropertyChange(e.getActionCommand(), -1, al.id);
        }

        /* synthetic */ 1() {
        }
    }
}

