/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.xsr.som.RaidSystem;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DataModel {
    private RaidSystem system;
    private static int INITIAL_CAPACITY = 20;
    private Map data = new HashMap(INITIAL_CAPACITY);
    private boolean modelChanged = false;

    public DataModel() {
    }

    public DataModel(RaidSystem system) {
        this.system = system;
    }

    public void setRaidSystem(RaidSystem system) {
        this.system = system;
    }

    public RaidSystem getRaidSystem() {
        return this.system;
    }

    public void reset() {
        this.data = new HashMap(INITIAL_CAPACITY);
        this.modelChanged = false;
    }

    public void putField(String key, Object value, Class type) {
        Field field = (Field)this.data.get(key);
        if (field == null) {
            this.data.put(key, new Field(value));
        } else if (value == null || field.value == null) {
            if (value != null || field.value != null) {
                field.value = value;
                field.changed = true;
                this.modelChanged = true;
            }
        } else if (!field.value.equals(value)) {
            field.value = value;
            field.changed = true;
            this.modelChanged = true;
        }
    }

    public Object getField(String key) {
        Field field = (Field)this.data.get(key);
        if (field != null) {
            return field.value;
        }
        return null;
    }

    public boolean modelChanged() {
        return this.modelChanged;
    }

    public boolean fieldChanged(String key) {
        Field field = (Field)this.data.get(key);
        if (field != null) {
            return field.changed;
        }
        return false;
    }

    public Set keySet() {
        return this.data.keySet();
    }

    public Collection fieldSet() {
        return this.data.values();
    }

    public Set changedKeySet() {
        HashSet set = new HashSet();
        Iterator iter = this.data.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Field field = (Field)entry.getValue();
            if (!field.changed) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    public Set changedFieldSet() {
        HashSet<Field> set = new HashSet<Field>();
        Iterator iter = this.data.values().iterator();
        while (iter.hasNext()) {
            Field field = (Field)iter.next();
            if (!field.changed) continue;
            set.add(field);
        }
        return set;
    }

    public static class Field {
        Object value;
        boolean changed;

        public Field(Object value) {
            this.value = value;
        }
    }
}

