/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.util.CapacityConverter;
import com.apple.util.StringUtilities;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DrivePanel;
import com.apple.xsr.DrivePanelEvent;
import com.apple.xsr.DrivePanelListener;
import com.apple.xsr.Resources;
import com.apple.xsr.SOMLocalizer;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;

public class DriveInfoPanelController
implements DrivePanelListener {
    DriveInformationPanel infoPanel;

    public DriveInfoPanelController(DriveInformationPanel infoPanel) {
        this.infoPanel = infoPanel;
    }

    public void driveIconEntered(DrivePanelEvent e) {
        Object o = this.getExplanation(((DrivePanel)e.getSource()).getRaidSystem(), e.getFirstID());
        if (this.infoPanel != null && o != null) {
            this.infoPanel.setText(o);
        }
    }

    public void driveIconExited(DrivePanelEvent e) {
        if (this.infoPanel != null) {
            this.infoPanel.setText(Resources.getString("management.driveInfo.note"));
        }
    }

    public void driveIconClicked(DrivePanelEvent e) {
    }

    public void valueChanged(DrivePanelEvent e) {
    }

    public Object getExplanation(RaidSystem system, int driveID) {
        DriveInformationPanel.TextCell[] o = null;
        Disk disk = system.getDisk(driveID);
        if (disk != null) {
            DriveInformationPanel.TextCell[] s = "";
            int state = disk.getState();
            int type = disk.getType();
            if (state == -2) {
                s = StringUtilities.replaceAll(Resources.getString("management.driveInfo.empty"), "{number}", String.valueOf(driveID));
            } else if (state == 0) {
                s = StringUtilities.replaceAll(Resources.getString("management.driveInfo.offline"), "{number}", String.valueOf(driveID));
            } else if (state == 1) {
                if (type == 1) {
                    RaidSet rs = disk.getRaidSet();
                    s = StringUtilities.replaceAll(Resources.getString("management.driveInfo.assigned"), "{number}", String.valueOf(driveID));
                    s = StringUtilities.replaceAll((String)s, "{index}", String.valueOf(rs.getId()));
                    s = StringUtilities.replaceAll((String)s, "{description}", SOMLocalizer.getRaidSetLevelAndCapacity(rs));
                } else if (type == 3) {
                    s = StringUtilities.replaceAll(Resources.getString("management.driveInfo.jbod"), "{number}", String.valueOf(driveID));
                    s = StringUtilities.replaceAll((String)s, "{capacity}", this.createCapacityString(disk.getCapacityBytes()));
                } else if (type == 4) {
                    DriveInformationPanel.TextCell cell = new DriveInformationPanel.TextCell();
                    int CELL_COUNT = 9;
                    DriveInformationPanel.TextCell[] cells = new DriveInformationPanel.TextCell[9];
                    int cellIndex = 0;
                    cell.x = 0;
                    cell.y = 0;
                    cell.colspan = 2;
                    cell.text = StringUtilities.replaceAll(Resources.getString("management.driveInfo.orphan.note"), "{number}", String.valueOf(driveID));
                    cells[cellIndex++] = new DriveInformationPanel.TextCell(cell);
                    cell.colspan = 1;
                    cell.x = 0;
                    ++cell.y;
                    cell.text = Resources.getString("management.driveInfo.orphan.raidSet");
                    cells[cellIndex++] = new DriveInformationPanel.TextCell(cell);
                    cell.x = 1;
                    cell.text = String.valueOf(disk.getOrphanRaidSetId());
                    cells[cellIndex++] = new DriveInformationPanel.TextCell(cell);
                    cell.x = 0;
                    ++cell.y;
                    cell.text = Resources.getString("management.driveInfo.orphan.raidLevel");
                    cells[cellIndex++] = new DriveInformationPanel.TextCell(cell);
                    cell.x = 1;
                    cell.text = String.valueOf(disk.getOrphanRaidLevel());
                    cells[cellIndex++] = new DriveInformationPanel.TextCell(cell);
                    cell.x = 0;
                    ++cell.y;
                    cell.text = Resources.getString("management.driveInfo.orphan.memberIndexLabel");
                    cells[cellIndex++] = new DriveInformationPanel.TextCell(cell);
                    cell.x = 1;
                    cell.text = StringUtilities.replaceAll(Resources.getString("management.driveInfo.orphan.memberIndex"), "{index}", String.valueOf(disk.getOrphanRaidMemberIndex() + 1));
                    cell.text = StringUtilities.replaceAll(cell.text, "{count}", String.valueOf(disk.getOrphanRaidMemberCount()));
                    cells[cellIndex++] = new DriveInformationPanel.TextCell(cell);
                    cell.x = 0;
                    ++cell.y;
                    cell.text = Resources.getString("management.driveInfo.orphan.serialNumber");
                    cells[cellIndex++] = new DriveInformationPanel.TextCell(cell);
                    cell.x = 1;
                    cell.text = String.valueOf(disk.getRaidControllerSerialNumber());
                    cells[cellIndex++] = new DriveInformationPanel.TextCell(cell);
                    if (cellIndex != 9) {
                        throw new Error("Assert: cellIndex (" + cellIndex + ") != CELL_COUNT (" + 9 + ")");
                    }
                    o = cells;
                } else if (type == 0) {
                    s = StringUtilities.replaceAll(Resources.getString("management.driveInfo.unassigned"), "{number}", String.valueOf(driveID));
                    s = StringUtilities.replaceAll((String)s, "{capacity}", this.createCapacityString(disk.getCapacityBytes()));
                }
            }
            if (!s.equals("")) {
                o = s;
            }
        }
        return o;
    }

    private String createCapacityString(long capacityBytes) {
        String capacityString;
        int capacity = (int)CapacityConverter.toGigabytes(capacityBytes);
        if (capacity < 1024) {
            capacityString = Resources.getString("management.create.capacity.gb");
            capacityString = StringUtilities.replaceAll(capacityString, "{number}", String.valueOf(capacity));
        } else {
            capacityString = Resources.getString("management.create.capacity.tb");
            capacityString = StringUtilities.replaceAll(capacityString, "{number}", String.valueOf((double)((int)((double)capacity / 1024.0 * 100.0)) / 100.0));
        }
        return capacityString;
    }
}

