/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.xsr.DrivePanelEvent;
import com.apple.xsr.DrivePanelListener;
import com.apple.xsr.DrivePanelSelectionModel;
import com.apple.xsr.DrivePanelSelectionPolicy;
import com.apple.xsr.som.RaidSystem;
import java.beans.PropertyChangeListener;
import javax.swing.event.EventListenerList;

public interface DrivePanel {
    public static final int SELECTION_COLOR_NORMAL = 0;
    public static final int SELECTION_COLOR_DANGER = 1;
    public static final int BADGE_DEFAULT = 0;
    public static final int BADGE_EXPAND = 1;
    public static final int INFO_ICON_DELETE = 0;
    public static final int INDEX_NONE = -10;
    public static final int RAID_SET_ID_JBOD_TOP = -2;
    public static final int RAID_SET_ID_JBOD_BOTTOM = -3;
    public static final int TYPE_UNASSIGNED = 0;
    public static final int TYPE_RAID_MEMBER = 1;
    public static final int TYPE_JBOD = 3;
    public static final int TYPE_ORPHAN = 4;
    public static final int STATE_ONLINE = 1;
    public static final int STATE_OFFLINE = 0;
    public static final int STATE_PREDICTIVE_FAILURE = 2;
    public static final int STATE_EMPTY = -2;

    public void setRaidSystem(RaidSystem var1);

    public RaidSystem getRaidSystem();

    public void setSelectionMode(int var1);

    public void setDriveSelected(int var1, boolean var2);

    public boolean isDriveSelected(int var1);

    public void setArraySelected(int var1, boolean var2);

    public boolean isArraySelected(int var1);

    public int getSelectionCount();

    public void setSelectedArray(int var1);

    public int getSelectedArray();

    public void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public void setConfirmed(boolean var1);

    public static class DefaultSelectionModel
    implements DrivePanelSelectionModel {
        private static final int DRIVE_COUNT = 14;
        private static final int ARRAY_COUNT = 8;
        private int mode = 1;
        private int style = 0;
        private boolean[] driveSelections = new boolean[14];
        private boolean[] arraySelections = new boolean[8];
        private boolean isAdjusting = false;
        private final EventListenerList listenerList = new EventListenerList();
        static /* synthetic */ Class class$com$apple$xsr$DrivePanelListener;

        public DefaultSelectionModel() {
            int i = 0;
            while (i < this.driveSelections.length) {
                this.driveSelections[i] = false;
                ++i;
            }
            int i2 = 0;
            while (i2 < this.arraySelections.length) {
                this.arraySelections[i2] = false;
                ++i2;
            }
        }

        public void addDrivePanelListener(DrivePanelListener listener) {
            this.listenerList.add(class$com$apple$xsr$DrivePanelListener != null ? class$com$apple$xsr$DrivePanelListener : (class$com$apple$xsr$DrivePanelListener = DefaultSelectionModel.class$("com.apple.xsr.DrivePanelListener")), listener);
        }

        public void removeDrivePanelListener(DrivePanelListener listener) {
            this.listenerList.remove(class$com$apple$xsr$DrivePanelListener != null ? class$com$apple$xsr$DrivePanelListener : (class$com$apple$xsr$DrivePanelListener = DefaultSelectionModel.class$("com.apple.xsr.DrivePanelListener")), listener);
        }

        public void setSelectionMode(int mode) {
            this.mode = mode;
        }

        public int getSelectionMode() {
            return this.mode;
        }

        public void setSelectionStyle(int style) {
            this.style = style;
        }

        public int getSelectionStyle() {
            return this.style;
        }

        public void setSelectionIsAdjusting(boolean isAdjusting) {
            this.isAdjusting = isAdjusting;
        }

        public void setDriveSelected(int driveID, boolean selected) {
            if (this.driveSelections[driveID - 1] != selected) {
                this.driveSelections[driveID - 1] = selected;
                this.fireValueChanged(3, driveID, selected ? 1 : 2, this.isAdjusting);
            }
        }

        public void setArraySelected(int arrayID, boolean selected) {
            if (this.arraySelections[arrayID - 1] != selected) {
                this.arraySelections[arrayID - 1] = selected;
                this.fireValueChanged(4, arrayID, selected ? 1 : 2, this.isAdjusting);
            }
        }

        public void clearSelection() {
            int i = 0;
            while (i < this.driveSelections.length) {
                this.driveSelections[i] = false;
                ++i;
            }
            int i2 = 0;
            while (i2 < this.arraySelections.length) {
                this.arraySelections[i2] = false;
                ++i2;
            }
        }

        public int[] getSelectedDrives() {
            int[] selected = null;
            int count = 0;
            int i = 0;
            while (i < 2) {
                int drive = 0;
                while (drive < this.driveSelections.length) {
                    if (this.driveSelections[drive]) {
                        if (selected != null) {
                            selected[count] = drive + 1;
                        }
                        ++count;
                    }
                    ++drive;
                }
                if (selected == null) {
                    selected = new int[count];
                    count = 0;
                }
                ++i;
            }
            return selected;
        }

        public boolean isDriveSelected(int driveID) {
            if (driveID < 1 || driveID > 14) {
                throw new IndexOutOfBoundsException("driveID " + driveID + " out of bounds");
            }
            return this.driveSelections[driveID - 1];
        }

        public boolean isArraySelected(int arrayID) {
            if (arrayID < 1 || arrayID > 8) {
                throw new IndexOutOfBoundsException("arrayID " + arrayID + " out of bounds");
            }
            return this.arraySelections[arrayID - 1];
        }

        public int getSelectionCount() {
            boolean[] selections = this.mode == 1 ? this.driveSelections : this.arraySelections;
            int count = 0;
            int i = 0;
            while (i < selections.length) {
                if (selections[i]) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        private void fireValueChanged(int eventID, int itemID, int state, boolean isAdjusting) {
            Object[] listeners = this.listenerList.getListenerList();
            DrivePanelEvent event = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$com$apple$xsr$DrivePanelListener != null ? class$com$apple$xsr$DrivePanelListener : DefaultSelectionModel.class$("com.apple.xsr.DrivePanelListener"))) {
                    if (event == null) {
                        event = new DrivePanelEvent(eventID, this, itemID, state, isAdjusting);
                    }
                    ((DrivePanelListener)listeners[i + 1]).valueChanged(event);
                }
                i -= 2;
            }
        }

        static /* synthetic */ Class class$(String class$) {
            try {
                return Class.forName(class$);
            }
            catch (ClassNotFoundException forName) {
                throw new NoClassDefFoundError(forName.getMessage());
            }
        }
    }

    public static class DefaultSelectionPolicy
    implements DrivePanelSelectionPolicy {
        protected int selectableStates = 0;
        protected int selectableTypes = 0;

        public DefaultSelectionPolicy() {
        }

        public DefaultSelectionPolicy(int selectableStates, int selectableTypes) {
            this.selectableStates = selectableStates;
            this.selectableTypes = selectableTypes;
        }

        public void setSelectableStates(int states) {
            this.selectableStates = states;
        }

        public int getSelectableStates() {
            return this.selectableStates;
        }

        public void setSelectableTypes(int types) {
            this.selectableTypes = types;
        }

        public int getSelectableTypes() {
            return this.selectableTypes;
        }

        public boolean isStateSelectable(int state) {
            if (this.selectableStates == -1) {
                return true;
            }
            return this.selectableStates == state;
        }

        public boolean isTypeSelectable(int type) {
            if (this.selectableTypes == -1) {
                return true;
            }
            return this.selectableTypes == type;
        }

        public boolean isSelectable(int state, int type) {
            return this.isStateSelectable(state) && this.isTypeSelectable(type);
        }
    }
}

