/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.xsr.Resources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class EmailNotifications {
    static HashMap messagesDictionary;
    static HashMap headersDictionary;
    private Map props = new HashMap();

    public EmailNotifications(String SMTPEmailAddress, String SMTPServer, String SMTPUserName, String SMTPPassword, ArrayList toAccounts) {
        if (messagesDictionary == null) {
            messagesDictionary = new HashMap();
            messagesDictionary.put("ambient-temperature-problem", Resources.getString("emailMessage.ambientTempProblem"));
            messagesDictionary.put("battery-problem", Resources.getString("emailMessage.batteryProblem"));
            messagesDictionary.put("blower-speed-problem", Resources.getString("emailMessage.blowerSpeedProblem"));
            messagesDictionary.put("blower-temperature-problem", Resources.getString("emailMessage.blowerTempProblem"));
            messagesDictionary.put("blower-problem", Resources.getString("emailMessage.blowerProblem"));
            messagesDictionary.put("raid-controller-communication-problem", Resources.getString("emailMessage.raidControllerCommunicationsProblem"));
            messagesDictionary.put("raid-controller-temperature-problem", Resources.getString("emailMessage.raidControllerTempProblem"));
            messagesDictionary.put("raid-set-problem", Resources.getString("emailMessage.raidSetProblem"));
            messagesDictionary.put("emu-temperature-problem", Resources.getString("emailMessage.emuTempProblem"));
            messagesDictionary.put("hard-drive-temperature-problem", Resources.getString("emailMessage.hardDriveTempProblem"));
            messagesDictionary.put("power-supply-problem", Resources.getString("emailMessage.powerSupplyProblem"));
            messagesDictionary.put("smart-problem", Resources.getString("emailMessage.smartProblem"));
            messagesDictionary.put("drive-problem", Resources.getString("emailMessage.hardDriveProblem"));
            messagesDictionary.put("ide-error-problem", Resources.getString("emailMessage.hardDriveCommandError"));
            messagesDictionary.put("ide-command-failure-problem", Resources.getString("emailMessage.hardDriveCommandTimeout"));
            messagesDictionary.put("ide-reset-failure-problem", Resources.getString("emailMessage.hardDriveResetFailure"));
            messagesDictionary.put("data-loss-during-rebuild-problem", Resources.getString("emailMessage.dataLossDuringRebuild"));
        }
        if (headersDictionary == null) {
            headersDictionary = new HashMap();
            headersDictionary.put("Subject", Resources.getString("emailHeader.subject"));
        }
        if (messagesDictionary != null && messagesDictionary.size() > 0) {
            this.props.put("messages", messagesDictionary);
        } else {
            this.props.put("messages", new HashMap());
        }
        if (headersDictionary != null && headersDictionary.size() > 0) {
            this.props.put("headers", headersDictionary);
        } else {
            this.props.put("headers", new HashMap());
        }
        if (this.isValidString(SMTPEmailAddress)) {
            this.props.put("from", SMTPEmailAddress);
        } else {
            this.props.put("from", "");
        }
        if (this.isValidString(SMTPServer)) {
            this.props.put("smtp-server", SMTPServer);
        } else {
            this.props.put("from", "");
        }
        if (this.isValidString(SMTPUserName) && this.isValidString(SMTPEmailAddress) && this.isValidString(SMTPPassword)) {
            this.props.put("username", SMTPUserName);
            this.props.put("password", SMTPPassword);
        } else {
            this.props.put("username", "");
            this.props.put("password", "");
        }
        if (toAccounts != null && toAccounts.size() > 0) {
            this.props.put("to", toAccounts);
        } else {
            this.props.put("to", new ArrayList());
        }
    }

    private boolean isValidString(String string) {
        return string != null && string.length() > 0;
    }

    public String getSMTPEmailAddress() {
        return (String)this.props.get("from");
    }

    public String getSMTPServer() {
        return (String)this.props.get("smtp-server");
    }

    public String getSMTPUsername() {
        return (String)this.props.get("username");
    }

    public String getSMTPPassword() {
        return (String)this.props.get("password");
    }

    public ArrayList getEmailAddressList() {
        return (ArrayList)this.props.get("to");
    }

    public Map toMap() {
        return this.props;
    }

    public static EmailNotifications fromMap(Map props) {
        String SMTPEmailAddress = props.get("from") != null ? (String)props.get("from") : null;
        String SMTPServer = props.get("smtp-server") != null ? (String)props.get("smtp-server") : null;
        String SMTPUserName = props.get("username") != null ? (String)props.get("username") : null;
        String SMTPPassword = props.get("password") != null ? (String)props.get("password") : null;
        ArrayList toAccounts = props.get("to") != null ? (ArrayList)props.get("to") : null;
        EmailNotifications en = new EmailNotifications(SMTPEmailAddress, SMTPServer, SMTPUserName, SMTPPassword, toAccounts);
        return en;
    }
}

