/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

class KeyPressForwardingPanel
extends JPanel
implements KeyListener,
ContainerListener {
    private ArrayList registeredKeyListeners = new ArrayList();

    public KeyPressForwardingPanel(JPanel inPanel) {
        this.addKeyAndContainerListenerRecursively(this);
        this.add(inPanel);
    }

    public KeyPressForwardingPanel(JPanel inPanel, KeyListener inListener) {
        this(inPanel);
        this.registerForKeyPressEvents(inListener);
    }

    public synchronized void registerForKeyPressEvents(KeyListener inListener) {
        this.registeredKeyListeners.add(inListener);
    }

    public void componentAdded(ContainerEvent inEvent) {
        this.addKeyAndContainerListenerRecursively(inEvent.getChild());
    }

    public void componentRemoved(ContainerEvent inEvent) {
        this.removeKeyAndContainerListenerRecursively(inEvent.getChild());
    }

    private void addKeyAndContainerListenerRecursively(Component inComponent) {
        inComponent.addKeyListener(this);
        if (inComponent instanceof Container) {
            Container cont = (Container)inComponent;
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            int i = 0;
            while (i < children.length) {
                this.addKeyAndContainerListenerRecursively(children[i]);
                ++i;
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component inComponent) {
        inComponent.removeKeyListener(this);
        if (inComponent instanceof Container) {
            Container cont = (Container)inComponent;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            int i = 0;
            while (i < children.length) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
                ++i;
            }
        }
    }

    public synchronized void keyPressed(KeyEvent inEvent) {
        Iterator iter = ((AbstractList)this.registeredKeyListeners).iterator();
        while (iter.hasNext()) {
            KeyListener keyListener = (KeyListener)iter.next();
            keyListener.keyPressed(inEvent);
        }
    }

    public synchronized void keyReleased(KeyEvent inEvent) {
        Iterator iter = ((AbstractList)this.registeredKeyListeners).iterator();
        while (iter.hasNext()) {
            KeyListener keyListener = (KeyListener)iter.next();
            keyListener.keyReleased(inEvent);
        }
    }

    public synchronized void keyTyped(KeyEvent inEvent) {
        Iterator iter = ((AbstractList)this.registeredKeyListeners).iterator();
        while (iter.hasNext()) {
            KeyListener keyListener = (KeyListener)iter.next();
            keyListener.keyTyped(inEvent);
        }
    }
}

