/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.net.acp.AcpPropertyCode;
import com.apple.util.StringUtilities;
import com.apple.util.plist.PropertyListUtilities;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertListener;
import com.apple.xsr.AquaProgressClock;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.CreateArrayModel;
import com.apple.xsr.CreateArrayPane;
import com.apple.xsr.DataModel;
import com.apple.xsr.DeleteArrayModel;
import com.apple.xsr.DeleteArrayPane;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.EmailNotifications;
import com.apple.xsr.LunMaskSetting;
import com.apple.xsr.ManagementController;
import com.apple.xsr.ManagementFibreModel;
import com.apple.xsr.ManagementNetworkModel;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.ManagementPerformanceModel;
import com.apple.xsr.ManagementSystemModel;
import com.apple.xsr.ManagementWindow;
import com.apple.xsr.NotificationsModel;
import com.apple.xsr.NotificationsPane;
import com.apple.xsr.OperationManager;
import com.apple.xsr.RaidAdmin;
import com.apple.xsr.Resources;
import com.apple.xsr.SOMLocalizer;
import com.apple.xsr.SetupPane;
import com.apple.xsr.TestEmail;
import com.apple.xsr.Utilities;
import com.apple.xsr.advanced.AdvancedExpansionModel;
import com.apple.xsr.advanced.AdvancedExpansionPane;
import com.apple.xsr.advanced.AdvancedMaskingModel;
import com.apple.xsr.advanced.AdvancedMaskingPane;
import com.apple.xsr.advanced.AdvancedSlicingModel;
import com.apple.xsr.advanced.AdvancedSlicingPane;
import com.apple.xsr.firstaid.AbstractFirstAidPane;
import com.apple.xsr.firstaid.FirstAidDataModel;
import com.apple.xsr.net.CommunicationHandler;
import com.apple.xsr.net.IPAddress;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.Response;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.FibreChannelInterface;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.Slice;
import com.apple.xsr.som.SystemController;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

class ManagementController
implements ActionListener {
    private static final int SYSTEM_SETUP_MODEL = 0;
    private static final int NETWORK_SETUP_MODEL = 1;
    private static final int FIBRE_SETUP_MODEL = 2;
    private static final int PERFORMANCE_SETUP_MODEL = 3;
    private static final int SLICING_MODEL = 0;
    private static final int EXPANSION_MODEL = 1;
    private static final int MASKING_MODEL = 2;
    private static final int PROGRESS_ALERT_DISPLAY_SECS = 4;
    private static final int RESTART_UPPER_RAID_MASK = 1;
    private static final int RESTART_LOWER_RAID_MASK = 2;
    private static final int RESTART_UPPER_COPROCESSOR_MASK = 4;
    private static final int RESTART_LOWER_COPROCESSOR_MASK = 8;
    private static final int SYNC_NVRAM_UPPER_RAID_MASK = 16;
    private static final int SYNC_NVRAM_LOWER_RAID_MASK = 32;
    private static final int SYNC_NVRAM_UPPER_COPROCESSOR_MASK = 64;
    private static final int SYNC_NVRAM_LOWER_COPROCESSOR_MASK = 128;
    private static final int SYSTEM_NAME_MAX_LENGTH_BYTES = 255;
    private static final String SYSTEM_NAME_UNIQUIFIER = "-2";
    private ManagementWindow managementWindow;
    private RaidSystem managedSystem;
    private DataModel createDataModel = new CreateArrayModel();
    private DataModel deleteDataModel = new DeleteArrayModel();
    private DataModel notificationsModel = new NotificationsModel();
    private DataModel firstAidDataModel = new FirstAidDataModel();
    private DataModel[] setupDataModels = new DataModel[]{new ManagementSystemModel(), new ManagementNetworkModel(), new ManagementFibreModel(), new ManagementPerformanceModel()};
    private DataModel[] advancedDataModels = new DataModel[]{new AdvancedSlicingModel(), new AdvancedExpansionModel(), new AdvancedMaskingModel()};
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementController != null ? class$com$apple$xsr$ManagementController : (class$com$apple$xsr$ManagementController = ManagementController.class$("com.apple.xsr.ManagementController")));
    static /* synthetic */ Class class$com$apple$xsr$ManagementController;
    static /* synthetic */ Class class$com$apple$xsr$ManagementController$RaidSetCreator;
    static /* synthetic */ Class class$com$apple$xsr$ManagementController$Slicer;
    static /* synthetic */ Class class$com$apple$xsr$ManagementController$LunMapper;
    static /* synthetic */ Class class$com$apple$xsr$ManagementController$LunMapRepairer;

    public boolean showManagementWindow(RaidSystem selectedSystem, String pane, Component relativeTo) {
        if (selectedSystem == null) {
            throw new NullPointerException("selected system cannot be null");
        }
        if (pane == null) {
            throw new NullPointerException("pane cannot be null");
        }
        boolean result = true;
        if (this.managedSystem == null) {
            this.managedSystem = selectedSystem;
            this.initManagementWindow(pane);
            this.populatePane(pane);
            result = true;
            Utilities.setWindowLocationRelativeToComponent(this.managementWindow, relativeTo);
        }
        ((Component)this.managementWindow).setVisible(true);
        return result;
    }

    public void managementWindowToFront() {
        this.managementWindow.toFront();
    }

    public void closeManagementWindow() {
        this.managementWindow.dispose();
    }

    public RaidSystem getManagedSystem() {
        return this.managedSystem;
    }

    public String getManagementPaneType() {
        String type = "";
        if (this.managementWindow != null) {
            type = this.managementWindow.getManagementPaneType();
        }
        return type;
    }

    public boolean aSystemIsBeingManaged() {
        boolean systemIsBeingManaged = this.getManagedSystem() != null;
        return systemIsBeingManaged;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof TestEmail) {
            this.handleTestEmail((TestEmail)e.getSource());
            return;
        }
        if (!(e.getSource() instanceof ManagementPane)) {
            logger.warn("Action event source not a ManagementPane: " + e.getSource().getClass());
            return;
        }
        ManagementPane pane = (ManagementPane)e.getSource();
        String command = e.getActionCommand();
        if (command.equals("APPLY")) {
            if (pane instanceof SetupPane) {
                boolean result = pane.validateUI(this.setupDataModels);
                if (result) {
                    this.handleSetup();
                }
            } else if (pane instanceof CreateArrayPane) {
                boolean result = pane.validateUI(this.createDataModel);
                if (result) {
                    this.handleCreate();
                } else {
                    logger.error("Create array validation failed");
                }
            } else if (pane instanceof DeleteArrayPane) {
                boolean result = pane.validateUI(this.deleteDataModel);
                if (result) {
                    this.handleDelete();
                }
            } else if (pane instanceof NotificationsPane) {
                boolean result = pane.validateUI(this.notificationsModel);
                if (result) {
                    this.handleNotifications();
                }
            } else if (pane instanceof AbstractFirstAidPane) {
                boolean result = pane.validateUI(this.firstAidDataModel);
                if (result) {
                    this.handleFirstAid();
                }
            } else if (pane instanceof AdvancedSlicingPane) {
                boolean result = pane.validateUI(this.advancedDataModels[0]);
                if (result) {
                    this.handleSlicing();
                }
            } else if (pane instanceof AdvancedExpansionPane) {
                boolean result = pane.validateUI(this.advancedDataModels[1]);
                if (result) {
                    this.handleExpansion();
                }
            } else if (pane instanceof AdvancedMaskingPane) {
                boolean result = pane.validateUI(this.advancedDataModels[2]);
                if (result) {
                    this.handleMasking();
                }
            } else {
                logger.error("Unknown management pane \"" + pane.getClass() + "\"");
            }
        } else if (command.equals("CANCEL")) {
            this.closeManagementWindow();
        } else {
            logger.error("Unknown action command \"" + command + "\" received in actionPerformed");
        }
    }

    private void populatePane(String pane) {
        if (pane == "setup_pane") {
            this.populateSystemSetup((ManagementSystemModel)this.setupDataModels[0]);
            this.populateNetworkSetup((ManagementNetworkModel)this.setupDataModels[1]);
            this.populateFibreSetup((ManagementFibreModel)this.setupDataModels[2]);
            this.populatePerformance((ManagementPerformanceModel)this.setupDataModels[3]);
            this.managementWindow.populateUI(pane, this.setupDataModels);
        } else if (pane == "create_array_pane") {
            this.populateCreateArray((CreateArrayModel)this.createDataModel);
            this.managementWindow.populateUI(pane, this.createDataModel);
        } else if (pane == "delete_array_pane") {
            this.populateDeleteArray((DeleteArrayModel)this.deleteDataModel);
            this.managementWindow.populateUI(pane, this.deleteDataModel);
        } else if (pane == "notifications_pane") {
            this.populateNotifications((NotificationsModel)this.notificationsModel);
            this.managementWindow.populateUI(pane, this.notificationsModel);
        } else if (pane == "first_aid") {
            this.populateFirstAid((FirstAidDataModel)this.firstAidDataModel);
            this.managementWindow.populateUI(pane, this.firstAidDataModel);
        } else if (pane == "advanced_pane") {
            this.populateSlicing((AdvancedSlicingModel)this.advancedDataModels[0]);
            this.populateExpansion((AdvancedExpansionModel)this.advancedDataModels[1]);
            this.populateMasking((AdvancedMaskingModel)this.advancedDataModels[2]);
            this.managementWindow.populateUI(pane, this.advancedDataModels);
        }
    }

    private void populateSystemSetup(ManagementSystemModel model) {
        model.reset();
        model.setSystemName(this.managedSystem.getName());
        model.setLocation(this.managedSystem.getLocation());
        model.setContact(this.managedSystem.getContact());
        model.setXserveRAIDTime(this.managedSystem.getTime());
        MessageFactory mf = this.managedSystem.getMessageFactory();
        RequestMessage request = mf.newGetPropertyRequest(AcpPropertyCode.NTP_CONFIG);
        String ntpServer = ".";
        ntpServer = this.managedSystem.getNtpServerAddress();
        if (ntpServer.equals(".") || ntpServer.equals("")) {
            model.setTimeSynchronizationMethod(1);
            model.setNTPServer("");
        } else {
            model.setTimeSynchronizationMethod(3);
            model.setNTPServer(ntpServer);
        }
        boolean state = this.managedSystem.getAudibleAlarmState() != 0;
        model.setEnableAudibleAlerts(state);
        state = this.managedSystem.getAutoRebootState() == 1;
        model.setRestartAutomatically(state);
        state = false;
        Iterator iter = this.managedSystem.getSystemControllers().iterator();
        while (iter.hasNext()) {
            SystemController sc = (SystemController)iter.next();
            if (sc.getSnmpState() != 1 && sc.getSnmpState() != -1) continue;
            state = true;
            break;
        }
        model.setEnableSnmp(state);
        model.setAdminPassword("");
        model.setGuestPassword("");
    }

    private void populateNetworkSetup(ManagementNetworkModel model) {
        model.reset();
        int index = 1;
        while (index <= 2) {
            NetworkInterface nif = this.managedSystem.getSystemController(index).getNetworkInterface();
            ManagementNetworkModel.ManagementNetworkControllerModel networkModel = index == 1 ? model.getUpperControllerModel() : model.getLowerControllerModel();
            networkModel.reset();
            if (nif.getConfigurationMethod() == 512) {
                networkModel.setNetworkConfigurationMethod(1);
            } else {
                networkModel.setNetworkConfigurationMethod(2);
            }
            networkModel.setIPAddress(String.valueOf(String.valueOf(nif.getAddress())));
            networkModel.setSubnetMask(String.valueOf(String.valueOf(nif.getSubnetMask())));
            networkModel.setRouter(String.valueOf(String.valueOf(nif.getGateway())));
            networkModel.setDHCPClientID(nif.getDhcpClientId());
            IPAddress[] dns = nif.getDns();
            if (dns.length >= 1 && dns[0] != null && !dns[0].isAllZero()) {
                networkModel.setDNS1(String.valueOf(String.valueOf(dns[0])));
            } else {
                networkModel.setDNS1("");
            }
            if (dns.length >= 2 && dns[1] != null && !dns[1].isAllZero()) {
                networkModel.setDNS2(String.valueOf(String.valueOf(dns[1])));
            } else {
                networkModel.setDNS2("");
            }
            if (dns.length >= 3 && dns[2] != null && !dns[2].isAllZero()) {
                networkModel.setDNS3(String.valueOf(String.valueOf(dns[2])));
            } else {
                networkModel.setDNS3("");
            }
            networkModel.setEthernetMACAddress(nif.getMacAddress());
            ++index;
        }
    }

    private void populateFibreSetup(ManagementFibreModel model) {
        model.reset();
        int index = 1;
        while (index <= 2) {
            RaidController controller = this.managedSystem.getRaidController(index);
            FibreChannelInterface fc = (FibreChannelInterface)controller.getHostInterface(1);
            ManagementFibreModel.ManagementFibreControllerModel fcModel = index == 1 ? model.getUpperControllerModel() : model.getLowerControllerModel();
            fcModel.reset();
            fcModel.setWWPName(fc.getWorldWidePortName());
            fcModel.setWWNName(fc.getWorldWideNodeName());
            if (fc.getSpeed() == 1) {
                fcModel.setSpeed(1);
            } else if (fc.getSpeed() == 2) {
                fcModel.setSpeed(2);
            } else {
                fcModel.setSpeed(0);
            }
            if (fc.getTopology() == 0) {
                fcModel.setTopology(2);
            } else if (fc.getTopology() == 1) {
                fcModel.setTopology(1);
            } else {
                fcModel.setTopology(0);
            }
            fcModel.setHardLoopEnabled(fc.getHardLoopIdEnabled() == 1);
            fcModel.setHardLoopID(String.valueOf(fc.getHardLoopId()));
            ++index;
        }
    }

    private void populatePerformance(ManagementPerformanceModel model) {
        model.reset();
        model.setRaidSystem(this.managedSystem);
        int index = 1;
        while (index <= 2) {
            ManagementPerformanceModel.ManagementPerformanceControllerModel perfModel = index == 1 ? model.getUpperPerformanceModel() : model.getLowerPerformanceModel();
            perfModel.reset();
            RaidController controller = this.managedSystem.getRaidController(index);
            perfModel.setControllerCache(controller.getWriteCacheState() == 1 ? 0 : 1);
            perfModel.setSyncCache(controller.getSyncCacheState() == 1 ? 0 : 1);
            int diskCache = 0;
            Iterator iter = controller.getDiskSlots().iterator();
            while (iter.hasNext()) {
                DiskSlot slot = (DiskSlot)iter.next();
                if (!slot.isPopulated() || slot.getDisk().getCacheState() != 0) continue;
                diskCache = 1;
                break;
            }
            perfModel.setDiskCache(diskCache);
            perfModel.setSlowReadBypass(controller.getSlowReadBypassModeState() == 1 ? 0 : 1);
            int prefetch = 1 << controller.getPrefetchSize();
            if (prefetch < 8) {
                perfModel.setPrefetch(0);
            } else if (prefetch == 8) {
                perfModel.setPrefetch(1);
            } else {
                perfModel.setPrefetch(2);
            }
            ++index;
        }
    }

    private void populateCreateArray(CreateArrayModel model) {
        model.reset();
        model.setLevel(3);
        model.setBackgroundInitEnabled(true);
        model.setRaidSystem(this.managedSystem);
        model.setDriveStates(DriveSelectionPanel.getDriveStatesFromRaidSystem(this.managedSystem));
        model.setDriveArrays(DriveSelectionPanel.getDriveArraysFromRaidSystem(this.managedSystem));
        model.setDriveCapacities(DriveSelectionPanel.getDriveCapacitiesFromRaidSystem(this.managedSystem));
        model.setArrayDescriptions(ArraySelectionPanel.getArrayDescriptionsFromRaidSystem(this.managedSystem));
    }

    private void populateDeleteArray(DeleteArrayModel model) {
        model.reset();
        model.setRaidSystem(this.managedSystem);
        model.setDriveStates(DriveSelectionPanel.getDriveStatesFromRaidSystem(this.managedSystem));
        model.setDriveArrays(DriveSelectionPanel.getDriveArraysFromRaidSystem(this.managedSystem));
        model.setDriveCapacities(DriveSelectionPanel.getDriveCapacitiesFromRaidSystem(this.managedSystem));
        model.setArrayDescriptions(ArraySelectionPanel.getArrayDescriptionsFromRaidSystem(this.managedSystem));
    }

    private void populateNotifications(NotificationsModel model) {
        SystemController sc = this.managedSystem.getPrimarySystemController();
        EmailNotifications data = sc.getEmailNotificationsData();
        model.reset();
        if (data != null) {
            model.setSMTPFromEmailAddress(data.getSMTPEmailAddress());
            model.setSMTPServer(data.getSMTPServer());
            if (this.isValidString(data.getSMTPUsername()) && this.isValidString(data.getSMTPPassword())) {
                model.setSMTPUsername(data.getSMTPUsername());
                model.setSMTPPassword(data.getSMTPPassword());
                model.setSMTPServerRequiresAuthentication(true);
            } else {
                model.setSMTPUsername("");
                model.setSMTPPassword("");
                model.setSMTPServerRequiresAuthentication(false);
            }
            model.setEmailAddressList(data.getEmailAddressList());
        } else {
            model.setSMTPFromEmailAddress("");
            model.setSMTPServer("");
            model.setSMTPUsername("");
            model.setSMTPPassword("");
            model.setSMTPServerRequiresAuthentication(false);
            model.setEmailAddressList(null);
        }
    }

    private void populateFirstAid(FirstAidDataModel model) {
        model.reset();
        model.setRaidSystem(this.managedSystem);
        model.setConditioningPriority(50);
    }

    private void populateSlicing(AdvancedSlicingModel model) {
        model.reset();
        model.setRaidSystem(this.managedSystem);
        model.setDriveStates(DriveSelectionPanel.getDriveStatesFromRaidSystem(this.managedSystem));
        model.setDriveArrays(DriveSelectionPanel.getDriveArraysFromRaidSystem(this.managedSystem));
        model.setDriveCapacities(DriveSelectionPanel.getDriveCapacitiesFromRaidSystem(this.managedSystem));
        model.setArrayDescriptions(ArraySelectionPanel.getArrayDescriptionsFromRaidSystem(this.managedSystem));
        model.setArrayLevels(ArraySelectionPanel.getArrayLevelsFromRaidSystem(this.managedSystem));
        Collection raidsets = this.managedSystem.getRaidSets();
        int[][] sliceSizes = new int[raidsets.size()][8];
        Iterator rsIter = raidsets.iterator();
        while (rsIter.hasNext()) {
            RaidSet rs = (RaidSet)rsIter.next();
            Collection slices = rs.getSlices();
            int[] sliceArray = new int[slices.size()];
            Iterator sliceIter = slices.iterator();
            while (sliceIter.hasNext()) {
                Slice slice = (Slice)sliceIter.next();
                sliceArray[slice.getId()] = slice.getSize();
            }
            sliceSizes[rs.getId() - 1] = sliceArray;
        }
        model.setSliceSizes(sliceSizes);
    }

    private void populateExpansion(AdvancedExpansionModel model) {
        model.reset();
        model.setRaidSystem(this.managedSystem);
        model.setDriveStates(DriveSelectionPanel.getDriveStatesFromRaidSystem(this.managedSystem));
        model.setDriveArrays(DriveSelectionPanel.getDriveArraysFromRaidSystem(this.managedSystem));
        model.setDriveCapacities(DriveSelectionPanel.getDriveCapacitiesFromRaidSystem(this.managedSystem));
        model.setArrayDescriptions(ArraySelectionPanel.getArrayDescriptionsFromRaidSystem(this.managedSystem));
        model.setArrayLevels(ArraySelectionPanel.getArrayLevelsFromRaidSystem(this.managedSystem));
    }

    private void populateMasking(AdvancedMaskingModel model) {
        model.reset();
        model.setControllers(2);
        int index = 1;
        while (index <= 2) {
            RaidController controller = this.managedSystem.getRaidController(index);
            FibreChannelInterface fc = (FibreChannelInterface)controller.getHostInterface(1);
            AdvancedMaskingModel.AdvancedMaskingControllerModel lunModel = index == 1 ? model.getUpperControllerModel() : model.getLowerControllerModel();
            lunModel.reset();
            lunModel.setLUNMaskEnabled(controller.getLunMaskEnabled() == 1 ? Boolean.TRUE : Boolean.FALSE);
            ArrayList<Integer> lunIDs = new ArrayList<Integer>();
            ArrayList<String> lunNames = new ArrayList<String>();
            ArrayList<String> lunDescriptions = new ArrayList<String>();
            Iterator iter = controller.getRaidSets().iterator();
            while (iter.hasNext()) {
                RaidSet rs = (RaidSet)iter.next();
                Iterator sliceIter = rs.getMappedSlices().iterator();
                while (sliceIter.hasNext()) {
                    Slice s = (Slice)sliceIter.next();
                    lunIDs.add(new Integer(s.getLunId()));
                    lunNames.add(SOMLocalizer.getSliceName(s));
                    lunDescriptions.add(SOMLocalizer.getSliceDescription(s));
                }
            }
            lunModel.setLUNIDs(lunIDs);
            lunModel.setLUNNames(lunNames);
            lunModel.setLUNDescriptions(lunDescriptions);
            ArrayList<String> lunMaskHostList = new ArrayList<String>();
            ArrayList<BitSet> visibleList = new ArrayList<BitSet>();
            Iterator iter2 = ((AbstractList)fc.getLunMaskList()).iterator();
            while (iter2.hasNext()) {
                LunMaskSetting setting = (LunMaskSetting)iter2.next();
                lunMaskHostList.add(setting.getWorldWideName());
                BitSet visibleBitMask = new BitSet();
                Iterator lunMaskIterator = ((AbstractList)setting.getLUNMaskArray()).iterator();
                while (lunMaskIterator.hasNext()) {
                    Long lunIDMasked = (Long)lunMaskIterator.next();
                    visibleBitMask.set(lunIDMasked.intValue());
                }
                visibleList.add(visibleBitMask);
            }
            lunModel.setWWPName(lunMaskHostList);
            lunModel.setLUNVisible(visibleList);
            ++index;
        }
    }

    private boolean isValidString(String string) {
        return string != null && string.length() > 0;
    }

    private void handleCreate() {
        CreateArrayModel model = (CreateArrayModel)this.createDataModel;
        boolean selectionJBOD = model.getLevel() == 255;
        String progressMsg = selectionJBOD ? Resources.getString("management.progress.creating.jbod") : Resources.getString("management.progress.creating");
        this.showProgressDialogAndCloseManagementWindow(progressMsg);
        if (selectionJBOD) {
            this.handleCreateJbod(model);
        } else {
            this.handleCreateRaid(model);
        }
    }

    private void handleCreateRaid(CreateArrayModel model) {
        String raidLevel;
        RaidController controller = null;
        ArrayList<Integer> memberList = new ArrayList<Integer>(7);
        int[] drives = model.getDriveStates();
        int i = 0;
        while (i < drives.length) {
            if (drives[i] == -1) {
                if (controller == null) {
                    controller = i < 7 ? this.managedSystem.getRaidController(1) : this.managedSystem.getRaidController(2);
                }
                Integer memberId = controller.getId() == 1 ? new Integer(i + 1) : new Integer(i + 1 - 7);
                memberList.add(memberId);
            }
            ++i;
        }
        Integer[] members = memberList.toArray(new Integer[0]);
        switch (model.getLevel()) {
            case 0: {
                raidLevel = "0";
                break;
            }
            case 1: {
                raidLevel = "1";
                break;
            }
            case 2: {
                raidLevel = "3";
                break;
            }
            case 3: {
                raidLevel = "5";
                break;
            }
            case 4: {
                raidLevel = "0+1";
                break;
            }
            default: {
                String msg = "Unknown RAID level for create RAID set: \"" + model.getLevel() + "\"";
                logger.error(msg);
                throw new Error(msg);
            }
        }
        String type = model.getBackgroundInitEnabled() ? "raid-now" : "regular";
        RaidSetCreator creator = new RaidSetCreator(controller, members, raidLevel, type);
        new Thread(creator).start();
    }

    private void handleCreateJbod(CreateArrayModel model) {
        int id = -1;
        int[] drives = model.getDriveStates();
        int i = 0;
        while (i < drives.length) {
            if (drives[i] == -1) {
                id = i < 7 ? 1 : 2;
                break;
            }
            ++i;
        }
        if (id != -1) {
            logger.info("Creating " + (id == 1 ? "upper" : "lower") + " JBOD");
            RequestMessage msg = this.managedSystem.getMessageFactory().newJbodMaskEnableRequest(Boolean.FALSE);
            this.managedSystem.postMessageAsync(null, msg, id, null);
            int restartMask = id == 1 ? 17 : 34;
            new Thread(new Restarter(this.managedSystem, restartMask)).start();
        }
    }

    private void handleDelete() {
        DeleteArrayModel model = (DeleteArrayModel)this.deleteDataModel;
        boolean selectionJBOD = DriveSelectionPanel.isJbod(model.getArrayIndex());
        String progressMsg = selectionJBOD ? Resources.getString("management.progress.deleting.jbod") : Resources.getString("management.progress.deleting");
        this.showProgressDialogAndCloseManagementWindow(progressMsg);
        if (selectionJBOD) {
            this.handleDeleteJbod(model);
        } else {
            this.handleDeleteRaid(model);
        }
    }

    private void handleDeleteRaid(DeleteArrayModel model) {
        RequestMessage msg;
        int index = model.getArrayIndex();
        RaidSet rs = this.managedSystem.getRaidSet(index);
        Integer id = new Integer(rs.getNativeId());
        RaidController controller = rs.getController();
        MessageFactory factory = this.managedSystem.getMessageFactory();
        logger.info("Deleting RAID set " + id);
        Collection slices = rs.getMappedSlices();
        ArrayList<Integer> luns = new ArrayList<Integer>(slices.size());
        Iterator iter = slices.iterator();
        while (iter.hasNext()) {
            Slice s = (Slice)iter.next();
            if (s.getLunId() == -1) continue;
            luns.add(new Integer(s.getLunId()));
        }
        if (rs.getOperation() == 1) {
            logger.info("RAID set " + index + " is initializing. Stopping init before delete.");
            msg = factory.newRecalculateCheckDataRequest(id, "stop");
            this.managedSystem.postMessageAsync(null, msg, controller.getId(), null);
        }
        boolean restart = controller.getRaidSets().size() == 1;
        msg = factory.newDeleteArrayRequest(id);
        this.managedSystem.postMessageAsync(null, msg, controller.getId(), null);
        LunMapper mapper = new LunMapper(controller);
        mapper.unmapLuns(luns);
        if (restart) {
            logger.info("RAID set " + id + " was the last array. Restarting RAID controller " + controller.getId());
            msg = factory.newRestartRaidControllerRequest();
            this.managedSystem.postMessageAsync(null, msg, controller.getId(), null);
        }
    }

    private void handleDeleteJbod(DeleteArrayModel model) {
        int id = -1;
        int arrayIndex = model.getArrayIndex();
        if (arrayIndex == -2) {
            id = 1;
        } else if (arrayIndex == -3) {
            id = 2;
        } else {
            logger.error("handleDeleteJbod called with no JBOD RAID set selected. arrayIndex = " + arrayIndex);
        }
        if (id != -1) {
            logger.info("Deleting " + (id == 1 ? "upper" : "lower") + " JBOD");
            RequestMessage msg = this.managedSystem.getMessageFactory().newJbodMaskEnableRequest(Boolean.TRUE);
            this.managedSystem.postMessageAsync(null, msg, id, null);
            int restartMask = id == 1 ? 17 : 34;
            new Thread(new Restarter(this.managedSystem, restartMask)).start();
        }
    }

    private void handleNotifications() {
        String password;
        String username;
        MessageFactory factory = this.managedSystem.getMessageFactory();
        NotificationsModel model = (NotificationsModel)this.notificationsModel;
        this.showProgressDialogAndCloseManagementWindow(Resources.getString("management.progress.notifications"));
        logger.info("Setting up email list");
        if (model.getSMTPServerRequiresAuthentication()) {
            username = model.getSMTPUsername();
            password = model.getSMTPPassword();
        } else {
            username = "";
            password = "";
        }
        EmailNotifications emailNotification = new EmailNotifications(model.getSMTPFromEmailAddress(), model.getSMTPServer(), username, password, model.getEmailAddressList());
        HashMap<String, String> props = new HashMap<String, String>();
        ArrayList<Map> list = new ArrayList<Map>();
        StringWriter writer = new StringWriter();
        list.add(emailNotification.toMap());
        try {
            PropertyListUtilities.writeXML(list, writer);
            props.put(String.valueOf(String.valueOf(AcpPropertyCode.EMAIL_NOTIFICATION)), writer.toString());
            RequestMessage msg = factory.newSetPropertiesRequest(props);
            1 handler = new 1(emailNotification);
            logger.info("Sending list to companion...");
            msg.setTargetController(RequestMessage.Target.COMPANION);
            this.managedSystem.postMessageAsync(null, msg);
            logger.info("Sending list to master...");
            msg.setTargetController(null);
            this.managedSystem.postMessageAsync(null, msg);
            props.put(String.valueOf(String.valueOf(AcpPropertyCode.ACTION_FLUSH_NVRAM)), "");
            msg = factory.newSetPropertiesRequest(props);
            logger.info("Sending nvram sync to companion...");
            msg.setTargetController(RequestMessage.Target.COMPANION);
            this.managedSystem.postMessageAsync(null, msg);
            logger.info("Sending nvram sync to master...");
            msg.setTargetController(null);
            this.managedSystem.postMessageAsync(handler, msg);
        }
        catch (IOException iOException) {}
    }

    private void handleTestEmail(TestEmail email) {
        MessageFactory factory = this.managedSystem.getMessageFactory();
        RequestMessage msg = factory.newSendEmailRequest(email);
        this.managedSystem.postMessageAsync(null, msg, null);
    }

    private void handleSetup() {
        this.showProgressDialogAndCloseManagementWindow(Resources.getString("management.progress.settings"));
        int restartBitMask = 0;
        restartBitMask |= this.handleNetworkSetup(restartBitMask);
        restartBitMask |= this.handleSystemSetup(restartBitMask);
        restartBitMask |= this.handleFibreChannelSetup(restartBitMask);
        restartBitMask |= this.handlePerformanceSetup(restartBitMask);
        Restarter restarter = new Restarter(this.managedSystem, restartBitMask);
        new Thread(restarter).start();
    }

    private int handleSystemSetup(int restartBitMask) {
        RequestMessage msg;
        ManagementSystemModel model = (ManagementSystemModel)this.setupDataModels[0];
        int syncMethod = model.getTimeSynchronizationMethod();
        String bottomSysPresentationName = null;
        String bottomSysName = null;
        boolean restartUpper = false;
        boolean restartLower = false;
        HashMap<String, Object> props = new HashMap<String, Object>();
        Set fields = model.changedKeySet();
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            logger.info("System setup field \"" + key + "\" changed");
            if (key.equals("SYSTEM_NAME")) {
                try {
                    String name = StringUtilities.truncateStringToEncodedByteLength(model.getSystemName(), "UTF-8", 255);
                    props.put(String.valueOf(String.valueOf(AcpPropertyCode.SYS_PRESENTATION_NAME)), name);
                    props.put(String.valueOf(String.valueOf(AcpPropertyCode.SYS_NAME)), name);
                    bottomSysPresentationName = StringUtilities.truncateStringToEncodedByteLength(model.getSystemName(), "UTF-8", 255);
                    bottomSysName = StringUtilities.appendStringWithMaxEncodedByteLength(name, SYSTEM_NAME_UNIQUIFIER, "UTF-8", 255);
                    restartUpper = true;
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e);
                }
                continue;
            }
            if (key.equals("CONTACT")) {
                props.put(String.valueOf(String.valueOf(AcpPropertyCode.SYS_CONTACT)), model.getContact());
                continue;
            }
            if (key.equals("LOCATION")) {
                props.put(String.valueOf(String.valueOf(AcpPropertyCode.SYS_LOCATION)), model.getLocation());
                continue;
            }
            if (key.equals("ENABLE_AUDIBLE_ALERTS")) {
                props.put(String.valueOf(String.valueOf(AcpPropertyCode.EFFECT_FLAGS)), model.getEnableAudibleAlerts() ? new Integer(0) : new Integer(1));
                continue;
            }
            if (key.equals("RESTART_AUTOMATICALLY")) {
                props.put(String.valueOf(String.valueOf(AcpPropertyCode.SERVER_MODE)), new Integer(model.getRestartAutomatically() ? 1 : 0));
                continue;
            }
            if (key.equals("ENABLE_SNMP")) {
                int flags = 1;
                if (!model.getEnableSnmp()) {
                    flags |= 2;
                }
                props.put(String.valueOf(String.valueOf(AcpPropertyCode.SNMP_ACCESS_FLAGS)), new Integer(flags));
                continue;
            }
            if (key.equals("GUEST_PASSWORD")) {
                try {
                    props.put(String.valueOf(String.valueOf(AcpPropertyCode.SYS_GUEST_PASSWORD)), model.getGuestPassword());
                    String encoded = Utilities.crypt(model.getGuestPassword());
                    this.managedSystem.setMonitoringPassword(encoded);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!key.equals("ADMIN_PASSWORD")) continue;
            props.put(String.valueOf(String.valueOf(AcpPropertyCode.SYS_PASSWORD_RW)), model.getAdminPassword());
        }
        HashMap propsCopy = (HashMap)props.clone();
        if (bottomSysPresentationName != null && bottomSysName != null) {
            props.put(String.valueOf(String.valueOf(AcpPropertyCode.SYS_PRESENTATION_NAME)), bottomSysPresentationName);
            props.put(String.valueOf(String.valueOf(AcpPropertyCode.SYS_NAME)), bottomSysName);
            restartLower = true;
        }
        if (propsCopy.size() > 0) {
            if ((restartBitMask & 4) == 0) {
                restartBitMask = restartUpper ? (restartBitMask |= 4) : (restartBitMask |= 0x40);
            }
            msg = this.managedSystem.getMessageFactory().newSetPropertiesRequest(propsCopy);
            logger.info("Updating system properties for top system controller");
            this.managedSystem.postMessageAsync(null, msg, 1, null);
        }
        if (props.size() > 0) {
            if ((restartBitMask & 8) == 0) {
                restartBitMask = restartLower ? (restartBitMask |= 8) : (restartBitMask |= 0x80);
            }
            msg = this.managedSystem.getMessageFactory().newSetPropertiesRequest(props);
            logger.info("Updating system properties for bottom system controller");
            this.managedSystem.postMessageAsync(null, msg, 2, null);
        }
        if (syncMethod == 2) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm z");
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            String now = formatter.format(new Date());
            msg = this.managedSystem.getMessageFactory().newSetTimeRequest(null);
            logger.info("Updating top system controller RTC to " + now);
            this.managedSystem.postMessageAsync(null, msg, 1, null);
            logger.info("Updating bottom system controller RTC to " + now);
            this.managedSystem.postMessageAsync(null, msg, 2, null);
            msg = this.managedSystem.getMessageFactory().newSetPropertyRequest(AcpPropertyCode.NTP_CONFIG.toString(), ".");
            this.managedSystem.postMessageAsync(null, msg, 1, null);
            this.managedSystem.postMessageAsync(null, msg, 2, null);
        } else if (syncMethod == 3) {
            msg = this.managedSystem.getMessageFactory().newSetPropertyRequest(AcpPropertyCode.NTP_CONFIG.toString(), model.getNTPServer());
            this.managedSystem.postMessageAsync(null, msg, 1, null);
            this.managedSystem.postMessageAsync(null, msg, 2, null);
        } else {
            msg = this.managedSystem.getMessageFactory().newSetPropertyRequest(AcpPropertyCode.NTP_CONFIG.toString(), ".");
            this.managedSystem.postMessageAsync(null, msg, 1, null);
            this.managedSystem.postMessageAsync(null, msg, 2, null);
        }
        return restartBitMask;
    }

    private int handleNetworkSetup(int restartBitMask) {
        ManagementNetworkModel model = (ManagementNetworkModel)this.setupDataModels[1];
        int index = 1;
        while (index <= 2) {
            ManagementNetworkModel.ManagementNetworkControllerModel networkModel = index == 1 ? model.getUpperControllerModel() : model.getLowerControllerModel();
            HashMap<String, Object> props = new HashMap<String, Object>();
            int method = networkModel.getNetworkConfigurationMethod();
            if (networkModel.fieldChanged("NETWORK_CONFIGURATION_METHOD")) {
                int cv = method == 1 ? 768 : (method == 2 ? 1024 : 768);
                props.put(String.valueOf(String.valueOf(AcpPropertyCode.LAN_CONFIGURE_VIA)), new Integer(cv));
            }
            if (method == 2) {
                boolean changed = false;
                if (networkModel.fieldChanged("IP_ADDRESS")) {
                    props.put(String.valueOf(String.valueOf(AcpPropertyCode.LAN_IP_ADDRESS)), ManagementNetworkModel.translateAddress(networkModel.getIPAddress()));
                    changed = true;
                }
                if (networkModel.fieldChanged("SUBNET_MASK")) {
                    props.put(String.valueOf(String.valueOf(AcpPropertyCode.LAN_SUBNET_MASK)), ManagementNetworkModel.translateAddress(networkModel.getSubnetMask()));
                    changed = true;
                }
                if (networkModel.fieldChanged("ROUTER_ADDRESS")) {
                    props.put(String.valueOf(String.valueOf(AcpPropertyCode.LAN_ROUTER_ADDRESS)), ManagementNetworkModel.translateAddress(networkModel.getRouter()));
                    changed = true;
                }
                if (changed) {
                    props.put(String.valueOf(String.valueOf(AcpPropertyCode.WAN_DNS_1)), ManagementNetworkModel.translateAddress(networkModel.getDNS1()));
                    props.put(String.valueOf(String.valueOf(AcpPropertyCode.WAN_DNS_2)), ManagementNetworkModel.translateAddress(networkModel.getDNS2()));
                    props.put(String.valueOf(String.valueOf(AcpPropertyCode.WAN_DNS_3)), ManagementNetworkModel.translateAddress(networkModel.getDNS3()));
                }
            }
            if (networkModel.fieldChanged("DNS_1")) {
                props.put(String.valueOf(String.valueOf(AcpPropertyCode.WAN_DNS_1)), ManagementNetworkModel.translateAddress(networkModel.getDNS1()));
            }
            if (networkModel.fieldChanged("DNS_2")) {
                props.put(String.valueOf(String.valueOf(AcpPropertyCode.WAN_DNS_2)), ManagementNetworkModel.translateAddress(networkModel.getDNS2()));
            }
            if (networkModel.fieldChanged("DNS_3")) {
                props.put(String.valueOf(String.valueOf(AcpPropertyCode.WAN_DNS_3)), ManagementNetworkModel.translateAddress(networkModel.getDNS3()));
            }
            if (networkModel.fieldChanged("DHCP_CLIENT_ID")) {
                props.put(String.valueOf(String.valueOf(AcpPropertyCode.LAN_DHCP_CLIENT_ID)), networkModel.getDHCPClientID());
            }
            if (props.size() > 0) {
                RequestMessage msg = this.managedSystem.getMessageFactory().newSetPropertiesRequest(props);
                logger.info("Updating network properties for " + (index == 1 ? "top" : "bottom") + " system controller");
                logger.info("Network properties: " + props);
                this.managedSystem.postMessageAsync(null, msg, index, null);
                restartBitMask = index == 1 ? (restartBitMask |= 4) : (restartBitMask |= 8);
            }
            ++index;
        }
        return restartBitMask;
    }

    private int handleFibreChannelSetup(int restartBitMask) {
        ManagementFibreModel model = (ManagementFibreModel)this.setupDataModels[2];
        int index = 1;
        while (index <= 2) {
            boolean needsRestart = false;
            ManagementFibreModel.ManagementFibreControllerModel fcModel = index == 1 ? model.getUpperControllerModel() : model.getLowerControllerModel();
            HashMap props = new HashMap();
            Set fields = fcModel.changedKeySet();
            Iterator iter = fields.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (!key.equals("WORLD_WIDE_PORT_NAME") && !key.equals("WORLD_WIDE_NODE_NAME")) {
                    RequestMessage msg;
                    if (key.equals("SPEED")) {
                        int speedSelection = fcModel.getSpeed();
                        String speed = speedSelection == 2 ? "2Gb/sec" : (speedSelection == 1 ? "1Gb/sec" : "auto-negotiated");
                        msg = this.managedSystem.getMessageFactory().newSetFibreChannelSpeedRequest(new Integer(1), speed);
                        logger.info("Updating fibre speed properties for " + (index == 1 ? "top" : "bottom") + " raid controller");
                        this.managedSystem.postMessageAsync(null, msg, index, null);
                        needsRestart = true;
                    } else if (key.equals("TOPOLOGY")) {
                        int topologySelection = fcModel.getTopology();
                        String topology = topologySelection == 1 ? "point-to-point" : (topologySelection == 2 ? "arbitrated-loop" : "auto");
                        msg = this.managedSystem.getMessageFactory().newSetFibreChannelTopologyRequest(topology);
                        logger.info("Updating fibre topology properties for " + (index == 1 ? "top" : "bottom") + " raid controller");
                        this.managedSystem.postMessageAsync(null, msg, index, null);
                        needsRestart = true;
                    } else if (key.equals("HARD_LOOP_ID_ENABLED")) {
                        boolean enabled = fcModel.getHardLoopEnabled();
                        msg = this.managedSystem.getMessageFactory().newSetFibreChannelHardLoopIDEnableRequest(enabled);
                        logger.info(enabled ? "Enabling" : "Disabling fibre hard loop ID for " + (index == 1 ? "top" : "bottom") + " raid controller");
                        this.managedSystem.postMessageAsync(null, msg, index, null);
                        needsRestart = true;
                    } else if (key.equals("HARD_LOOP_ID")) {
                        Integer id = new Integer(fcModel.getHardLoopID());
                        msg = this.managedSystem.getMessageFactory().newSetFibreChannelHardLoopIDRequest(id);
                        logger.info("Setting fibre hard loop ID = " + id + " for " + (index == 1 ? "top" : "bottom") + " raid controller");
                        this.managedSystem.postMessageAsync(null, msg, index, null);
                        needsRestart = true;
                    }
                }
                if (!needsRestart) continue;
                restartBitMask |= index == 1 ? 16 : 32;
                restartBitMask |= index == 1 ? 1 : 2;
            }
            ++index;
        }
        return restartBitMask;
    }

    private int handlePerformanceSetup(int restartBitMask) {
        boolean slowReadBypassSupported;
        boolean syncCacheSupported;
        boolean diskCacheSupported;
        ManagementPerformanceModel model = (ManagementPerformanceModel)this.setupDataModels[3];
        try {
            diskCacheSupported = OperationManager.isSupported(this.managedSystem, OperationManager.OP_CONFIGURE_DISK_CACHE);
        }
        catch (Exception e) {
            diskCacheSupported = true;
            logger.error(e);
        }
        try {
            syncCacheSupported = OperationManager.isSupported(this.managedSystem, OperationManager.OP_CONFIGURE_SYNC_CACHE);
        }
        catch (Exception e) {
            syncCacheSupported = true;
            logger.error(e);
        }
        try {
            slowReadBypassSupported = OperationManager.isSupported(this.managedSystem, OperationManager.OP_CONFIGURE_SLOW_READ_BYPASS);
        }
        catch (Exception e) {
            slowReadBypassSupported = true;
            logger.error(e);
        }
        int index = 1;
        while (index <= 2) {
            RequestMessage msg;
            ManagementPerformanceModel.ManagementPerformanceControllerModel perfModel = index == 1 ? model.getUpperPerformanceModel() : model.getLowerPerformanceModel();
            Set fields = perfModel.changedKeySet();
            Iterator iter = fields.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (key.equals("CONTROLLER_CACHE")) {
                    logger.info("Changing Controller cache setting for " + (index == 1 ? "top" : "bottom") + " RAID controller");
                    msg = this.managedSystem.getMessageFactory().newSetRAIDCacheControlRequest(perfModel.getControllerCache() == 0);
                    this.managedSystem.postMessageAsync(null, msg, index, null);
                    continue;
                }
                if (syncCacheSupported && key.equals("SYNC_CACHE")) {
                    logger.info(String.valueOf(perfModel.getSyncCache() == 0 ? "Enabling " : "Disabling ") + "sync cache setting for " + (index == 1 ? "top" : "bottom") + " RAID controller");
                    msg = this.managedSystem.getMessageFactory().newSetSynchronizeCacheRequest(perfModel.getSyncCache() == 0 ? 1 : 2);
                    this.managedSystem.postMessageAsync(null, msg, index, null);
                    continue;
                }
                if (slowReadBypassSupported && key.equals("SLOW_READ_BYPASS")) {
                    logger.info(String.valueOf(perfModel.getSlowReadBypass() == 0 ? "Enabling " : "Disabling ") + "slow read bypass mode for " + (index == 1 ? "top" : "bottom") + " RAID controller");
                    msg = this.managedSystem.getMessageFactory().newSlowReadBypassModeControlRequest(perfModel.getSlowReadBypass() == 0);
                    this.managedSystem.postMessageAsync(null, msg, index, null);
                    continue;
                }
                if (!key.equals("PREFETCH")) continue;
                int[] nArray = new int[3];
                nArray[1] = 3;
                nArray[2] = 7;
                int[] settings = nArray;
                logger.info("Changing Controller prefetch setting for " + (index == 1 ? "top" : "bottom") + " RAID controller");
                msg = this.managedSystem.getMessageFactory().newSetRAIDPrefetchSizeRequest(settings[perfModel.getPrefetch()]);
                this.managedSystem.postMessageAsync(null, msg, index, null);
            }
            if (diskCacheSupported) {
                boolean cacheEnabled = perfModel.getDiskCache() == 0;
                boolean hasDriveCacheFeature = this.managedSystem.supportsGlobalDriveCacheFeature();
                if (hasDriveCacheFeature) {
                    logger.info("1.5 or later firmware: " + (cacheEnabled ? "Enabling" : "Disabling") + " all drive caches on controller " + index);
                    Integer driveCacheFlags = cacheEnabled ? new Integer(127) : new Integer(0);
                    msg = this.managedSystem.getMessageFactory().newSetPropertyRequest(AcpPropertyCode.DRIVE_CACHE_FLAGS.fourCharCode(), driveCacheFlags);
                    this.managedSystem.postMessageAsync(null, msg, index, null);
                } else {
                    RaidController controller = this.managedSystem.getRaidController(index);
                    Iterator slotIter = controller.getDiskSlots().iterator();
                    while (slotIter.hasNext()) {
                        DiskSlot slot = (DiskSlot)slotIter.next();
                        if (!slot.isPopulated()) continue;
                        logger.info("Pre-1.5 firmware: " + (cacheEnabled ? "Enabling" : "Disabling") + " disk " + slot.getDisk().getId() + " cache on controller " + index);
                        msg = this.managedSystem.getMessageFactory().newSetDriveCacheControlRequest(slot.getDisk().getNativeId(), cacheEnabled);
                        this.managedSystem.postMessageAsync(null, msg, index, null);
                    }
                }
            }
            ++index;
        }
        return restartBitMask;
    }

    private void handleFirstAid() {
        RequestMessage request;
        String progressMsg;
        int raidControllerID;
        int raidSetID;
        FirstAidDataModel model = (FirstAidDataModel)this.firstAidDataModel;
        int operation = model.getOperation();
        MessageFactory msgFactory = this.managedSystem.getMessageFactory();
        if (operation == 0 || operation == 1 || operation == 2 || operation == 3 || operation == 5) {
            RaidSet raidSet = this.managedSystem.getRaidSet(model.getArrayID());
            RaidController raidController = raidSet.getController();
            raidSetID = raidSet.getNativeId();
            raidControllerID = raidController.getId();
        } else {
            raidSetID = 0;
            raidControllerID = model.getControllerID();
        }
        if (operation == 0) {
            logger.info("Verify RAID set " + raidSetID + " parity on RAID controller " + raidControllerID);
            progressMsg = Resources.getString("management.progress.verifying");
            request = msgFactory.newVerifyCheckDataRequest(new Integer(raidSetID), "start");
        } else if (operation == 1) {
            logger.info("Rebuild RAID set " + raidSetID + " parity on RAID controller " + raidControllerID);
            progressMsg = Resources.getString("management.progress.rebuilding");
            request = msgFactory.newRecalculateCheckDataRequest(new Integer(raidSetID), "start");
        } else if (operation == 2) {
            logger.info("Start background read/write scan on RAID controller " + raidControllerID + ", RAID set " + raidSetID);
            progressMsg = Resources.getString("management.progress.bgrw.starting");
            this.showProgressDialogAndCloseManagementWindow(progressMsg);
            request = msgFactory.newSetBackgroundReadWriteScanThresholdRequest(new Integer(model.getConditioningPriority()));
            this.managedSystem.postMessageAsync(null, request, raidControllerID, null);
            request = msgFactory.newBackgroundReadWriteScanRequest(raidSetID, 1);
        } else if (operation == 3) {
            logger.info("Pause background read/write scan on RAID controller " + raidControllerID + ", RAID set " + raidSetID);
            progressMsg = Resources.getString("management.progress.bgrw.pausing");
            request = msgFactory.newBackgroundReadWriteScanRequest(raidSetID, 3);
        } else if (operation == 4) {
            logger.info("Resume background read/write scan on RAID controller " + raidControllerID + ", RAID set " + raidSetID);
            progressMsg = Resources.getString("management.progress.bgrw.resuming");
            request = msgFactory.newBackgroundReadWriteScanRequest(raidSetID, 1);
        } else if (operation == 5) {
            logger.info("Stop background read/write scan on RAID controller " + raidControllerID + ", RAID set " + raidSetID);
            progressMsg = Resources.getString("management.progress.bgrw.stopping");
            request = msgFactory.newBackgroundReadWriteScanRequest(raidSetID, 2);
        } else if (operation == 6) {
            Disk disk = this.managedSystem.getDisk(model.getDriveID());
            logger.info("Clearing metadata on disk " + disk.getNativeId() + ", RAID controller " + raidControllerID);
            progressMsg = Resources.getString("management.progress.manageOrphans");
            request = msgFactory.newDeleteBrokenRaidMemberRequest(disk.getNativeId());
        } else if (operation == 7) {
            logger.info("Recognize array on RAID controller " + raidControllerID);
            ManagementProgressSheet progressPanel = new ManagementProgressSheet(Resources.getString("management.progress.recognizeArray"));
            AquaAlert progressSheet = new AquaAlert(progressPanel, null, null, null);
            new Thread(new RecognizeArrayAction(this.managedSystem, raidControllerID, progressSheet)).start();
            progressSheet.showSheet(this.managementWindow, new 2(progressPanel, this), null);
            progressMsg = null;
            request = null;
        } else {
            progressMsg = StringUtilities.replaceAll(Resources.getString("management.progress.error"), "{window}", Resources.getString("firstAid"));
            progressMsg = StringUtilities.replaceAll(progressMsg, "{code}", String.valueOf(operation));
            logger.error(progressMsg);
            request = null;
        }
        if (progressMsg != null) {
            this.showProgressDialogAndCloseManagementWindow(progressMsg);
        }
        if (request != null) {
            this.managedSystem.postMessageAsync(null, request, raidControllerID, null);
        }
    }

    private void handleSlicing() {
        AdvancedSlicingModel model = (AdvancedSlicingModel)this.advancedDataModels[0];
        RaidSet raidSet = this.managedSystem.getRaidSet(model.getArrayIndex());
        String progressMessage = Resources.getString("management.progress.slicing");
        ManagementProgressSheet progressPanel = new ManagementProgressSheet(progressMessage);
        AquaAlert progressSheet = new AquaAlert(progressPanel, null, null, null);
        progressSheet.showSheet(this.managementWindow, null, null);
        progressPanel.startAnimation();
        3 completeSlicing = new 3(progressSheet, this);
        Slicer slicer = new Slicer(this.managedSystem, raidSet, model.getSliceCount(), new InvocationEvent((Object)this, completeSlicing));
        new Thread(slicer).start();
    }

    private void handleExpansion() {
        AdvancedExpansionModel model = (AdvancedExpansionModel)this.advancedDataModels[1];
        int index = model.getArrayIndex();
        RaidSet rs = this.managedSystem.getRaidSet(index);
        Integer id = new Integer(rs.getNativeId());
        RaidController controller = rs.getController();
        MessageFactory factory = this.managedSystem.getMessageFactory();
        this.showProgressDialogAndCloseManagementWindow(Resources.getString("management.progress.expanding"));
        int controllerId = -1;
        int diskCount = 0;
        int[] drives = model.getDriveStates();
        int i = 0;
        while (i < drives.length) {
            if (drives[i] == -1) {
                ++diskCount;
            }
            ++i;
        }
        logger.info("Expanding RAID set " + id + " with " + diskCount + " disks on RAID controller " + controller.getId());
        if (diskCount > 0) {
            RequestMessage msg = factory.newExpandArrayRequest(id, new Integer(diskCount));
            this.managedSystem.postMessageAsync(null, msg, controller.getId(), null);
        }
    }

    private void handleMasking() {
        AdvancedMaskingModel model = (AdvancedMaskingModel)this.advancedDataModels[2];
        int restartBitMask = 0;
        this.showProgressDialogAndCloseManagementWindow(Resources.getString("management.progress.masking"));
        int index = 1;
        while (index <= 2) {
            RequestMessage msg;
            AdvancedMaskingModel.AdvancedMaskingControllerModel lunModel = index == 1 ? model.getUpperControllerModel() : model.getLowerControllerModel();
            HashMap props = new HashMap();
            Set fields = lunModel.changedKeySet();
            boolean needsRestart = false;
            boolean mappingChanged = false;
            Iterator iter = fields.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (key.equals("ENABLED")) {
                    boolean enabled = lunModel.getLUNMaskEnabled();
                    msg = this.managedSystem.getMessageFactory().newSetFibreChannelLUNMaskEnableRequest(enabled);
                    logger.info(enabled ? "Enabling" : "Disabling LUN Masking for " + (index == 1 ? "top" : "bottom") + " RAID controller");
                    this.managedSystem.postMessageAsync(null, msg, index, null);
                    needsRestart = true;
                    continue;
                }
                if (key.equals("WORLD_WIDE_NAME")) {
                    mappingChanged = true;
                    needsRestart = true;
                    continue;
                }
                if (!key.equals("LUN_VISIBLE")) continue;
                mappingChanged = true;
                needsRestart = true;
            }
            if (mappingChanged) {
                logger.info("LUN mask settings changed:");
                ArrayList wwns = lunModel.getWWPName();
                ArrayList visible = lunModel.getLUNVisible();
                ArrayList<Map> lunMaskList = new ArrayList<Map>();
                if (wwns.size() != visible.size()) {
                    throw new RuntimeException("wwns.size() != visible.size()");
                }
                int host = 1;
                int count = 0;
                while (count < wwns.size()) {
                    String wwpName = (String)wwns.get(count);
                    if (wwpName.length() > 0) {
                        BitSet mask = (BitSet)visible.get(count);
                        ArrayList<Integer> ids = new ArrayList<Integer>();
                        int bit = 0;
                        while (bit < 128) {
                            if (mask.get(bit)) {
                                ids.add(new Integer(bit));
                            }
                            ++bit;
                        }
                        logger.info("     WWPN " + wwpName + " views " + ids);
                        LunMaskSetting lms = new LunMaskSetting(host++, wwpName, ids);
                        lunMaskList.add(lms.toMap());
                    }
                    ++count;
                }
                msg = this.managedSystem.getMessageFactory().newSetFibreChannelLUNMaskRequest(lunMaskList);
                logger.info("Changing LUN Masking for " + (index == 1 ? "top" : "bottom") + " RAID controller");
                this.managedSystem.postMessageAsync(null, msg, index, null);
            }
            if (needsRestart) {
                restartBitMask |= index == 1 ? 16 : 32;
                restartBitMask |= index == 1 ? 1 : 2;
            }
            ++index;
        }
        Restarter restarter = new Restarter(this.managedSystem, restartBitMask);
        new Thread(restarter).start();
    }

    private void setDriveCacheForRaidSet(RaidSet rs, boolean enabled) {
        Disk[] disks = rs.getMembers().toArray(new Disk[0]);
        RaidController rc = rs.getController();
        int index = 0;
        while (index < disks.length) {
            RequestMessage msg = this.managedSystem.getMessageFactory().newSetDriveCacheControlRequest(disks[index].getNativeId(), enabled);
            logger.info("Changing drive cache setting for " + (rc.getId() == 1 ? "top" : "bottom") + " RAID controller, drive = " + index);
            this.managedSystem.postMessageAsync(null, msg, rc.getId() == 1 ? 1 : 2, null);
            ++index;
        }
    }

    private void showProgressDialogAndCloseManagementWindow(String message) {
        ManagementProgressSheet progressPanel = new ManagementProgressSheet(message);
        AquaAlert progressSheet = new AquaAlert(progressPanel, null, null, null);
        progressSheet.showSheet(this.managementWindow, new 4(progressPanel, progressSheet, this), null);
    }

    private boolean validatePane(ManagementPane pane, DataModel[] data) {
        return pane.validateUI(data);
    }

    private void initManagementWindow(String paneType) {
        if (this.managementWindow == null) {
            this.managementWindow = new ManagementWindow(String.valueOf(this.managedSystem.getName()) + Resources.getString("managementController.windowTitleSeparator") + this.managedSystem.getPrimaryHostAddress(), paneType);
            this.managementWindow.setJMenuBar(RaidAdmin.newMenuBar(1));
            if (paneType == null) {
                throw new NullPointerException("paneType may not be null when initializing the management window.");
            }
            if (paneType.equals("create_array_pane")) {
                this.managementWindow.addActionListener(this, "create_array_pane");
            } else if (paneType.equals("delete_array_pane")) {
                this.managementWindow.addActionListener(this, "delete_array_pane");
            } else if (paneType.equals("setup_pane")) {
                this.managementWindow.addActionListener(this, "setup_pane");
            } else if (paneType.equals("notifications_pane")) {
                this.managementWindow.addActionListener(this, "notifications_pane");
            } else if (paneType.equals("first_aid")) {
                this.managementWindow.addActionListener(this, "first_aid");
            } else if (paneType.equals("advanced_pane")) {
                this.managementWindow.addActionListener(this, "advanced_pane");
            } else {
                throw new IllegalArgumentException("An illegal paneType was passed in.");
            }
            this.managementWindow.addWindowListener(new 6());
        } else {
            logger.error("Attempt to init management window when it already exists");
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static /* synthetic */ ManagementWindow access$0(ManagementController $0) {
        return $0.managementWindow;
    }

    static /* synthetic */ RaidSystem access$2(ManagementController $0) {
        return $0.managedSystem;
    }

    private static final class 1
    implements CommunicationHandler {
        private final /* synthetic */ EmailNotifications val$emailNotification;

        public void handleResponse(RaidSystem system, Response response, Object context) {
            if (response.getResultCode() == 0) {
                Iterator iter = system.getSystemControllers().iterator();
                while (iter.hasNext()) {
                    SystemController sc = (SystemController)iter.next();
                    sc.setEmailNotificationsData(this.val$emailNotification);
                }
            }
        }

        /* synthetic */ 1(EmailNotifications val$emailNotification) {
            this.val$emailNotification = val$emailNotification;
        }
    }

    private static final class 2
    implements AquaAlertListener {
        private final /* synthetic */ ManagementController this$0;
        private final /* synthetic */ ManagementProgressSheet val$progressPanel;

        public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
            this.val$progressPanel.stopAnimation();
            this.this$0.closeManagementWindow();
        }

        public void aquaAlertSheetVisible(Object contextInfo) {
            this.val$progressPanel.startAnimation();
        }

        public boolean allowAquaAlertToBeDismissed(int buttonPressIdentifier, Object contextInfo) {
            return true;
        }

        public void aquaAlertWillBeShown(Object contextInfo) {
        }

        public void aquaAlertResized(Object contextInfo) {
        }

        /* synthetic */ 2(ManagementProgressSheet val$progressPanel, ManagementController this$0) {
            this.val$progressPanel = val$progressPanel;
            this.this$0 = this$0;
        }
    }

    private static final class 3
    implements Runnable {
        private final /* synthetic */ ManagementController this$0;
        private final /* synthetic */ AquaAlert val$progressSheet;

        public void run() {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {}
            this.val$progressSheet.dismissSheetOrDialog(1);
            this.this$0.closeManagementWindow();
        }

        /* synthetic */ 3(AquaAlert val$progressSheet, ManagementController this$0) {
            this.val$progressSheet = val$progressSheet;
            this.this$0 = this$0;
        }
    }

    private static final class 4
    implements AquaAlertListener {
        private final /* synthetic */ AquaAlert val$progressSheet;
        private final /* synthetic */ ManagementProgressSheet val$progressPanel;
        private final /* synthetic */ ManagementController this$0;

        public void aquaAlertWillBeShown(Object contextInfo) {
        }

        public void aquaAlertResized(Object contextInfo) {
        }

        public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
            this.this$0.closeManagementWindow();
        }

        public void aquaAlertSheetVisible(Object contextInfo) {
            this.val$progressPanel.startAnimation();
            Timer theTimer = new Timer(4000, new 5(this.val$progressPanel, this.val$progressSheet));
            theTimer.setRepeats(false);
            theTimer.start();
        }

        public boolean allowAquaAlertToBeDismissed(int buttonPressIdentifier, Object contextInfo) {
            return true;
        }

        /* synthetic */ 4(ManagementProgressSheet val$progressPanel, AquaAlert val$progressSheet, ManagementController this$0) {
            this.val$progressPanel = val$progressPanel;
            this.val$progressSheet = val$progressSheet;
            this.this$0 = this$0;
        }
    }

    private final class 6
    extends WindowAdapter {
        public void windowClosed(WindowEvent event) {
            ManagementController.this.managementWindow = null;
            ManagementController.this.managedSystem = null;
        }

        /* synthetic */ 6() {
        }
    }

    private static class ManagementProgressSheet
    extends JPanel {
        AquaProgressClock progressClock;

        public ManagementProgressSheet(String message) {
            this.setLayout(new GridBagLayout());
            EmptyBorder margin = new EmptyBorder(40, 40, 40, 40);
            this.setBorder(margin);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 10;
            constraints.fill = 1;
            constraints.weightx = 1.0;
            constraints.gridwidth = 3;
            constraints.insets = new Insets(0, 0, 10, 0);
            this.add((Component)new JLabel(message, 0), constraints);
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.gridwidth = 1;
            constraints.weightx = 0.0;
            ++constraints.gridy;
            constraints.weightx = 1.0;
            constraints.gridwidth = 3;
            this.add(Box.createHorizontalStrut(300), constraints);
            constraints.gridwidth = 1;
            constraints.weightx = 0.0;
            ++constraints.gridy;
            constraints.weightx = 1.0;
            this.add(Box.createHorizontalStrut(1), constraints);
            constraints.weightx = 0.0;
            ++constraints.gridx;
            this.progressClock = new AquaProgressClock();
            this.add((Component)this.progressClock, constraints);
            ++constraints.gridx;
            constraints.weightx = 1.0;
            this.add(Box.createHorizontalStrut(1), constraints);
            constraints.weightx = 0.0;
            ++constraints.gridx;
        }

        public boolean isFocusCycleRoot() {
            return true;
        }

        public void startAnimation() {
            this.progressClock.startAnimation();
        }

        public void stopAnimation() {
            this.progressClock.stopAnimation();
        }
    }

    private class RecognizeArrayAction
    implements Runnable {
        RaidSystem system;
        int controllerID;
        AquaAlert progressAlert;
        Map raidSetIdMap = new HashMap();

        public RecognizeArrayAction(RaidSystem system, int controllerID, AquaAlert progressAlert) {
            this.system = system;
            this.controllerID = controllerID;
            this.progressAlert = progressAlert;
        }

        public void run() {
            RaidController controller = this.system.getRaidController(this.controllerID);
            int hotPlug = 0;
            int idConflict = 0;
            long startTime = System.currentTimeMillis();
            logger.info("Checking for hot-plugged drives on RAID controller " + this.controllerID + "...");
            Iterator iter = controller.getDisks().iterator();
            while (iter.hasNext()) {
                Disk disk = (Disk)iter.next();
                if (!disk.isOrphanRaidMember() || disk.getMemberState() != 4) continue;
                ++hotPlug;
            }
            if (hotPlug > 0) {
                logger.info("Restarting RAID controller " + this.controllerID + " to bring hot-plugged drives online...");
                this.system.setUserMessageIndex(7);
                this.restartRaidController(false);
            } else if (logger.isInfoEnabled()) {
                logger.info("No hot-plugged drives found");
            }
            logger.info("Checking for RAID set ID conflicts on RAID controller " + this.controllerID + "...");
            Iterator iter2 = controller.getDisks().iterator();
            while (iter2.hasNext()) {
                Disk disk = (Disk)iter2.next();
                if (!disk.isOrphanRaidMember() || disk.getMemberState() != 2) continue;
                this.changeRaidSetID(disk);
                ++idConflict;
            }
            if (idConflict > 0) {
                logger.info("Restarting RAID controller " + this.controllerID + " to bring conflicting ID drives online...");
                this.system.setUserMessageIndex(7);
                this.restartRaidController(false);
                ArrayList slices = new ArrayList();
                Iterator iter3 = controller.getRaidSets().iterator();
                while (iter3.hasNext()) {
                    RaidSet raidSet = (RaidSet)iter3.next();
                    slices.addAll(raidSet.getLiveSlices());
                }
                if (slices.size() > 0) {
                    logger.info("Updating LUN map for RAID controller " + this.controllerID + "...");
                    this.updateLunMap(controller, slices);
                    logger.info("Syncing NVRAM and restarting RAID controller " + this.controllerID + "...");
                    this.system.setUserMessageIndex(7);
                    this.restartRaidController(true);
                } else {
                    logger.info("No slices exist for RAID controller " + this.controllerID + ". Skipping LUN map repair.");
                }
            } else if (logger.isInfoEnabled()) {
                logger.info("No conflicting ID drives found. Recognize Array complete.");
            }
            if (this.progressAlert != null) {
                if (System.currentTimeMillis() - startTime < 4000L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(4000L - (System.currentTimeMillis() - startTime));
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.progressAlert.dismissSheetOrDialog(1);
            }
        }

        private void changeRaidSetID(Disk disk) {
            int newID;
            RaidSetIdentifier identifier = new RaidSetIdentifier(disk.getOrphanRaidSetId(), disk.getRaidControllerSerialNumber());
            if (this.raidSetIdMap.containsKey(identifier)) {
                newID = (Integer)this.raidSetIdMap.get(identifier);
                logger.info("Retrieved new ID " + newID + " from cache");
            } else {
                newID = disk.getRaidController().nextRaidSetId();
                this.raidSetIdMap.put(identifier, new Integer(newID));
                logger.info("Generated new ID " + newID);
            }
            RequestMessage request = this.system.getMessageFactory().newChangeBrokenRaidIdRequest(disk.getNativeId(), newID);
            try {
                this.system.postMessage(request, this.controllerID);
                logger.info("Setting orphan disk " + disk.getId() + " on RAID controller " + this.controllerID + " to new RS ID " + newID);
            }
            catch (IOException iOException) {}
        }

        private void restartRaidController(boolean syncNVRAM) {
            int mask;
            if (this.controllerID == 1) {
                mask = 1;
                if (syncNVRAM) {
                    mask |= 0x10;
                }
            } else {
                mask = 2;
                if (syncNVRAM) {
                    mask |= 0x20;
                }
            }
            Restarter restarter = new Restarter(this.system, mask, true, null);
            restarter.run();
        }

        private void updateLunMap(RaidController controller, Collection slices) {
            if (slices.size() > 8) {
                logger.warn("Warning. Insufficient LUN's available to map all slices (slice count = " + slices.size() + ")");
            }
            int lun = 0;
            Iterator iter = slices.iterator();
            while (iter.hasNext()) {
                LunMapper.map((Slice)iter.next(), lun++);
                if (lun > 7) break;
            }
            while (lun <= 7) {
                LunMapper.unmap(controller, lun++);
            }
        }

        private boolean idConflicts(RaidController controller, int id) {
            Iterator iter = controller.getRaidSets().iterator();
            while (iter.hasNext()) {
                int existingRaidSetID = ((RaidSet)iter.next()).getNativeId();
                if (existingRaidSetID != id) continue;
                logger.info("Orphan disk RAID set ID " + id + " conflicts with existing RAID set " + existingRaidSetID);
                return true;
            }
            return false;
        }

        private class RaidSetIdentifier {
            public int raidSetID;
            public String controllerSerialNumber;

            public RaidSetIdentifier(int raidSetID, String controllerSerialNumber) {
                this.raidSetID = raidSetID;
                this.controllerSerialNumber = controllerSerialNumber;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof RaidSetIdentifier)) {
                    return false;
                }
                RaidSetIdentifier rsi = (RaidSetIdentifier)o;
                boolean result = rsi.raidSetID == this.raidSetID && rsi.controllerSerialNumber.equals(this.controllerSerialNumber);
                return result;
            }

            public int hashCode() {
                int result = 13;
                result = 37 * result + this.raidSetID;
                result = 37 * result + this.controllerSerialNumber.hashCode();
                return result;
            }
        }
    }

    private static class RaidSetCreator
    implements Runnable {
        private RaidController controller;
        private Integer[] members;
        private String raidLevel;
        private String type;
        private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementController$RaidSetCreator != null ? class$com$apple$xsr$ManagementController$RaidSetCreator : (class$com$apple$xsr$ManagementController$RaidSetCreator = ManagementController.class$("com.apple.xsr.ManagementController$RaidSetCreator")));

        public RaidSetCreator(RaidController controller, Integer[] members, String raidLevel, String type) {
            this.controller = controller;
            this.members = members;
            this.raidLevel = raidLevel;
            this.type = type;
        }

        public void run() {
            RaidSetCreator.createRaidSet(this.controller, this.members, this.raidLevel, this.type);
        }

        public static void createRaidSet(RaidController controller, Integer[] members, String raidLevel, String type) {
            RaidSystem system;
            block15: {
                system = controller.getRaidSystem();
                MessageFactory factory = system.getMessageFactory();
                int controllerId = controller.getId();
                boolean firstRaidSet = controller.getRaidSets().size() == 0;
                Integer id = new Integer(controller.nextRaidSetId());
                if (id == -1) {
                    String msg = "Could not allocate new RAID set ID (" + id + ")";
                    logger.error(msg);
                    throw new Error(msg);
                }
                if (logger.isInfoEnabled()) {
                    String nl = Resources.getLineSeparator();
                    String log = "Creating RAID set " + id + " on RAID controller " + controllerId + nl;
                    log = String.valueOf(log) + "\t\tRAID set ID: " + id + nl;
                    log = String.valueOf(log) + "\t\tRAID level:  " + raidLevel + nl;
                    log = String.valueOf(log) + "\t\tMembers:     ";
                    int i = 0;
                    while (i < members.length) {
                        log = String.valueOf(log) + members[i] + (i < members.length - 1 ? ", " : nl);
                        ++i;
                    }
                    log = String.valueOf(log) + "\t\tType:        " + type + nl;
                    logger.info(log);
                }
                system.setRaidSetCreationInProgress(controllerId, id);
                RequestMessage message = factory.newCreateArrayRequest(id, raidLevel, members, type);
                system.postMessageAsync(null, message, controllerId, null);
                if (firstRaidSet) {
                    logger.info("RAID set " + id + " is the first array. Restarting RAID controller " + controllerId);
                    message = factory.newRestartRaidControllerRequest();
                    system.postMessageAsync(null, message, controllerId, null);
                    logger.info("Waiting for RAID controller to restart...");
                    try {
                        system.waitForRaidControllerOnline(controllerId);
                        logger.info(String.valueOf(controller.getName()) + " is online");
                    }
                    catch (InterruptedException e) {
                        logger.info("Exception waiting for " + controller.getName() + " to come online: " + e);
                    }
                }
                try {
                    system.waitForRaidSetOnline(controllerId, id);
                    system.waitForUpdateFinished();
                    boolean mapped = false;
                    Iterator i = controller.getRaidSets().iterator();
                    while (i.hasNext()) {
                        RaidSet rs = (RaidSet)i.next();
                        if (id.intValue() != rs.getNativeId() || !rs.getSlice(0).isMapped()) continue;
                        logger.warn("RAID set " + id + " slice 0 already mapped to LUN " + rs.getSlice(0).getLunId() + ". Array creation complete.");
                        mapped = true;
                        break;
                    }
                    if (mapped) break block15;
                    Integer nextLun = LunMapper.nextAvailableLun(controller);
                    if (nextLun != null) {
                        int sliceId = system.translateSliceId(0, controllerId, 0);
                        int lunId = system.translateLunId(nextLun, controllerId, 0);
                        logger.info("Mapping Slice " + sliceId + " of new array " + id + " to LUN " + lunId);
                        message = factory.newLUNAssignmentRequest(id, new Integer(sliceId), new Integer(lunId));
                        system.postMessageAsync(null, message, controllerId, null);
                    } else {
                        logger.error("Unable to map Slice 0 of new array " + id + ". No LUN's available.");
                    }
                    message = factory.newFlushRaidControllerNvramRequest();
                    system.postMessageAsync(null, message, controllerId, null);
                    message = factory.newRestartRaidControllerRequest();
                    system.postMessageAsync(null, message, controllerId, null);
                    logger.info("Waiting for RAID controller to restart...");
                    try {
                        system.waitForRaidControllerOnline(controller.getId());
                        logger.info(String.valueOf(controller.getName()) + " is online");
                    }
                    catch (InterruptedException e) {
                        logger.info("Exception waiting for " + controller.getName() + " to come online: " + e);
                    }
                    logger.info("Waiting for poll cycle to complete...");
                    try {
                        system.waitForUpdateFinished();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted waiting for RAID set " + id + " to come online. RAID set was not mapped. " + e);
                }
            }
            system.clearRaidSetCreationInProgress();
        }
    }

    static class Restarter
    implements Runnable {
        private static final int RESTART_UPPER_RAID_BIT = 0;
        private static final int RESTART_LOWER_RAID_BIT = 1;
        private static final int RESTART_UPPER_COPROCESSOR_BIT = 2;
        private static final int RESTART_LOWER_COPROCESSOR_BIT = 3;
        private static final int SYNC_NVRAM_UPPER_RAID_BIT = 4;
        private static final int SYNC_NVRAM_LOWER_RAID_BIT = 5;
        private static final int SYNC_NVRAM_UPPER_COPROCESSOR_BIT = 6;
        private static final int SYNC_NVRAM_LOWER_COPROCESSOR_BIT = 7;
        public static final int RESTART_UPPER_RAID_MASK = 1;
        public static final int RESTART_LOWER_RAID_MASK = 2;
        public static final int RESTART_UPPER_COPROCESSOR_MASK = 4;
        public static final int RESTART_LOWER_COPROCESSOR_MASK = 8;
        public static final int SYNC_NVRAM_UPPER_RAID_MASK = 16;
        public static final int SYNC_NVRAM_LOWER_RAID_MASK = 32;
        public static final int SYNC_NVRAM_UPPER_COPROCESSOR_MASK = 64;
        public static final int SYNC_NVRAM_LOWER_COPROCESSOR_MASK = 128;
        public static final int RESTART_DELAY = 10000;
        RaidSystem system;
        int restartBitMask;
        boolean suspendPolling;
        ActiveEvent completionEvent;

        public Restarter(RaidSystem system, int mask) {
            this(system, mask, false, null);
        }

        public Restarter(RaidSystem system, int mask, boolean suspendPolling, ActiveEvent completionEvent) {
            this.system = system;
            this.restartBitMask = mask;
            this.suspendPolling = suspendPolling;
            this.completionEvent = completionEvent;
        }

        public void run() {
            if (this.suspendPolling) {
                try {
                    this.system.waitForUpdateFinished();
                }
                catch (InterruptedException interruptedException) {}
                this.system.setPollingEnabled(false);
            }
            this.restart();
            if ((this.restartBitMask & 4) != 0 || (this.restartBitMask & 8) != 0 || (this.restartBitMask & 1) != 0 || (this.restartBitMask & 2) != 0 && (this.suspendPolling || this.completionEvent != null)) {
                logger.info("Restarter: Pausing 60 secs before resuming polling or dispatching");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.suspendPolling) {
                this.system.setPollingEnabled(true);
                try {
                    this.system.waitForUpdateFinished();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.completionEvent != null) {
                this.completionEvent.dispatch();
            }
        }

        public void restart() {
            if (this.restartBitMask != 0) {
                HashMap<String, String> props;
                RequestMessage msg;
                MessageFactory factory = this.system.getMessageFactory();
                int index = 0;
                if ((this.restartBitMask & 0x10) != 0) {
                    index = 1;
                    msg = factory.newFlushRaidControllerNvramRequest();
                    this.system.postMessageAsync(null, msg, index, null);
                }
                if ((this.restartBitMask & 0x20) != 0) {
                    index = 2;
                    msg = factory.newFlushRaidControllerNvramRequest();
                    this.system.postMessageAsync(null, msg, index, null);
                }
                if ((this.restartBitMask & 1) != 0) {
                    index = 1;
                    msg = factory.newRestartRaidControllerRequest();
                    this.system.postMessageAsync(null, msg, index, null);
                }
                if ((this.restartBitMask & 2) != 0) {
                    index = 2;
                    msg = factory.newRestartRaidControllerRequest();
                    this.system.postMessageAsync(null, msg, index, null);
                }
                if ((this.restartBitMask & 0x80) != 0) {
                    props = new HashMap<String, String>();
                    props.put(String.valueOf(String.valueOf(AcpPropertyCode.ACTION_FLUSH_NVRAM)), "");
                    msg = factory.newSetPropertiesRequest(props);
                    index = 2;
                    this.system.postMessageAsync(null, msg, index, null);
                }
                if ((this.restartBitMask & 0x40) != 0) {
                    props = new HashMap();
                    props.put(String.valueOf(String.valueOf(AcpPropertyCode.ACTION_FLUSH_NVRAM)), "");
                    msg = factory.newSetPropertiesRequest(props);
                    index = 1;
                    this.system.postMessageAsync(null, msg, index, null);
                }
                if (this.system.getPrimarySystemController().getId() == 1) {
                    if ((this.restartBitMask & 8) != 0) {
                        msg = factory.newRestartSystemRequest();
                        index = 2;
                        this.system.postMessageAsync(null, msg, index, null);
                    }
                    if ((this.restartBitMask & 4) != 0 && (this.restartBitMask & 8) != 0) {
                        logger.info("Restarter: Pausing 10 secs before restarting top controller");
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if ((this.restartBitMask & 4) != 0) {
                        msg = factory.newRestartSystemRequest();
                        index = 1;
                        this.system.postMessageAsync(null, msg, index, null);
                    }
                } else {
                    if ((this.restartBitMask & 4) != 0) {
                        msg = factory.newRestartSystemRequest();
                        index = 1;
                        this.system.postMessageAsync(null, msg, index, null);
                    }
                    if ((this.restartBitMask & 4) != 0 && (this.restartBitMask & 8) != 0) {
                        logger.info("Restarter: Pausing 10 secs before restarting bottom controller");
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if ((this.restartBitMask & 8) != 0) {
                        msg = factory.newRestartSystemRequest();
                        index = 2;
                        this.system.postMessageAsync(null, msg, index, null);
                    }
                }
            }
        }
    }

    private static class Slicer
    implements Runnable {
        private RaidSystem system;
        private RaidSet raidSet;
        private int newSliceCount;
        private InvocationEvent completionEvent;
        private static final int RESTART_WAIT_SECS = 30;
        private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementController$Slicer != null ? class$com$apple$xsr$ManagementController$Slicer : (class$com$apple$xsr$ManagementController$Slicer = ManagementController.class$("com.apple.xsr.ManagementController$Slicer")));

        public Slicer(RaidSystem system, RaidSet raidSet, int newSliceCount, InvocationEvent completionEvent) {
            this.system = system;
            this.raidSet = raidSet;
            this.newSliceCount = newSliceCount;
            this.completionEvent = completionEvent;
        }

        public void run() {
            this.slice();
            if (this.completionEvent != null) {
                this.completionEvent.dispatch();
            }
        }

        public void slice() {
            block19: {
                RequestMessage request;
                int newSliceSize;
                TreeSet slices;
                MessageFactory factory = this.system.getMessageFactory();
                RaidController controller = this.raidSet.getController();
                int rsNativeId = this.raidSet.getNativeId();
                int currentSliceCount = this.raidSet.getLiveSliceCount();
                if (currentSliceCount <= 1) {
                    slices = this.raidSet.getSlices();
                    long bytesPerSlice = this.raidSet.getCapacityBytes() / (long)this.newSliceCount;
                    newSliceSize = (int)(bytesPerSlice / 1024L / 1024L);
                } else {
                    slices = new TreeSet(Collections.reverseOrder());
                    slices.addAll(this.raidSet.getSlices());
                    newSliceSize = (int)(this.raidSet.getCapacityBytes() / 1024L / 1024L);
                }
                logger.info("Slicing RAID set " + this.raidSet.getNativeId() + " on " + controller.getName());
                logger.info("     New slice count " + this.newSliceCount);
                logger.info("     New slice size " + newSliceSize);
                ArrayList<RequestMessage> shrink = new ArrayList<RequestMessage>();
                ArrayList<RequestMessage> expand = new ArrayList<RequestMessage>();
                ArrayList<Comparable> modified = new ArrayList<Comparable>();
                Iterator iter = slices.iterator();
                while (iter.hasNext()) {
                    Slice slice = (Slice)iter.next();
                    int size = slice.getSize();
                    int sliceId = this.system.translateSliceId(slice.getId(), controller.getId(), 0);
                    if (this.newSliceCount > 1) {
                        if (size > 0) {
                            request = factory.newSetSliceSizeRequest(new Integer(rsNativeId), new Integer(sliceId), new Integer(newSliceSize));
                            shrink.add(request);
                            continue;
                        }
                        if (shrink.size() + expand.size() >= this.newSliceCount) continue;
                        request = factory.newSetSliceSizeRequest(new Integer(rsNativeId), new Integer(sliceId), new Integer(newSliceSize));
                        expand.add(request);
                        modified.add(slice);
                        continue;
                    }
                    if (slice.getId() == 0) {
                        request = factory.newSetSliceSizeRequest(new Integer(rsNativeId), new Integer(sliceId), new Integer(newSliceSize));
                        expand.add(request);
                        continue;
                    }
                    if (size <= 0) continue;
                    request = factory.newSetSliceSizeRequest(new Integer(rsNativeId), new Integer(sliceId), new Integer(0));
                    shrink.add(request);
                    if (slice.getLunId() == -1) continue;
                    modified.add(new Integer(slice.getLunId()));
                }
                int restartMask = 0;
                if (controller.getId() == 1) {
                    restartMask |= 0x10;
                    restartMask |= 1;
                } else {
                    restartMask |= 0x20;
                    restartMask |= 2;
                }
                Restarter restarter = new Restarter(this.system, restartMask);
                if (shrink.size() > 0) {
                    ListIterator iter2 = ((AbstractList)shrink).listIterator();
                    while (iter2.hasNext()) {
                        logger.info("Sending request to shrink slice...");
                        request = (RequestMessage)iter2.next();
                        this.system.postMessageAsync(null, request, controller.getId(), null);
                    }
                    if (expand.size() > 0) {
                        logger.info("Restarting RAID controller....");
                        restarter.restart();
                        logger.info("Waiting for RAID controller to restart...");
                        try {
                            this.system.waitForRaidControllerOnline(controller.getId());
                            logger.info(String.valueOf(controller.getName()) + " is online");
                        }
                        catch (InterruptedException e) {
                            logger.info("Exception waiting for " + controller.getName() + " to come online: " + e);
                        }
                    }
                }
                if (expand.size() > 0) {
                    ListIterator iter3 = ((AbstractList)expand).listIterator();
                    while (iter3.hasNext()) {
                        logger.info("Sending request to expand slice...");
                        request = (RequestMessage)iter3.next();
                        this.system.postMessageAsync(null, request, controller.getId(), null);
                    }
                }
                if (shrink.size() <= 0 && expand.size() <= 0) break block19;
                LunMapper mapper = new LunMapper(controller);
                if (this.newSliceCount > 1) {
                    mapper.mapLunsToSlices(modified);
                } else {
                    mapper.unmapLuns(modified);
                }
                logger.info("Restarting RAID controller....");
                restarter.restart();
                logger.info("Waiting for RAID controller to restart...");
                try {
                    this.system.waitForRaidControllerOnline(controller.getId());
                    logger.info(String.valueOf(controller.getName()) + " is online");
                }
                catch (InterruptedException e) {
                    logger.info("Exception waiting for " + controller.getName() + " to come online: " + e);
                }
            }
        }
    }

    public static class LunMapper {
        private RaidController controller;
        private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementController$LunMapper != null ? class$com$apple$xsr$ManagementController$LunMapper : (class$com$apple$xsr$ManagementController$LunMapper = ManagementController.class$("com.apple.xsr.ManagementController$LunMapper")));

        public LunMapper(RaidController controller) {
            if (controller == null) {
                throw new NullPointerException("controller cannot be null");
            }
            this.controller = controller;
        }

        public static int map(Slice slice, int lunId) {
            int err;
            if (slice == null) {
                throw new NullPointerException("slice cannot be null");
            }
            RaidSet raidSet = slice.getRaidSet();
            if (raidSet == null) {
                throw new IllegalArgumentException("invalid slice (no parent RAID set): " + slice);
            }
            RaidController controller = raidSet.getController();
            RaidSystem system = controller.getRaidSystem();
            MessageFactory factory = system.getMessageFactory();
            int sliceId = system.translateSliceId(slice.getNativeId(), controller.getId(), 0);
            lunId = system.translateLunId(lunId, controller.getId(), 0);
            RequestMessage request = factory.newLUNAssignmentRequest(new Integer(raidSet.getNativeId()), new Integer(sliceId), new Integer(lunId));
            try {
                Response response = system.postMessage(request, controller.getId());
                err = response.getResultCode();
                if (err == 0) {
                    logger.info("Mapped RAID set " + raidSet.getNativeId() + ", slice " + slice.getNativeId() + " to LUN " + lunId);
                } else {
                    logger.error("Result code " + err + " attempting to map RAID set " + raidSet.getNativeId() + ", slice " + slice.getNativeId() + " to LUN " + lunId);
                }
            }
            catch (IOException e) {
                err = -102;
                logger.error("Error sending LUN assignment request. " + e);
            }
            return err;
        }

        public static int unmap(RaidController raidController, int lunId) {
            int err;
            block5: {
                Integer unmapped = new Integer(15);
                RaidSystem system = raidController.getRaidSystem();
                MessageFactory factory = system.getMessageFactory();
                if (lunId >= 0 && lunId <= 7) {
                    lunId = system.translateLunId(lunId, raidController.getId(), 0);
                    RequestMessage request = factory.newLUNAssignmentRequest(unmapped, unmapped, new Integer(lunId));
                    try {
                        Response response = system.postMessage(request, raidController.getId());
                        err = response.getResultCode();
                        if (err == 0) {
                            logger.info("Unmapped LUN " + lunId);
                            break block5;
                        }
                        logger.error("Result code " + err + " attempting to unmap LUN " + lunId);
                    }
                    catch (IOException e) {
                        err = -102;
                        logger.error("Error sending LUN assignment request. " + e);
                    }
                } else {
                    err = -100;
                    logger.warn("Attempt to unmap invalid LUN ID (" + lunId + ")");
                }
            }
            return err;
        }

        public static Integer nextAvailableLun(RaidController raidController) {
            Integer lun = null;
            Collection unmappedLuns = raidController.getUnmappedLuns();
            if (!unmappedLuns.isEmpty()) {
                lun = (Integer)unmappedLuns.iterator().next();
            }
            return lun;
        }

        public void mapLunsToSlices(Collection slices) {
            LunMapper.mapLunsToSlices(this.controller, slices);
        }

        public static void mapLunsToSlices(RaidController raidController, Collection slices) {
            if (slices.size() > 0) {
                Collection unmappedLuns = raidController.getUnmappedLuns();
                if (unmappedLuns.size() < slices.size()) {
                    logger.error("Insufficient LUNs available (" + unmappedLuns.size() + ") to map all slices (" + slices.size() + ")");
                }
                Iterator lunIter = unmappedLuns.iterator();
                Iterator sliceIter = slices.iterator();
                while (sliceIter.hasNext()) {
                    Integer lun;
                    Slice slice = (Slice)sliceIter.next();
                    Integer n = lun = lunIter.hasNext() ? (Integer)lunIter.next() : null;
                    if (lun != null) {
                        LunMapper.map(slice, lun);
                        continue;
                    }
                    logger.error("No unmapped LUN's available for slice " + slice);
                    break;
                }
            }
        }

        public void unmapLuns(Collection luns) {
            LunMapper.unmapLuns(this.controller, luns);
        }

        public static void unmapLuns(RaidController raidController, Collection luns) {
            if (luns != null && luns.size() > 0) {
                Iterator iter = luns.iterator();
                while (iter.hasNext()) {
                    int lun = (Integer)iter.next();
                    LunMapper.unmap(raidController, lun);
                }
            }
        }

        public void unmapLunsFromSlices(Collection slices) {
            LunMapper.unmapLunsFromSlices(this.controller, slices);
        }

        public static void unmapLunsFromSlices(RaidController raidController, Collection slices) {
            if (slices.size() > 0) {
                ArrayList<Integer> luns = new ArrayList<Integer>(slices.size());
                Iterator iter = slices.iterator();
                while (iter.hasNext()) {
                    Slice slice = (Slice)iter.next();
                    if (slice.getLunId() == -1) continue;
                    luns.add(new Integer(slice.getLunId()));
                }
                LunMapper.unmapLuns(raidController, luns);
            }
        }

        public static void mapUnmappedSlices(RaidSystem system) {
            Collection slices;
            Iterator iter;
            ArrayList unmapped = new ArrayList();
            RaidController raidController = null;
            int restartMask = 0;
            raidController = system.getRaidController(1);
            if (raidController != null) {
                iter = raidController.getRaidSets().iterator();
                while (iter.hasNext()) {
                    slices = ((RaidSet)iter.next()).getUnmappedSlices();
                    unmapped.addAll(slices);
                }
                if (unmapped.size() > 0) {
                    logger.info("mapUnmappedSlices: Mapping top RAID controller slices " + unmapped);
                    LunMapper.mapLunsToSlices(raidController, unmapped);
                    restartMask |= 0x10;
                    restartMask |= 1;
                } else {
                    logger.info("mapUnmappedSlices: No unmapped slices on top RAID controller");
                }
            }
            unmapped.clear();
            raidController = system.getRaidController(2);
            if (raidController != null) {
                iter = raidController.getRaidSets().iterator();
                while (iter.hasNext()) {
                    slices = ((RaidSet)iter.next()).getUnmappedSlices();
                    unmapped.addAll(slices);
                }
                if (unmapped.size() > 0) {
                    logger.info("mapUnmappedSlices: Mapping bottom RAID controller slices " + unmapped);
                    LunMapper.mapLunsToSlices(raidController, unmapped);
                    restartMask |= 0x20;
                    restartMask |= 2;
                } else {
                    logger.info("mapUnmappedSlices: No unmapped slices on bottom RAID controller");
                }
            }
            Restarter restarter = new Restarter(system, restartMask);
            restarter.restart();
        }
    }

    public static class LunMapRepairer
    implements Runnable {
        private RaidSystem system;
        private int[] controllerIDs;
        private ActiveEvent completionEvent;
        private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementController$LunMapRepairer != null ? class$com$apple$xsr$ManagementController$LunMapRepairer : (class$com$apple$xsr$ManagementController$LunMapRepairer = ManagementController.class$("com.apple.xsr.ManagementController$LunMapRepairer")));

        public LunMapRepairer(RaidSystem system) {
            this(system, new int[]{1, 2}, null);
        }

        public LunMapRepairer(RaidSystem system, int[] controllerIDs) {
            this(system, controllerIDs, null);
        }

        public LunMapRepairer(RaidSystem system, int[] controllerIDs, ActiveEvent completionEvent) {
            if (system == null) {
                throw new NullPointerException("RaidSystem cannot be null");
            }
            if (controllerIDs == null) {
                throw new NullPointerException("controllerIDs cannot be null");
            }
            this.system = system;
            this.controllerIDs = controllerIDs;
            this.completionEvent = completionEvent;
        }

        public void run() {
            int restartMask = 0;
            boolean[] restart = new boolean[this.controllerIDs.length];
            int i = 0;
            while (i < this.controllerIDs.length) {
                restart[i] = LunMapRepairer.repair(this.system, this.controllerIDs[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < restart.length) {
                if (restart[i2]) {
                    if (this.controllerIDs[i2] == 1) {
                        restartMask |= 0x10;
                        restartMask |= 1;
                    } else if (this.controllerIDs[i2] == 2) {
                        restartMask |= 0x20;
                        restartMask |= 2;
                    }
                }
                ++i2;
            }
            new Restarter(this.system, restartMask, true, null).restart();
            if (this.completionEvent != null) {
                this.completionEvent.dispatch();
            }
        }

        public static boolean repair(RaidSystem system, int controllerID) {
            RaidController controller = system.getRaidController(controllerID);
            ArrayList slices = new ArrayList();
            int lun = 0;
            boolean needsRestart = false;
            if (system == null) {
                throw new NullPointerException("RaidSystem cannot be null");
            }
            if (controllerID != 1 && controllerID != 2) {
                throw new IllegalArgumentException("invalid controller ID (" + controllerID + ")");
            }
            Iterator iter = controller.getRaidSets().iterator();
            while (iter.hasNext()) {
                RaidSet raidSet = (RaidSet)iter.next();
                slices.addAll(raidSet.getLiveSlices());
            }
            if (slices.size() > 0) {
                needsRestart = true;
            }
            if (slices.size() > 8) {
                logger.warn("Insufficient LUN's available to map all slices (slice count = " + slices.size() + ")");
            }
            Iterator iter2 = ((AbstractList)slices).iterator();
            while (iter2.hasNext()) {
                int err = LunMapper.map((Slice)iter2.next(), lun++);
                if (lun > 7) break;
            }
            while (lun <= 7) {
                int n = LunMapper.unmap(controller, lun++);
            }
            return needsRestart;
        }
    }
}

