/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.RestrictedTextField;
import com.apple.xsr.ManagementFibreModel;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.SetupPane;
import com.apple.xsr.SizeLinkedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class ManagementFibrePane
extends JPanel {
    SizeLinkedPanel[] lunGroup;
    JLabel[] wwpnValue;
    JLabel[] wwnnValue;
    RadioButtonGroup[] speedGroup;
    JRadioButton[][] speedRadio;
    RadioButtonGroup[] topologyGroup;
    JRadioButton[][] topologyRadio;
    JCheckBox[] hardLoopCheckBox;
    JLabel[] hardLoopIDLabel;
    RestrictedTextField[] hardLoopText;
    JLabel[] validateLabel;
    SetupPane parent;
    boolean populated = false;
    static final int CHANNEL_COUNT = 2;
    static final int CONTROL_HSPACE = 5;
    static final int CONTROL_VSPACE = 16;
    static final int GROUP_SPACING = 16;

    public ManagementFibrePane(SetupPane parent) {
        GUIFactory.configureComponentForPlatform(this);
        this.parent = parent;
        this.lunGroup = new SizeLinkedPanel[2];
        this.wwpnValue = new JLabel[2];
        this.wwnnValue = new JLabel[2];
        this.speedGroup = new RadioButtonGroup[2];
        this.speedRadio = new JRadioButton[2][3];
        this.topologyGroup = new RadioButtonGroup[2];
        this.topologyRadio = new JRadioButton[2][3];
        this.hardLoopCheckBox = new JCheckBox[2];
        this.hardLoopIDLabel = new JLabel[2];
        this.hardLoopText = new RestrictedTextField[2];
        this.validateLabel = new JLabel[2];
        1 theFocusAdapter = new 1();
        2 theCaretListener = new 2();
        3 theActionListener = new 3();
        this.setBorder(ManagementPane.DEFAULT_BORDER);
        this.setLayout(new GridBagLayout());
        GridBagConstraints lunTabConstraints = new GridBagConstraints();
        lunTabConstraints.gridx = 0;
        lunTabConstraints.gridy = 0;
        lunTabConstraints.gridheight = 1;
        lunTabConstraints.gridwidth = 1;
        lunTabConstraints.anchor = 17;
        lunTabConstraints.fill = 0;
        int group = 0;
        while (group < 2) {
            int currentRow = 0;
            this.lunGroup[group] = new SizeLinkedPanel();
            this.lunGroup[group].setFont(GUIFactory.FONT_SMALL);
            String groupTitle = Resources.getString(group == 0 ? "management.fibre.drives1thru7" : "management.fibre.drives8thru14");
            TitledBorder border = BorderFactory.createTitledBorder(" " + groupTitle + " ");
            border.setTitleFont(GUIFactory.FONT_SMALL);
            this.lunGroup[group].setBorder(new CompoundBorder(border, ManagementPane.DEFAULT_GROUP_BOX_BORDER));
            this.lunGroup[group].setLayout(new GridBagLayout());
            GridBagConstraints lunGroupConstraints = new GridBagConstraints();
            lunGroupConstraints.anchor = 17;
            lunGroupConstraints.fill = 2;
            JLabel wwnnLabel = new JLabel(Resources.getString("management.fibre.wwnn"));
            wwnnLabel.setFont(GUIFactory.FONT_SMALL);
            wwnnLabel.setHorizontalAlignment(4);
            lunGroupConstraints.gridx = 0;
            lunGroupConstraints.gridy = currentRow;
            lunGroupConstraints.insets = new Insets(0, 0, 16, 5);
            this.lunGroup[group].add((Component)wwnnLabel, lunGroupConstraints);
            lunGroupConstraints.insets = new Insets(0, 0, 0, 0);
            this.wwnnValue[group] = new JLabel();
            this.wwnnValue[group].setFont(GUIFactory.FONT_SMALL);
            this.wwnnValue[group].setHorizontalAlignment(4);
            lunGroupConstraints.gridx = 1;
            lunGroupConstraints.gridy = currentRow++;
            lunGroupConstraints.insets = new Insets(0, 0, 16, 0);
            this.lunGroup[group].add((Component)this.wwnnValue[group], lunGroupConstraints);
            lunGroupConstraints.insets = new Insets(0, 0, 0, 0);
            JLabel wwpnLabel = new JLabel(Resources.getString("management.fibre.wwpn"));
            wwpnLabel.setFont(GUIFactory.FONT_SMALL);
            wwpnLabel.setHorizontalAlignment(4);
            lunGroupConstraints.gridx = 0;
            lunGroupConstraints.gridy = currentRow;
            lunGroupConstraints.insets = new Insets(0, 0, 16, 5);
            this.lunGroup[group].add((Component)wwpnLabel, lunGroupConstraints);
            lunGroupConstraints.insets = new Insets(0, 0, 0, 0);
            this.wwpnValue[group] = new JLabel();
            this.wwpnValue[group].setFont(GUIFactory.FONT_SMALL);
            this.wwpnValue[group].setHorizontalAlignment(4);
            lunGroupConstraints.gridx = 1;
            lunGroupConstraints.gridy = currentRow++;
            lunGroupConstraints.insets = new Insets(0, 0, 16, 0);
            this.lunGroup[group].add((Component)this.wwpnValue[group], lunGroupConstraints);
            lunGroupConstraints.insets = new Insets(0, 0, 0, 0);
            JLabel speedLabel = new JLabel(Resources.getString("management.fibre.speed"));
            speedLabel.setFont(GUIFactory.FONT_SMALL);
            speedLabel.setHorizontalAlignment(4);
            lunGroupConstraints.gridx = 0;
            lunGroupConstraints.gridy = currentRow;
            lunGroupConstraints.insets = new Insets(0, 0, 0, 5);
            this.lunGroup[group].add((Component)speedLabel, lunGroupConstraints);
            lunGroupConstraints.insets = new Insets(0, 0, 0, 0);
            this.speedGroup[group] = new RadioButtonGroup();
            int row = 0;
            while (row < 3) {
                String radioTitle = row == 1 ? Resources.getString("management.fibre.speed.1Gbps") : (row == 2 ? Resources.getString("management.fibre.speed.2Gbps") : Resources.getString("management.fibre.speed.auto"));
                this.speedRadio[group][row] = GUIFactory.newRadioButton(radioTitle, true);
                this.speedRadio[group][row].addActionListener(theActionListener);
                this.speedRadio[group][row].setFont(GUIFactory.FONT_SMALL);
                this.speedGroup[group].add(this.speedRadio[group][row]);
                lunGroupConstraints.gridx = 1;
                lunGroupConstraints.gridy = currentRow++;
                lunGroupConstraints.insets = new Insets(0, 0, row == 2 ? 16 : 0, 0);
                this.lunGroup[group].add((Component)this.speedRadio[group][row], lunGroupConstraints);
                lunGroupConstraints.insets = new Insets(0, 0, 0, 0);
                ++row;
            }
            JLabel topologyLabel = new JLabel(Resources.getString("management.fibre.topology"));
            topologyLabel.setFont(GUIFactory.FONT_SMALL);
            topologyLabel.setHorizontalAlignment(4);
            lunGroupConstraints.gridx = 0;
            lunGroupConstraints.gridy = currentRow;
            lunGroupConstraints.insets = new Insets(0, 0, 0, 5);
            this.lunGroup[group].add((Component)topologyLabel, lunGroupConstraints);
            lunGroupConstraints.insets = new Insets(0, 0, 0, 0);
            this.topologyGroup[group] = new RadioButtonGroup();
            int row2 = 0;
            while (row2 < 3) {
                String radioTitle = row2 == 1 ? Resources.getString("management.fibre.topology.pointtopoint") : (row2 == 2 ? Resources.getString("management.fibre.topology.arbitratedloop") : Resources.getString("management.fibre.topology.auto"));
                this.topologyRadio[group][row2] = GUIFactory.newRadioButton(radioTitle, true);
                this.topologyRadio[group][row2].addActionListener(theActionListener);
                this.topologyRadio[group][row2].setFont(GUIFactory.FONT_SMALL);
                this.topologyGroup[group].add(this.topologyRadio[group][row2]);
                lunGroupConstraints.gridx = 1;
                lunGroupConstraints.gridy = currentRow++;
                lunGroupConstraints.insets = new Insets(0, 0, row2 == 2 ? 16 : 0, 0);
                this.lunGroup[group].add((Component)this.topologyRadio[group][row2], lunGroupConstraints);
                lunGroupConstraints.insets = new Insets(0, 0, 0, 0);
                ++row2;
            }
            this.hardLoopCheckBox[group] = GUIFactory.newCheckBox(Resources.getString("management.fibre.hardloop.enable"));
            this.hardLoopCheckBox[group].addActionListener(theActionListener);
            this.hardLoopCheckBox[group].setFont(GUIFactory.FONT_SMALL);
            lunGroupConstraints.gridx = 0;
            lunGroupConstraints.gridy = currentRow++;
            lunGroupConstraints.gridwidth = 2;
            this.lunGroup[group].add((Component)this.hardLoopCheckBox[group], lunGroupConstraints);
            lunGroupConstraints.gridwidth = 1;
            this.hardLoopIDLabel[group] = new JLabel(Resources.getString("management.fibre.hardloop.id"));
            this.hardLoopIDLabel[group].setFont(GUIFactory.FONT_SMALL);
            this.hardLoopIDLabel[group].setHorizontalAlignment(4);
            lunGroupConstraints.gridx = 0;
            lunGroupConstraints.gridy = currentRow;
            lunGroupConstraints.insets = new Insets(0, 0, 0, 5);
            this.lunGroup[group].add((Component)this.hardLoopIDLabel[group], lunGroupConstraints);
            lunGroupConstraints.insets = new Insets(0, 0, 0, 0);
            this.hardLoopText[group] = GUIFactory.newRestrictedTextField("");
            this.hardLoopText[group].setFont(GUIFactory.FONT_SMALL);
            this.hardLoopText[group].addFocusListener(theFocusAdapter);
            this.hardLoopText[group].addCaretListener(theCaretListener);
            this.hardLoopText[group].addActionListener(theActionListener);
            this.hardLoopText[group].setRestrictedCharacterSet(Resources.getString("aquaTextField.validNumericCharacters"));
            lunGroupConstraints.gridx = 1;
            lunGroupConstraints.gridy = currentRow;
            this.lunGroup[group].add((Component)this.hardLoopText[group], lunGroupConstraints);
            this.hardLoopCheckBox[group].addActionListener(new HardLoopIdListener(group));
            ImageIcon validateIcon = new ImageIcon(Resources.getImage("icon.validate"));
            this.validateLabel[group] = new JLabel(validateIcon);
            this.validateLabel[group].setVisible(false);
            lunGroupConstraints.gridx = 2;
            lunGroupConstraints.gridy = currentRow++;
            lunGroupConstraints.insets = new Insets(0, 2, 0, 0);
            this.lunGroup[group].add((Component)this.validateLabel[group], lunGroupConstraints);
            lunGroupConstraints.insets = new Insets(0, 0, 0, 0);
            lunGroupConstraints.gridx = 2;
            lunGroupConstraints.gridy = currentRow++;
            this.lunGroup[group].add(Box.createHorizontalStrut(16), lunGroupConstraints);
            lunGroupConstraints.gridx = 0;
            lunGroupConstraints.gridy = currentRow++;
            lunGroupConstraints.weightx = 1.0;
            lunGroupConstraints.weighty = 1.0;
            lunGroupConstraints.gridwidth = 3;
            this.lunGroup[group].add(Box.createGlue(), lunGroupConstraints);
            lunGroupConstraints.weightx = 0.0;
            lunGroupConstraints.weighty = 0.0;
            lunGroupConstraints.gridwidth = 0;
            lunTabConstraints.gridx = group;
            lunTabConstraints.gridy = 1;
            lunTabConstraints.insets = new Insets(0, group > 0 ? 16 : 0, 0, 0);
            this.add((Component)this.lunGroup[group], lunTabConstraints);
            lunTabConstraints.insets = new Insets(0, 0, 0, 0);
            ++group;
        }
        lunTabConstraints.weightx = 1.0;
        lunTabConstraints.weighty = 1.0;
        lunTabConstraints.gridx = 2;
        lunTabConstraints.gridy = 2;
        this.add(Box.createVerticalStrut(0), lunTabConstraints);
        this.lunGroup[0].linkPanel(this.lunGroup[1]);
    }

    public void populate(ManagementFibreModel model) {
        int group = 0;
        while (group < 2) {
            ManagementFibreModel.ManagementFibreControllerModel fcModel = group == 0 ? model.getUpperControllerModel() : model.getLowerControllerModel();
            String wwpName = fcModel.getWWPName();
            String wwnName = fcModel.getWWNName();
            int speed = fcModel.getSpeed();
            int topology = fcModel.getTopology();
            boolean hardLoopEnabled = fcModel.getHardLoopEnabled();
            String hardLoopID = fcModel.getHardLoopID();
            this.wwpnValue[group].setText(wwpName);
            this.wwnnValue[group].setText(wwnName);
            this.speedRadio[group][speed].setSelected(true);
            this.topologyRadio[group][topology].setSelected(true);
            this.setHardLoopIdEnabled(hardLoopEnabled, group);
            this.hardLoopText[group].setText(hardLoopID);
            ++group;
        }
        this.validate(null);
        this.populated = true;
    }

    public boolean validate(ManagementFibreModel model) {
        boolean valid = true;
        int group = 0;
        while (group < 2) {
            boolean hardLoopEnabled = this.hardLoopCheckBox[group].isSelected();
            String hardLoopID = this.hardLoopText[group].getText();
            int length = hardLoopID.length();
            if (hardLoopEnabled && length == 0 || length > 3) {
                this.validateLabel[group].setVisible(true);
                valid = false;
            } else {
                this.validateLabel[group].setVisible(false);
            }
            ++group;
        }
        int tabIndex = this.parent.tabbedPane.indexOfComponent(this);
        if (!valid && this.parent.tabbedPane.getSelectedIndex() != tabIndex) {
            this.parent.tabbedPane.setIconAt(tabIndex, new ImageIcon(Resources.getImage("icon.validate")));
        } else {
            this.parent.tabbedPane.setIconAt(tabIndex, null);
        }
        if (valid && model != null) {
            int group2 = 0;
            while (group2 < 2) {
                ManagementFibreModel.ManagementFibreControllerModel fcModel = group2 == 0 ? model.getUpperControllerModel() : model.getLowerControllerModel();
                String wwpName = this.wwpnValue[group2].getText();
                String wwnName = this.wwnnValue[group2].getText();
                int speed = this.speedGroup[group2].getSelectedIndex();
                int topology = this.topologyGroup[group2].getSelectedIndex();
                boolean hardLoopEnabled = this.hardLoopCheckBox[group2].isSelected();
                String hardLoopID = this.hardLoopText[group2].getText();
                int length = hardLoopID.length();
                fcModel.setWWPName(wwpName);
                fcModel.setWWNName(wwnName);
                fcModel.setSpeed(speed);
                fcModel.setTopology(topology);
                fcModel.setHardLoopEnabled(hardLoopEnabled);
                fcModel.setHardLoopID(length > 0 ? hardLoopID : "0");
                ++group2;
            }
        }
        return valid;
    }

    public SizeLinkedPanel getGroupBox(int group) {
        return this.lunGroup[group];
    }

    private void setHardLoopIdEnabled(boolean enabled, int group) {
        this.hardLoopCheckBox[group].setSelected(enabled);
        this.hardLoopIDLabel[group].setEnabled(enabled);
        this.hardLoopText[group].setEnabled(enabled);
    }

    private final class 1
    extends FocusAdapter {
        public void focusLost(FocusEvent event) {
            if (ManagementFibrePane.this.populated) {
                ManagementFibrePane.this.validate(null);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements CaretListener {
        public void caretUpdate(CaretEvent e) {
            if (ManagementFibrePane.this.populated) {
                ManagementFibrePane.this.parent.setModified();
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (ManagementFibrePane.this.populated) {
                ManagementFibrePane.this.validate(null);
                ManagementFibrePane.this.parent.setModified();
            }
        }

        /* synthetic */ 3() {
        }
    }

    private class HardLoopIdListener
    implements ActionListener {
        int group;

        public HardLoopIdListener(int group) {
            this.group = group;
        }

        public void actionPerformed(ActionEvent e) {
            boolean enabled = ((JCheckBox)e.getSource()).isSelected();
            ManagementFibrePane.this.setHardLoopIdEnabled(enabled, this.group);
        }
    }
}

