/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.RestrictedTextField;
import com.apple.xsr.LineSeparator;
import com.apple.xsr.ManagementNetworkModel;
import com.apple.xsr.ManagementNetworkPane;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.Resources;
import com.apple.xsr.SetupPane;
import com.apple.xsr.SizeLinkedPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ManagementNetworkPane
extends JPanel {
    public static final boolean ALLOW_DNS_OVERRIDES = false;
    static final int BIG_GRID_BAG_INSET_VALUE = 16;
    static final int GRID_BAG_INSET_VALUE = 8;
    static final int GRID_BAG_COLUMN_SEPERATOR_INSET_VALUE = 28;
    static final int TEXT_FIELD_WIDTH = 12;
    static final float LABEL_SIZE = 11.0f;
    static final float SMALL_LABEL_SIZE = 9.0f;
    private static final int INVALID_NETWORK_CONFIG_1 = 2560;
    private static final int INVALID_NETWORK_CONFIG_2 = 2814;
    private ManagementNetworkPaneInner mTopController;
    private ManagementNetworkPaneInner mBottomController;
    private SetupPane parent;
    private boolean populated = false;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementNetworkPane != null ? class$com$apple$xsr$ManagementNetworkPane : (class$com$apple$xsr$ManagementNetworkPane = ManagementNetworkPane.class$("com.apple.xsr.ManagementNetworkPane")));
    static /* synthetic */ Class class$com$apple$xsr$ManagementNetworkPane;

    public ManagementNetworkPane(SetupPane parent) {
        this.parent = parent;
        GUIFactory.configureComponentForPlatform(this);
        this.setLayout(new GridLayout(1, 2, 16, 0));
        this.setBorder(ManagementPane.DEFAULT_BORDER);
        this.mTopController = new ManagementNetworkPaneInner(Resources.getString("management.network.topController"));
        this.add(this.mTopController);
        this.mBottomController = new ManagementNetworkPaneInner(Resources.getString("management.network.bottomController"));
        this.add(this.mBottomController);
    }

    public SizeLinkedPanel getGroupBox(int controllerID) {
        ManagementNetworkPaneInner thePanel = null;
        thePanel = controllerID == 1 ? this.mTopController : this.mBottomController;
        return thePanel;
    }

    public boolean validate(ManagementNetworkModel networkModel) {
        boolean validationSucceeded = true;
        if (!this.mTopController.checkValidity()) {
            validationSucceeded = false;
        }
        if (!this.mBottomController.checkValidity()) {
            validationSucceeded = false;
        }
        if (validationSucceeded && networkModel != null) {
            this.mTopController.fillInModel(networkModel.getUpperControllerModel());
            this.mBottomController.fillInModel(networkModel.getLowerControllerModel());
        }
        int tabIndex = this.parent.tabbedPane.indexOfComponent(this);
        if (!validationSucceeded && this.parent.tabbedPane.getSelectedIndex() != tabIndex) {
            this.parent.tabbedPane.setIconAt(tabIndex, new ImageIcon(Resources.getImage("icon.validate")));
        } else {
            this.parent.tabbedPane.setIconAt(tabIndex, null);
        }
        return validationSucceeded;
    }

    public void populate(ManagementNetworkModel networkModel) {
        this.mTopController.populate(networkModel.getUpperControllerModel());
        this.mBottomController.populate(networkModel.getLowerControllerModel());
        this.populated = true;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static /* synthetic */ boolean access$0(ManagementNetworkPane $0) {
        return $0.populated;
    }

    static /* synthetic */ SetupPane access$1(ManagementNetworkPane $0) {
        return $0.parent;
    }

    private class ManagementNetworkPaneInner
    extends SizeLinkedPanel {
        final int HEIGHT = 296;
        final Insets INSETS_ZERO = new Insets(0, 0, 0, 0);
        final Insets INSETS_SEPARATOR = new Insets(16, 0, 4, 0);
        final Insets INSETS_CONFIGURE_LABEL = new Insets(0, 16, 0, 0);
        final Insets INSETS_CONFIGURE_COMBO = new Insets(0, 8, 0, 0);
        final Insets INSETS_LABELS = new Insets(8, 16, 0, 0);
        final Insets INSETS_TEXT_FIELDS = new Insets(8, 8, 0, 0);
        final Insets INSETS_OPTIONAL_LABELS = new Insets(0, 8, 0, 0);
        final Insets INSETS_VALIDATE_LABELS = new Insets(0, 4, 4, 0);
        final Insets INSETS_VALIDATE_STRUT = new Insets(0, 4, 0, 0);
        final Insets INSETS_ETHERNET_ADDRESS_LABEL = new Insets(8, 16, 16, 0);
        final Insets INSETS_ETHERNET_ADDRESS = new Insets(8, 8, 16, 0);
        private final String OPTIONAL = Resources.getString("management.network.optional");
        private final String PROVIDED_BY_DHCP = Resources.getString("management.network.usingDHCP");
        private final String VALID_IP_OCTET_SET = Resources.getString("aquaTextField.validIPOctetCharacters");
        private JComboBox mConfigurationComboBox;
        private RestrictedTextField mIPAddressTextField;
        private RestrictedTextField mSubnetMaskTextField;
        private RestrictedTextField mRouterTextField;
        private RestrictedTextField mDNS1TextField;
        private RestrictedTextField mDNS2TextField;
        private RestrictedTextField mDNS3TextField;
        private JTextField mDHCPClientIDTextField;
        private JLabel mEthernetAddressLabel;
        private JLabel mIPAddressValidateLabel;
        private JLabel mSubnetMaskValidateLabel;
        private JLabel mRouterValidateLabel;
        private JLabel mDHCPClientIDValidateLabel;
        private JLabel mDNS1ValidateLabel;
        private JLabel mDNS2ValidateLabel;
        private JLabel mDNS3ValidateLabel;
        private JLabel mDNS1OptionalLabel;
        private JLabel mDNS2OptionalLabel;
        private JLabel mDNS3OptionalLabel;
        private JLabel mDHCPClientIDLabel;
        private JLabel mDHCPClientIDOptionalLabel;
        private String mDHCPClientIDString = null;
        private ManagementNetworkModel.ManagementNetworkControllerModel model = null;

        public ManagementNetworkPaneInner(String title) {
            this.setLayout(new GridBagLayout());
            TitledBorder networkBorder = new TitledBorder(" " + title + " ");
            networkBorder.setTitleFont(GUIFactory.FONT_SMALL);
            this.setBorder(new CompoundBorder(networkBorder, ManagementPane.DEFAULT_GROUP_BOX_BORDER));
            1 theFocusAdapter = new 1(this);
            2 theCaretListener = new 2(this);
            3 theActionListener = new 3(this);
            LineSeparator theLineSeparator = new LineSeparator(true, Color.gray);
            JLabel configureLabel = this.jlabelWithFont(Resources.getString("management.network.configure"), GUIFactory.FONT_SMALL);
            JLabel ipAddressLabel = this.jlabelWithFont(Resources.getString("management.network.ipAddress"), GUIFactory.FONT_SMALL);
            JLabel subnetMaskLabel = this.jlabelWithFont(Resources.getString("management.network.subnetMask"), GUIFactory.FONT_SMALL);
            JLabel routerLabel = this.jlabelWithFont(Resources.getString("management.network.router"), GUIFactory.FONT_SMALL);
            JLabel dns1Label = this.jlabelWithFont(Resources.getString("management.network.dns1"), GUIFactory.FONT_SMALL);
            JLabel dns2Label = this.jlabelWithFont(Resources.getString("management.network.dns2"), GUIFactory.FONT_SMALL);
            JLabel dns3Label = this.jlabelWithFont(Resources.getString("management.network.dns3"), GUIFactory.FONT_SMALL);
            JLabel ethernetAddressLabel = this.jlabelWithFont(Resources.getString("management.network.ethernetAddress"), GUIFactory.FONT_SMALL);
            this.mConfigurationComboBox = new JComboBox();
            this.mConfigurationComboBox.setEditable(false);
            this.mConfigurationComboBox.setFont(GUIFactory.FONT_SMALL);
            this.mConfigurationComboBox.addItem(Resources.getString("management.network.usingDHCP"));
            this.mConfigurationComboBox.addItem(Resources.getString("management.network.manually"));
            this.mConfigurationComboBox.addActionListener(theActionListener);
            this.mConfigurationComboBox.addActionListener(new 4(this));
            this.mIPAddressTextField = GUIFactory.newRestrictedTextField(12);
            this.mIPAddressTextField.setFont(GUIFactory.FONT_SMALL);
            this.mIPAddressTextField.addFocusListener(theFocusAdapter);
            this.mIPAddressTextField.addCaretListener(theCaretListener);
            this.mIPAddressTextField.addActionListener(theActionListener);
            this.mIPAddressTextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mSubnetMaskTextField = GUIFactory.newRestrictedTextField(12);
            this.mSubnetMaskTextField.setFont(GUIFactory.FONT_SMALL);
            this.mSubnetMaskTextField.addFocusListener(theFocusAdapter);
            this.mSubnetMaskTextField.addCaretListener(theCaretListener);
            this.mSubnetMaskTextField.addActionListener(theActionListener);
            this.mSubnetMaskTextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mRouterTextField = GUIFactory.newRestrictedTextField(12);
            this.mRouterTextField.setFont(GUIFactory.FONT_SMALL);
            this.mRouterTextField.addFocusListener(theFocusAdapter);
            this.mRouterTextField.addCaretListener(theCaretListener);
            this.mRouterTextField.addActionListener(theActionListener);
            this.mRouterTextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDHCPClientIDTextField = GUIFactory.newTextField(12);
            this.mDHCPClientIDTextField.setFont(GUIFactory.FONT_SMALL);
            this.mDHCPClientIDTextField.addFocusListener(theFocusAdapter);
            this.mDHCPClientIDTextField.addCaretListener(theCaretListener);
            this.mDHCPClientIDTextField.addActionListener(theActionListener);
            this.mDNS1TextField = GUIFactory.newRestrictedTextField(12);
            this.mDNS1TextField.setFont(GUIFactory.FONT_SMALL);
            this.mDNS1TextField.addFocusListener(theFocusAdapter);
            this.mDNS1TextField.addCaretListener(theCaretListener);
            this.mDNS1TextField.addActionListener(theActionListener);
            this.mDNS1TextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDNS2TextField = GUIFactory.newRestrictedTextField(12);
            this.mDNS2TextField.setFont(GUIFactory.FONT_SMALL);
            this.mDNS2TextField.addFocusListener(theFocusAdapter);
            this.mDNS2TextField.addCaretListener(theCaretListener);
            this.mDNS2TextField.addActionListener(theActionListener);
            this.mDNS2TextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDNS3TextField = GUIFactory.newRestrictedTextField(12);
            this.mDNS3TextField.setFont(GUIFactory.FONT_SMALL);
            this.mDNS3TextField.addFocusListener(theFocusAdapter);
            this.mDNS3TextField.addCaretListener(theCaretListener);
            this.mDNS3TextField.addActionListener(theActionListener);
            this.mDNS3TextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDNS1OptionalLabel = this.jlabelWithFont(this.OPTIONAL, GUIFactory.FONT_TINY);
            this.mDNS2OptionalLabel = this.jlabelWithFont(this.OPTIONAL, GUIFactory.FONT_TINY);
            this.mDNS3OptionalLabel = this.jlabelWithFont(this.OPTIONAL, GUIFactory.FONT_TINY);
            this.mDNS1OptionalLabel.setVisible(false);
            this.mDNS2OptionalLabel.setVisible(false);
            this.mDNS3OptionalLabel.setVisible(false);
            this.mDHCPClientIDOptionalLabel = this.jlabelWithFont(Resources.getString("management.network.optional"), GUIFactory.FONT_TINY);
            this.mDHCPClientIDLabel = this.jlabelWithFont(Resources.getString("management.network.dhcpClientID"), GUIFactory.FONT_SMALL);
            this.mEthernetAddressLabel = new JLabel();
            this.mEthernetAddressLabel.setFont(GUIFactory.FONT_SMALL);
            ImageIcon validateIcon = new ImageIcon(Resources.getImage("icon.validate"));
            this.mIPAddressValidateLabel = new JLabel(validateIcon);
            this.mSubnetMaskValidateLabel = new JLabel(validateIcon);
            this.mRouterValidateLabel = new JLabel(validateIcon);
            this.mDHCPClientIDValidateLabel = new JLabel(validateIcon);
            this.mDNS1ValidateLabel = new JLabel(validateIcon);
            this.mDNS2ValidateLabel = new JLabel(validateIcon);
            this.mDNS3ValidateLabel = new JLabel(validateIcon);
            this.mIPAddressValidateLabel.setVisible(false);
            this.mSubnetMaskValidateLabel.setVisible(false);
            this.mRouterValidateLabel.setVisible(false);
            this.mDHCPClientIDValidateLabel.setVisible(false);
            this.mDNS1ValidateLabel.setVisible(false);
            this.mDNS2ValidateLabel.setVisible(false);
            this.mDNS3ValidateLabel.setVisible(false);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 16, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)configureLabel, constraints);
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 3;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 10;
            constraints.fill = 2;
            constraints.insets = this.createInsets(16, 0, 4, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)theLineSeparator, constraints);
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 16, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)ipAddressLabel, constraints);
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 16, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)subnetMaskLabel, constraints);
            constraints.gridx = 0;
            constraints.gridy = 4;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 16, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)routerLabel, constraints);
            constraints.gridx = 0;
            constraints.gridy = 5;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 16, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)dns1Label, constraints);
            constraints.gridx = 0;
            constraints.gridy = 7;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 16, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)dns2Label, constraints);
            constraints.gridx = 0;
            constraints.gridy = 9;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 16, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)dns3Label, constraints);
            constraints.gridx = 0;
            constraints.gridy = 11;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 16, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDHCPClientIDLabel, constraints);
            constraints.gridx = 0;
            constraints.gridy = 13;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 16;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 16, 16, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)ethernetAddressLabel, constraints);
            constraints.gridx = 0;
            constraints.gridy = 14;
            constraints.gridwidth = 3;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.anchor = 10;
            constraints.fill = 1;
            constraints.insets = this.INSETS_ZERO;
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add(Box.createGlue(), constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 2;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 8, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mConfigurationComboBox, constraints);
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 8, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mIPAddressTextField, constraints);
            constraints.gridx = 1;
            constraints.gridy = 3;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 8, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mSubnetMaskTextField, constraints);
            constraints.gridx = 1;
            constraints.gridy = 4;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 8, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mRouterTextField, constraints);
            constraints.gridx = 1;
            constraints.gridy = 5;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 8, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDNS1TextField, constraints);
            constraints.gridx = 1;
            constraints.gridy = 6;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 8, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDNS1OptionalLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 7;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 8, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDNS2TextField, constraints);
            constraints.gridx = 1;
            constraints.gridy = 8;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 8, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDNS2OptionalLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 9;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 8, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDNS3TextField, constraints);
            constraints.gridx = 1;
            constraints.gridy = 10;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 8, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDNS3OptionalLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 11;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 8, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDHCPClientIDTextField, constraints);
            constraints.gridx = 1;
            constraints.gridy = 12;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 8, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDHCPClientIDOptionalLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 13;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 16;
            constraints.fill = 0;
            constraints.insets = this.createInsets(8, 8, 16, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mEthernetAddressLabel, constraints);
            constraints.gridx = 2;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 16;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 4, 4, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mIPAddressValidateLabel, constraints);
            constraints.gridx = 2;
            constraints.gridy = 3;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 16;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 4, 4, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mSubnetMaskValidateLabel, constraints);
            constraints.gridx = 2;
            constraints.gridy = 4;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 16;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 4, 4, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mRouterValidateLabel, constraints);
            constraints.gridx = 2;
            constraints.gridy = 5;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 16;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 4, 4, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDNS1ValidateLabel, constraints);
            constraints.gridx = 2;
            constraints.gridy = 7;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 16;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 4, 4, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDNS2ValidateLabel, constraints);
            constraints.gridx = 2;
            constraints.gridy = 9;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 16;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 4, 4, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDNS3ValidateLabel, constraints);
            constraints.gridx = 2;
            constraints.gridy = 11;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 16;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 4, 4, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)this.mDHCPClientIDValidateLabel, constraints);
            constraints.gridx = 2;
            constraints.gridy = 13;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 16;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 4, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add(Box.createHorizontalStrut(validateIcon.getIconWidth()), constraints);
            constraints.gridx = 3;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 13;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 11;
            constraints.fill = 0;
            constraints.insets = this.createInsets(0, 0, 0, 0);
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add(Box.createVerticalStrut(296), constraints);
            this.configureUIForDHCP();
        }

        public void configureUIForDHCP() {
            this.mIPAddressTextField.setRestrictedCharacterSet(null);
            this.mSubnetMaskTextField.setRestrictedCharacterSet(null);
            this.mRouterTextField.setRestrictedCharacterSet(null);
            if (this.model != null && this.model.getNetworkConfigurationMethod() == 1) {
                this.mIPAddressTextField.setText(this.model.getIPAddress());
                this.mSubnetMaskTextField.setText(this.model.getSubnetMask());
                this.mRouterTextField.setText(this.model.getRouter());
                this.mDNS1TextField.setText(this.model.getDNS1());
                this.mDNS2TextField.setText(this.model.getDNS2());
                this.mDNS3TextField.setText(this.model.getDNS3());
            } else if (this.model != null && this.model.getNetworkConfigurationMethod() == 2) {
                this.mIPAddressTextField.setText(this.PROVIDED_BY_DHCP);
                this.mSubnetMaskTextField.setText(this.PROVIDED_BY_DHCP);
                this.mRouterTextField.setText(this.PROVIDED_BY_DHCP);
                this.mDNS1TextField.setText("");
                this.mDNS2TextField.setText("");
                this.mDNS3TextField.setText("");
            } else {
                this.mIPAddressTextField.setText("");
                this.mSubnetMaskTextField.setText("");
                this.mRouterTextField.setText("");
                this.mDNS1TextField.setText("");
                this.mDNS2TextField.setText("");
                this.mDNS3TextField.setText("");
            }
            GUIFactory.configureTextFieldAsLabel(this.mIPAddressTextField);
            GUIFactory.configureTextFieldAsLabel(this.mSubnetMaskTextField);
            GUIFactory.configureTextFieldAsLabel(this.mRouterTextField);
            this.mIPAddressValidateLabel.setVisible(false);
            this.mSubnetMaskValidateLabel.setVisible(false);
            this.mRouterValidateLabel.setVisible(false);
            GUIFactory.configureTextFieldAsLabel(this.mDNS1TextField);
            GUIFactory.configureTextFieldAsLabel(this.mDNS2TextField);
            GUIFactory.configureTextFieldAsLabel(this.mDNS3TextField);
            this.mDNS1OptionalLabel.setVisible(false);
            this.mDNS2OptionalLabel.setVisible(false);
            this.mDNS3OptionalLabel.setVisible(false);
            GUIFactory.configureTextFieldAsField(this.mDHCPClientIDTextField);
            if (this.mDHCPClientIDString != null) {
                this.mDHCPClientIDTextField.setText(this.mDHCPClientIDString);
            }
            this.mDHCPClientIDLabel.setVisible(true);
            this.mDHCPClientIDOptionalLabel.setVisible(true);
        }

        public void configureUIForManual() {
            if (this.model != null && this.model.getNetworkConfigurationMethod() == 2) {
                this.mIPAddressTextField.setText(this.model.getIPAddress());
                this.mSubnetMaskTextField.setText(this.model.getSubnetMask());
                this.mRouterTextField.setText(this.model.getRouter());
                this.mDNS1TextField.setText(this.model.getDNS1());
                this.mDNS2TextField.setText(this.model.getDNS2());
                this.mDNS3TextField.setText(this.model.getDNS3());
            } else if (this.model != null && this.model.getNetworkConfigurationMethod() == 1) {
                this.mIPAddressTextField.setText("");
                this.mSubnetMaskTextField.setText(this.model.getSubnetMask());
                this.mRouterTextField.setText(this.model.getRouter());
                this.mDNS1TextField.setText(this.model.getDNS1());
                this.mDNS2TextField.setText(this.model.getDNS2());
                this.mDNS3TextField.setText(this.model.getDNS3());
            } else {
                this.mIPAddressTextField.setText("");
                this.mSubnetMaskTextField.setText("");
                this.mRouterTextField.setText("");
                this.mDNS1TextField.setText("");
                this.mDNS2TextField.setText("");
                this.mDNS3TextField.setText("");
            }
            this.mIPAddressTextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mSubnetMaskTextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mRouterTextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDNS1TextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDNS2TextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDNS3TextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            GUIFactory.configureTextFieldAsField(this.mIPAddressTextField);
            GUIFactory.configureTextFieldAsField(this.mSubnetMaskTextField);
            GUIFactory.configureTextFieldAsField(this.mRouterTextField);
            GUIFactory.configureTextFieldAsField(this.mDNS1TextField);
            GUIFactory.configureTextFieldAsField(this.mDNS2TextField);
            GUIFactory.configureTextFieldAsField(this.mDNS3TextField);
            this.mDNS1OptionalLabel.setVisible(false);
            this.mDNS2OptionalLabel.setVisible(true);
            this.mDNS3OptionalLabel.setVisible(true);
            GUIFactory.configureTextFieldAsLabel(this.mDHCPClientIDTextField);
            this.mDHCPClientIDString = this.mDHCPClientIDTextField.getText();
            this.mDHCPClientIDTextField.setText(" ");
            this.mDHCPClientIDLabel.setVisible(false);
            this.mDHCPClientIDOptionalLabel.setVisible(false);
        }

        public void populate(ManagementNetworkModel.ManagementNetworkControllerModel networkModel) {
            this.model = networkModel;
            if (networkModel.getNetworkConfigurationMethod() == 1) {
                this.mConfigurationComboBox.setSelectedItem(Resources.getString("management.network.usingDHCP"));
                this.configureUIForDHCP();
            } else {
                this.mConfigurationComboBox.setSelectedItem(Resources.getString("management.network.manually"));
                this.configureUIForManual();
            }
            this.mDHCPClientIDTextField.setText(networkModel.getDHCPClientID());
            this.mEthernetAddressLabel.setText(networkModel.getEthernetMACAddress());
            this.checkValidity();
        }

        public boolean checkValidity() {
            boolean validationSucceeded = true;
            if (this.getConfigurationMode() == 2) {
                boolean aFieldIsValid = false;
                aFieldIsValid = this.validateAddressField(this.mIPAddressTextField, this.mIPAddressValidateLabel);
                if (!aFieldIsValid) {
                    validationSucceeded = false;
                }
                if (!this.mSubnetMaskTextField.getText().trim().equals("") && !(aFieldIsValid = this.validateAddressField(this.mSubnetMaskTextField, this.mSubnetMaskValidateLabel))) {
                    validationSucceeded = false;
                }
                if (validationSucceeded && !(aFieldIsValid = this.validateIPAddressSubnetConflicts())) {
                    validationSucceeded = false;
                }
                if (!this.mRouterTextField.getText().trim().equals("") && !(aFieldIsValid = this.validateAddressField(this.mRouterTextField, this.mRouterValidateLabel))) {
                    validationSucceeded = false;
                }
                if (!this.mDNS1TextField.getText().trim().equals("") && !(aFieldIsValid = this.validateAddressField(this.mDNS1TextField, this.mDNS1ValidateLabel))) {
                    validationSucceeded = false;
                }
                if (!this.mDNS2TextField.getText().trim().equals("") && !(aFieldIsValid = this.validateAddressField(this.mDNS2TextField, this.mDNS2ValidateLabel))) {
                    validationSucceeded = false;
                }
                if (!this.mDNS3TextField.getText().trim().equals("") && !(aFieldIsValid = this.validateAddressField(this.mDNS3TextField, this.mDNS3ValidateLabel))) {
                    validationSucceeded = false;
                }
            }
            return validationSucceeded;
        }

        public void fillInModel(ManagementNetworkModel.ManagementNetworkControllerModel networkModel) {
            if (networkModel == null) {
                throw new IllegalArgumentException("networkModel is null.");
            }
            int configurationMode = this.getConfigurationMode();
            networkModel.setNetworkConfigurationMethod(configurationMode);
            if (configurationMode == 2) {
                networkModel.setIPAddress(this.mIPAddressTextField.getText());
                networkModel.setSubnetMask(this.mSubnetMaskTextField.getText());
                networkModel.setRouter(this.mRouterTextField.getText());
                networkModel.setDNS1(this.mDNS1TextField.getText());
                networkModel.setDNS2(this.mDNS2TextField.getText());
                networkModel.setDNS3(this.mDNS3TextField.getText());
            } else {
                networkModel.setDNS1(this.mDNS1TextField.getText());
                networkModel.setDNS2(this.mDNS2TextField.getText());
                networkModel.setDNS3(this.mDNS3TextField.getText());
            }
            String clientId = this.mDHCPClientIDTextField.getText();
            if (clientId.equals(" ")) {
                clientId = "";
            }
            networkModel.setDHCPClientID(clientId);
            networkModel.setEthernetMACAddress(this.mEthernetAddressLabel.getText());
        }

        public int getConfigurationMode() {
            String selection = (String)this.mConfigurationComboBox.getSelectedItem();
            if (selection.equals(Resources.getString("management.network.usingDHCP"))) {
                return 1;
            }
            return 2;
        }

        private boolean validateAddressField(JTextField theField, JLabel theValidateLabel) {
            boolean addressIsValid = true;
            try {
                theField.setText(theField.getText().trim());
                addressIsValid = this.validateFourOctetAddress(theField.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                addressIsValid = false;
            }
            if (addressIsValid) {
                theValidateLabel.setVisible(false);
            } else {
                theValidateLabel.setVisible(true);
            }
            return addressIsValid;
        }

        private boolean validateFourOctetAddress(String address) throws NumberFormatException {
            boolean addressIsValid = true;
            boolean indexOfLastPeriod = false;
            int index = 0;
            while (index < 4) {
                int octetValue = this.octetValueAtIndex(address, index);
                if (octetValue < 0 || octetValue > 255) {
                    addressIsValid = false;
                    break;
                }
                ++index;
            }
            return addressIsValid;
        }

        private boolean validateIPAddressSubnetConflicts() {
            int top2SubnetOctets;
            int top2IPOctets;
            int secondSubnetOctet;
            boolean fieldIsValid = true;
            try {
                int firstIPOctet = this.octetValueAtIndex(this.mIPAddressTextField.getText().trim(), 0);
                int firstSubnetOctet = this.octetValueAtIndex(this.mSubnetMaskTextField.getText().trim(), 0);
                secondSubnetOctet = this.octetValueAtIndex(this.mSubnetMaskTextField.getText().trim(), 1);
                top2IPOctets = firstIPOctet << 8 | this.octetValueAtIndex(this.mIPAddressTextField.getText().trim(), 1);
                top2SubnetOctets = firstSubnetOctet << 8 | secondSubnetOctet;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if ((top2IPOctets & top2SubnetOctets) == 2560 && secondSubnetOctet == 0 || (top2IPOctets & top2SubnetOctets) == 2814) {
                this.mIPAddressValidateLabel.setVisible(true);
                this.mSubnetMaskValidateLabel.setVisible(true);
                fieldIsValid = false;
            } else {
                this.mIPAddressValidateLabel.setVisible(false);
                this.mSubnetMaskValidateLabel.setVisible(false);
            }
            return fieldIsValid;
        }

        private int octetValueAtIndex(String address, int index) {
            int octetValue = -1;
            int indexOfLastPeriod = 0;
            if (index < 0 || index > 3) {
                throw new IllegalArgumentException("Invalid index value");
            }
            int i = 0;
            while (i <= index) {
                int nextPeriodIndex = address.indexOf(".", indexOfLastPeriod);
                if (i < 3) {
                    if (nextPeriodIndex != -1 && i == index) {
                        octetValue = Integer.valueOf(address.substring(indexOfLastPeriod, nextPeriodIndex));
                        break;
                    }
                    if (nextPeriodIndex == -1) {
                        octetValue = -1;
                        break;
                    }
                    indexOfLastPeriod = nextPeriodIndex + 1;
                } else {
                    octetValue = Integer.valueOf(address.substring(indexOfLastPeriod));
                }
                ++i;
            }
            return octetValue;
        }

        public JLabel jlabelWithFont(String labelString, Font theFont) {
            JLabel theJLabel = new JLabel(labelString);
            theJLabel.setFont(theFont);
            return theJLabel;
        }

        private Insets createInsets(int top, int left, int bottom, int right) {
            Insets insets;
            if (top == 16 && left == 0 && bottom == 4 && right == 0) {
                insets = this.INSETS_SEPARATOR;
            } else if (top == 0 && left == 16 && bottom == 0 && right == 0) {
                insets = this.INSETS_CONFIGURE_LABEL;
            } else if (top == 0 && left == 8 && bottom == 0 && right == 0) {
                insets = this.INSETS_CONFIGURE_COMBO;
            } else if (top == 8 && left == 16 && bottom == 0 && right == 0) {
                insets = this.INSETS_LABELS;
            } else if (top == 8 && left == 8 && bottom == 0 && right == 0) {
                insets = this.INSETS_TEXT_FIELDS;
            } else if (top == 0 && left == 8 && bottom == 0 && right == 0) {
                insets = this.INSETS_OPTIONAL_LABELS;
            } else if (top == 0 && left == 4 && bottom == 4 && right == 0) {
                insets = this.INSETS_VALIDATE_LABELS;
            } else if (top == 0 && left == 4 && bottom == 0 && right == 0) {
                insets = this.INSETS_VALIDATE_STRUT;
            } else if (top == 8 && left == 16 && bottom == 16 && right == 0) {
                insets = this.INSETS_ETHERNET_ADDRESS_LABEL;
            } else if (top == 8 && left == 8 && bottom == 16 && right == 0) {
                insets = this.INSETS_ETHERNET_ADDRESS;
            } else if (top == 0 && left == 0 && bottom == 0 && right == 0) {
                insets = this.INSETS_ZERO;
            } else {
                insets = new Insets(top, left, bottom, right);
                logger.warn("Had to create new insets: " + top + "," + left + "," + bottom + "," + right);
            }
            return insets;
        }

        static /* synthetic */ ManagementNetworkPane access$0(ManagementNetworkPaneInner $0) {
            return $0.ManagementNetworkPane.this;
        }

        static /* synthetic */ JComboBox access$1(ManagementNetworkPaneInner $0) {
            return $0.mConfigurationComboBox;
        }
    }
}

