/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.MenuManager;
import com.apple.gui.text.SelectAllAction;
import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJQuitHandler;
import com.apple.util.Gestalt;
import com.apple.util.ImageUtilities;
import com.apple.util.StringUtilities;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.AboutBox;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertAdapter;
import com.apple.xsr.PreferencesWindow;
import com.apple.xsr.RaidAdmin;
import com.apple.xsr.Resources;
import com.apple.xsr.SystemMonitorController;
import com.apple.xsr.Utilities;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultEditorKit;

public class RaidAdmin
implements MRJOpenDocumentHandler {
    public static final int MENU_BAR_TYPE_MANAGEMENT_DISABLED = 1;
    private static final int GRID_BAG_INSET_VALUE = 12;
    private Preferences preferences;
    private static SystemMonitorController monitorController;
    private AquaAlert firmwareUpdateAlert;
    public static String lastFirmwareFilePath;

    public RaidAdmin() throws MissingResourceException {
        Resources.load();
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setEnabled(true);
        toolTipManager.setInitialDelay(750);
        toolTipManager.setReshowDelay(500);
        if (Gestalt.isAquaLookAndFeel) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        if (Gestalt.isMacLookAndFeel) {
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        }
        this.loadPreferences();
        if (!this.displayLicenseAgreementIfNeeded()) {
            this.runApplication();
        }
    }

    private void runApplication() {
        this.initMenuBar();
        monitorController = SystemMonitorController.getInstance();
        MRJApplicationUtils.registerOpenDocumentHandler(this);
    }

    private void loadPreferences() {
        this.preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
    }

    private void initMenuBar() {
        MenuManager menuMgr = MenuManager.getInstance();
        AboutAction aboutAction = new AboutAction();
        MRJApplicationUtils.registerAboutHandler(aboutAction);
        menuMgr.register("application.menu.misc.about", aboutAction);
        PrefsHandler prefsHandler = new PrefsHandler();
        MRJApplicationUtils.registerPrefsHandler(prefsHandler);
        menuMgr.register("application.menu.misc.preferences", prefsHandler);
        QuitHandler quitHandler = new QuitHandler();
        MRJApplicationUtils.registerQuitHandler(quitHandler);
        menuMgr.register("application.menu.misc.quit", quitHandler);
        menuMgr.register("application.menu.file.closeWindow", menuMgr.newCloseWindowListener());
        MenuManager.EditMenuListener editMenuListener = menuMgr.newEditMenuListener("application.menu.edit.cut", "application.menu.edit.copy", "application.menu.edit.paste", "application.menu.edit.selectAll");
        menuMgr.register("application.menu.edit", editMenuListener);
        DefaultEditorKit.CutAction cutAction = new DefaultEditorKit.CutAction();
        cutAction.putValue("Name", Resources.getString("application.menu.edit.cut"));
        cutAction.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.edit.cut.accelerator"));
        menuMgr.register("application.menu.edit.cut", cutAction);
        DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
        copyAction.putValue("Name", Resources.getString("application.menu.edit.copy"));
        copyAction.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.edit.copy.accelerator"));
        menuMgr.register("application.menu.edit.copy", copyAction);
        DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
        pasteAction.putValue("Name", Resources.getString("application.menu.edit.paste"));
        pasteAction.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.edit.paste.accelerator"));
        menuMgr.register("application.menu.edit.paste", pasteAction);
        SelectAllAction selectAllAction = new SelectAllAction();
        selectAllAction.putValue("Name", Resources.getString("application.menu.edit.selectAll"));
        selectAllAction.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.edit.selectAll.accelerator"));
        menuMgr.register("application.menu.edit.selectAll", selectAllAction);
        menuMgr.register("application.menu.help.appHelp", new HelpListener());
    }

    private boolean displayLicenseAgreementIfNeeded() {
        boolean licenseShown = false;
        if (!this.preferences.exists("LicenseAgreementAccepted")) {
            licenseShown = true;
            LicensePanel theLicensePanel = new LicensePanel();
            JFrame theLicenseFrame = new JFrame();
            theLicenseFrame.setTitle(Resources.getString("licenseAgreement.title"));
            theLicenseFrame.setDefaultCloseOperation(3);
            theLicenseFrame.setContentPane(theLicensePanel);
            JButton acceptButton = theLicensePanel.getAcceptButton();
            JButton declineButton = theLicensePanel.getDeclineButton();
            acceptButton.addActionListener(new 1(theLicenseFrame, this));
            declineButton.addActionListener(new 2(theLicenseFrame, this));
            ((Component)theLicenseFrame).setSize(theLicensePanel.getPreferredSize());
            theLicenseFrame.show();
        }
        return licenseShown;
    }

    public static String getAppVersion() {
        return Resources.getAppVersion();
    }

    public static int[] getSupportedProductIds() {
        int[] ids = new int[]{2, 4};
        return ids;
    }

    public static SystemMonitorController getMonitorController() {
        return monitorController;
    }

    public static JMenuBar newMenuBar(int type) {
        JMenu systemMenu;
        JMenuBar menuBar = null;
        if (type == 1 && (systemMenu = MenuManager.getMenu(menuBar = MenuManager.getInstance().newMenuBar(), "application.menu.system")) != null) {
            MenuManager.removeActions(systemMenu);
            MenuManager.setMenuEnabled(systemMenu, false);
        }
        return menuBar;
    }

    public void handleOpenFile(File file) {
        lastFirmwareFilePath = file.getParent();
        if (this.firmwareUpdateAlert == null) {
            String message = Resources.getString("firmwareAlert.message");
            message = StringUtilities.replaceAll(message, "{filename}", file.getName());
            this.firmwareUpdateAlert = AquaAlert.createStandardAquaAlert(message, Resources.getString("firmwareAlert.explanation"), Resources.getImage("icon.firmware").getScaledInstance(48, 48, 4), Resources.getString("ok"), null, null);
            3 listener = new 3();
            this.firmwareUpdateAlert.showSheet(RaidAdmin.monitorController.monitorWindow, listener, null);
        }
    }

    static /* synthetic */ AquaAlert access$2(RaidAdmin $0) {
        return $0.firmwareUpdateAlert;
    }

    private static final class 1
    implements ActionListener {
        private final /* synthetic */ RaidAdmin this$0;
        private final /* synthetic */ JFrame val$theLicenseFrame;

        public void actionPerformed(ActionEvent event) {
            this.val$theLicenseFrame.dispose();
            this.this$0.preferences.setBoolean("LicenseAgreementAccepted", true);
            this.this$0.preferences.synchronize();
            this.this$0.runApplication();
        }

        /* synthetic */ 1(JFrame val$theLicenseFrame, RaidAdmin this$0) {
            this.val$theLicenseFrame = val$theLicenseFrame;
            this.this$0 = this$0;
        }
    }

    private static final class 2
    implements ActionListener {
        private final /* synthetic */ RaidAdmin this$0;
        private final /* synthetic */ JFrame val$theLicenseFrame;

        public void actionPerformed(ActionEvent event) {
            this.val$theLicenseFrame.dispose();
            this.this$0.new QuitHandler().handleQuit();
        }

        /* synthetic */ 2(JFrame val$theLicenseFrame, RaidAdmin this$0) {
            this.val$theLicenseFrame = val$theLicenseFrame;
            this.this$0 = this$0;
        }
    }

    private final class 3
    extends AquaAlertAdapter {
        public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
            RaidAdmin.this.firmwareUpdateAlert = null;
        }

        /* synthetic */ 3() {
        }
    }

    class LicensePanel
    extends JPanel {
        private JComboBox mLanguageSelectPopUp;
        private InvertableImageIcon[] mLicenseLanguageIcons;
        private JScrollPane mScrollPane;
        private JButton mAcceptButton;
        private JButton mDeclineButton;
        private JLabel brazilianPortugueseLabel = null;
        private JLabel danishLabel = null;
        private JLabel dutchLabel = null;
        private JLabel englishLabel = null;
        private JLabel finnishLabel = null;
        private JLabel frenchLabel = null;
        private JLabel germanLabel = null;
        private JLabel italianLabel = null;
        private JLabel japaneseLabel = null;
        private JLabel koreanLabel = null;
        private JLabel norwegianLabel = null;
        private JLabel simplifiedChineseLabel = null;
        private JLabel spanishLabel = null;
        private JLabel swedishLabel = null;
        private JLabel traditionalChineseLabel = null;
        private ImageIcon brazilianPortugueseYesLabel = null;
        private ImageIcon danishYesLabel = null;
        private ImageIcon dutchYesLabel = null;
        private ImageIcon englishYesLabel = null;
        private ImageIcon finnishYesLabel = null;
        private ImageIcon frenchYesLabel = null;
        private ImageIcon germanYesLabel = null;
        private ImageIcon italianYesLabel = null;
        private ImageIcon japaneseYesLabel = null;
        private ImageIcon koreanYesLabel = null;
        private ImageIcon norwegianYesLabel = null;
        private ImageIcon simplifiedChineseYesLabel = null;
        private ImageIcon spanishYesLabel = null;
        private ImageIcon swedishYesLabel = null;
        private ImageIcon traditionalChineseYesLabel = null;
        private ImageIcon brazilianPortugueseNoLabel = null;
        private ImageIcon danishNoLabel = null;
        private ImageIcon dutchNoLabel = null;
        private ImageIcon englishNoLabel = null;
        private ImageIcon finnishNoLabel = null;
        private ImageIcon frenchNoLabel = null;
        private ImageIcon germanNoLabel = null;
        private ImageIcon italianNoLabel = null;
        private ImageIcon japaneseNoLabel = null;
        private ImageIcon koreanNoLabel = null;
        private ImageIcon norwegianNoLabel = null;
        private ImageIcon simplifiedChineseNoLabel = null;
        private ImageIcon spanishNoLabel = null;
        private ImageIcon swedishNoLabel = null;
        private ImageIcon traditionalChineseNoLabel = null;
        private static final int LICENSE_PANEL_WIDTH = 660;
        private static final int LICENSE_PANEL_HEIGHT = 400;

        public LicensePanel() {
            EmptyBorder margin = new EmptyBorder(12, 12, 16, 12);
            this.setBorder(margin);
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            Box controlBox = Box.createHorizontalBox();
            this.mAcceptButton = GUIFactory.newButton();
            this.mDeclineButton = GUIFactory.newButton();
            this.mLicenseLanguageIcons = new InvertableImageIcon[15];
            this.mLanguageSelectPopUp = new JComboBox();
            this.preparePopUp();
            this.mLanguageSelectPopUp.setMaximumSize(this.mLanguageSelectPopUp.getPreferredSize());
            constraints.anchor = 10;
            constraints.fill = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.insets = new Insets(0, 0, 6, 0);
            this.add((Component)this.mLanguageSelectPopUp, constraints);
            constraints.anchor = 17;
            constraints.fill = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.mScrollPane = new JScrollPane();
            this.mScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.mScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            this.mScrollPane.setVerticalScrollBarPolicy(22);
            this.mScrollPane.getViewport().setBackground(Color.white);
            this.add((Component)this.mScrollPane, constraints);
            this.switchLicenseAgreementUI(Resources.getInt("licenseAgreement.defaultLanguageIndex"));
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 13;
            constraints.insets = new Insets(12, 12, 0, 0);
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            controlBox.add(this.mDeclineButton);
            controlBox.add(Box.createHorizontalStrut(12));
            controlBox.add(this.mAcceptButton);
            this.add((Component)controlBox, constraints);
        }

        public void preparePopUp() {
            this.mLicenseLanguageIcons[11] = new InvertableImageIcon(Resources.getImage("licenseAgreement.brazilianPortugueseLanguagePopup"));
            this.mLicenseLanguageIcons[7] = new InvertableImageIcon(Resources.getImage("licenseAgreement.danishLanguagePopup"));
            this.mLicenseLanguageIcons[0] = new InvertableImageIcon(Resources.getImage("licenseAgreement.dutchLanguagePopup"));
            this.mLicenseLanguageIcons[1] = new InvertableImageIcon(Resources.getImage("licenseAgreement.englishLanguagePopup"));
            this.mLicenseLanguageIcons[8] = new InvertableImageIcon(Resources.getImage("licenseAgreement.finnishLanguagePopup"));
            this.mLicenseLanguageIcons[2] = new InvertableImageIcon(Resources.getImage("licenseAgreement.frenchLanguagePopup"));
            this.mLicenseLanguageIcons[3] = new InvertableImageIcon(Resources.getImage("licenseAgreement.germanLanguagePopup"));
            this.mLicenseLanguageIcons[4] = new InvertableImageIcon(Resources.getImage("licenseAgreement.italianLanguagePopup"));
            this.mLicenseLanguageIcons[5] = new InvertableImageIcon(Resources.getImage("licenseAgreement.japaneseLanguagePopup"));
            this.mLicenseLanguageIcons[9] = new InvertableImageIcon(Resources.getImage("licenseAgreement.koreanLanguagePopup"));
            this.mLicenseLanguageIcons[10] = new InvertableImageIcon(Resources.getImage("licenseAgreement.norwegianLanguagePopup"));
            this.mLicenseLanguageIcons[13] = new InvertableImageIcon(Resources.getImage("licenseAgreement.simplifiedChineseLanguagePopup"));
            this.mLicenseLanguageIcons[6] = new InvertableImageIcon(Resources.getImage("licenseAgreement.spanishLanguagePopup"));
            this.mLicenseLanguageIcons[12] = new InvertableImageIcon(Resources.getImage("licenseAgreement.swedishLanguagePopup"));
            this.mLicenseLanguageIcons[14] = new InvertableImageIcon(Resources.getImage("licenseAgreement.traditionalChineseLanguagePopup"));
            int index = 0;
            while (index < 15) {
                this.mLanguageSelectPopUp.addItem(this.mLicenseLanguageIcons[index]);
                ++index;
            }
            this.mLanguageSelectPopUp.addActionListener(new 4(this));
            this.mLanguageSelectPopUp.setRenderer(new LanguageMenuRenderer());
            this.mLanguageSelectPopUp.setMaximumRowCount(15);
        }

        public void switchLicenseAgreementUI(int languageIndex) {
            if (this.mLanguageSelectPopUp.getSelectedIndex() != languageIndex) {
                this.mLanguageSelectPopUp.setSelectedIndex(languageIndex);
            }
            JViewport viewport = this.mScrollPane.getViewport();
            switch (languageIndex) {
                case 11: {
                    if (this.brazilianPortugueseLabel == null) {
                        this.brazilianPortugueseLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.brazilianPortugueseLanguageAgreement")));
                        this.brazilianPortugueseYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.brazilianPortugueseButtonYes"));
                        this.brazilianPortugueseNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.brazilianPortugueseButtonNo"));
                    }
                    this.syncInterface(this.brazilianPortugueseLabel, this.brazilianPortugueseYesLabel, this.brazilianPortugueseNoLabel);
                    break;
                }
                case 7: {
                    if (this.danishLabel == null) {
                        this.danishLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.danishLanguageAgreement")));
                        this.danishYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.danishButtonYes"));
                        this.danishNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.danishButtonNo"));
                    }
                    this.syncInterface(this.danishLabel, this.danishYesLabel, this.danishNoLabel);
                    break;
                }
                case 0: {
                    if (this.dutchLabel == null) {
                        this.dutchLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.dutchLanguageAgreement")));
                        this.dutchYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.dutchButtonYes"));
                        this.dutchNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.dutchButtonNo"));
                    }
                    this.syncInterface(this.dutchLabel, this.dutchYesLabel, this.dutchNoLabel);
                    break;
                }
                case 1: {
                    if (this.englishLabel == null) {
                        this.englishLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.englishLanguageAgreement")));
                        this.englishYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.englishButtonYes"));
                        this.englishNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.englishButtonNo"));
                    }
                    this.syncInterface(this.englishLabel, this.englishYesLabel, this.englishNoLabel);
                    break;
                }
                case 8: {
                    if (this.finnishLabel == null) {
                        this.finnishLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.finnishLanguageAgreement")));
                        this.finnishYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.finnishButtonYes"));
                        this.finnishNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.finnishButtonNo"));
                    }
                    this.syncInterface(this.finnishLabel, this.finnishYesLabel, this.finnishNoLabel);
                    break;
                }
                case 2: {
                    if (this.frenchLabel == null) {
                        this.frenchLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.frenchLanguageAgreement")));
                        this.frenchYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.frenchButtonYes"));
                        this.frenchNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.frenchButtonNo"));
                    }
                    this.syncInterface(this.frenchLabel, this.frenchYesLabel, this.frenchNoLabel);
                    break;
                }
                case 3: {
                    if (this.germanLabel == null) {
                        this.germanLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.germanLanguageAgreement")));
                        this.germanYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.germanButtonYes"));
                        this.germanNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.germanButtonNo"));
                    }
                    this.syncInterface(this.germanLabel, this.germanYesLabel, this.germanNoLabel);
                    break;
                }
                case 4: {
                    if (this.italianLabel == null) {
                        this.italianLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.italianLanguageAgreement")));
                        this.italianYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.italianButtonYes"));
                        this.italianNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.italianButtonNo"));
                    }
                    this.syncInterface(this.italianLabel, this.italianYesLabel, this.italianNoLabel);
                    break;
                }
                case 5: {
                    if (this.japaneseLabel == null) {
                        this.japaneseLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.japaneseLanguageAgreement")));
                        this.japaneseYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.japaneseButtonYes"));
                        this.japaneseNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.japaneseButtonNo"));
                    }
                    this.syncInterface(this.japaneseLabel, this.japaneseYesLabel, this.japaneseNoLabel);
                    break;
                }
                case 9: {
                    if (this.koreanLabel == null) {
                        this.koreanLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.koreanLanguageAgreement")));
                        this.koreanYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.koreanButtonYes"));
                        this.koreanNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.koreanButtonNo"));
                    }
                    this.syncInterface(this.koreanLabel, this.koreanYesLabel, this.koreanNoLabel);
                    break;
                }
                case 10: {
                    if (this.norwegianLabel == null) {
                        this.norwegianLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.norwegianLanguageAgreement")));
                        this.norwegianYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.norwegianButtonYes"));
                        this.norwegianNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.norwegianButtonNo"));
                    }
                    this.syncInterface(this.norwegianLabel, this.norwegianYesLabel, this.norwegianNoLabel);
                    break;
                }
                case 13: {
                    if (this.simplifiedChineseLabel == null) {
                        this.simplifiedChineseLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.simplifiedChineseLanguageAgreement")));
                        this.simplifiedChineseYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.simplifiedChineseButtonYes"));
                        this.simplifiedChineseNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.simplifiedChineseButtonNo"));
                    }
                    this.syncInterface(this.simplifiedChineseLabel, this.simplifiedChineseYesLabel, this.simplifiedChineseNoLabel);
                    break;
                }
                case 6: {
                    if (this.spanishLabel == null) {
                        this.spanishLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.spanishLanguageAgreement")));
                        this.spanishYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.spanishButtonYes"));
                        this.spanishNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.spanishButtonNo"));
                    }
                    this.syncInterface(this.spanishLabel, this.spanishYesLabel, this.spanishNoLabel);
                    break;
                }
                case 12: {
                    if (this.swedishLabel == null) {
                        this.swedishLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.swedishLanguageAgreement")));
                        this.swedishYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.swedishButtonYes"));
                        this.swedishNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.swedishButtonNo"));
                    }
                    this.syncInterface(this.swedishLabel, this.swedishYesLabel, this.swedishNoLabel);
                    break;
                }
                case 14: {
                    if (this.traditionalChineseLabel == null) {
                        this.traditionalChineseLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.traditionalChineseLanguageAgreement")));
                        this.traditionalChineseYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.traditionalChineseButtonYes"));
                        this.traditionalChineseNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.traditionalChineseButtonNo"));
                    }
                    this.syncInterface(this.traditionalChineseLabel, this.traditionalChineseYesLabel, this.traditionalChineseNoLabel);
                    break;
                }
                default: {
                    this.syncInterface(null, null, null);
                }
            }
        }

        private void syncInterface(JLabel agreementImage, ImageIcon acceptIcon, ImageIcon declineIcon) {
            if (agreementImage != null) {
                this.mScrollPane.getViewport().setView(agreementImage);
            } else {
                this.mScrollPane.getViewport().setView(new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.defaultPath"))));
            }
            if (acceptIcon != null) {
                this.mAcceptButton.setIcon(acceptIcon);
                this.mAcceptButton.setMargin(new Insets(2, 10, 2, 10));
                this.mAcceptButton.setText(null);
            } else {
                this.mAcceptButton.setText(Resources.getString("licenseAgreement.acceptButton"));
                this.mAcceptButton.setMargin(null);
                this.mAcceptButton.setIcon(null);
            }
            if (declineIcon != null) {
                this.mDeclineButton.setIcon(declineIcon);
                this.mDeclineButton.setMargin(new Insets(2, 10, 2, 10));
                this.mDeclineButton.setText(null);
            } else {
                this.mDeclineButton.setText(Resources.getString("licenseAgreement.declineButton"));
                this.mDeclineButton.setMargin(null);
                this.mDeclineButton.setIcon(null);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(660, 400);
        }

        public JButton getAcceptButton() {
            return this.mAcceptButton;
        }

        public JButton getDeclineButton() {
            return this.mDeclineButton;
        }

        static /* synthetic */ JComboBox access$0(LicensePanel $0) {
            return $0.mLanguageSelectPopUp;
        }

        private class LanguageMenuRenderer
        extends DefaultListCellRenderer {
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ((InvertableImageIcon)((JLabel)retValue).getIcon()).setInverted(isSelected && index > -1);
                return retValue;
            }

            LanguageMenuRenderer() {
            }
        }

        private class InvertableImageIcon
        extends ImageIcon {
            final int marginX = 22;
            final int marginY = 1;
            Image invertedImage = null;
            boolean inverted = false;

            InvertableImageIcon(Image image) {
                super(image);
            }

            public int getIconWidth() {
                return super.getIconWidth() + 44;
            }

            public int getIconHeight() {
                return super.getIconHeight() + 2;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (this.invertedImage == null) {
                    this.invertedImage = c.createImage(new FilteredImageSource(this.getImage().getSource(), ImageUtilities.getInvertingFilterInstance()));
                    MediaTracker tracker = new MediaTracker(c);
                    tracker.addImage(this.invertedImage, 0);
                    try {
                        tracker.waitForAll();
                    }
                    catch (Exception exception) {}
                    tracker.removeImage(this.invertedImage);
                }
                if (this.inverted && this.invertedImage != null) {
                    g.drawImage(this.invertedImage, x + 22, y + 1, null);
                } else {
                    super.paintIcon(c, g, x + 22, y + 1);
                }
            }

            public void setInverted(boolean state) {
                this.inverted = state;
            }
        }
    }

    static class AboutAction
    extends AbstractAction
    implements ActionListener,
    MRJAboutHandler {
        public static final String COMMAND_KEY = "about";

        public AboutAction() {
            String name = Resources.getStringWithReplacement("application.menu.misc.about", new String[]{"appName", Resources.getString("appName")});
            this.putValue("Name", name);
            this.putValue("ActionCommandKey", COMMAND_KEY);
        }

        public void actionPerformed(ActionEvent e) {
            AboutBox about = AboutBox.getSharedInstance();
            about.setResizable(false);
            Utilities.setWindowLocationRelativeToComponent(about, monitorController.getMonitorWindow());
            about.show();
        }

        public void handleAbout() {
            this.actionPerformed(new ActionEvent(this, 1001, COMMAND_KEY));
        }
    }

    class QuitHandler
    implements ActionListener,
    MRJQuitHandler {
        public void actionPerformed(ActionEvent e) {
            if (monitorController != null && monitorController.monitorWindow != null) {
                monitorController.monitorWindow.updatePreferences();
            }
            System.exit(0);
        }

        public void handleQuit() {
            this.actionPerformed(new ActionEvent(this, 1001, "QUIT_MENU_ITEM_SELECTED"));
        }

        QuitHandler() {
        }
    }

    class PrefsHandler
    implements ActionListener,
    MRJPrefsHandler {
        public void actionPerformed(ActionEvent e) {
            PreferencesWindow prefs = PreferencesWindow.getSharedInstance();
            if (!prefs.isVisible()) {
                Utilities.setWindowLocationRelativeToComponent(prefs, monitorController.monitorWindow);
            }
            prefs.show();
        }

        public void handlePrefs() {
            this.actionPerformed(new ActionEvent(this, 1001, "PREFS_MENU_ITEM_SELECTED"));
        }

        PrefsHandler() {
        }
    }

    static class HelpListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                BrowserLauncher.openURL(Resources.getString("helpURL"));
            }
            catch (Exception exception) {}
        }

        HelpListener() {
        }
    }
}

