/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.TextField;
import com.apple.util.Gestalt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;

public class SelectableLabel
extends TextField {
    private static String ellipsis = "\u2026";
    private static int LABEL_WIDTH = 130;
    private String actualText = "";

    public SelectableLabel() {
        this(null);
    }

    public SelectableLabel(String text) {
        super(text);
        this.setEditable(false);
        this.setOpaque(false);
        if (Gestalt.isJava141OrLater) {
            this.setBorder(null);
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        }
        this.addComponentListener(new 1());
    }

    public void setText(String text) {
        this.actualText = text;
        super.setText(this.truncateText(text));
    }

    public Dimension getPreferredSize() {
        return new Dimension(LABEL_WIDTH, ((Component)this).getFontMetrics(this.getFont()).getHeight());
    }

    public Dimension getMinimumSize() {
        return new Dimension(LABEL_WIDTH, ((Component)this).getFontMetrics(this.getFont()).getHeight());
    }

    private String truncateText(String text) {
        FontMetrics metrics = ((Component)this).getFontMetrics(this.getFont());
        int displayWidth = this.getWidth();
        if (metrics.stringWidth(text) < displayWidth) {
            return text;
        }
        displayWidth -= metrics.stringWidth(ellipsis);
        String truncatedString = "";
        int currentLength = text.length();
        int index = 0;
        while (index < currentLength) {
            String nextChar = text.substring(index, index + 1);
            if (metrics.stringWidth(truncatedString) + metrics.stringWidth(nextChar) >= displayWidth) break;
            truncatedString = String.valueOf(truncatedString) + nextChar;
            ++index;
        }
        return String.valueOf(truncatedString.trim()) + ellipsis;
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            SelectableLabel.this.setText(SelectableLabel.this.actualText);
        }

        /* synthetic */ 1() {
        }
    }
}

