/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.SelectableLabel;
import com.apple.xsr.StatusIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SelectableStatusLabel
extends JPanel {
    public static final int NOT_INSTALLED = -2;
    public static final int NOT_APPLICABLE = -3;
    private JLabel iconLabel;
    private SelectableLabel textLabel;
    private static final int ICON_SIZE = 10;

    public SelectableStatusLabel() {
        GUIFactory.configureComponentForPlatform(this);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        this.iconLabel = new JLabel(StatusIcon.getSmallStatusIconInstance(-1));
        this.iconLabel.setVisible(false);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 4);
        this.addComponent(this.iconLabel, this, layout, constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        this.textLabel = new SelectableLabel();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        this.addComponent(this.textLabel, this, layout, constraints);
        constraints.weightx = 0.0;
    }

    public void setStatusAndText(int status, String inString) {
        this.setStatus(status);
        this.setText(inString);
    }

    public void setText(String inString) {
        this.textLabel.setText(inString);
    }

    public void setIcon(ImageIcon inIcon) {
        this.iconLabel.setIcon(inIcon);
    }

    public void setFont(Font inFont) {
        if (this.textLabel != null) {
            this.textLabel.setFont(inFont);
        }
    }

    public void setStatus(int status) {
        if (status == -1 || status == -3) {
            this.iconLabel.setVisible(false);
        } else {
            this.iconLabel.setIcon(StatusIcon.getSmallStatusIconInstance(status));
            this.iconLabel.setVisible(true);
        }
    }

    private void addComponent(Component component, Container container, GridBagLayout gbl, GridBagConstraints gbc) {
        gbl.setConstraints(component, gbc);
        container.add(component);
    }
}

