/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.Gestalt;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertListener;
import com.apple.xsr.DataModel;
import com.apple.xsr.ManagementFibreModel;
import com.apple.xsr.ManagementFibrePane;
import com.apple.xsr.ManagementNetworkModel;
import com.apple.xsr.ManagementNetworkPane;
import com.apple.xsr.ManagementPerformanceModel;
import com.apple.xsr.ManagementPerformancePane;
import com.apple.xsr.ManagementSystemModel;
import com.apple.xsr.ManagementSystemPane;
import com.apple.xsr.Resources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SetupPane
extends AbstractManagementPane
implements AquaAlertListener {
    public static final int SYSTEM_TAB = 0;
    public static final int NETWORK_TAB = 1;
    public static final int FIBRE_TAB = 2;
    public static final int PERFORMANCE_TAB = 3;
    private JFrame parent;
    public JTabbedPane tabbedPane;
    private boolean modified = false;
    private ManagementSystemPane systemPane;
    private ManagementNetworkPane networkPane;
    private ManagementFibrePane fibrePane;
    private ManagementPerformancePane performancePane;
    private JLabel restartIcon;
    private JLabel restartLabel;
    private static final int preferredWidth = 800;
    private static final int preferredHeight = 610;

    public SetupPane() {
        super(800, 610);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 1;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(1);
        this.tabbedPane.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(this.tabbedPane, this, layout, constraints);
        ++constraints.gridy;
        this.systemPane = new ManagementSystemPane(this);
        this.tabbedPane.addTab(Resources.getString("management.systemInfo"), this.systemPane);
        this.networkPane = new ManagementNetworkPane(this);
        this.tabbedPane.addTab(Resources.getString("management.network"), this.networkPane);
        this.fibrePane = new ManagementFibrePane(this);
        this.tabbedPane.addTab(Resources.getString("management.fibre"), this.fibrePane);
        this.performancePane = new ManagementPerformancePane(this);
        this.tabbedPane.addTab(Resources.getString("management.performance"), this.performancePane);
        this.networkPane.getGroupBox(1).linkPanel(this.fibrePane.getGroupBox(0));
        this.fibrePane.getGroupBox(1).linkPanel(this.performancePane.getGroupBox(0));
        JPanel buttonPane = GUIFactory.newPanel();
        buttonPane.setBorder(new EmptyBorder(0, 10, 0, 0));
        GridBagLayout buttonLayout = new GridBagLayout();
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonPane.setLayout(buttonLayout);
        buttonConstraints.gridx = 0;
        buttonConstraints.gridy = 0;
        buttonConstraints.gridwidth = 1;
        buttonConstraints.gridheight = 1;
        buttonConstraints.anchor = 17;
        buttonConstraints.fill = 1;
        this.restartIcon = new JLabel(new ImageIcon(Resources.getImage("icon.restart")));
        this.addComponent(this.restartIcon, buttonPane, buttonLayout, buttonConstraints);
        ++buttonConstraints.gridx;
        this.addComponent(Box.createHorizontalStrut(5), buttonPane, buttonLayout, buttonConstraints);
        ++buttonConstraints.gridx;
        this.restartLabel = new JLabel(Resources.getString("management.restartRequired"));
        this.restartLabel.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(this.restartLabel, buttonPane, buttonLayout, buttonConstraints);
        ++buttonConstraints.gridx;
        buttonConstraints.weightx = 1.0;
        this.addComponent(Box.createHorizontalStrut(0), buttonPane, buttonLayout, buttonConstraints);
        buttonConstraints.weightx = 0.0;
        ++buttonConstraints.gridx;
        JButton cancelButton = GUIFactory.newCancelButton();
        cancelButton.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(cancelButton, buttonPane, buttonLayout, buttonConstraints);
        ++buttonConstraints.gridx;
        cancelButton.addActionListener(new 1());
        this.addComponent(Box.createHorizontalStrut(10), buttonPane, buttonLayout, buttonConstraints);
        ++buttonConstraints.gridx;
        JButton applyButton = GUIFactory.newOKButton();
        applyButton.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(applyButton, buttonPane, buttonLayout, buttonConstraints);
        ++buttonConstraints.gridx;
        applyButton.addActionListener(new 2());
        if (!Gestalt.isAquaLookAndFeel) {
            constraints.insets = new Insets(10, 0, 0, 0);
        }
        this.addComponent(buttonPane, this, layout, constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        ++constraints.gridy;
        this.tabbedPane.addChangeListener(new 3());
        this.syncRestartMessage();
    }

    public void addNotify() {
        super.addNotify();
        this.parent = (JFrame)this.getTopLevelAncestor();
    }

    public void populateUI(DataModel data) {
        throw new UnsupportedOperationException();
    }

    public void populateUI(DataModel[] data) {
        if (data == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (data.length != this.tabbedPane.getTabCount()) {
            String msg = "data model array contains an invalid number of elements (" + data.length + " elements, expected " + this.tabbedPane.getTabCount() + ")";
            throw new IllegalArgumentException(msg);
        }
        int i = 0;
        while (i < data.length) {
            if (data[i] instanceof ManagementSystemModel) {
                this.systemPane.populate((ManagementSystemModel)data[i]);
            } else if (data[i] instanceof ManagementNetworkModel) {
                this.networkPane.populate((ManagementNetworkModel)data[i]);
            } else if (data[i] instanceof ManagementFibreModel) {
                this.fibrePane.populate((ManagementFibreModel)data[i]);
            } else if (data[i] instanceof ManagementPerformanceModel) {
                this.performancePane.populate((ManagementPerformanceModel)data[i]);
            } else {
                throw new IllegalArgumentException("illegal data model " + data[i].getClass());
            }
            ++i;
        }
    }

    public boolean validateUI(DataModel data) {
        throw new UnsupportedOperationException();
    }

    public boolean validateUI(DataModel[] data) {
        boolean result = true;
        if (data != null) {
            int tabCount = this.tabbedPane.getTabCount();
            if (data.length != tabCount) {
                String msg = "data model array contains an invalid number of elements (" + data.length + " elements, expected " + tabCount + ")";
                throw new IllegalArgumentException(msg);
            }
            boolean[] valid = new boolean[tabCount];
            int i = 0;
            while (i < valid.length) {
                valid[i] = false;
                ++i;
            }
            int i2 = 0;
            while (i2 < data.length) {
                if (data[i2] instanceof ManagementSystemModel) {
                    valid[0] = this.systemPane.validate((ManagementSystemModel)data[i2]);
                } else if (data[i2] instanceof ManagementNetworkModel) {
                    valid[1] = this.networkPane.validate((ManagementNetworkModel)data[i2]);
                } else if (data[i2] instanceof ManagementFibreModel) {
                    valid[2] = this.fibrePane.validate((ManagementFibreModel)data[i2]);
                } else if (data[i2] instanceof ManagementPerformanceModel) {
                    valid[3] = this.performancePane.validate((ManagementPerformanceModel)data[i2]);
                } else {
                    throw new IllegalArgumentException("illegal data model " + data[i2].getClass());
                }
                ++i2;
            }
            int firstInvalidPane = -1;
            int i3 = 0;
            while (i3 < valid.length) {
                if (!valid[i3]) {
                    firstInvalidPane = i3;
                    break;
                }
                ++i3;
            }
            if (firstInvalidPane != -1) {
                if (valid[this.tabbedPane.getSelectedIndex()]) {
                    this.tabbedPane.setSelectedIndex(firstInvalidPane);
                }
                this.showValidationAlert();
                result = false;
            } else {
                result = true;
            }
        }
        return result;
    }

    public void aquaAlertWillBeShown(Object contextInfo) {
    }

    public void aquaAlertResized(Object contextInfo) {
    }

    public void aquaAlertSheetVisible(Object contextInfo) {
    }

    public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
        if (buttonPressIdentifier == 1) {
            ActionEvent event = new ActionEvent(this, 1001, "APPLY");
            this.fireActionPerformed(event);
        } else if (buttonPressIdentifier == 2) {
            ActionEvent event = new ActionEvent(this, 1001, "CANCEL");
            this.fireActionPerformed(event);
        }
    }

    public boolean allowAquaAlertToBeDismissed(int ignoredButtonIdentifier, Object ignoredContext) {
        return true;
    }

    void syncRestartMessage() {
        boolean needsRestart = false;
        Component component = this.tabbedPane.getSelectedComponent();
        if (component instanceof ManagementSystemPane) {
            needsRestart = true;
        } else if (component instanceof ManagementNetworkPane) {
            needsRestart = true;
        } else if (component instanceof ManagementFibrePane) {
            needsRestart = true;
        }
        this.restartIcon.setVisible(needsRestart);
        this.restartLabel.setVisible(needsRestart);
    }

    public void setModified() {
        this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
        this.modified = true;
    }

    public void confirmCancel() {
        if (this.modified) {
            AquaAlert theAlert = AquaAlert.createStandardAquaAlert(Resources.getString("management.unsaved.title"), Resources.getString("management.unsaved.message"), Resources.getImage("icon.application"), Resources.getString("management.unsaved.applyButton"), Resources.getString("management.unsaved.dontApplyButton"), null);
            theAlert.showSheet(this.parent, this, null);
        } else {
            ActionEvent event = new ActionEvent(this, 1001, "CANCEL");
            this.fireActionPerformed(event);
        }
    }

    private void showValidationAlert() {
        AquaAlert theAlert = AquaAlert.createStandardAquaAlert(Resources.getString("management.validation.title"), Resources.getString("management.validation.message"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        theAlert.showSheet(this.parent, null, null);
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SetupPane.this.confirmCancel();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(SetupPane.this, 1001, "APPLY");
            SetupPane.this.fireActionPerformed(event);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            SetupPane.this.systemPane.validate(null);
            SetupPane.this.networkPane.validate(null);
            SetupPane.this.fibrePane.validate(null);
            SetupPane.this.performancePane.validate(null);
            SetupPane.this.syncRestartMessage();
        }

        /* synthetic */ 3() {
        }
    }
}

