/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.xsr.SystemRegistryEvent;
import com.apple.xsr.SystemRegistryListener;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.SystemObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import javax.swing.event.EventListenerList;

public class SystemRegistry
implements SystemObserver {
    protected List list = Collections.synchronizedList(new ArrayList());
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$com$apple$xsr$SystemRegistryListener;

    public void add(RaidSystem system) {
        system.addObserver(this);
        this.list.add(system);
        this.fireSystemAdded(system);
    }

    public void remove(String name) {
        List list = this.list;
        synchronized (list) {
            Iterator i = this.list.iterator();
            while (i.hasNext()) {
                RaidSystem system = (RaidSystem)i.next();
                if (!system.getName().equals(name)) continue;
                this.remove(system);
                break;
            }
        }
    }

    public void remove(RaidSystem system) {
        RaidSystem[] systems = new RaidSystem[]{system};
        this.remove(systems);
    }

    public void remove(RaidSystem[] systems) {
        int i = 0;
        while (i < systems.length) {
            systems[i].deleteObserver(this);
            this.list.remove(systems[i]);
            ++i;
        }
        this.fireSystemRemoved(systems);
    }

    public int getSystemCount() {
        return this.list.size();
    }

    public RaidSystem getSystem(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.list.size()) {
            throw new IndexOutOfBoundsException("index = " + index);
        }
        return (RaidSystem)this.list.get(index);
    }

    public Collection getSystems() {
        return Collections.unmodifiableCollection(this.list);
    }

    public void addSystemRegistryListener(SystemRegistryListener listener) {
        this.listenerList.add(class$com$apple$xsr$SystemRegistryListener != null ? class$com$apple$xsr$SystemRegistryListener : (class$com$apple$xsr$SystemRegistryListener = SystemRegistry.class$("com.apple.xsr.SystemRegistryListener")), listener);
    }

    public void removeSystemRegistryListener(SystemRegistryListener listener) {
        this.listenerList.remove(class$com$apple$xsr$SystemRegistryListener != null ? class$com$apple$xsr$SystemRegistryListener : (class$com$apple$xsr$SystemRegistryListener = SystemRegistry.class$("com.apple.xsr.SystemRegistryListener")), listener);
    }

    public void update(Observable system, Object arg) {
        RaidSystem[] systems = new RaidSystem[]{(RaidSystem)system};
        this.fireSystemUpdated(systems);
    }

    protected void fireSystemAdded(RaidSystem system) {
        if (system == null) {
            throw new NullPointerException("system cannot be null");
        }
        RaidSystem[] systems = new RaidSystem[]{system};
        this.fireRegistryChanged(new SystemRegistryEvent(this, 0, systems));
    }

    protected void fireSystemRemoved(RaidSystem[] systems) {
        if (systems == null) {
            throw new NullPointerException("systems cannot be null");
        }
        if (systems.length == 0) {
            throw new IllegalArgumentException("systems must contain at least one system object");
        }
        this.fireRegistryChanged(new SystemRegistryEvent(this, 1, systems));
    }

    protected void fireSystemUpdated(RaidSystem[] systems) {
        if (systems == null) {
            throw new NullPointerException("systems cannot be null");
        }
        if (systems.length == 0) {
            throw new IllegalArgumentException("systems must contain at least one system object");
        }
        this.fireRegistryChanged(new SystemRegistryEvent(this, 2, systems));
    }

    protected void fireRegistryChanged(SystemRegistryEvent event) {
        if (event == null) {
            throw new NullPointerException("event cannot be null");
        }
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$apple$xsr$SystemRegistryListener != null ? class$com$apple$xsr$SystemRegistryListener : SystemRegistry.class$("com.apple.xsr.SystemRegistryListener"))) {
                ((SystemRegistryListener)listeners[i + 1]).registryChanged(event);
            }
            i -= 2;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

