/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.advanced;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.ChooserButtonPanel;
import com.apple.xsr.DataModel;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.advanced.AdvancedExpansionModel;
import com.apple.xsr.advanced.AdvancedPane;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;

public class AdvancedExpansionPane
extends AbstractManagementPane {
    private final AdvancedPane parent;
    DriveSelectionPanel drivePanel;
    JLabel legendLabel;
    ArraySelectionPanel legend;
    RadioButtonGroup driveCountRadioGroup;
    JRadioButton[] driveRadioButton;
    int driveCount;
    StepByStepPanel summaryHeader;
    JTextPane summaryLabel;
    JCheckBox confirmCheckBox;
    private static final String TAG = "ADVANCED_EXPANSION";
    private static final int PREFERRED_WIDTH = 663;
    private static final int PREFERRED_HEIGHT = 437;
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static final int LEFT_INDENT = 20;
    private static final int STEP_VSPACE = 15;
    static /* synthetic */ Class class$com$apple$xsr$advanced$AdvancedExpansionModel;

    public AdvancedExpansionPane(AdvancedPane parent) {
        super(663, 437);
        this.parent = parent;
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 2;
        StepByStepPanel summaryHeader = new StepByStepPanel(Resources.getImage("icon.step.five"), Resources.getString("advanced.expansion.summary"));
        this.summaryLabel = GUIFactory.newTextPane(Resources.getString("advanced.expansion.summary.cannot.general"), 2);
        ChooserButtonPanel buttons = new ChooserButtonPanel(true);
        buttons.backButton.addActionListener(new 1());
        buttons.cancelButton.addActionListener(new 2());
        buttons.okButton.setText(Resources.getString("advanced.expansion.defaultButton"));
        buttons.okButton.addActionListener(new 3());
        StepByStepPanel stepOne = new StepByStepPanel(Resources.getImage("icon.step.one"), Resources.getString("advanced.expansion.selectArray"));
        this.addComponent(stepOne, this, layout, constraints);
        ++constraints.gridy;
        DriveInformationPanel driveInfo = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        JPanel driveGroup = GUIFactory.newPanel();
        GridBagLayout driveGroupLayout = new GridBagLayout();
        driveGroup.setLayout(driveGroupLayout);
        GridBagConstraints driveGroupConstraints = new GridBagConstraints();
        driveGroupConstraints.anchor = 17;
        driveGroupConstraints.fill = 2;
        driveGroupConstraints.gridx = 1;
        driveGroupConstraints.gridy = 0;
        driveGroupConstraints.fill = 1;
        driveGroupConstraints.insets = new Insets(0, 0, 6, 0);
        driveGroupConstraints.weightx = 1.0;
        this.addComponent(driveInfo, driveGroup, driveGroupLayout, driveGroupConstraints);
        driveGroupConstraints.weightx = 0.0;
        driveGroupConstraints.insets = ZERO_INSETS;
        driveGroupConstraints.fill = 0;
        this.drivePanel = new DriveSelectionPanel(5, driveInfo, summaryHeader, this.summaryLabel, buttons.okButton);
        driveGroupConstraints.gridx = 0;
        driveGroupConstraints.gridy = 0;
        driveGroupConstraints.insets = new Insets(0, 0, 0, 20);
        this.addComponent(this.drivePanel, driveGroup, driveGroupLayout, driveGroupConstraints);
        driveGroupConstraints.insets = ZERO_INSETS;
        constraints.insets = new Insets(0, 20, 15, 0);
        this.addComponent(driveGroup, this, layout, constraints);
        constraints.insets = ZERO_INSETS;
        ++constraints.gridy;
        this.legendLabel = new JLabel(Resources.getString("advanced.expansion.legendNote"));
        this.legendLabel.setVisible(false);
        this.legendLabel.setFont(GUIFactory.FONT_SMALL);
        constraints.insets = new Insets(0, 22, 0, 0);
        this.addComponent(this.legendLabel, this, layout, constraints);
        constraints.insets = ZERO_INSETS;
        ++constraints.gridy;
        this.legend = new ArraySelectionPanel(1);
        constraints.insets = new Insets(0, 20, 15, 0);
        constraints.fill = 0;
        this.addComponent(this.legend, this, layout, constraints);
        constraints.fill = 2;
        constraints.insets = ZERO_INSETS;
        ++constraints.gridy;
        this.legend.addPropertyChangeListener("ArrayIndex", new 4());
        this.drivePanel.addPropertyChangeListener("ArrayIndex", new 5());
        JPanel driveCountPanel = GUIFactory.newPanel();
        driveCountPanel.setOpaque(true);
        GridBagLayout driveCountLayout = new GridBagLayout();
        driveCountPanel.setLayout(driveCountLayout);
        GridBagConstraints driveCountConstraints = new GridBagConstraints();
        driveCountConstraints.gridwidth = 1;
        driveCountConstraints.anchor = 17;
        driveCountConstraints.fill = 0;
        this.driveRadioButton = new JRadioButton[5];
        this.driveCountRadioGroup = new RadioButtonGroup();
        driveCountConstraints.gridx = 0;
        driveCountConstraints.gridy = 0;
        JLabel driveCountLabel = new JLabel(Resources.getString("advanced.expansion.drivesToAdd"));
        driveCountLabel.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(driveCountLabel, driveCountPanel, driveCountLayout, driveCountConstraints);
        ++driveCountConstraints.gridx;
        driveCountConstraints.insets = new Insets(0, 5, 0, 10);
        int index = 1;
        while (index <= 5) {
            int count = index;
            this.driveRadioButton[index - 1] = GUIFactory.newRadioButton(String.valueOf(index));
            this.driveRadioButton[index - 1].setFont(GUIFactory.FONT_SMALL);
            this.driveCountRadioGroup.add(this.driveRadioButton[index - 1]);
            this.addComponent(this.driveRadioButton[index - 1], driveCountPanel, driveCountLayout, driveCountConstraints);
            ++driveCountConstraints.gridx;
            this.driveRadioButton[index - 1].addActionListener(new 6(count, this));
            ++index;
        }
        driveCountConstraints.insets = new Insets(0, 0, 0, 0);
        driveCountConstraints.weightx = 1.0;
        this.addComponent(Box.createHorizontalStrut(0), driveCountPanel, driveCountLayout, driveCountConstraints);
        driveCountConstraints.weightx = 0.0;
        ++driveCountConstraints.gridx;
        constraints.insets = new Insets(0, 20, 15, 0);
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.addComponent(driveCountPanel, this, layout, constraints);
        constraints.weightx = 0.0;
        constraints.insets = ZERO_INSETS;
        ++constraints.gridy;
        StepByStepPanel stepTwo = new StepByStepPanel(Resources.getImage("icon.step.two"), Resources.getString("advanced.expansion.confirmation"));
        this.addComponent(stepTwo, this, layout, constraints);
        ++constraints.gridy;
        JPanel confirmGroup = GUIFactory.newPanel();
        GridBagLayout confirmGroupLayout = new GridBagLayout();
        confirmGroup.setLayout(confirmGroupLayout);
        GridBagConstraints confirmGroupConstraints = new GridBagConstraints();
        confirmGroupConstraints.gridwidth = 1;
        confirmGroupConstraints.anchor = 17;
        confirmGroupConstraints.fill = 2;
        int optionsRow = 0;
        this.confirmCheckBox = GUIFactory.newCheckBox(Resources.getString("advanced.expansion.iUnderstand"));
        this.confirmCheckBox.setFont(GUIFactory.FONT_SMALL);
        confirmGroupConstraints.gridx = 0;
        confirmGroupConstraints.gridy = optionsRow++;
        this.addComponent(this.confirmCheckBox, confirmGroup, confirmGroupLayout, confirmGroupConstraints);
        this.confirmCheckBox.addActionListener(new 7());
        constraints.insets = new Insets(0, 20, 15, 0);
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.weightx = 1.0;
        this.addComponent(confirmGroup, this, layout, constraints);
        constraints.weightx = 0.0;
        constraints.insets = ZERO_INSETS;
        constraints.fill = 2;
        ++constraints.gridy;
        this.addComponent(summaryHeader, this, layout, constraints);
        ++constraints.gridy;
        JPanel summaryGroup = GUIFactory.newPanel();
        GridBagLayout summaryGroupLayout = new GridBagLayout();
        summaryGroup.setLayout(summaryGroupLayout);
        GridBagConstraints summaryGroupConstraints = new GridBagConstraints();
        summaryGroupConstraints.anchor = 17;
        summaryGroupConstraints.fill = 2;
        this.summaryLabel.setFont(GUIFactory.FONT_SMALL);
        this.summaryLabel.setEditable(false);
        this.summaryLabel.setOpaque(false);
        summaryGroupConstraints.weightx = 1.0;
        summaryGroupConstraints.weighty = 1.0;
        summaryGroupConstraints.fill = 1;
        this.addComponent(this.summaryLabel, summaryGroup, summaryGroupLayout, summaryGroupConstraints);
        ++constraints.gridy;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 20, 15, 0);
        this.addComponent(summaryGroup, this, layout, constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.insets = ZERO_INSETS;
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.addComponent(Box.createVerticalStrut(0), this, layout, constraints);
        constraints.weighty = 0.0;
        ++constraints.gridy;
        constraints.fill = 2;
        this.addComponent(buttons, this, layout, constraints);
        constraints.fill = 0;
        this.setSize(this.getPreferredSize());
    }

    void syncDriveCountRadioButtons() {
        int available = this.drivePanel.getAvailableDriveCount();
        int count = this.driveCount;
        int index = 0;
        while (index < 5) {
            boolean enable = index < available;
            this.driveRadioButton[index].setEnabled(enable);
            if (!enable && this.driveRadioButton[index].isSelected()) {
                this.driveCountRadioGroup.remove(this.driveRadioButton[index]);
                this.driveRadioButton[index].setSelected(false);
                this.driveCountRadioGroup.add(this.driveRadioButton[index]);
                count = 0;
            }
            ++index;
        }
        if (count > 0) {
            this.driveRadioButton[count - 1].setSelected(true);
        }
        this.drivePanel.setSelectedDriveCount(count);
    }

    public void populateUI(DataModel data) {
        if (data.getClass() != (class$com$apple$xsr$advanced$AdvancedExpansionModel != null ? class$com$apple$xsr$advanced$AdvancedExpansionModel : (class$com$apple$xsr$advanced$AdvancedExpansionModel = AdvancedExpansionPane.class$("com.apple.xsr.advanced.AdvancedExpansionModel")))) {
            throw new IllegalArgumentException("illegal data model type " + data.getClass());
        }
        if (data != null) {
            AdvancedExpansionModel model = (AdvancedExpansionModel)data;
            this.drivePanel.setRaidSystem(model.getRaidSystem());
            this.legend.setRaidSystem(model.getRaidSystem());
        }
        this.validateUI((DataModel)null);
    }

    public boolean validateUI(DataModel data) {
        if (data != null) {
            AdvancedExpansionModel model = (AdvancedExpansionModel)data;
            model.setArrayIndex(this.drivePanel.getArrayIndex());
            model.setDriveStates(this.drivePanel.getDriveStates());
        }
        return true;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(Resources.getImage("icon.expansion"));
    }

    public String getTitle() {
        return Resources.getString("advanced.expansion");
    }

    public String getExplanation() {
        return Resources.getString("advanced.expansionExplanation");
    }

    public String getTag() {
        return TAG;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AdvancedExpansionPane.this.parent.goBackToChooser();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(AdvancedExpansionPane.this.parent, 1001, "CANCEL");
            AdvancedExpansionPane.this.parent.fireActionPerformed(event);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(AdvancedExpansionPane.this, 1001, "APPLY");
            AdvancedExpansionPane.this.parent.fireActionPerformed(event);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            int value = (Integer)e.getNewValue();
            AdvancedExpansionPane.this.drivePanel.setArrayIndex(value);
            AdvancedExpansionPane.this.syncDriveCountRadioButtons();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            int value = (Integer)e.getNewValue();
            AdvancedExpansionPane.this.legend.setArrayIndex(value);
            AdvancedExpansionPane.this.syncDriveCountRadioButtons();
        }

        /* synthetic */ 5() {
        }
    }

    private static final class 6
    implements ActionListener {
        private final /* synthetic */ int val$count;
        private final /* synthetic */ AdvancedExpansionPane this$0;

        public void actionPerformed(ActionEvent e) {
            this.this$0.driveCount = this.val$count;
            this.this$0.drivePanel.setSelectedDriveCount(this.val$count);
        }

        /* synthetic */ 6(int val$count, AdvancedExpansionPane this$0) {
            this.val$count = val$count;
            this.this$0 = this$0;
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            boolean selected = AdvancedExpansionPane.this.confirmCheckBox.isSelected();
            AdvancedExpansionPane.this.drivePanel.setConfirmed(selected);
        }

        /* synthetic */ 7() {
        }
    }
}

