/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.advanced;

import com.apple.gui.AlternatingTable;
import com.apple.gui.GUIFactory;
import com.apple.gui.RestrictedTextField;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.AquaTableCellBorder;
import com.apple.xsr.ChooserButtonPanel;
import com.apple.xsr.DataModel;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.advanced.AdvancedMaskingModel;
import com.apple.xsr.advanced.AdvancedMaskingPane;
import com.apple.xsr.advanced.AdvancedPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class AdvancedMaskingPane
extends AbstractManagementPane {
    private final AdvancedPane parent;
    private JPanel controllerSelector;
    private RadioButtonGroup controllerRadioButtonGroup;
    private JCheckBox lunEnable;
    private HostModel hostModel;
    private LUNModel lunModel;
    private AlternatingTable hostTable;
    private AlternatingTable lunTable;
    private JScrollPane hostScrollPane;
    private JScrollPane lunScrollPane;
    private JButton addButton;
    private JButton removeButton;
    private JButton allOnButton;
    private JButton allOffButton;
    private JButton copyButton;
    private JButton pasteButton;
    private ChooserButtonPanel buttons;
    private int controller = 0;
    private boolean[] enabled = new boolean[2];
    private ArrayList[] wwpNames = new ArrayList[2];
    private ArrayList[] lunIDs = new ArrayList[2];
    private ArrayList[] lunNames = new ArrayList[2];
    private ArrayList[] lunDescriptions = new ArrayList[2];
    private ArrayList[] lunVisible = new ArrayList[2];
    private BitSet nullBitSet = new BitSet();
    private boolean paneEnabled = true;
    private static final int MAX_HOST_COUNT = 8;
    private static final int COLUMN_HOST = 0;
    private static final int COLUMN_LUN_CHECKBOX = 0;
    private static final int COLUMN_LUN_NAME = 1;
    private static final int COLUMN_LUN_DESCRIPTION = 2;
    private static final String TAG = "ADVANCED_MASKING";
    private static final int PREFERRED_WIDTH = 663;
    private static final int PREFERRED_HEIGHT = 437;
    private static final Insets LABEL_INSETS = new Insets(0, 0, 16, 0);
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$advanced$AdvancedMaskingPane != null ? class$com$apple$xsr$advanced$AdvancedMaskingPane : (class$com$apple$xsr$advanced$AdvancedMaskingPane = AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane")));
    static /* synthetic */ Class class$com$apple$xsr$advanced$AdvancedMaskingPane;
    static /* synthetic */ Class class$com$apple$xsr$advanced$AdvancedMaskingModel;
    static /* synthetic */ Class class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    AdvancedMaskingPane(AdvancedPane parent) {
        super(663, 437);
        this.parent = parent;
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        this.controllerSelector = GUIFactory.newPanel();
        JLabel controllerLabel = new JLabel(Resources.getString("advanced.masking.selectController"));
        this.controllerSelector.add(controllerLabel);
        this.controllerRadioButtonGroup = new RadioButtonGroup();
        JRadioButton upperControllerRadioButton = GUIFactory.newRadioButton(Resources.getString("advanced.masking.upperController"), true);
        upperControllerRadioButton.addActionListener(new 1());
        this.controllerSelector.add(upperControllerRadioButton);
        this.controllerRadioButtonGroup.add(upperControllerRadioButton);
        JRadioButton lowerControllerRadioButton = GUIFactory.newRadioButton(Resources.getString("advanced.masking.lowerController"), false);
        lowerControllerRadioButton.addActionListener(new 2());
        this.controllerSelector.add(lowerControllerRadioButton);
        this.controllerRadioButtonGroup.add(lowerControllerRadioButton);
        constraints.gridwidth = 3;
        constraints.insets = new Insets(0, 0, 20, 0);
        this.addComponent(this.controllerSelector, this, layout, constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        this.lunEnable = GUIFactory.newCheckBox(Resources.getString("advanced.masking.enable"));
        this.lunEnable.addActionListener(new 3());
        constraints.gridwidth = 1;
        constraints.insets = LABEL_INSETS;
        this.addComponent(this.lunEnable, this, layout, constraints);
        constraints.insets = ZERO_INSETS;
        constraints.gridwidth = 1;
        ++constraints.gridy;
        this.hostModel = new HostModel();
        this.hostTable = new AlternatingTable(this.hostModel);
        this.hostTable.setSelectionModel(new SelectionModel());
        this.updateTableKeyBindings();
        this.hostTable.setRowSelectionAllowed(true);
        this.hostTable.setColumnSelectionAllowed(false);
        this.hostTable.setRowHeight(22);
        this.hostTable.getSelectionModel().setSelectionMode(0);
        this.hostTable.setAutoResizeMode(3);
        this.hostScrollPane = new JScrollPane(this.hostTable);
        this.hostScrollPane.setVerticalScrollBarPolicy(22);
        this.hostScrollPane.setHorizontalScrollBarPolicy(32);
        constraints.fill = 1;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        this.addComponent(this.hostScrollPane, this, layout, constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        ++constraints.gridx;
        this.hostTable.getModel().addTableModelListener(new 4());
        this.hostTable.getSelectionModel().addListSelectionListener(new 5());
        TableColumn hostColumn = this.hostTable.getColumnModel().getColumn(0);
        hostColumn.setCellRenderer(new HostRenderer());
        HostEditor hostEditor = new HostEditor(this.hostTable);
        hostColumn.setCellEditor(hostEditor);
        hostEditor.addCellEditorListener(new 6());
        constraints.gridy = 1;
        this.addComponent(Box.createHorizontalStrut(16), this, layout, constraints);
        ++constraints.gridx;
        JLabel lunLabel = new JLabel(Resources.getString("advanced.masking.choose"));
        constraints.insets = LABEL_INSETS;
        this.addComponent(lunLabel, this, layout, constraints);
        constraints.insets = ZERO_INSETS;
        ++constraints.gridy;
        this.lunModel = new LUNModel();
        this.lunTable = new AlternatingTable(this.lunModel);
        this.lunTable.setRowSelectionAllowed(false);
        this.lunTable.setColumnSelectionAllowed(false);
        this.lunTable.setRowHeight(22);
        this.lunTable.setAutoResizeMode(3);
        this.lunScrollPane = new JScrollPane(this.lunTable);
        this.lunScrollPane.setVerticalScrollBarPolicy(22);
        this.lunScrollPane.setHorizontalScrollBarPolicy(32);
        constraints.fill = 1;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        this.addComponent(this.lunScrollPane, this, layout, constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.gridx = 0;
        ++constraints.gridy;
        TableColumn visibleColumn = this.lunTable.getColumnModel().getColumn(0);
        visibleColumn.setResizable(false);
        visibleColumn.setMaxWidth(32);
        visibleColumn.setMinWidth(32);
        visibleColumn.setCellRenderer(new VisibleRenderer(this.lunTable));
        visibleColumn.setCellEditor(new VisibleEditor(this.lunTable));
        TableColumn nameColumn = this.lunTable.getColumnModel().getColumn(1);
        nameColumn.setResizable(false);
        nameColumn.setMaxWidth(80);
        nameColumn.setMinWidth(80);
        constraints.gridx = 0;
        JPanel addRemovePanel = GUIFactory.newPanel();
        addRemovePanel.setLayout(new GridLayout(1, 2));
        this.addButton = GUIFactory.newButton(Resources.getString("advanced.masking.host.add"));
        this.addButton.addActionListener(new 7());
        addRemovePanel.add(this.addButton);
        this.removeButton = GUIFactory.newButton(Resources.getString("advanced.masking.host.remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.setVerifyInputWhenFocusTarget(false);
        this.removeButton.addActionListener(new 8());
        addRemovePanel.add(this.removeButton);
        this.addComponent(addRemovePanel, this, layout, constraints);
        ++constraints.gridx;
        ++constraints.gridx;
        JPanel onOffPanel = GUIFactory.newPanel();
        onOffPanel.setLayout(new GridLayout(1, 4));
        this.allOnButton = GUIFactory.newButton(Resources.getString("advanced.masking.all.on"));
        this.allOnButton.setEnabled(false);
        this.allOnButton.addActionListener(new 9());
        onOffPanel.add(this.allOnButton);
        this.allOffButton = GUIFactory.newButton(Resources.getString("advanced.masking.all.off"));
        this.allOffButton.setEnabled(false);
        this.allOffButton.addActionListener(new 10());
        onOffPanel.add(this.allOffButton);
        this.copyButton = GUIFactory.newButton(Resources.getString("advanced.masking.copy"));
        this.copyButton.setEnabled(false);
        this.copyButton.addActionListener(new 11());
        onOffPanel.add(this.copyButton);
        this.pasteButton = GUIFactory.newButton(Resources.getString("advanced.masking.paste"));
        this.pasteButton.setEnabled(false);
        this.pasteButton.addActionListener(new 12());
        onOffPanel.add(this.pasteButton);
        this.addComponent(onOffPanel, this, layout, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.addComponent(Box.createVerticalStrut(16), this, layout, constraints);
        ++constraints.gridy;
        this.buttons = new ChooserButtonPanel(true);
        this.buttons.setRestartRequiredLabelVisible(true);
        this.buttons.backButton.addActionListener(new 13());
        this.buttons.cancelButton.setVerifyInputWhenFocusTarget(false);
        this.buttons.cancelButton.addActionListener(new 14());
        this.buttons.okButton.addActionListener(new 15());
        constraints.fill = 2;
        constraints.gridwidth = 3;
        this.addComponent(this.buttons, this, layout, constraints);
        constraints.gridwidth = 1;
        constraints.fill = 0;
    }

    void setPaneEnabled(boolean enable) {
        this.paneEnabled = enable;
        this.hostTable.setEnabled(enable);
        this.lunEnable.setEnabled(enable);
        this.addButton.setEnabled(enable);
        this.buttons.okButton.setEnabled(enable);
        if (!enable) {
            this.removeButton.setEnabled(enable);
            this.allOnButton.setEnabled(enable);
            this.allOffButton.setEnabled(enable);
            this.copyButton.setEnabled(enable);
            this.pasteButton.setEnabled(enable);
        }
    }

    private void updateTableKeyBindings() {
        InputMap inputMap = this.hostTable.getInputMap(1);
        ActionMap actionMap = this.hostTable.getActionMap();
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0);
        Object cancelBinding = null;
        if (inputMap != null) {
            cancelBinding = inputMap.get(escKeyStroke);
        }
        if (actionMap != null && cancelBinding != null) {
            ActionListener cancelAction = this.hostTable.getActionForKeyStroke(escKeyStroke);
            actionMap.put(cancelBinding, new CancelEditingAction(this.hostTable, cancelAction));
        }
    }

    public void populateForController(int index) {
        if (this.hostTable.getEditingRow() != -1) {
            this.hostTable.getCellEditor().stopCellEditing();
        }
        this.controller = index;
        this.lunEnable.setSelected(this.enabled[this.controller]);
        this.hostModel.setNamesAndVisible(this.wwpNames[this.controller], this.lunVisible[this.controller]);
        this.lunModel.setLists(this.lunIDs[this.controller], this.lunNames[this.controller], this.lunDescriptions[this.controller]);
    }

    public void populateUI(DataModel data) {
        if (data.getClass() != (class$com$apple$xsr$advanced$AdvancedMaskingModel != null ? class$com$apple$xsr$advanced$AdvancedMaskingModel : (class$com$apple$xsr$advanced$AdvancedMaskingModel = AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingModel")))) {
            throw new IllegalArgumentException("illegal data model type " + data.getClass());
        }
        if (data != null) {
            AdvancedMaskingModel model = (AdvancedMaskingModel)data;
            int controllers = model.getControllers();
            this.controllerSelector.setVisible(controllers > 1);
            int group = 0;
            while (group < controllers) {
                AdvancedMaskingModel.AdvancedMaskingControllerModel controllerModel = group == 0 ? model.getUpperControllerModel() : model.getLowerControllerModel();
                this.enabled[group] = controllerModel.getLUNMaskEnabled();
                this.wwpNames[group] = controllerModel.getWWPName();
                this.lunIDs[group] = controllerModel.getLUNIDs();
                this.lunNames[group] = controllerModel.getLUNNames();
                this.lunDescriptions[group] = controllerModel.getLUNDescriptions();
                this.lunVisible[group] = controllerModel.getLUNVisible();
                ++group;
            }
            this.populateForController(0);
        }
        this.validateUI((DataModel)null);
    }

    public boolean validateUI(DataModel data) {
        if (data != null) {
            AdvancedMaskingModel model = (AdvancedMaskingModel)data;
            int controllers = model.getControllers();
            int group = 0;
            while (group < controllers) {
                AdvancedMaskingModel.AdvancedMaskingControllerModel controllerModel = group == 0 ? model.getUpperControllerModel() : model.getLowerControllerModel();
                controllerModel.setLUNMaskEnabled(new Boolean(this.enabled[group]));
                controllerModel.setWWPName(this.wwpNames[group]);
                controllerModel.setLUNVisible(this.lunVisible[group]);
                ++group;
            }
        }
        return true;
    }

    public boolean allowAbort() {
        logger.debug("Allow abort called");
        TableCellEditor editor = this.hostTable.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        return true;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(Resources.getImage("icon.masking"));
    }

    public String getTitle() {
        return Resources.getString("advanced.masking");
    }

    public String getExplanation() {
        return Resources.getString("advanced.maskingExplanation");
    }

    public String getTag() {
        return TAG;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static class CancelEditingAction
    extends AbstractAction {
        JTable table;
        ActionListener originalAction;

        public CancelEditingAction(JTable table, ActionListener originalAction) {
            this.table = table;
            this.originalAction = originalAction;
        }

        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = this.table.getCellEditor();
            if (editor != null) {
                editor.cancelCellEditing();
            }
            if (this.originalAction != null) {
                this.originalAction.actionPerformed(e);
            }
        }
    }

    static class VisibleRenderer
    extends JPanel
    implements TableCellRenderer {
        private JTable table;
        public JCheckBox checkbox;
        AquaTableCellBorder border;

        public VisibleRenderer(JTable table) {
            this.table = table;
            this.setLayout(new GridLayout(1, 1, 0, 0));
            this.border = new AquaTableCellBorder();
            this.setBorder(this.border);
            this.checkbox = GUIFactory.newCheckBox();
            this.checkbox.setOpaque(false);
            this.add(this.checkbox);
            this.checkbox.addActionListener(new 16(this));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.checkbox.setEnabled(value != null);
            this.checkbox.setSelected(value != null && value.equals(Boolean.TRUE));
            this.border.setAttributes(false, false, row);
            return this;
        }

        static /* synthetic */ JTable access$0(VisibleRenderer $0) {
            return $0.table;
        }
    }

    static class VisibleEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        VisibleRenderer renderer;

        public VisibleEditor(JTable table) {
            this.renderer = new VisibleRenderer(table);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            return this.renderer.getTableCellRendererComponent(table, value, true, false, row, col);
        }

        public Object getCellEditorValue() {
            return new Boolean(this.renderer.checkbox.isSelected());
        }
    }

    static class HostRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel label;
        private static final AquaTableCellBorder border = new AquaTableCellBorder();

        public HostRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(border);
            this.label = new JLabel();
            this.label.setFont(GUIFactory.FONT_SMALL);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.add(this.label);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value == null) {
                return this;
            }
            this.label.setText((String)value);
            this.label.setForeground(isSelected ? Color.white : Color.black);
            border.setAttributes(isSelected, table.hasFocus(), row);
            return this;
        }
    }

    static class HostEditor
    extends AbstractCellEditorEx
    implements TableCellEditor {
        private JTable table;
        private TextComponent comp = new TextComponent();
        private Object initialValue;

        public HostEditor(JTable table) {
            this.table = table;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            logger.debug("getTableCellEditorComponent: value=" + value + " isSelected=" + isSelected + " row=" + row + " col=" + col);
            this.initialValue = value;
            this.comp.setValue(value);
            this.comp.setAttributes(isSelected, false, row);
            return this.comp;
        }

        public Object getCellEditorValue() {
            return this.comp.getValue();
        }

        public boolean stopCellEditing() {
            Boolean result = null;
            if (this.comp.hasFocus() && !this.comp.shouldYieldFocus()) {
                this.fireValidationFailed();
                result = Boolean.FALSE;
            }
            if (result == null) {
                this.fireValidationSucceeded();
                result = new Boolean(super.stopCellEditing());
            }
            return result;
        }

        public void cancelCellEditing() {
            this.comp.setValue(this.initialValue);
            this.fireEditingCanceled();
        }

        public boolean isCellEditable(EventObject e) {
            boolean result = true;
            if (e instanceof MouseEvent) {
                JTable table = (JTable)e.getSource();
                int row = table.getSelectedRow();
                if (row != -1 && table.rowAtPoint(((MouseEvent)e).getPoint()) == row) {
                    result = true;
                } else {
                    boolean bl = result = ((MouseEvent)e).getClickCount() >= 2;
                }
            }
            if (result) {
                this.fireEditingStarted();
            }
            return result;
        }

        public boolean shouldSelectCell(EventObject e) {
            return true;
        }

        static class TextComponent
        extends RestrictedTextField {
            private InputVerifier verifier = new WWNInputVerifier();

            public TextComponent() {
                this.setFont(GUIFactory.FONT_SMALL);
                this.setRestrictedCharacterSet("0123456789AaBbCcDdEeFf:");
                this.setMaxNumCharactersAllowed(23);
                this.setInputVerifier(this.verifier);
            }

            public void setValue(Object value) {
                this.setText(value == null ? "" : value.toString());
            }

            public Object getValue() {
                return this.getText();
            }

            public void setAttributes(boolean selected, boolean hasFocus, int row) {
            }

            public boolean shouldYieldFocus() {
                return this.verifier.shouldYieldFocus(this);
            }
        }
    }

    static interface CellEditorListenerEx
    extends CellEditorListener {
        public void editingStarted(ChangeEvent var1);

        public void validationSucceeded(ChangeEvent var1);

        public void validationFailed(ChangeEvent var1);
    }

    static abstract class AbstractCellEditorEx
    extends AbstractCellEditor {
        public boolean isCellEditable(EventObject e) {
            this.fireEditingStarted();
            return true;
        }

        public void addCellEditorListener(CellEditorListenerEx l) {
            this.listenerList.add(class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx != null ? class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx : (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx = AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx")), l);
        }

        public void removeCellEditorListener(CellEditorListenerEx l) {
            this.listenerList.remove(class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx != null ? class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx : (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx = AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx")), l);
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$javax$swing$event$CellEditorListener != null ? class$javax$swing$event$CellEditorListener : AdvancedMaskingPane.class$("javax.swing.event.CellEditorListener")) || listeners[i] == (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx != null ? class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx : AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx"))) {
                    if (this.changeEvent == null) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
                }
                i -= 2;
            }
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$javax$swing$event$CellEditorListener != null ? class$javax$swing$event$CellEditorListener : AdvancedMaskingPane.class$("javax.swing.event.CellEditorListener")) || listeners[i] == (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx != null ? class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx : AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx"))) {
                    if (this.changeEvent == null) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
                }
                i -= 2;
            }
        }

        protected void fireEditingStarted() {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx != null ? class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx : AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx"))) {
                    if (this.changeEvent == null) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((CellEditorListenerEx)listeners[i + 1]).editingStarted(this.changeEvent);
                }
                i -= 2;
            }
        }

        protected void fireValidationSucceeded() {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx != null ? class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx : AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx"))) {
                    if (this.changeEvent == null) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((CellEditorListenerEx)listeners[i + 1]).validationSucceeded(this.changeEvent);
                }
                i -= 2;
            }
        }

        protected void fireValidationFailed() {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx != null ? class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx : AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx"))) {
                    if (this.changeEvent == null) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((CellEditorListenerEx)listeners[i + 1]).validationFailed(this.changeEvent);
                }
                i -= 2;
            }
        }

        AbstractCellEditorEx() {
        }
    }

    static class WWNInputVerifier
    extends InputVerifier {
        public boolean verify(JComponent input) {
            JTextField tf = (JTextField)input;
            String text = tf.getText();
            boolean result = text.length() == 0 ? true : (text.length() > 23 ? false : this.checkColons(tf));
            logger.debug("WWNInputVerifier result: " + result);
            return result;
        }

        boolean checkColons(JTextField tf) {
            String text = tf.getText();
            boolean result = true;
            int colonCount = 0;
            int charCount = 0;
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) != ':') {
                    ++charCount;
                } else {
                    if (charCount < 1 || charCount > 2 || colonCount > 7) {
                        return false;
                    }
                    ++colonCount;
                    charCount = 0;
                }
                ++i;
            }
            if (text.length() != 16 && colonCount < 7 || text.length() == 16 && colonCount != 0) {
                result = false;
            } else if (text.length() == 16 && colonCount == 0) {
                StringBuffer buf = new StringBuffer();
                int begin = 0;
                int i2 = 2;
                while (i2 <= 16) {
                    buf.append(String.valueOf(text.substring(begin, i2)) + (i2 < 16 ? ":" : ""));
                    begin = i2;
                    i2 += 2;
                }
                tf.setText(buf.toString());
            }
            return result;
        }

        WWNInputVerifier() {
        }
    }

    static class SelectionModel
    extends DefaultListSelectionModel {
        protected boolean selectionEnabled = true;

        public void setSelectionEnabled(boolean enabled) {
            this.selectionEnabled = enabled;
        }

        public void addSelectionInterval(int index0, int index1) {
            if (this.selectionEnabled) {
                super.addSelectionInterval(index0, index1);
            }
        }

        public void insertIndexInterval(int index, int length, boolean before) {
            if (this.selectionEnabled) {
                super.insertIndexInterval(index, length, before);
            }
        }

        public void removeIndexInterval(int index0, int index1) {
            if (this.selectionEnabled) {
                super.removeIndexInterval(index0, index1);
            }
        }

        public void removeSelectionInterval(int index0, int index1) {
            if (this.selectionEnabled) {
                super.removeSelectionInterval(index0, index1);
            }
        }

        public void setAnchorSelectionIndex(int index) {
            if (this.selectionEnabled) {
                super.setAnchorSelectionIndex(index);
            }
        }

        public void setLeadSelectionIndex(int index) {
            if (this.selectionEnabled) {
                super.setLeadSelectionIndex(index);
            }
        }

        public void setSelectionInterval(int index0, int index1) {
            if (this.selectionEnabled) {
                super.setSelectionInterval(index0, index1);
            }
        }

        SelectionModel() {
        }
    }

    private class HostModel
    extends AbstractTableModel {
        ArrayList hostsList = new ArrayList();
        ArrayList visibleList = new ArrayList();

        public void setNamesAndVisible(ArrayList hostsList, ArrayList visibleList) {
            this.hostsList = hostsList;
            this.visibleList = visibleList;
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.hostsList.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public Object getValueAt(int row, int column) {
            Object value = null;
            switch (column) {
                case 0: {
                    value = this.hostsList.get(row);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + column);
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int column) {
            switch (column) {
                case 0: {
                    this.hostsList.set(row, value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + column);
                }
            }
        }

        public int insertValue(Object value, JTable table) {
            int selectedRow = table.getSelectedRow();
            if (selectedRow == -1) {
                selectedRow = this.hostsList.size();
            }
            if (table.getEditingRow() != -1 && !table.getCellEditor().stopCellEditing()) {
                return -1;
            }
            this.hostsList.add(selectedRow, value);
            this.visibleList.add(selectedRow, new BitSet());
            this.fireTableRowsInserted(selectedRow, selectedRow);
            table.changeSelection(selectedRow, 0, false, false);
            table.editCellAt(selectedRow, 0);
            Component c = table.getEditorComponent();
            if (c != null) {
                c.requestFocus();
            }
            return selectedRow;
        }

        public void removeSelectedRow(JTable table) {
            int selectedRow = table.getSelectedRow();
            if (table.getEditingRow() == selectedRow && table.getCellEditor() != null) {
                table.getCellEditor().cancelCellEditing();
            }
            if (selectedRow != -1 && selectedRow < this.hostsList.size()) {
                this.hostsList.remove(selectedRow);
                this.visibleList.remove(selectedRow);
            }
            this.fireTableDataChanged();
        }

        public String getColumnName(int column) {
            return Resources.getString("advanced.masking.hostWWPN");
        }

        public Class getColumnClass(int column) {
            Class columnClass = null;
            switch (column) {
                case 0: {
                    columnClass = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = AdvancedMaskingPane.class$("java.lang.String"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + column);
                }
            }
            return columnClass;
        }

        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        HostModel() {
        }
    }

    private class LUNModel
    extends AbstractTableModel
    implements ListDataListener {
        ArrayList ids = new ArrayList();
        ArrayList names = new ArrayList();
        ArrayList descriptions = new ArrayList();
        BitSet visible = null;
        BitSet clipboard = new BitSet();

        public LUNModel() {
            this.setAll(false);
        }

        public void setLists(ArrayList ids, ArrayList names, ArrayList descriptions) {
            this.ids = ids;
            this.names = names;
            this.descriptions = descriptions;
            this.fireTableDataChanged();
        }

        public void setVisibleList(BitSet set) {
            this.visible = set;
            this.fireTableDataChanged();
        }

        public void setAll(boolean state) {
            if (this.visible != null) {
                if (state) {
                    int index = 0;
                    while (index < 128) {
                        this.visible.set(index);
                        ++index;
                    }
                } else {
                    int index = 0;
                    while (index < 128) {
                        this.visible.clear(index);
                        ++index;
                    }
                }
                this.fireTableDataChanged();
            }
        }

        public void copyOnOff() {
            if (this.visible != null) {
                int index = 0;
                while (index < 128) {
                    if (this.visible.get(index)) {
                        this.clipboard.set(index);
                    } else {
                        this.clipboard.clear(index);
                    }
                    ++index;
                }
            }
        }

        public void pasteOnOff() {
            if (this.visible != null) {
                int index = 0;
                while (index < 128) {
                    if (this.clipboard.get(index)) {
                        this.visible.set(index);
                    } else {
                        this.visible.clear(index);
                    }
                    ++index;
                }
                this.fireTableDataChanged();
            }
        }

        public int getRowCount() {
            return this.descriptions.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int row, int column) {
            Object value = null;
            switch (column) {
                case 0: {
                    if (this.visible == null || row >= this.ids.size()) {
                        value = null;
                        break;
                    }
                    int lunID = (Integer)this.ids.get(row);
                    if (lunID >= 0) {
                        value = new Boolean(this.visible.get(lunID));
                        break;
                    }
                    value = new Boolean(false);
                    break;
                }
                case 1: {
                    if (row >= this.names.size()) break;
                    value = this.names.get(row);
                    break;
                }
                case 2: {
                    if (row >= this.descriptions.size()) break;
                    value = String.valueOf(String.valueOf(this.descriptions.get(row))) + " ";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + column);
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int column) {
            switch (column) {
                case 0: {
                    int lunID;
                    if (row >= this.ids.size() || (lunID = ((Integer)this.ids.get(row)).intValue()) < 0 || this.visible == null) break;
                    if (value != null && value.equals(Boolean.TRUE)) {
                        this.visible.set(lunID);
                        break;
                    }
                    this.visible.clear(lunID);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + column);
                }
            }
        }

        public String getColumnName(int column) {
            String value = "";
            switch (column) {
                case 0: {
                    value = Resources.getString("advanced.masking.on");
                    break;
                }
                case 1: {
                    value = Resources.getString("advanced.masking.name");
                    break;
                }
                case 2: {
                    value = Resources.getString("advanced.masking.description");
                    break;
                }
            }
            return value;
        }

        public Class getColumnClass(int column) {
            Class columnClass = null;
            switch (column) {
                case 0: {
                    columnClass = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = AdvancedMaskingPane.class$("java.lang.Object"));
                    break;
                }
                case 1: 
                case 2: {
                    columnClass = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = AdvancedMaskingPane.class$("java.lang.String"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + column);
                }
            }
            return columnClass;
        }

        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public void contentsChanged(ListDataEvent e) {
            SwingUtilities.invokeLater(new 17(this));
        }

        public void intervalAdded(ListDataEvent e) {
        }

        public void intervalRemoved(ListDataEvent e) {
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AdvancedMaskingPane.this.populateForController(0);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AdvancedMaskingPane.this.populateForController(1);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ((AdvancedMaskingPane)AdvancedMaskingPane.this).enabled[((AdvancedMaskingPane)AdvancedMaskingPane.this).controller] = AdvancedMaskingPane.this.lunEnable.isSelected();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements TableModelListener {
        public void tableChanged(TableModelEvent e) {
            if (AdvancedMaskingPane.this.paneEnabled) {
                int count = AdvancedMaskingPane.this.hostTable.getModel().getRowCount();
                AdvancedMaskingPane.this.addButton.setEnabled(count < 8);
            }
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = AdvancedMaskingPane.this.hostTable.getSelectedRow();
            if (selectedRow != -1 && selectedRow < AdvancedMaskingPane.this.hostModel.getRowCount()) {
                BitSet visibleList = (BitSet)((AdvancedMaskingPane)AdvancedMaskingPane.this).hostModel.visibleList.get(selectedRow);
                AdvancedMaskingPane.this.lunModel.setVisibleList(visibleList);
                AdvancedMaskingPane.this.removeButton.setEnabled(true);
                AdvancedMaskingPane.this.allOnButton.setEnabled(true);
                AdvancedMaskingPane.this.allOffButton.setEnabled(true);
                AdvancedMaskingPane.this.copyButton.setEnabled(true);
            } else {
                AdvancedMaskingPane.this.lunModel.setVisibleList(null);
                AdvancedMaskingPane.this.removeButton.setEnabled(false);
                AdvancedMaskingPane.this.allOnButton.setEnabled(false);
                AdvancedMaskingPane.this.allOffButton.setEnabled(false);
                AdvancedMaskingPane.this.copyButton.setEnabled(false);
                AdvancedMaskingPane.this.pasteButton.setEnabled(false);
            }
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements CellEditorListenerEx {
        public void editingStarted(ChangeEvent e) {
            logger.debug("EDITING STARTED");
            this.updatePaneState(false);
        }

        public void editingStopped(ChangeEvent e) {
            logger.debug("EDITING STOPPED");
            this.updatePaneState(true);
            this.removeRowIfEmpty(e);
        }

        public void editingCanceled(ChangeEvent e) {
            logger.debug("EDITING CANCELED");
            this.updatePaneState(true);
            this.removeRowIfEmpty(e);
        }

        public void validationSucceeded(ChangeEvent e) {
            logger.debug("VALIDATION SUCCEEDED");
        }

        public void validationFailed(ChangeEvent e) {
            logger.debug("VALIDATION FAILED");
        }

        private void updatePaneState(boolean enable) {
            Enumeration<AbstractButton> e = AdvancedMaskingPane.this.controllerRadioButtonGroup.getElements();
            while (e.hasMoreElements()) {
                ((Component)e.nextElement()).setEnabled(enable);
            }
            AdvancedMaskingPane.this.addButton.setEnabled(enable);
            ((AdvancedMaskingPane)AdvancedMaskingPane.this).buttons.okButton.setEnabled(enable);
            ((AdvancedMaskingPane)AdvancedMaskingPane.this).buttons.backButton.setEnabled(enable);
            ((SelectionModel)AdvancedMaskingPane.this.hostTable.getSelectionModel()).setSelectionEnabled(enable);
        }

        private void removeRowIfEmpty(ChangeEvent e) {
            String value = (String)((HostEditor)e.getSource()).getCellEditorValue();
            logger.debug("removeRowIfEmpty: value=" + value + " length=" + value.length());
            if (value.length() == 0) {
                AdvancedMaskingPane.this.hostModel.removeSelectedRow(AdvancedMaskingPane.this.hostTable);
            }
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AdvancedMaskingPane.this.hostModel.insertValue("", AdvancedMaskingPane.this.hostTable);
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AdvancedMaskingPane.this.hostModel.removeSelectedRow(AdvancedMaskingPane.this.hostTable);
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AdvancedMaskingPane.this.lunModel.setAll(true);
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AdvancedMaskingPane.this.lunModel.setAll(false);
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AdvancedMaskingPane.this.lunModel.copyOnOff();
            AdvancedMaskingPane.this.pasteButton.setEnabled(true);
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AdvancedMaskingPane.this.lunModel.pasteOnOff();
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AdvancedMaskingPane.this.parent.goBackToChooser();
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = AdvancedMaskingPane.this.hostTable.getCellEditor();
            if (editor != null) {
                editor.cancelCellEditing();
            }
            ActionEvent event = new ActionEvent(AdvancedMaskingPane.this.parent, 1001, "CANCEL");
            AdvancedMaskingPane.this.parent.fireActionPerformed(event);
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(AdvancedMaskingPane.this, 1001, "APPLY");
            AdvancedMaskingPane.this.parent.fireActionPerformed(event);
        }

        /* synthetic */ 15() {
        }
    }
}

