/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.advanced;

import com.apple.xsr.AbstractChooserMgmtPane;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertAdapter;
import com.apple.xsr.ChooserButtonPanel;
import com.apple.xsr.DataModel;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.OperationManager;
import com.apple.xsr.Resources;
import com.apple.xsr.advanced.AdvancedExpansionModel;
import com.apple.xsr.advanced.AdvancedExpansionPane;
import com.apple.xsr.advanced.AdvancedMaskingModel;
import com.apple.xsr.advanced.AdvancedMaskingPane;
import com.apple.xsr.advanced.AdvancedSlicingModel;
import com.apple.xsr.advanced.AdvancedSlicingPane;
import com.apple.xsr.som.RaidSystem;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;

public class AdvancedPane
extends AbstractChooserMgmtPane {
    public static final int SLICING_OPERATION = 0;
    public static final int EXPANSION_OPERATION = 1;
    public static final int MASKING_OPERATION = 2;
    public static final int ADVANCED_COUNT = 3;
    private static final int PREFERRED_WIDTH = 780;
    private static final int PREFERRED_HEIGHT = 560;
    private AdvancedSlicingPane slicingPane = new AdvancedSlicingPane(this);
    private AdvancedExpansionPane expansionPane = new AdvancedExpansionPane(this);
    private AdvancedMaskingPane maskingPane = new AdvancedMaskingPane(this);
    private ManagementPane[] panes = new ManagementPane[]{this.slicingPane, this.expansionPane, this.maskingPane};
    private RaidSystem system;

    public AdvancedPane() {
        super(780, 560, Resources.getString("advanced.choose"));
        this.setPanes(this.panes);
    }

    public void populateUI(DataModel data) {
        throw new UnsupportedOperationException();
    }

    public void populateUI(DataModel[] data) {
        if (data == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (data.length != 3) {
            String msg = "data model array contains an invalid number of elements (" + data.length + " elements, expected " + 3 + ")";
            throw new IllegalArgumentException(msg);
        }
        this.system = null;
        int i = 0;
        while (i < data.length) {
            if (data[i] instanceof AdvancedSlicingModel) {
                this.slicingPane.populateUI((AdvancedSlicingModel)data[i]);
                this.system = ((AdvancedSlicingModel)data[i]).getRaidSystem();
            } else if (data[i] instanceof AdvancedExpansionModel) {
                this.expansionPane.populateUI((AdvancedExpansionModel)data[i]);
            } else if (data[i] instanceof AdvancedMaskingModel) {
                this.maskingPane.populateUI((AdvancedMaskingModel)data[i]);
            } else {
                throw new IllegalArgumentException("illegal data model " + data[i].getClass());
            }
            ++i;
        }
        boolean slicingEnabled = true;
        boolean expansionEnabled = true;
        boolean maskingEnabled = true;
        if (this.system != null) {
            try {
                slicingEnabled = OperationManager.isSupported(this.system, OperationManager.OP_SLICE_ARRAY);
            }
            catch (Exception exception) {
                slicingEnabled = true;
            }
            try {
                expansionEnabled = OperationManager.isSupported(this.system, OperationManager.OP_EXPAND_ARRAY);
            }
            catch (Exception exception) {
                expansionEnabled = true;
            }
            try {
                maskingEnabled = OperationManager.isSupported(this.system, OperationManager.OP_CONFIGURE_LUN_MASKING);
            }
            catch (Exception exception) {
                maskingEnabled = true;
            }
        }
        this.chooserPanel.setPaneEnabled(this.slicingPane, slicingEnabled);
        this.chooserPanel.setPaneEnabled(this.expansionPane, expansionEnabled);
        this.chooserPanel.setPaneEnabled(this.maskingPane, maskingEnabled);
        if (slicingEnabled) {
            this.chooserPanel.setSelectedPane(this.slicingPane);
        } else if (expansionEnabled) {
            this.chooserPanel.setSelectedPane(this.expansionPane);
        } else if (maskingEnabled) {
            this.chooserPanel.setSelectedPane(this.maskingPane);
        }
    }

    public boolean validateUI(DataModel data) {
        throw new UnsupportedOperationException();
    }

    public boolean validateUI(DataModel[] data) {
        if (data != null) {
            int i = 0;
            while (i < data.length) {
                if (data[i] instanceof AdvancedSlicingModel) {
                    this.slicingPane.validateUI((AdvancedSlicingModel)data[i]);
                } else if (data[i] instanceof AdvancedExpansionModel) {
                    this.expansionPane.validateUI((AdvancedExpansionModel)data[i]);
                } else if (data[i] instanceof AdvancedMaskingModel) {
                    this.maskingPane.validateUI((AdvancedMaskingModel)data[i]);
                } else {
                    throw new IllegalArgumentException("illegal data model " + data[i].getClass());
                }
                ++i;
            }
        }
        return true;
    }

    public boolean allowAbort() {
        ManagementPane pane = this.getCurrentlyShowingManagementPane();
        if (pane != null) {
            return pane.allowAbort();
        }
        return true;
    }

    protected ChooserButtonPanel createChooserButtonPanel() {
        ChooserButtonPanel buttonPanel = new ChooserButtonPanel(false);
        buttonPanel.cancelButton.addActionListener(new 1());
        buttonPanel.okButton.addActionListener(new 2());
        return buttonPanel;
    }

    private void showMaskingDisabledDialog() {
        Container c = this.getTopLevelAncestor();
        JFrame frame = c instanceof JFrame ? (JFrame)c : null;
        AquaAlert alert = AquaAlert.createStandardAquaAlert(Resources.getString("advanced.masking.busyDialog.message"), Resources.getString("advanced.masking.busyDialog.explanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        alert.showSheet(frame, new 3(), null);
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AdvancedPane.this.fireActionPerformed(new ActionEvent(AdvancedPane.this, 1001, "CANCEL"));
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String tag = AdvancedPane.this.getSelectedPaneTag();
            if (tag != null) {
                if (tag.equals(AdvancedPane.this.maskingPane.getTag()) && AdvancedPane.this.system.isBusy()) {
                    if (AdvancedPane.this.system.isBusy()) {
                        AdvancedPane.this.maskingPane.setPaneEnabled(false);
                        AdvancedPane.this.showMaskingDisabledDialog();
                    } else {
                        AdvancedPane.this.maskingPane.setPaneEnabled(true);
                    }
                } else {
                    AdvancedPane.this.showPane(tag);
                }
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends AquaAlertAdapter {
        public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
            AdvancedPane.this.showPane(AdvancedPane.this.maskingPane.getTag());
        }

        public boolean allowAquaAlertToBeDismissed(int buttonPressIdentifier, Object contextInfo) {
            return true;
        }

        /* synthetic */ 3() {
        }
    }
}

