/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.advanced;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.ChooserButtonPanel;
import com.apple.xsr.DataModel;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.advanced.AdvancedPane;
import com.apple.xsr.advanced.AdvancedSlicingModel;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.apache.log4j.Logger;

public class AdvancedSlicingPane
extends AbstractManagementPane {
    private final AdvancedPane parent;
    private DriveSelectionPanel drivePanel;
    private JLabel legendLabel;
    private ArraySelectionPanel legend;
    RadioButtonGroup sliceCountRadioGroup;
    JRadioButton[] sliceRadioButton;
    JLabel sliceCountLabel;
    JLabel sliceCountCurrentLabel;
    private StepByStepPanel summaryHeader;
    private JTextPane summaryLabel;
    JCheckBox confirmCheckBox;
    ChooserButtonPanel buttons;
    private JTextField[] sizeTextFields;
    private JLabel totalLabel = new JLabel();
    private RaidSystem system;
    private int[][] sliceSizes;
    private int mode = -1;
    private static final String TAG = "ADVANCED_SLICING";
    private static final int PREFERRED_WIDTH = 663;
    private static final int PREFERRED_HEIGHT = 437;
    private static final int MAX_SLICES = 6;
    private static final int MIN_EXPAND_DIFFERENCE_MB = 81920;
    private static final int MODE_SLICING = 0;
    private static final int MODE_MERGING = 1;
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static final int LEFT_INDENT = 20;
    private static final int STEP_VSPACE = 15;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$advanced$AdvancedSlicingPane != null ? class$com$apple$xsr$advanced$AdvancedSlicingPane : (class$com$apple$xsr$advanced$AdvancedSlicingPane = AdvancedSlicingPane.class$("com.apple.xsr.advanced.AdvancedSlicingPane")));
    static /* synthetic */ Class class$com$apple$xsr$advanced$AdvancedSlicingPane;
    static /* synthetic */ Class class$com$apple$xsr$advanced$AdvancedSlicingModel;

    public AdvancedSlicingPane(AdvancedPane parent) {
        super(663, 437);
        this.parent = parent;
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 2;
        StepByStepPanel summaryHeader = new StepByStepPanel(Resources.getImage("icon.step.five"), Resources.getString("advanced.slicing.summary"));
        this.summaryLabel = GUIFactory.newTextPane(Resources.getString("advanced.slicing.summary.cannot.general"), 2);
        this.buttons = new ChooserButtonPanel(true);
        this.buttons.setRestartRequiredLabelVisible(true);
        this.buttons.backButton.addActionListener(new 1());
        this.buttons.cancelButton.addActionListener(new 2());
        this.buttons.okButton.setText(Resources.getString("advanced.slicing.defaultButton.slice"));
        this.buttons.okButton.addActionListener(new 3());
        StepByStepPanel stepOne = new StepByStepPanel(Resources.getImage("icon.step.one"), Resources.getString("advanced.slicing.selectArray"));
        this.addComponent(stepOne, this, layout, constraints);
        ++constraints.gridy;
        DriveInformationPanel driveInfo = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        JPanel driveGroup = GUIFactory.newPanel();
        GridBagLayout driveGroupLayout = new GridBagLayout();
        driveGroup.setLayout(driveGroupLayout);
        GridBagConstraints driveGroupConstraints = new GridBagConstraints();
        driveGroupConstraints.anchor = 17;
        driveGroupConstraints.fill = 2;
        driveGroupConstraints.gridx = 1;
        driveGroupConstraints.gridy = 0;
        driveGroupConstraints.fill = 1;
        driveGroupConstraints.insets = new Insets(0, 0, 6, 0);
        driveGroupConstraints.weightx = 1.0;
        this.addComponent(driveInfo, driveGroup, driveGroupLayout, driveGroupConstraints);
        driveGroupConstraints.weightx = 0.0;
        driveGroupConstraints.insets = ZERO_INSETS;
        driveGroupConstraints.fill = 0;
        this.drivePanel = new DriveSelectionPanel(8, driveInfo, summaryHeader, this.summaryLabel, this.buttons.okButton);
        driveGroupConstraints.gridx = 0;
        driveGroupConstraints.gridy = 0;
        driveGroupConstraints.insets = new Insets(0, 0, 0, 20);
        this.addComponent(this.drivePanel, driveGroup, driveGroupLayout, driveGroupConstraints);
        driveGroupConstraints.insets = ZERO_INSETS;
        constraints.insets = new Insets(0, 20, 15, 0);
        this.addComponent(driveGroup, this, layout, constraints);
        constraints.insets = ZERO_INSETS;
        ++constraints.gridy;
        this.legendLabel = new JLabel(Resources.getString("advanced.slicing.legendNote"));
        this.legendLabel.setVisible(false);
        this.legendLabel.setFont(GUIFactory.FONT_SMALL);
        constraints.insets = new Insets(0, 22, 0, 0);
        this.addComponent(this.legendLabel, this, layout, constraints);
        constraints.insets = ZERO_INSETS;
        ++constraints.gridy;
        this.legend = new ArraySelectionPanel(1);
        constraints.insets = new Insets(0, 20, 15, 0);
        constraints.fill = 0;
        this.addComponent(this.legend, this, layout, constraints);
        constraints.fill = 2;
        constraints.insets = ZERO_INSETS;
        ++constraints.gridy;
        this.legend.addPropertyChangeListener("ArrayIndex", new 4());
        this.drivePanel.addPropertyChangeListener("ArrayIndex", new 5());
        JPanel sliceCountPanel = GUIFactory.newPanel();
        sliceCountPanel.setOpaque(true);
        GridBagLayout sliceCountLayout = new GridBagLayout();
        sliceCountPanel.setLayout(sliceCountLayout);
        GridBagConstraints sliceCountConstraints = new GridBagConstraints();
        sliceCountConstraints.gridwidth = 1;
        sliceCountConstraints.anchor = 17;
        sliceCountConstraints.fill = 0;
        this.sliceRadioButton = new JRadioButton[5];
        this.sliceCountRadioGroup = new RadioButtonGroup();
        sliceCountConstraints.gridx = 0;
        sliceCountConstraints.gridy = 0;
        this.sliceCountLabel = new JLabel(Resources.getString("advanced.slicing.slicesToCreate"));
        this.sliceCountLabel.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(this.sliceCountLabel, sliceCountPanel, sliceCountLayout, sliceCountConstraints);
        ++sliceCountConstraints.gridx;
        sliceCountConstraints.insets = new Insets(0, 5, 0, 10);
        this.sliceCountCurrentLabel = new JLabel(Resources.getString("som.unknown"));
        this.sliceCountCurrentLabel.setVisible(false);
        this.sliceCountCurrentLabel.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(this.sliceCountCurrentLabel, sliceCountPanel, sliceCountLayout, sliceCountConstraints);
        ++sliceCountConstraints.gridx;
        int slice = 2;
        while (slice <= 6) {
            int index = slice - 2;
            this.sliceRadioButton[index] = GUIFactory.newRadioButton(String.valueOf(slice));
            this.sliceRadioButton[index].setActionCommand(String.valueOf(slice));
            this.sliceRadioButton[index].setFont(GUIFactory.FONT_SMALL);
            this.sliceCountRadioGroup.add(this.sliceRadioButton[index]);
            this.addComponent(this.sliceRadioButton[index], sliceCountPanel, sliceCountLayout, sliceCountConstraints);
            ++sliceCountConstraints.gridx;
            ++slice;
        }
        sliceCountConstraints.insets = new Insets(0, 0, 0, 0);
        sliceCountConstraints.weightx = 1.0;
        this.addComponent(Box.createHorizontalStrut(0), sliceCountPanel, sliceCountLayout, sliceCountConstraints);
        sliceCountConstraints.weightx = 0.0;
        ++sliceCountConstraints.gridx;
        constraints.insets = new Insets(0, 20, 15, 0);
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.addComponent(sliceCountPanel, this, layout, constraints);
        constraints.weightx = 0.0;
        constraints.insets = ZERO_INSETS;
        ++constraints.gridy;
        StepByStepPanel stepTwo = new StepByStepPanel(Resources.getImage("icon.step.two"), Resources.getString("advanced.slicing.confirmation"));
        this.addComponent(stepTwo, this, layout, constraints);
        ++constraints.gridy;
        JPanel confirmGroup = GUIFactory.newPanel();
        GridBagLayout confirmGroupLayout = new GridBagLayout();
        confirmGroup.setLayout(confirmGroupLayout);
        GridBagConstraints confirmGroupConstraints = new GridBagConstraints();
        confirmGroupConstraints.gridwidth = 1;
        confirmGroupConstraints.anchor = 17;
        confirmGroupConstraints.fill = 2;
        int optionsRow = 0;
        this.confirmCheckBox = GUIFactory.newCheckBox(Resources.getString("advanced.slicing.iUnderstand"));
        this.confirmCheckBox.setFont(GUIFactory.FONT_SMALL);
        confirmGroupConstraints.gridx = 0;
        confirmGroupConstraints.gridy = optionsRow++;
        this.addComponent(this.confirmCheckBox, confirmGroup, confirmGroupLayout, confirmGroupConstraints);
        this.confirmCheckBox.addActionListener(new 6());
        constraints.insets = new Insets(0, 20, 15, 0);
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.weightx = 1.0;
        this.addComponent(confirmGroup, this, layout, constraints);
        constraints.weightx = 0.0;
        constraints.insets = ZERO_INSETS;
        constraints.fill = 2;
        ++constraints.gridy;
        this.addComponent(summaryHeader, this, layout, constraints);
        ++constraints.gridy;
        JPanel summaryGroup = GUIFactory.newPanel();
        GridBagLayout summaryGroupLayout = new GridBagLayout();
        summaryGroup.setLayout(summaryGroupLayout);
        GridBagConstraints summaryGroupConstraints = new GridBagConstraints();
        summaryGroupConstraints.anchor = 17;
        summaryGroupConstraints.fill = 2;
        this.summaryLabel.setFont(GUIFactory.FONT_SMALL);
        this.summaryLabel.setEditable(false);
        this.summaryLabel.setOpaque(false);
        summaryGroupConstraints.weightx = 1.0;
        summaryGroupConstraints.weighty = 1.0;
        summaryGroupConstraints.fill = 1;
        this.addComponent(this.summaryLabel, summaryGroup, summaryGroupLayout, summaryGroupConstraints);
        ++constraints.gridy;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 20, 15, 0);
        this.addComponent(summaryGroup, this, layout, constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.insets = ZERO_INSETS;
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.addComponent(Box.createVerticalStrut(0), this, layout, constraints);
        constraints.weighty = 0.0;
        ++constraints.gridy;
        constraints.fill = 2;
        this.addComponent(this.buttons, this, layout, constraints);
        constraints.fill = 0;
        this.setSize(this.getPreferredSize());
    }

    void syncSliceCountRadioButtons() {
        if (this.drivePanel.getArrayIndex() > 0) {
            int index;
            int slices = this.countSlicesInArray(this.drivePanel.getArrayIndex());
            if (slices > 1 || slices == 1 && this.isArrayExpanded(this.drivePanel.getArrayIndex())) {
                index = 0;
                while (index <= 4) {
                    this.sliceRadioButton[index].setVisible(false);
                    ++index;
                }
                this.sliceCountLabel.setText(Resources.getString("advanced.slicing.existingSlices"));
                this.sliceCountCurrentLabel.setText(String.valueOf(slices));
                this.sliceCountCurrentLabel.setVisible(true);
                this.mode = 1;
                this.drivePanel.setSelectionMode(9);
                this.buttons.okButton.setText(Resources.getString("advanced.slicing.defaultButton.merge"));
            } else {
                this.sliceCountLabel.setText(Resources.getString("advanced.slicing.slicesToCreate"));
                this.sliceCountCurrentLabel.setVisible(false);
                this.sliceCountCurrentLabel.setText(Resources.getString("som.unknown"));
                index = 0;
                while (index <= 4) {
                    this.sliceRadioButton[index].setVisible(true);
                    ++index;
                }
                this.mode = 0;
                this.drivePanel.setSelectionMode(8);
                this.buttons.okButton.setText(Resources.getString("advanced.slicing.defaultButton.slice"));
            }
            int available = this.drivePanel.countAvailableLuns();
            int index2 = 0;
            while (index2 <= 4) {
                boolean enable = index2 + 2 <= available + 1;
                this.sliceRadioButton[index2].setEnabled(enable);
                if (!enable && this.sliceRadioButton[index2].isSelected()) {
                    this.sliceCountRadioGroup.remove(this.sliceRadioButton[index2]);
                    this.sliceRadioButton[index2].setSelected(false);
                    this.sliceCountRadioGroup.add(this.sliceRadioButton[index2]);
                }
                ++index2;
            }
            boolean somethingSelected = false;
            int index3 = 0;
            while (index3 <= 4) {
                if (this.sliceRadioButton[index3].isSelected()) {
                    somethingSelected = true;
                    break;
                }
                ++index3;
            }
            if (!somethingSelected) {
                this.sliceRadioButton[0].setSelected(true);
            }
        }
    }

    private int countSlicesInArray(int arrayIndex) {
        int count = 0;
        int index = 0;
        while (index < 8) {
            if (this.sliceSizes[arrayIndex - 1][index] > 0) {
                ++count;
            }
            ++index;
        }
        return count;
    }

    private boolean isArrayExpanded(int arrayIndex) {
        RaidSet rs;
        Integer arrayCapacityMb = null;
        int sliceCapacityMb = 0;
        int index = 0;
        while (index < 8) {
            sliceCapacityMb += this.sliceSizes[arrayIndex - 1][index];
            ++index;
        }
        if (this.system != null && (rs = this.system.getRaidSet(arrayIndex)) != null) {
            arrayCapacityMb = new Integer((int)(rs.getCapacityBytes() / 1024L / 1024L));
        }
        boolean result = arrayCapacityMb != null && arrayCapacityMb - sliceCapacityMb > 81920;
        logger.debug("isArrayExpanded: sliceCapacity=" + sliceCapacityMb + " arrayCapacity=" + arrayCapacityMb + " result=" + result);
        return result;
    }

    public void populateUI(DataModel data) {
        if (data.getClass() != (class$com$apple$xsr$advanced$AdvancedSlicingModel != null ? class$com$apple$xsr$advanced$AdvancedSlicingModel : (class$com$apple$xsr$advanced$AdvancedSlicingModel = AdvancedSlicingPane.class$("com.apple.xsr.advanced.AdvancedSlicingModel")))) {
            throw new IllegalArgumentException("illegal data model type " + data.getClass());
        }
        if (data != null) {
            AdvancedSlicingModel model = (AdvancedSlicingModel)data;
            this.system = model.getRaidSystem();
            if (this.system == null) {
                throw new NullPointerException("RAID system cannot be null");
            }
            this.drivePanel.setRaidSystem(this.system);
            this.legend.setRaidSystem(this.system);
            this.sliceSizes = model.getSliceSizes();
        }
        this.validateUI((DataModel)null);
    }

    public boolean validateUI(DataModel data) {
        if (data != null) {
            AdvancedSlicingModel model = (AdvancedSlicingModel)data;
            int arrayIndex = this.drivePanel.getArrayIndex();
            int sliceCount = 1;
            if (this.mode == 0) {
                try {
                    sliceCount = Integer.parseInt(this.sliceCountRadioGroup.getSelection().getActionCommand());
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            model.setArrayIndex(arrayIndex);
            model.setSliceCount(sliceCount);
        }
        return true;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(Resources.getImage("icon.slicing"));
    }

    public String getTitle() {
        return Resources.getString("advanced.slicing");
    }

    public String getExplanation() {
        return Resources.getString("advanced.slicingExplanation");
    }

    public String getTag() {
        return TAG;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AdvancedSlicingPane.this.parent.goBackToChooser();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(AdvancedSlicingPane.this.parent, 1001, "CANCEL");
            AdvancedSlicingPane.this.parent.fireActionPerformed(event);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(AdvancedSlicingPane.this, 1001, "APPLY");
            AdvancedSlicingPane.this.parent.fireActionPerformed(event);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            int value = (Integer)e.getNewValue();
            AdvancedSlicingPane.this.drivePanel.setArrayIndex(value);
            AdvancedSlicingPane.this.syncSliceCountRadioButtons();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            int value = (Integer)e.getNewValue();
            AdvancedSlicingPane.this.legend.setArrayIndex(value);
            AdvancedSlicingPane.this.syncSliceCountRadioButtons();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            boolean selected = AdvancedSlicingPane.this.confirmCheckBox.isSelected();
            AdvancedSlicingPane.this.drivePanel.setConfirmed(selected);
        }

        /* synthetic */ 6() {
        }
    }
}

