/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.cli;

import com.apple.net.acp.AcpPropertyCode;
import com.apple.util.plist.PListUtils;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.xsr.cli.AcpPropertyMap;
import com.apple.xsr.cli.CommandHandler;
import com.apple.xsr.cli.CommandLineOption;
import com.apple.xsr.cli.CommandLineUtils;
import com.apple.xsr.cli.IllegalOptionException;
import com.apple.xsr.cli.MissingArgumentException;
import com.apple.xsr.cli.OptionException;
import com.apple.xsr.cli.OptionSet;
import com.apple.xsr.cli.OptionTokenizer;
import com.apple.xsr.net.AcpxConnection;
import com.apple.xsr.net.AcpxMessageFactory;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class CommandDispatcher {
    private static final boolean USE_PERSISTENT_CONNECTIONS = false;
    private static final boolean ENCRYPT_COMMUNICATIONS = true;
    private static CommandDispatcher INSTANCE = new CommandDispatcher();
    private Hashtable commands = new Hashtable();

    private CommandDispatcher() {
        this.initGetCommandHandlers();
        this.initSetCommandHandlers();
        this.initDoCommandHandlers();
        this.initStopCommandHandlers();
    }

    public static CommandDispatcher getInstance() {
        return INSTANCE;
    }

    public void dispatch(String command, String commandObject, String[] globalArgs, String[] commandArgs, OutputStream out) throws OptionException, IOException {
        CommandHandler handler;
        Hashtable handlers = (Hashtable)this.commands.get(command);
        if (handlers != null) {
            handler = (CommandHandler)handlers.get(commandObject);
            if (handler != null) {
                try {
                    handler = (CommandHandler)handler.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new Error("Assertion failure");
                }
            } else if (command.equals("get")) {
                handler = new GetPropertyHandler(commandObject);
            } else if (command.equals("set")) {
                handler = new SetPropertyHandler(commandObject);
            }
            if (handler == null) {
                throw new OptionException("Illegal command object: " + commandObject, -404);
            }
        } else {
            throw new OptionException("Illegal command: " + command, -403);
        }
        handler.handle(globalArgs, commandArgs, out);
    }

    public Set getCommands() {
        return this.getCommands(null);
    }

    public Set getCommands(String commandType) {
        Set commandSet = null;
        if (commandType == null || commandType.equals("")) {
            commandSet = Collections.unmodifiableSet(this.commands.keySet());
        } else {
            Hashtable handlers = (Hashtable)this.commands.get(commandType);
            if (handlers != null) {
                commandSet = Collections.unmodifiableSet(((Hashtable)this.commands.get(commandType)).keySet());
            }
        }
        return commandSet;
    }

    private void initGetCommandHandlers() {
        Hashtable<String, AbstractHandler> handlers = new Hashtable<String, AbstractHandler>();
        AcpPropertyMap propMap = AcpPropertyMap.getInstance();
        Iterator i = propMap.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            handlers.put(name, new GetPropertyHandler(propMap.get(name)));
        }
        handlers.put("page", new 1());
        2 controllerInfoHandler = new 2();
        handlers.put("controller_info", controllerInfoHandler);
        handlers.put("controller-info", controllerInfoHandler);
        3 raidInfoHandler = new 3();
        handlers.put("raid_info", raidInfoHandler);
        handlers.put("raid-info", raidInfoHandler);
        4 serialInfoHandler = new 4();
        handlers.put("rs232_info", serialInfoHandler);
        handlers.put("rs232-info", serialInfoHandler);
        handlers.put("serial_info", serialInfoHandler);
        handlers.put("serial-info", serialInfoHandler);
        5 slotInfoHandler = new 5();
        handlers.put("slot_info", slotInfoHandler);
        handlers.put("slot-info", slotInfoHandler);
        6 eventLog1Handler = new 6();
        handlers.put("event_log1", eventLog1Handler);
        handlers.put("event-log1", eventLog1Handler);
        7 eventLog2Handler = new 7();
        handlers.put("event_log2", eventLog2Handler);
        handlers.put("event-log2", eventLog2Handler);
        8 eventLog3Handler = new 8();
        handlers.put("event_log3", eventLog3Handler);
        handlers.put("event-log3", eventLog3Handler);
        9 eventLog4Handler = new 9();
        handlers.put("event_log4", eventLog4Handler);
        handlers.put("event-log4", eventLog4Handler);
        handlers.put("date", new 10());
        handlers.put("temperature", new 11());
        12 devicePropertiesHandler = new 12();
        handlers.put("device_properties", devicePropertiesHandler);
        handlers.put("device-properties", devicePropertiesHandler);
        13 systemStatusHandler = new 13();
        handlers.put("system_status", systemStatusHandler);
        handlers.put("system-status", systemStatusHandler);
        14 postResultsHandler = new 14();
        handlers.put("post_results", postResultsHandler);
        handlers.put("post-results", postResultsHandler);
        15 getVersionsHandler = new 15();
        handlers.put("versions", getVersionsHandler);
        this.commands.put("get", handlers);
    }

    private void initSetCommandHandlers() {
        Hashtable<String, DefaultHandler> handlers = new Hashtable<String, DefaultHandler>();
        AcpPropertyMap propMap = AcpPropertyMap.getInstance();
        Iterator i = propMap.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            AcpPropertyCode prop = propMap.get(name);
            if (!prop.isWriteable()) continue;
            handlers.put(name, new SetPropertyHandler(prop));
        }
        16 setSliceSizeHandler = new 16();
        handlers.put("slice_size", setSliceSizeHandler);
        handlers.put("slice-size", setSliceSizeHandler);
        handlers.put("ipconfig_method", new 17());
        handlers.put("led", new 18());
        handlers.put("date", new 19());
        20 setFibreChannelSpeedHandler = new 20();
        handlers.put("fc_speed", setFibreChannelSpeedHandler);
        handlers.put("fc-speed", setFibreChannelSpeedHandler);
        21 setFibreChannelTopologyHandler = new 21();
        handlers.put("fc_topology", setFibreChannelTopologyHandler);
        handlers.put("fc-topology", setFibreChannelTopologyHandler);
        22 jbodMaskEnableHandler = new 22();
        handlers.put("jbod_mask", jbodMaskEnableHandler);
        handlers.put("jbod-mask", jbodMaskEnableHandler);
        23 setServerModeHandler = new 23();
        handlers.put("server_mode", setServerModeHandler);
        handlers.put("server-mode", setServerModeHandler);
        this.commands.put("set", handlers);
    }

    private void initDoCommandHandlers() {
        Hashtable<String, DefaultHandler> handlers = new Hashtable<String, DefaultHandler>();
        24 createArrayHandler = new 24();
        handlers.put("create_array", createArrayHandler);
        handlers.put("create-array", createArrayHandler);
        25 deleteArrayHandler = new 25();
        handlers.put("delete_array", deleteArrayHandler);
        handlers.put("delete-array", deleteArrayHandler);
        26 expandArrayHandler = new 26();
        handlers.put("expand_array", expandArrayHandler);
        handlers.put("expand-array", expandArrayHandler);
        27 initArrayHandler = new 27();
        handlers.put("init_array", initArrayHandler);
        handlers.put("init-array", initArrayHandler);
        28 checkArrayHandler = new 28();
        handlers.put("check_array", checkArrayHandler);
        handlers.put("check-array", checkArrayHandler);
        29 mapLunHandler = new 29();
        handlers.put("map_lun", mapLunHandler);
        handlers.put("map-lun", mapLunHandler);
        30 clearLogHandler = new 30();
        handlers.put("clear_log", clearLogHandler);
        handlers.put("clear-log", clearLogHandler);
        handlers.put("power", new 31());
        handlers.put("restart", new 32());
        33 restartControllerHandler = new 33();
        handlers.put("restart_controller", restartControllerHandler);
        handlers.put("restart-controller", restartControllerHandler);
        34 flushNvramHandler = new 34();
        handlers.put("flush_raid_nvram", flushNvramHandler);
        handlers.put("flush-raid-nvram", flushNvramHandler);
        35 resetNvramHandler = new 35();
        handlers.put("reset_nvram", resetNvramHandler);
        handlers.put("reset-nvram", resetNvramHandler);
        36 morseCodeHandler = new 36();
        handlers.put("morse_code", morseCodeHandler);
        handlers.put("morse-code", morseCodeHandler);
        handlers.put("morse", morseCodeHandler);
        37 ledDiagHandler = new 37();
        handlers.put("led_test", ledDiagHandler);
        handlers.put("led-test", ledDiagHandler);
        38 buzzerDiagHandler = new 38();
        handlers.put("buzzer_test", buzzerDiagHandler);
        handlers.put("buzzer-test", buzzerDiagHandler);
        39 cacheDiagHandler = new 39();
        handlers.put("mem_test", cacheDiagHandler);
        handlers.put("mem-test", cacheDiagHandler);
        handlers.put("dram_test", cacheDiagHandler);
        handlers.put("dram-test", cacheDiagHandler);
        40 fibreChannelDiagHandler = new 40();
        handlers.put("fc_test", fibreChannelDiagHandler);
        handlers.put("fc-test", fibreChannelDiagHandler);
        41 serialDiagHandler = new 41();
        handlers.put("com_test", serialDiagHandler);
        handlers.put("com-test", serialDiagHandler);
        42 diskDiagHandler = new 42();
        handlers.put("disk_test", diskDiagHandler);
        handlers.put("disk-test", diskDiagHandler);
        43 writeSignatureHandler = new 43();
        handlers.put("write_signature", writeSignatureHandler);
        handlers.put("write-signature", writeSignatureHandler);
        44 readSignatureHandler = new 44();
        handlers.put("read_signature", readSignatureHandler);
        handlers.put("read-signature", readSignatureHandler);
        45 updateFirmwareHandler = new 45();
        handlers.put("flash", updateFirmwareHandler);
        this.commands.put("do", handlers);
        this.commands.put("start", handlers);
    }

    private void initStopCommandHandlers() {
        Hashtable<String, DefaultHandler> handlers = new Hashtable<String, DefaultHandler>();
        46 stopInitArrayHandler = new 46();
        handlers.put("init_array", stopInitArrayHandler);
        handlers.put("init-array", stopInitArrayHandler);
        47 stopCheckArrayHandler = new 47();
        handlers.put("check_array", stopCheckArrayHandler);
        handlers.put("check-array", stopCheckArrayHandler);
        48 stopLedDiagHandler = new 48();
        handlers.put("led_test", stopLedDiagHandler);
        handlers.put("led-test", stopLedDiagHandler);
        49 fibreChannelDiagHandler = new 49();
        handlers.put("fc_test", fibreChannelDiagHandler);
        handlers.put("fc-test", fibreChannelDiagHandler);
        50 stopSerialDiagHandler = new 50();
        handlers.put("com_test", stopSerialDiagHandler);
        handlers.put("com-test", stopSerialDiagHandler);
        51 stopDiskDiagHandler = new 51();
        handlers.put("disk_test", stopDiskDiagHandler);
        handlers.put("disk-test", stopDiskDiagHandler);
        this.commands.put("stop", handlers);
    }

    private String getAppVersion() {
        ResourceBundle bundle = ResourceBundle.getBundle("com.apple.xsr.resources.Versions");
        return bundle.getString("app_version");
    }

    private final class 1
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "p:");
            Integer page = options.get("p").argIntegerValue(0);
            return this.msgFactory.newGetControllerPageRequest(page);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) {
            return this.msgFactory.newGetControllerPageRequest(new Integer(0));
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) {
            return this.msgFactory.newGetControllerPageRequest(new Integer(1));
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) {
            return this.msgFactory.newGetControllerPageRequest(new Integer(2));
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) {
            return this.msgFactory.newGetControllerPageRequest(new Integer(16));
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) {
            return this.msgFactory.newGetControllerPageRequest(new Integer(3));
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) {
            return this.msgFactory.newGetControllerPageRequest(new Integer(4));
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) {
            return this.msgFactory.newGetControllerPageRequest(new Integer(5));
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) {
            return this.msgFactory.newGetControllerPageRequest(new Integer(6));
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) {
            return this.msgFactory.newGetTimeRequest();
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "n:");
            String name = options.get("n").argStringValue(0);
            return this.msgFactory.newGetTemperatureRequest(name);
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "n:i:");
            String name = options.get("n").argStringValue(0);
            Integer id = options.get("i").argIntegerValue(0);
            return this.msgFactory.newGetDevicePropertiesRequest(name, id);
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            return this.msgFactory.newGetStatusRequest();
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            return this.msgFactory.newGetPostResultsRequest();
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    extends AbstractHandler {
        public void handle(String[] globalArgs, String[] commandArgs, OutputStream out) throws OptionException, IOException {
            this.parseGlobalArgs(globalArgs);
            if (this.getHostAddress() == null) {
                throw new OptionException("No host address specified", -405);
            }
            RequestMessage.Target target = this.getTargetController();
            AcpxConnection connection = new AcpxConnection(this.getHostAddress());
            connection.setPersistent(false);
            connection.setEncrypted(this.isEncryptionEnabled());
            AcpxMessageFactory mf = new AcpxMessageFactory();
            mf.setDefaultTimeout(this.timeout);
            if (this.getUser() != null) {
                mf.setDefaultUser(this.getUser());
                mf.setDefaultPassword(this.getPassword(), true);
            }
            RequestMessage request = mf.newGetPropertyRequest(AcpPropertyCode.SYS_VERSION.fourCharCode());
            request.setTargetController(target);
            PropertyList result = connection.send(request);
            String atlas = "";
            try {
                Map root = PListUtils.toDictionary(result.getRootElement());
                Map dict = PListUtils.toDictionary(root.get("syVs"));
                atlas = PListUtils.toString(dict.get("data"));
            }
            catch (PropertyListException propertyListException) {
                atlas = "Unable to get system controller version";
            }
            request = mf.newGetControllerPageRequest(new Integer(0));
            request.setTargetController(target);
            result = connection.send(request);
            String controller = "";
            try {
                Map root = PListUtils.toDictionary(result.getRootElement());
                Map dict = PListUtils.toDictionary(root.get("get-page"));
                controller = PListUtils.toString(dict.get("firmware-version"));
            }
            catch (PropertyListException propertyListException) {
                controller = "Unable to get RAID controller version";
            }
            String raidAdmin = CommandDispatcher.this.getAppVersion();
            if (raidAdmin == null) {
                raidAdmin = "Unable to get RAID Admin version";
            }
            HashMap<String, String> versions = new HashMap<String, String>();
            versions.put("atlas", atlas);
            versions.put("raid-admin", raidAdmin);
            versions.put("controller", controller);
            HashMap<String, HashMap<String, String>> root = new HashMap<String, HashMap<String, String>>();
            root.put("versions", versions);
            PropertyList response = new PropertyList(root);
            if (out != null) {
                try {
                    response.writeTo(out);
                }
                catch (PropertyListException e) {
                    throw new IOException("error processing plist: " + e.getMessage());
                }
            }
        }

        /* synthetic */ 15() {
        }
    }

    private final class 16
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "i:s:c:");
            Integer arrayId = options.get("i").argIntegerValue(0);
            Integer sliceId = options.get("s").argIntegerValue(0);
            Integer sliceSize = options.get("c").argIntegerValue(0);
            return this.msgFactory.newSetSliceSizeRequest(arrayId, sliceId, sliceSize);
        }

        /* synthetic */ 16() {
        }
    }

    private final class 17
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            Integer configType;
            if (args.length < 1) {
                throw new OptionException("Missing argument", -402);
            }
            if (args[0].equalsIgnoreCase("static")) {
                configType = new Integer(1024);
            } else if (args[0].equalsIgnoreCase("dhcp")) {
                configType = new Integer(768);
            } else if (args[0].equalsIgnoreCase("ppp")) {
                configType = new Integer(2304);
            } else if (args[0].equalsIgnoreCase("bootp")) {
                configType = new Integer(8448);
            } else {
                throw new OptionException("Illegal method argument: " + args[0], -401);
            }
            return this.msgFactory.newSetPropertyRequest(AcpPropertyCode.LAN_CONFIGURE_VIA.fourCharCode(), configType);
        }

        /* synthetic */ 17() {
        }
    }

    private final class 18
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "n:i:s:");
            String name = options.get("n").argStringValue(0);
            Integer id = options.get("i").argIntegerValue(0);
            String state = options.get("s").argStringValue(0);
            return this.msgFactory.newIlluminateRequest(name, id, state);
        }

        /* synthetic */ 18() {
        }
    }

    private final class 19
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            Date date = null;
            if (args.length >= 1) {
                SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM d HH':'mm':'ss zzz yyyy");
                try {
                    date = formatter.parse(args[0]);
                }
                catch (ParseException parseException) {
                    throw new OptionException("Invalid date: " + args[0], -407);
                }
            }
            return this.msgFactory.newSetTimeRequest(date);
        }

        /* synthetic */ 19() {
        }
    }

    private final class 20
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "i:s:");
            Integer hostInterface = options.get("i").argIntegerValue(0);
            String speed = null;
            String arg = options.get("s").argStringValue(0);
            if (arg != null) {
                speed = arg.equals("0") ? "auto-negotiated" : (arg.equals("1") ? "1Gb/sec" : (arg.equals("2") ? "2Gb/sec" : arg));
            }
            return this.msgFactory.newSetFibreChannelSpeedRequest(hostInterface, speed);
        }

        /* synthetic */ 20() {
        }
    }

    private final class 21
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            if (args.length < 1) {
                throw new OptionException("Missing argument", -402);
            }
            return this.msgFactory.newSetFibreChannelTopologyRequest(args[0]);
        }

        /* synthetic */ 21() {
        }
    }

    private final class 22
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            Boolean enable = null;
            if (args != null && args.length > 0) {
                String arg = args[0].trim().toLowerCase();
                if (arg.equals("0") || arg.equals("off") || arg.equals("disable")) {
                    enable = Boolean.FALSE;
                } else if (arg.equals("1") || arg.equals("on") || arg.equals("enable")) {
                    enable = Boolean.TRUE;
                } else {
                    throw new OptionException("Invalid JBOD mask enable argument: " + args[0], -408);
                }
            }
            return this.msgFactory.newJbodMaskEnableRequest(enable);
        }

        /* synthetic */ 22() {
        }
    }

    private final class 23
    extends DefaultHandler {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            Integer value;
            AcpPropertyCode prop = AcpPropertyMap.getInstance().get("server_mode");
            if (args != null && args.length > 0) {
                String mode = args[0].trim().toLowerCase();
                if (mode.equals("0") || mode.equals("off")) {
                    value = new Integer(0);
                    return this.msgFactory.newSetPropertyRequest(prop.fourCharCode(), value);
                } else {
                    if (!mode.equals("1") && !mode.equals("on")) throw new OptionException("Invalid mode: " + args[0], -409);
                    value = new Integer(1);
                }
                return this.msgFactory.newSetPropertyRequest(prop.fourCharCode(), value);
            } else {
                value = new Integer(1);
            }
            return this.msgFactory.newSetPropertyRequest(prop.fourCharCode(), value);
        }

        /* synthetic */ 23() {
        }
    }

    private final class 24
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "i:l:m:t:c:");
            Integer arrayId = options.get("i").argIntegerValue(0);
            String raidLevel = options.get("l").argStringValue(0);
            String membersOpt = options.get("m").argStringValue(0);
            String raidType = options.get("t").argStringValue(0);
            Integer[] members = null;
            if (membersOpt != null && !membersOpt.equals("")) {
                try {
                    members = CommandLineUtils.parseMembers(membersOpt);
                }
                catch (CommandLineUtils.MemberListFormatException memberListFormatException) {
                    throw new OptionException("Invalid member list", -410);
                }
            }
            return this.msgFactory.newCreateArrayRequest(arrayId, raidLevel, members, raidType);
        }

        /* synthetic */ 24() {
        }
    }

    private final class 25
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "i:");
            Integer arrayId = options.get("i").argIntegerValue(0);
            return this.msgFactory.newDeleteArrayRequest(arrayId);
        }

        /* synthetic */ 25() {
        }
    }

    private final class 26
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "i:c:");
            Integer arrayId = options.get("i").argIntegerValue(0);
            Integer diskCount = options.get("c").argIntegerValue(0);
            return this.msgFactory.newExpandArrayRequest(arrayId, diskCount);
        }

        /* synthetic */ 26() {
        }
    }

    private final class 27
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "i:");
            Integer arrayId = options.get("i").argIntegerValue(0);
            return this.msgFactory.newRecalculateCheckDataRequest(arrayId, "start");
        }

        /* synthetic */ 27() {
        }
    }

    private final class 28
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "i:");
            Integer arrayId = options.get("i").argIntegerValue(0);
            return this.msgFactory.newVerifyCheckDataRequest(arrayId, "start");
        }

        /* synthetic */ 28() {
        }
    }

    private final class 29
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "i:s:l:");
            Integer arrayId = options.get("i").argIntegerValue(0);
            Integer sliceId = options.get("s").argIntegerValue(0);
            Integer lunId = options.get("l").argIntegerValue(0);
            return this.msgFactory.newLUNAssignmentRequest(arrayId, sliceId, lunId);
        }

        /* synthetic */ 29() {
        }
    }

    private final class 30
    extends DefaultHandler {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            RequestMessage request = null;
            if (args.length == 0) return this.msgFactory.newClearRaidControllerEventLogRequest();
            OptionSet options = new OptionSet(args, "t:");
            String type = options.get("t").argStringValue(0);
            if (type.equalsIgnoreCase("coprocessor")) return this.msgFactory.newClearEventLogRequest();
            if (type.equalsIgnoreCase("system_controller")) {
                return this.msgFactory.newClearEventLogRequest();
            }
            if (type.equalsIgnoreCase("raid_controller")) return this.msgFactory.newClearRaidControllerEventLogRequest();
            if (type.equalsIgnoreCase("controller")) return this.msgFactory.newClearRaidControllerEventLogRequest();
            if (!type.equalsIgnoreCase("raid")) throw new OptionException("Invalid log type \"" + type + "\"");
            return this.msgFactory.newClearRaidControllerEventLogRequest();
        }

        /* synthetic */ 30() {
        }
    }

    private final class 31
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            if (args != null && args.length >= 1) {
                if (!args[0].equals("on") && !args[0].equals("off")) {
                    throw new OptionException("Illegal power state: " + args[0], -411);
                }
            } else {
                throw new OptionException("Power state must be 'on' or 'off'", -411);
            }
            return this.msgFactory.newPowerRequest(args[0]);
        }

        /* synthetic */ 31() {
        }
    }

    private final class 32
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            return this.msgFactory.newRestartSystemRequest();
        }

        /* synthetic */ 32() {
        }
    }

    private final class 33
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            return this.msgFactory.newRestartRaidControllerRequest();
        }

        /* synthetic */ 33() {
        }
    }

    private final class 34
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            return this.msgFactory.newFlushRaidControllerNvramRequest();
        }

        /* synthetic */ 34() {
        }
    }

    private final class 35
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            return this.msgFactory.newResetControllerNvramRequest();
        }

        /* synthetic */ 35() {
        }
    }

    private final class 36
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "d:m:");
            String device = options.get("d").argStringValue(0);
            String message = options.get("m").argStringValue(0);
            return this.msgFactory.newMorseCodeRequest(device, message);
        }

        /* synthetic */ 36() {
        }
    }

    private final class 37
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "l:a:p:");
            String led = options.get("l").argStringValue(0);
            String action = options.get("a").argStringValue(0);
            Integer passes = options.get("p").argIntegerValue(0);
            return this.msgFactory.newLedDiagnosticRequest(led, action, passes);
        }

        /* synthetic */ 37() {
        }
    }

    private final class 38
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "s:");
            String state = options.get("s").argStringValue(0);
            return this.msgFactory.newIlluminateRequest("buzzer", null, state);
        }

        /* synthetic */ 38() {
        }
    }

    private final class 39
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "m:p:");
            String mode = options.get("m").argStringValue(0);
            Integer passes = options.get("p").argIntegerValue(0);
            return this.msgFactory.newControllerCacheDiagnosticRequest(mode, passes);
        }

        /* synthetic */ 39() {
        }
    }

    private final class 40
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "a:p:");
            String action = options.get("a").argStringValue(0);
            Integer passes = options.get("p").argIntegerValue(0);
            return this.msgFactory.newFibreChannelDiagnosticRequest(action, passes);
        }

        /* synthetic */ 40() {
        }
    }

    private final class 41
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "1:2:a:p:");
            Integer port1 = options.get("1").argIntegerValue(0);
            Integer port2 = options.get("2").argIntegerValue(0);
            String action = options.get("a").argStringValue(0);
            Integer passes = options.get("p").argIntegerValue(0);
            return this.msgFactory.newSerialInterfaceDiagnosticRequest(port1, port2, action, passes);
        }

        /* synthetic */ 41() {
        }
    }

    private final class 42
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "d:a:m:c:p:");
            Integer disk = options.get("d").argIntegerValue(0);
            String action = options.get("a").argStringValue(0);
            String mode = options.get("m").argStringValue(0);
            Integer cylinders = options.get("c").argIntegerValue(0);
            Integer passes = options.get("p").argIntegerValue(0);
            return this.msgFactory.newDiskDiagnosticRequest(disk, action, mode, cylinders, passes);
        }

        /* synthetic */ 42() {
        }
    }

    private final class 43
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "b:s:");
            Integer block = options.get("b").argIntegerValue(0);
            String signature = options.get("s").argStringValue(0);
            return this.msgFactory.newWriteSignatureRequest(block, signature);
        }

        /* synthetic */ 43() {
        }
    }

    private final class 44
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "b:s:");
            Integer block = options.get("b").argIntegerValue(0);
            Integer maxSize = options.get("s").argIntegerValue(0);
            return this.msgFactory.newReadSignatureRequest(block, maxSize);
        }

        /* synthetic */ 44() {
        }
    }

    private final class 45
    extends DefaultHandler {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            int controllerType;
            OptionSet options = new OptionSet(args, "d:t:i:");
            String device = options.get("d").argStringValue(0);
            if (device == null) {
                throw new OptionException("No device specified");
            }
            String file = options.get("i").argStringValue(0);
            if (file == null) throw new OptionException("No flash ROM image file specified");
            if (file.length() == 0) {
                throw new OptionException("No flash ROM image file specified");
            }
            int flashType = 0;
            if (device.equals("system_controller") || device.equals("system-controller")) {
                controllerType = 0;
                String type = options.get("t").argStringValue(0);
                if (type == null) {
                    throw new OptionException("No flash type specified. Must be 'full' or 'update'.", -413);
                }
                if (type.equals("full")) {
                    flashType = 0;
                } else {
                    if (!type.equals("update")) throw new OptionException("Invalid flash update type: " + type, -413);
                    flashType = 1;
                }
            } else {
                if (!device.equals("raid_controller")) {
                    if (!device.equals("raid-controller")) throw new OptionException("Invalid device: " + device, -414);
                }
                controllerType = 1;
            }
            try {
                return this.msgFactory.newUpdateFirmwareRequest(controllerType, flashType, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new OptionException("ROM image file " + file + " could not be opened", -412);
            }
        }

        /* synthetic */ 45() {
        }
    }

    private final class 46
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "i:");
            Integer arrayId = options.get("i").argIntegerValue(0);
            return this.msgFactory.newRecalculateCheckDataRequest(arrayId, "stop");
        }

        /* synthetic */ 46() {
        }
    }

    private final class 47
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "i:");
            Integer arrayId = options.get("i").argIntegerValue(0);
            return this.msgFactory.newVerifyCheckDataRequest(arrayId, "stop");
        }

        /* synthetic */ 47() {
        }
    }

    private final class 48
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            return this.msgFactory.newLedDiagnosticRequest(null, "stop", null);
        }

        /* synthetic */ 48() {
        }
    }

    private final class 49
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            return this.msgFactory.newFibreChannelDiagnosticRequest("stop", null);
        }

        /* synthetic */ 49() {
        }
    }

    private final class 50
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "1:2:");
            Integer port1 = options.get("1").argIntegerValue(0);
            Integer port2 = options.get("2").argIntegerValue(0);
            return this.msgFactory.newSerialInterfaceDiagnosticRequest(port1, port2, "stop", null);
        }

        /* synthetic */ 50() {
        }
    }

    private final class 51
    extends DefaultHandler {
        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            OptionSet options = new OptionSet(args, "d:a:m:c:p:");
            Integer disk = options.get("d").argIntegerValue(0);
            String mode = options.get("m").argStringValue(0);
            Integer cylinders = options.get("c").argIntegerValue(0);
            Integer passes = options.get("p").argIntegerValue(0);
            return this.msgFactory.newDiskDiagnosticRequest(disk, "stop", mode, cylinders, passes);
        }

        /* synthetic */ 51() {
        }
    }

    private static class GetPropertyHandler
    extends DefaultHandler {
        private String propertyCode;

        public GetPropertyHandler(AcpPropertyCode propertyCode) {
            this.propertyCode = propertyCode.fourCharCode();
        }

        public GetPropertyHandler(String propertyCode) throws OptionException {
            if (propertyCode == null || propertyCode.length() != 4) {
                throw new OptionException("Invalid property code: " + propertyCode);
            }
            this.propertyCode = propertyCode;
        }

        public RequestMessage createRequestMessage(String[] args) {
            return this.msgFactory.newGetPropertyRequest(this.propertyCode);
        }
    }

    private static class SetPropertyHandler
    extends DefaultHandler {
        private String propertyCode;

        public SetPropertyHandler(AcpPropertyCode propertyCode) {
            this.propertyCode = propertyCode.fourCharCode();
        }

        public SetPropertyHandler(String propertyCode) throws OptionException {
            if (propertyCode == null || propertyCode.length() != 4) {
                throw new OptionException("Invalid property code: " + propertyCode);
            }
            this.propertyCode = propertyCode;
        }

        public RequestMessage createRequestMessage(String[] args) throws OptionException {
            if (args.length < 1) {
                throw new OptionException("Illegal number of arguments");
            }
            Object arg = args[0];
            try {
                arg = new Integer(args[0]);
            }
            catch (NumberFormatException numberFormatException) {}
            return this.msgFactory.newSetPropertyRequest(this.propertyCode, arg);
        }
    }

    private static abstract class AbstractHandler
    implements CommandHandler,
    Cloneable {
        private String hostAddress;
        protected int timeout = 0;
        protected String user;
        protected String password;
        protected String xsyncTarget;
        protected boolean encryptionEnabled = true;

        protected void setHostAddress(String address) {
            this.hostAddress = address;
        }

        public String getHostAddress() {
            if (this.hostAddress != null && this.hostAddress.length() > 0) {
                return this.hostAddress;
            }
            String xsrhost = null;
            try {
                xsrhost = System.getProperty("XSRHOST");
            }
            catch (Exception exception) {}
            if (xsrhost != null && xsrhost.length() > 0) {
                return xsrhost;
            }
            return null;
        }

        public String getUser() {
            if (this.user == null) {
                String xsruser = null;
                try {
                    xsruser = System.getProperty("XSRUSER");
                }
                catch (Exception exception) {}
                if (xsruser != null) {
                    return xsruser;
                }
            }
            return this.user;
        }

        public String getPassword() {
            if (this.password == null) {
                String xsrpasswd = null;
                try {
                    xsrpasswd = System.getProperty("XSRPASSWD");
                }
                catch (Exception exception) {}
                if (xsrpasswd != null) {
                    return xsrpasswd;
                }
                return "";
            }
            return this.password;
        }

        public RequestMessage.Target getTargetController() throws OptionException {
            RequestMessage.Target target = null;
            if (this.xsyncTarget != null) {
                if (this.xsyncTarget.equalsIgnoreCase("master")) {
                    target = RequestMessage.Target.MASTER;
                } else if (this.xsyncTarget.equalsIgnoreCase("top")) {
                    target = RequestMessage.Target.TOP;
                } else if (this.xsyncTarget.equalsIgnoreCase("companion")) {
                    target = RequestMessage.Target.COMPANION;
                } else if (this.xsyncTarget.equalsIgnoreCase("bottom")) {
                    target = RequestMessage.Target.BOTTOM;
                } else {
                    throw new OptionException("Unrecognized controller target (" + this.xsyncTarget + ")", -401);
                }
            }
            return target;
        }

        public boolean isEncryptionEnabled() {
            return this.encryptionEnabled;
        }

        public Object clone() throws CloneNotSupportedException {
            AbstractHandler result = (AbstractHandler)super.clone();
            return result;
        }

        protected void parseGlobalArgs(String[] args) throws OptionException, MissingArgumentException {
            String optstring = "a:c:t:u:p:x:";
            OptionTokenizer getopt = new OptionTokenizer(args, optstring);
            try {
                CommandLineOption option;
                while ((option = getopt.nextOption()) != null) {
                    if (option.getName().equals("a")) {
                        this.hostAddress = option.argStringValue(0);
                        continue;
                    }
                    if (option.getName().equals("c")) {
                        this.xsyncTarget = option.argStringValue(0);
                        continue;
                    }
                    if (option.getName().equals("t")) {
                        Integer i = option.argIntegerValue(0);
                        if (i == null) continue;
                        this.timeout = i;
                        continue;
                    }
                    if (option.getName().equals("u")) {
                        this.user = option.argStringValue(0);
                        continue;
                    }
                    if (option.getName().equals("p")) {
                        this.password = option.argStringValue(0);
                        continue;
                    }
                    if (!option.getName().equals("x")) continue;
                    String val = option.argStringValue(0);
                    if (val.equalsIgnoreCase("off") || val.equalsIgnoreCase("false") || val.equals("0")) {
                        this.encryptionEnabled = false;
                        continue;
                    }
                    if (val.equalsIgnoreCase("on") || val.equalsIgnoreCase("true") || val.equals("1")) {
                        this.encryptionEnabled = true;
                        continue;
                    }
                    throw new OptionException("Unrecognized encryption flag \"" + val + "\"");
                }
            }
            catch (IllegalOptionException illegalOptionException) {}
        }

        AbstractHandler() {
        }

        public abstract void handle(String[] var1, String[] var2, OutputStream var3) throws OptionException, IOException;
    }

    private static abstract class DefaultHandler
    extends AbstractHandler {
        protected MessageFactory msgFactory;

        public void handle(String[] globalArgs, String[] commandArgs, OutputStream out) throws OptionException, IOException {
            this.parseGlobalArgs(globalArgs);
            if (this.getHostAddress() == null) {
                throw new OptionException("No host address specified", -405);
            }
            this.msgFactory = new AcpxMessageFactory();
            ((AcpxMessageFactory)this.msgFactory).setDefaultTimeout(this.timeout);
            if (this.getUser() != null) {
                ((AcpxMessageFactory)this.msgFactory).setDefaultUser(this.getUser());
                ((AcpxMessageFactory)this.msgFactory).setDefaultPassword(this.getPassword(), true);
            }
            RequestMessage request = this.createRequestMessage(commandArgs);
            request.setTargetController(this.getTargetController());
            AcpxConnection connection = new AcpxConnection(this.getHostAddress());
            connection.setPersistent(false);
            connection.setEncrypted(this.isEncryptionEnabled());
            PropertyList response = connection.send(request);
            if (out != null) {
                try {
                    response.writeTo(out);
                }
                catch (PropertyListException e) {
                    throw new IOException("error processing plist: " + e.getMessage());
                }
            }
        }

        public abstract RequestMessage createRequestMessage(String[] var1) throws OptionException;

        public Object clone() throws CloneNotSupportedException {
            DefaultHandler result = (DefaultHandler)super.clone();
            result.msgFactory = this.msgFactory;
            return result;
        }

        DefaultHandler() {
        }
    }
}

