/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.cli;

import com.apple.xsr.cli.CommandDispatcher;
import com.apple.xsr.cli.OptionException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;

public class CommandLineInterface {
    private static final CommandLineInterface INSTANCE = new CommandLineInterface();

    private CommandLineInterface() {
    }

    public static CommandLineInterface getInstance() {
        return INSTANCE;
    }

    public void execute(String[] args) throws OptionException, IOException {
        this.execute(args, System.out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(String[] args, OutputStream out) throws OptionException, IOException {
        String[] commandArgs;
        String command = null;
        String commandObject = null;
        int commandArgsIndex = -1;
        int commandIndex = this.indexOfCommandToken(args, null);
        if (commandIndex != -1) {
            command = args[commandIndex];
            if (commandIndex >= args.length - 1) throw new OptionException("No object specified for " + command + " command");
            commandObject = args[commandIndex + 1];
            commandArgsIndex = commandIndex + 2 < args.length ? commandIndex + 2 : -1;
        } else {
            commandIndex = this.indexOfCommandToken(args, "do");
            if (commandIndex == -1) throw new OptionException("Command not found");
            command = "do";
            commandObject = args[commandIndex];
            commandArgsIndex = commandIndex + 1 < args.length ? commandIndex + 1 : -1;
        }
        String[] globalArgs = new String[commandIndex];
        System.arraycopy(args, 0, globalArgs, 0, commandIndex);
        if (commandArgsIndex != -1) {
            commandArgs = new String[args.length - commandArgsIndex];
            System.arraycopy(args, commandArgsIndex, commandArgs, 0, args.length - commandArgsIndex);
        } else {
            commandArgs = new String[]{};
        }
        CommandDispatcher.getInstance().dispatch(command, commandObject, globalArgs, commandArgs, out);
    }

    private int indexOfCommandToken(String[] args, String commandType) {
        Set commands = CommandDispatcher.getInstance().getCommands(commandType);
        int index = -1;
        int i = 0;
        while (i < args.length) {
            if (commands.contains(args[i])) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }
}

