/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.cli;

import com.apple.xsr.cli.OptionException;

public class CommandLineOption {
    private String name;
    private String[] args;

    public CommandLineOption(String name) {
        this.name = name;
        this.args = new String[0];
    }

    public String getName() {
        return this.name;
    }

    public String[] getArguments() {
        return this.args;
    }

    public void setArguments(String[] args) {
        if (args == null) {
            throw new NullPointerException("Args cannot be null");
        }
        this.args = args;
    }

    public String argStringValue(int index) {
        String value = null;
        if (index >= 0 && index < this.args.length) {
            value = this.args[index];
        }
        return value;
    }

    public Integer argIntegerValue(int index) throws OptionException {
        Integer value = null;
        if (index >= 0 && index < this.args.length) {
            try {
                value = new Integer(this.args[index]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new OptionException("Invalid integer argument: " + this.args[index], -406);
            }
        }
        return value;
    }
}

