/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.cli;

import java.util.HashSet;
import java.util.StringTokenizer;

public class CommandLineUtils {
    public static Integer[] parseMembers(String list) throws MemberListFormatException {
        HashSet<Integer> members = new HashSet<Integer>();
        Integer current = null;
        Integer first = null;
        boolean range = false;
        if (!list.endsWith(",")) {
            list = String.valueOf(list) + ",";
        }
        StringTokenizer st = new StringTokenizer(list, ",-", true);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("-")) {
                if (current == null) {
                    throw new MemberListFormatException("Dash in illegal location");
                }
                first = current;
                current = null;
                range = true;
                continue;
            }
            if (s.equals(",")) {
                if (current == null) {
                    throw new MemberListFormatException("Comma in illegal location");
                }
                try {
                    if (range) {
                        int i;
                        if (first.compareTo(current) < 0) {
                            i = first;
                            while (i <= current) {
                                members.add(new Integer(i));
                                ++i;
                            }
                        } else if (first.compareTo(current) > 0) {
                            i = first;
                            while (i >= current) {
                                members.add(new Integer(i));
                                --i;
                            }
                        } else {
                            members.add(current);
                        }
                        first = null;
                        range = false;
                    } else {
                        members.add(current);
                    }
                    current = null;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new MemberListFormatException("Illegal member: " + current);
                }
            }
            try {
                current = new Integer(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MemberListFormatException("Not a number: " + s);
            }
        }
        return members.toArray(new Integer[0]);
    }

    public static class MemberListFormatException
    extends IllegalArgumentException {
        public MemberListFormatException() {
        }

        public MemberListFormatException(String s) {
            super(s);
        }
    }
}

