/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.cli;

import com.apple.xsr.cli.CommandLineOption;
import com.apple.xsr.cli.IllegalOptionException;
import com.apple.xsr.cli.MissingArgumentException;
import com.apple.xsr.cli.OptionException;
import java.util.Hashtable;
import java.util.Vector;

public class OptionTokenizer {
    private String[] args;
    private Hashtable options;
    private int index;
    private int nextArgIndex;
    private int groupIndex;
    private boolean processingGroupedArgs;

    public OptionTokenizer(String[] args, String optstring) {
        this.args = args;
        this.index = 0;
        this.nextArgIndex = 0;
        this.groupIndex = 0;
        this.processingGroupedArgs = false;
        this.options = new Hashtable();
        this.parseOptionString(optstring);
    }

    public boolean hasMoreOptions() {
        boolean moreOptions = true;
        try {
            if (this.getNextOption() == null) {
                moreOptions = false;
            }
        }
        catch (OptionException optionException) {}
        return moreOptions;
    }

    public boolean hasNext() {
        return this.hasMoreOptions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommandLineOption nextOption() throws IllegalOptionException, MissingArgumentException {
        CommandLineOption opt = null;
        OptionException exception = null;
        try {
            try {
                opt = this.getNextOption();
            }
            catch (OptionException oe) {
                exception = oe;
            }
            Object var4_4 = null;
            this.incrementIndex();
            if (exception == null) return opt;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.incrementIndex();
            if (exception == null) throw throwable;
            if (exception instanceof IllegalOptionException) {
                throw (IllegalOptionException)exception;
            }
            if (!(exception instanceof MissingArgumentException)) throw throwable;
            throw (MissingArgumentException)exception;
        }
        if (exception instanceof IllegalOptionException) {
            throw (IllegalOptionException)exception;
        }
        if (!(exception instanceof MissingArgumentException)) return opt;
        throw (MissingArgumentException)exception;
    }

    public Object next() throws IllegalOptionException, MissingArgumentException {
        return this.nextOption();
    }

    /*
     * Enabled aggressive block sorting
     */
    private CommandLineOption getNextOption() throws IllegalOptionException, MissingArgumentException {
        String nextArg;
        int idx;
        String rawArg;
        Vector<String> optionArgs;
        CommandLineOption option;
        block8: {
            block9: {
                option = null;
                optionArgs = null;
                if (this.index >= this.args.length) {
                    return null;
                }
                rawArg = this.args[this.index];
                if (this.processingGroupedArgs) break block8;
                if (!rawArg.startsWith("-") || rawArg.equals("-") || rawArg.equals("--")) break block9;
                String optname = this.getOptionName(rawArg);
                if (!this.isValidOption(optname)) {
                    this.nextArgIndex = this.index + 1;
                    throw new IllegalOptionException(rawArg);
                }
                option = new CommandLineOption(optname);
                if (this.requiresArgs(optname).equals(Boolean.TRUE)) {
                    optionArgs = new Vector<String>();
                    if (rawArg.length() > 2) {
                        optionArgs.add(rawArg.substring(2));
                    }
                    idx = this.index + 1;
                } else {
                    if (rawArg.length() > 2) {
                        this.processingGroupedArgs = true;
                        this.groupIndex = 0;
                    }
                    this.nextArgIndex = this.index + 1;
                    return option;
                }
            }
            rawArg.equals("-");
            if (!rawArg.equals("--")) return option;
            this.nextArgIndex = this.args.length;
            return option;
        }
        String opt = rawArg.substring(this.groupIndex + 1, this.groupIndex + 2);
        if (this.isValidOption(opt) && this.requiresArgs(opt).equals(Boolean.FALSE)) {
            return new CommandLineOption(opt);
        }
        if (!this.requiresArgs(opt).equals(Boolean.TRUE)) throw new IllegalOptionException(opt);
        throw new MissingArgumentException(opt);
        while (!(nextArg = this.args[idx]).startsWith("-") || !this.isValidOption(nextArg)) {
            optionArgs.add(nextArg);
            ++idx;
            if (idx < this.args.length) continue;
        }
        this.nextArgIndex = idx;
        if (optionArgs.size() <= 0) throw new MissingArgumentException(option.getName());
        option.setArguments(optionArgs.toArray(new String[0]));
        return option;
    }

    private void incrementIndex() {
        if (this.processingGroupedArgs) {
            ++this.groupIndex;
            if (this.groupIndex + 1 >= this.args[this.index].length()) {
                this.processingGroupedArgs = false;
                this.groupIndex = 0;
                ++this.index;
            }
        } else if (this.index < this.args.length) {
            this.index = this.nextArgIndex;
        }
    }

    private boolean isValidOption(String option) {
        String optname = this.getOptionName(option);
        if (optname.equals("")) {
            boolean bl = false;
        }
        boolean result = this.options.containsKey(optname);
        return result;
    }

    private Boolean requiresArgs(String option) {
        String optname = this.getOptionName(option);
        Boolean required = (Boolean)this.options.get(option);
        if (required != null) {
            return required;
        }
        return Boolean.FALSE;
    }

    private String getOptionName(String option) {
        String optname = "";
        if (option.startsWith("-") && option.length() >= 2) {
            optname = option.substring(1, 2);
        } else if (option.length() == 1) {
            optname = option;
        }
        return optname;
    }

    private void parseOptionString(String optstring) {
        StringBuffer buffer = new StringBuffer(optstring);
        int idx = 0;
        while (idx < buffer.length()) {
            String opt = buffer.substring(idx, idx + 1);
            Boolean argsRequired = Boolean.FALSE;
            if (idx + 1 < buffer.length() && buffer.charAt(idx + 1) == ':') {
                argsRequired = Boolean.TRUE;
                ++idx;
            }
            this.options.put(opt, argsRequired);
            ++idx;
        }
    }
}

