/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.firstaid;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractChooserMgmtPane;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.ChooserButtonPanel;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DrivePanel;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.Resources;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.som.RaidSystem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public abstract class AbstractFirstAidPane
extends AbstractManagementPane {
    protected static final int STEP_ONE = 1;
    protected static final int STEP_TWO = 2;
    protected static final int STEP_THREE = 3;
    protected static final int STEP_FOUR = 4;
    static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    static final int LEFT_INDENT_1 = 20;
    static final int LEFT_INDENT_2 = 22;
    static final int STEP_VSPACE = 15;
    private static final int PREFERRED_WIDTH = 663;
    private static final int PREFERRED_HEIGHT = 437;
    protected static String paneExecuted = "";
    protected final AbstractChooserMgmtPane parent;
    protected final ImageIcon icon;
    protected final String title;
    protected final String explanation;
    protected final String tag;
    protected RaidSystem system;
    protected DrivePanel driveSelectionPanel;
    protected JLabel legendLabel;
    protected ArraySelectionPanel legend;
    protected StepByStepPanel summaryHeader;
    protected JTextPane summaryLabel;
    protected JCheckBox confirmCheckBox;
    protected ChooserButtonPanel buttons;
    private final GridBagConstraints constraints = new GridBagConstraints();
    private int nextStep = 1;

    public AbstractFirstAidPane(AbstractChooserMgmtPane parent, PaneProperties props) {
        super(663, 437);
        this.parent = parent;
        this.icon = props.icon;
        this.title = props.title;
        this.explanation = props.explanation;
        this.tag = props.tag;
        this.setLayout(new GridBagLayout());
        this.summaryHeader = new StepByStepPanel(Resources.getImage("icon.step.five"), props.summaryTitle);
        this.summaryLabel = GUIFactory.newTextPane(props.summaryText, 2);
        this.buttons = new ChooserButtonPanel(true);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 17;
        this.constraints.fill = 2;
        this.addStep(1, props.headerText);
        JPanel drivePanel = this.createDrivePanel(props.driveSelectionMode, this.summaryHeader, this.summaryLabel, this.buttons.okButton);
        this.constraints.insets = new Insets(0, 20, 15, 0);
        this.add((Component)drivePanel, this.constraints);
        this.constraints.insets = ZERO_INSETS;
        ++this.constraints.gridy;
        this.legendLabel = new JLabel(props.legendTitle);
        this.legendLabel.setVisible(false);
        this.legendLabel.setFont(GUIFactory.FONT_SMALL);
        this.constraints.insets = new Insets(0, 22, 0, 0);
        this.add((Component)this.legendLabel, this.constraints);
        this.constraints.insets = ZERO_INSETS;
        ++this.constraints.gridy;
        this.legend = new ArraySelectionPanel(props.arraySelectionMode);
        this.constraints.insets = new Insets(0, 20, 15, 0);
        this.constraints.fill = 0;
        this.add((Component)this.legend, this.constraints);
        this.constraints.fill = 2;
        this.constraints.insets = ZERO_INSETS;
        ++this.constraints.gridy;
        JPanel confirmPanel = this.createConfirmationPanel(props.confirmText);
        JPanel summaryPanel = this.createSummaryPanel();
        this.addSteps();
        if (confirmPanel != null) {
            this.addStep(this.getNextStep(), props.confirmTitle);
            this.constraints.insets = new Insets(0, 20, 15, 0);
            this.constraints.anchor = 17;
            this.constraints.fill = 0;
            this.constraints.weightx = 1.0;
            this.add((Component)confirmPanel, this.constraints);
            this.constraints.weightx = 0.0;
            this.constraints.insets = ZERO_INSETS;
            this.constraints.fill = 2;
            ++this.constraints.gridy;
        }
        if (summaryPanel != null) {
            this.add((Component)this.summaryHeader, this.constraints);
            ++this.constraints.gridy;
            this.constraints.fill = 1;
            this.constraints.weightx = 1.0;
            this.constraints.weighty = 1.0;
            this.constraints.insets = new Insets(0, 20, 15, 0);
            this.add((Component)summaryPanel, this.constraints);
            this.constraints.weightx = 0.0;
            this.constraints.weighty = 0.0;
            this.constraints.fill = 0;
            this.constraints.insets = ZERO_INSETS;
            ++this.constraints.gridy;
        }
        this.constraints.weighty = 1.0;
        this.add(Box.createVerticalStrut(0), this.constraints);
        this.constraints.weighty = 0.0;
        ++this.constraints.gridy;
        this.constraints.fill = 2;
        this.add((Component)this.buttons, this.constraints);
        this.constraints.fill = 0;
        this.driveSelectionPanel.addPropertyChangeListener("ArrayIndex", new 1());
        this.legend.addPropertyChangeListener("ArrayIndex", new 2());
        if (confirmPanel != null) {
            this.confirmCheckBox.addActionListener(new 3());
        }
        this.buttons.backButton.addActionListener(new 4());
        this.buttons.cancelButton.addActionListener(new 5());
        this.buttons.okButton.setText(props.actionButtonText);
        this.buttons.okButton.addActionListener(new 6());
        this.setSize(this.getPreferredSize());
    }

    protected int getCurrentRow() {
        return this.constraints.gridy;
    }

    protected void setCurrentRow(int row) {
        this.constraints.gridy = row;
    }

    protected int getNextStep() {
        return this.nextStep;
    }

    protected void incrementStep() {
        ++this.nextStep;
    }

    protected abstract void addSteps();

    protected JPanel createDrivePanel(int selectionMode, StepByStepPanel summaryHeader, JTextPane summaryLabel, JButton okButton) {
        JPanel drivePanel = GUIFactory.newPanel(new GridBagLayout());
        DriveInformationPanel driveInfo = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        this.driveSelectionPanel = new DriveSelectionPanel(selectionMode, driveInfo, summaryHeader, summaryLabel, this.buttons.okButton);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 20);
        drivePanel.add((Component)((JPanel)((Object)this.driveSelectionPanel)), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 6, 0);
        drivePanel.add((Component)driveInfo, gbc);
        return drivePanel;
    }

    protected JPanel createConfirmationPanel(String confirmText) {
        JPanel confirmPanel = GUIFactory.newPanel();
        confirmPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.confirmCheckBox = GUIFactory.newCheckBox(confirmText);
        this.confirmCheckBox.setFont(GUIFactory.FONT_SMALL);
        gbc.gridx = 0;
        gbc.gridy = 0;
        confirmPanel.add((Component)this.confirmCheckBox, gbc);
        return confirmPanel;
    }

    protected JPanel createSummaryPanel() {
        JPanel summaryPanel = GUIFactory.newPanel();
        summaryPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        this.summaryLabel.setFont(GUIFactory.FONT_SMALL);
        this.summaryLabel.setEditable(false);
        this.summaryLabel.setOpaque(false);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        summaryPanel.add((Component)this.summaryLabel, gbc);
        return summaryPanel;
    }

    protected final void addStep(int step, String text) {
        Image image;
        switch (step) {
            case 1: {
                image = Resources.getImage("icon.step.one");
                break;
            }
            case 2: {
                image = Resources.getImage("icon.step.two");
                break;
            }
            case 3: {
                image = Resources.getImage("icon.step.three");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid step constant (" + step + ")");
            }
        }
        this.constraints.gridx = 0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 17;
        this.constraints.fill = 2;
        StepByStepPanel stepPanel = new StepByStepPanel(image, text);
        this.add((Component)stepPanel, this.constraints);
        ++this.constraints.gridy;
        this.incrementStep();
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getTag() {
        return this.tag;
    }

    static class PaneProperties {
        ImageIcon icon;
        String title;
        String explanation;
        String tag;
        String headerText;
        String legendTitle;
        String confirmTitle;
        String confirmText;
        String summaryTitle;
        String summaryText;
        String actionButtonText;
        int driveSelectionMode;
        int arraySelectionMode;

        PaneProperties() {
        }
    }

    private final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            int value = (Integer)e.getNewValue();
            AbstractFirstAidPane.this.legend.setArrayIndex(value);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            int value = (Integer)e.getNewValue();
            AbstractFirstAidPane.this.driveSelectionPanel.setSelectedArray(value + 1);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            boolean selected = AbstractFirstAidPane.this.confirmCheckBox.isSelected();
            AbstractFirstAidPane.this.driveSelectionPanel.setConfirmed(selected);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AbstractFirstAidPane.this.parent.goBackToChooser();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(AbstractFirstAidPane.this.parent, 1001, "CANCEL");
            AbstractFirstAidPane.this.parent.fireActionPerformed(event);
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            paneExecuted = AbstractFirstAidPane.this.getTag();
            ActionEvent event = new ActionEvent(AbstractFirstAidPane.this, 1001, "APPLY");
            AbstractFirstAidPane.this.parent.fireActionPerformed(event);
        }

        /* synthetic */ 6() {
        }
    }
}

