/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.firstaid;

import com.apple.xsr.AbstractChooserMgmtPane;
import com.apple.xsr.DataModel;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.OperationManager;
import com.apple.xsr.Resources;
import com.apple.xsr.firstaid.ConditionPane;
import com.apple.xsr.firstaid.FirstAidDataModel;
import com.apple.xsr.firstaid.ManageOrphansPane;
import com.apple.xsr.firstaid.RebuildPane;
import com.apple.xsr.firstaid.RecognizeArrayPane;
import com.apple.xsr.firstaid.VerifyPane;
import com.apple.xsr.som.RaidSystem;

public class FirstAidChooserPane
extends AbstractChooserMgmtPane {
    private static final int PREFERRED_WIDTH = 780;
    private static final int PREFERRED_HEIGHT = 560;
    private VerifyPane verifyPane = new VerifyPane(this);
    private RebuildPane rebuildPane = new RebuildPane(this);
    private ConditionPane conditionPane = new ConditionPane(this);
    private ManageOrphansPane manageOrphansPane = new ManageOrphansPane(this);
    private RecognizeArrayPane recognizeArrayPane = new RecognizeArrayPane(this);
    private ManagementPane[] panes = new ManagementPane[]{this.verifyPane, this.rebuildPane, this.conditionPane, this.manageOrphansPane, this.recognizeArrayPane};

    public FirstAidChooserPane() {
        super(780, 560, Resources.getString("firstAid.choose"));
        this.setPanes(this.panes, true);
    }

    public void populateUI(DataModel data) {
        int i = 0;
        while (i < this.panes.length) {
            this.panes[i].populateUI((FirstAidDataModel)data);
            ++i;
        }
        RaidSystem system = data.getRaidSystem();
        boolean verifyEnabled = true;
        boolean rebuildEnabled = true;
        boolean conditionEnabled = true;
        boolean manageOrphansEnabled = true;
        if (system != null) {
            try {
                verifyEnabled = OperationManager.isSupported(system, OperationManager.OP_VERIFY_ARRAY);
                rebuildEnabled = OperationManager.isSupported(system, OperationManager.OP_REBUILD_ARRAY);
                conditionEnabled = OperationManager.isSupported(system, OperationManager.OP_BACKGROUND_CONDITION);
                manageOrphansEnabled = OperationManager.isSupported(system, OperationManager.OP_DELETE_ORPHAN);
            }
            catch (Exception exception) {}
        }
        this.chooserPanel.setPaneEnabled(this.verifyPane, verifyEnabled);
        this.chooserPanel.setPaneEnabled(this.rebuildPane, rebuildEnabled);
        this.chooserPanel.setPaneEnabled(this.conditionPane, conditionEnabled);
        this.chooserPanel.setPaneEnabled(this.manageOrphansPane, manageOrphansEnabled);
        if (verifyEnabled) {
            this.chooserPanel.setSelectedPane(this.verifyPane);
        } else if (rebuildEnabled) {
            this.chooserPanel.setSelectedPane(this.rebuildPane);
        } else if (conditionEnabled) {
            this.chooserPanel.setSelectedPane(this.conditionPane);
        } else if (manageOrphansEnabled) {
            this.chooserPanel.setSelectedPane(this.manageOrphansPane);
        }
    }

    public void populateUI(DataModel[] data) {
        throw new UnsupportedOperationException();
    }

    public boolean validateUI(DataModel data) {
        int i = 0;
        while (i < this.panes.length) {
            this.panes[i].validateUI((FirstAidDataModel)data);
            ++i;
        }
        return true;
    }

    public boolean validateUI(DataModel[] data) {
        throw new UnsupportedOperationException();
    }
}

