/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.firstaid;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractChooserMgmtPane;
import com.apple.xsr.DataModel;
import com.apple.xsr.DriveInfoPanelController;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DrivePanel;
import com.apple.xsr.DrivePanelEvent;
import com.apple.xsr.DrivePanelListener;
import com.apple.xsr.DriveSelectionPanelEx;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.firstaid.AbstractFirstAidPane;
import com.apple.xsr.firstaid.FirstAidDataModel;
import com.apple.xsr.som.Disk;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;

class RecognizeArrayPane
extends AbstractFirstAidPane {
    public static final String TAG = "RECOGNIZE_ARRAY_PANE";
    public static final String ACTION_CMD_UPPER_RADIO = "UPPER";
    public static final String ACTION_CMD_LOWER_RADIO = "LOWER";
    private static final Image IMG_VALIDATE_OK = Resources.getImage("icon.step.four");
    private static final Image IMG_VALIDATE_ERROR = Resources.getImage("icon.step.five");
    private static final AbstractFirstAidPane.PaneProperties props = new AbstractFirstAidPane.PaneProperties();
    private RadioButtonGroup controllerButtonGroup;
    private JRadioButton upperControllerRadio;
    private JRadioButton lowerControllerRadio;
    private int orphanCountTop;
    private int orphanCountBottom;
    private boolean radioClicked = false;

    static {
        RecognizeArrayPane.props.icon = new ImageIcon(Resources.getImage("icon.recognizeArray"));
        RecognizeArrayPane.props.title = Resources.getString("firstAid.recognizeArray");
        RecognizeArrayPane.props.explanation = Resources.getString("firstAid.recognizeArrayExplanation");
        RecognizeArrayPane.props.tag = TAG;
        RecognizeArrayPane.props.headerText = Resources.getString("firstAid.recognizeArray.examineDrives");
        RecognizeArrayPane.props.legendTitle = Resources.getString("firstAid.general.legendTitle");
        RecognizeArrayPane.props.summaryTitle = Resources.getString("firstAid.general.summaryTitle");
        RecognizeArrayPane.props.summaryText = Resources.getString("firstAid.recognizeArray.summary");
        RecognizeArrayPane.props.actionButtonText = Resources.getString("firstAid.recognizeArray.actionButton");
        RecognizeArrayPane.props.driveSelectionMode = 3;
        RecognizeArrayPane.props.arraySelectionMode = 0;
    }

    public RecognizeArrayPane(AbstractChooserMgmtPane parent) {
        super(parent, props);
        this.buttons.setRestartRequiredLabelVisible(true);
        this.buttons.okButton.setEnabled(false);
    }

    public void populateUI(DataModel data) {
        if (data == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (!(data instanceof FirstAidDataModel)) {
            throw new IllegalArgumentException("illegal data model type \"" + data.getClass() + "\"");
        }
        FirstAidDataModel model = (FirstAidDataModel)data;
        this.system = model.getRaidSystem();
        this.driveSelectionPanel.setRaidSystem(this.system);
        this.legend.setRaidSystem(this.system);
        int i = 1;
        while (i <= 2) {
            Iterator iter = this.system.getRaidController(i).getDisks().iterator();
            while (iter.hasNext()) {
                if (((Disk)iter.next()).getType() != 4) continue;
                if (i == 1) {
                    ++this.orphanCountTop;
                    continue;
                }
                ++this.orphanCountBottom;
            }
            ++i;
        }
    }

    public boolean validateUI(DataModel data) {
        if (data != null && AbstractFirstAidPane.paneExecuted.equals(TAG)) {
            if (!(data instanceof FirstAidDataModel)) {
                throw new IllegalArgumentException("illegal data model type \"" + data.getClass() + "\"");
            }
            FirstAidDataModel model = (FirstAidDataModel)data;
            model.setOperation(7);
            model.setControllerID(this.getSelectedControllerID());
        }
        return true;
    }

    protected final JPanel createDrivePanel(int selectionMode, StepByStepPanel summaryHeader, JTextPane summaryLabel, JButton okButton) {
        JPanel drivePanel = GUIFactory.newPanel(new GridBagLayout());
        DriveInformationPanel driveInfo = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        this.driveSelectionPanel = new DriveSelectionPanelEx(selectionMode);
        ((DriveSelectionPanelEx)this.driveSelectionPanel).setSelectionPolicy(new DrivePanel.DefaultSelectionPolicy(-1, -1));
        ((DriveSelectionPanelEx)this.driveSelectionPanel).addDrivePanelListener(new 1());
        DriveInfoPanelController infoController = new DriveInfoPanelController(driveInfo);
        ((DriveSelectionPanelEx)this.driveSelectionPanel).addDrivePanelListener(infoController);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 20);
        drivePanel.add((Component)((JPanel)((Object)this.driveSelectionPanel)), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 6, 0);
        drivePanel.add((Component)driveInfo, gbc);
        return drivePanel;
    }

    protected JPanel createConfirmationPanel(String confirmText) {
        return null;
    }

    protected void addSteps() {
        this.controllerButtonGroup = new RadioButtonGroup();
        this.addStep(this.getNextStep(), Resources.getString("firstAid.recognizeArray.chooseController"));
        JPanel chooseControllerPanel = GUIFactory.newPanel(new GridBagLayout());
        ControllerRadioListener radioListener = new ControllerRadioListener();
        this.upperControllerRadio = GUIFactory.newRadioButton(Resources.getString("firstAid.recognizeArray.chooseController.upper"));
        this.upperControllerRadio.setFont(GUIFactory.FONT_SMALL);
        this.upperControllerRadio.setActionCommand(ACTION_CMD_UPPER_RADIO);
        this.upperControllerRadio.addActionListener(radioListener);
        this.lowerControllerRadio = GUIFactory.newRadioButton(Resources.getString("firstAid.recognizeArray.chooseController.lower"));
        this.lowerControllerRadio.setFont(GUIFactory.FONT_SMALL);
        this.lowerControllerRadio.setActionCommand(ACTION_CMD_LOWER_RADIO);
        this.lowerControllerRadio.addActionListener(radioListener);
        this.controllerButtonGroup.add(this.upperControllerRadio);
        this.controllerButtonGroup.add(this.lowerControllerRadio);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        chooseControllerPanel.add((Component)this.upperControllerRadio, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        chooseControllerPanel.add((Component)this.lowerControllerRadio, gbc);
        gbc.gridx = 0;
        gbc.gridy = this.getCurrentRow();
        gbc.insets = new Insets(0, 20, 15, 0);
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        this.add((Component)chooseControllerPanel, gbc);
        this.setCurrentRow(gbc.gridy + 1);
    }

    private int getSelectedControllerID() {
        int controller = this.controllerButtonGroup.getSelectedIndex();
        if (controller != -1) {
            controller = controller == 0 ? 1 : 2;
        }
        return controller;
    }

    private boolean isPaneValid() {
        int orphanCount = 0;
        int controllerID = this.getSelectedControllerID();
        if (controllerID != -1) {
            orphanCount = controllerID == 1 ? this.orphanCountTop : this.orphanCountBottom;
        }
        return orphanCount > 1;
    }

    private final class 1
    implements DrivePanelListener {
        public void valueChanged(DrivePanelEvent e) {
            if (!e.getValueIsAdjusting() && e.getStateChange() == 1) {
                int id = e.getFirstID();
                if (id <= 7) {
                    RecognizeArrayPane.this.upperControllerRadio.setSelected(true);
                } else {
                    RecognizeArrayPane.this.lowerControllerRadio.setSelected(true);
                }
                boolean valid = RecognizeArrayPane.this.isPaneValid();
                RecognizeArrayPane.this.buttons.okButton.setEnabled(valid);
                RecognizeArrayPane.this.summaryHeader.setIcon(valid ? IMG_VALIDATE_OK : IMG_VALIDATE_ERROR);
            }
        }

        public void driveIconEntered(DrivePanelEvent e) {
        }

        public void driveIconExited(DrivePanelEvent e) {
        }

        public void driveIconClicked(DrivePanelEvent e) {
        }

        /* synthetic */ 1() {
        }
    }

    private class ControllerRadioListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == RecognizeArrayPane.ACTION_CMD_UPPER_RADIO) {
                ((DriveSelectionPanelEx)RecognizeArrayPane.this.driveSelectionPanel).doClick(1);
            } else {
                ((DriveSelectionPanelEx)RecognizeArrayPane.this.driveSelectionPanel).doClick(8);
            }
        }

        ControllerRadioListener() {
        }
    }
}

