/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.util.plist.PListUtils;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.xsr.net.Response;
import java.util.Map;

public class BasicResponse
implements Response {
    private int type;
    private Object content;
    private int result;
    private Exception exception;

    public BasicResponse(int type, Object content) {
        this(type, content, 0, null);
    }

    public BasicResponse(int type, Object content, int result) {
        this(type, content, result, null);
    }

    public BasicResponse(int type, Object content, int result, Exception e) {
        this.type = type;
        this.content = content;
        this.result = result;
        this.exception = e;
        if (content != null) {
            this.result = this.getStatus((PropertyList)content);
        }
    }

    public int getType() {
        return this.type;
    }

    public Object getContent() {
        return this.content;
    }

    public int getResultCode() {
        return this.result;
    }

    public Exception getException() {
        return this.exception;
    }

    private int getStatus(PropertyList plist) {
        int err = -100;
        try {
            Map rootDict = PListUtils.toDictionary(plist.getRootElement(), "root dict");
            Object status = rootDict.get("status");
            err = status != null ? PListUtils.toInteger(status, "status").intValue() : 0;
        }
        catch (PropertyListException e) {
            this.exception = e;
        }
        return err;
    }
}

