/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.xsr.net.HttpRequest;
import com.apple.xsr.net.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class HttpConnection {
    public static final int CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_SO_TIMEOUT = 30000;
    public static final String SCHEME = "http";
    public static final int PORT = 80;
    private Socket socket;
    private String host;
    private boolean connected = false;
    private boolean persistent = false;
    private int timeout = 30000;
    private boolean requestOutstanding = false;
    private boolean requestSent = false;
    private boolean responseReceived = false;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$net$HttpConnection != null ? class$com$apple$xsr$net$HttpConnection : (class$com$apple$xsr$net$HttpConnection = HttpConnection.class$("com.apple.xsr.net.HttpConnection")));
    static /* synthetic */ Class class$com$apple$xsr$net$HttpConnection;

    public HttpConnection(String host) throws IOException, UnknownHostException {
        this.host = host;
    }

    public HttpRequest newRequest(String path) throws IOException, MalformedURLException {
        if (this.requestOutstanding) {
            String msg = "There is an outstanding request. Either send the request or read the response first.";
            throw new IllegalStateException(msg);
        }
        URL u = new URL(SCHEME, this.host, path);
        HttpRequest request = new HttpRequest(this, u);
        this.requestOutstanding = true;
        this.requestSent = false;
        return request;
    }

    public HttpResponse getResponse() throws IOException {
        if (!this.requestOutstanding) {
            throw new IllegalStateException("No outstanding request");
        }
        if (!this.requestSent) {
            throw new IllegalStateException("Unsent request outstanding");
        }
        HttpResponse response = new HttpResponse(this);
        return response;
    }

    public void connect() throws IOException {
        if (this.socket == null || !this.connected) {
            this.createSocket(5000);
            this.connected = true;
        }
    }

    public void disconnect() throws IOException {
        if (this.socket != null) {
            try {
                this.socket.close();
                logger.debug("Socket closed");
            }
            finally {
                Object var2_1 = null;
                this.socket = null;
                this.connected = false;
            }
        }
    }

    public void open() throws IOException {
        this.connect();
    }

    public void close() throws IOException {
        this.disconnect();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setTimeout(int timeout) throws IOException {
        int newTimeout = timeout != 0 ? timeout : 30000;
        if (newTimeout == this.timeout) {
            return;
        }
        try {
            this.socket.setSoTimeout(newTimeout);
            this.timeout = newTimeout;
        }
        catch (SocketException e) {
            throw new IOException("Failed to set SO timeout: " + e.getMessage());
        }
    }

    public int getTimeout() throws IOException {
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException e) {
            throw new IOException("Failed to read SO timeout: " + e.getMessage());
        }
    }

    OutputStream getOutputStream() throws IOException {
        if (this.socket == null || !this.isConnected()) {
            this.connect();
        }
        return this.socket.getOutputStream();
    }

    InputStream getInputStream() throws IOException {
        if (this.socket == null || !this.isConnected()) {
            this.connect();
        }
        return this.socket.getInputStream();
    }

    void setRequestOutstanding(boolean outstanding) {
        this.requestOutstanding = outstanding;
    }

    void setRequestSent(boolean sent) {
        this.requestSent = sent;
    }

    private void createSocket(int timeout) throws IOException {
        this.socket = new Socket(this.host, 80);
        try {
            this.socket.setSoTimeout(this.timeout);
        }
        catch (SocketException e) {
            logger.error(e);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private class SocketProducer
    extends Thread {
        private Socket socket;
        private String host;
        private int port;
        private IOException exception;
        private boolean aborted = false;

        public SocketProducer(String host, int port) {
            super("SocketProducer: " + host + ":" + port);
            try {
                this.setDaemon(true);
            }
            catch (SecurityException securityException) {}
            this.host = host;
            this.port = port;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                InetAddress[] addresses = InetAddress.getAllByName(this.host);
                int i = 0;
                while (i < addresses.length) {
                    try {
                        this.socket = new Socket(addresses[i], this.port);
                        break;
                    }
                    catch (SocketException se) {
                        if (i == addresses.length - 1 || this.aborted) {
                            throw se;
                        }
                        if (!this.aborted) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
            if (this.aborted && this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
                this.socket = null;
            }
        }

        public Socket getSocket() {
            return this.socket;
        }

        public IOException getException() {
            return this.exception;
        }

        public void abort() {
            this.aborted = true;
        }
    }
}

