/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.xsr.net.HttpConnection;
import com.apple.xsr.net.HttpMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.log4j.Logger;

public class HttpRequest
extends HttpMessage {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String HEAD = "HEAD";
    public static final String PUT = "PUT";
    public static final String LINK = "LINK";
    public static final String UNLINK = "UNLINK";
    public static final String DELETE = "DELETE";
    public static final String OPTIONS = "OPTIONS";
    public static final String TRACE = "TRACE";
    private static final String DEFAULT_USER_AGENT = "Apple-Xserve_RAID_Admin/1.5";
    private static final String DEFAULT_CONTENT_TYPE = "application/xml";
    private static final String HTTP_VERSION = "HTTP/1.1";
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$net$HttpRequest != null ? class$com$apple$xsr$net$HttpRequest : (class$com$apple$xsr$net$HttpRequest = HttpRequest.class$("com.apple.xsr.net.HttpRequest")));
    private String method;
    private String host;
    private URL url;
    private String version;
    private HttpConnection connection;
    private OutputStream outStream;
    private HttpOutputStream outputBuffer;
    private boolean sent = false;
    static /* synthetic */ Class class$com$apple$xsr$net$HttpRequest;

    HttpRequest(HttpConnection connection, URL url) throws IOException {
        this.connection = connection;
        this.method = POST;
        this.url = url;
        this.version = HTTP_VERSION;
        this.setHeaderField("Host", url.getHost());
        this.setHeaderField("Content-Type", DEFAULT_CONTENT_TYPE);
        this.setHeaderField("User-Agent", DEFAULT_USER_AGENT);
        if (!this.connection.isPersistent()) {
            this.setHeaderField("Connection", "close");
        }
    }

    public void setRequestMethod(String method) {
        this.method = method;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public void setContentType(String contentType) {
        this.setHeaderField("Content-Type", contentType);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputBuffer == null) {
            this.outputBuffer = new HttpOutputStream();
        }
        return this.outputBuffer;
    }

    private void send() throws IOException {
        int retries = 1;
        while (retries > 0) {
            try {
                this.outStream = this.connection.getOutputStream();
                this.sendHeader();
                this.sendBody();
                this.sent = true;
                this.connection.setRequestSent(true);
                retries = 0;
            }
            catch (IOException ioe) {
                logger.error(String.valueOf(String.valueOf(ioe)));
                --retries;
                try {
                    this.connection.disconnect();
                }
                catch (IOException e) {
                    logger.error("Error disconnecting: " + e);
                }
                if (retries == 0) {
                    logger.error("Failed to send request.");
                    throw ioe;
                }
                logger.warn("Trying to send again (" + retries + ")");
            }
        }
    }

    private void sendHeader() throws IOException {
        byte[] newline = new byte[]{13, 10};
        String startLine = String.valueOf(this.method) + " " + this.url.getFile() + " " + this.version + "\r\n";
        this.contentLength = this.outputBuffer.size();
        this.setHeaderField("Content-Length", String.valueOf(this.contentLength));
        try {
            this.outStream.write(startLine.getBytes());
            this.outStream.write(this.getHeaders().getBytes());
            this.outStream.write(newline);
            this.outStream.flush();
        }
        catch (IOException e) {
            logger.error(String.valueOf(String.valueOf(e)));
            throw e;
        }
    }

    private void sendBody() throws IOException {
        try {
            this.outStream.write(this.outputBuffer.toByteArray());
            this.outStream.flush();
        }
        catch (IOException e) {
            logger.error(String.valueOf(String.valueOf(e)));
            throw e;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private class HttpOutputStream
    extends ByteArrayOutputStream {
        public void close() throws IOException {
            super.close();
            if (!HttpRequest.this.sent) {
                HttpRequest.this.send();
            }
        }

        HttpOutputStream() {
        }
    }
}

