/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import java.net.UnknownHostException;

public class IPAddress
implements Comparable {
    private byte[] address;

    public IPAddress(String address) throws UnknownHostException {
        if (address == null) {
            throw new NullPointerException("address cannot be null");
        }
        this.parseAddress(address);
    }

    public IPAddress(byte[] address) throws UnknownHostException {
        if (address == null) {
            throw new NullPointerException("address cannot be null");
        }
        if (address.length < 4) {
            throw new UnknownHostException("Illegal IP address: " + address);
        }
        this.address = address;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public Integer toInteger() {
        return new Integer(this.toInt());
    }

    public boolean isDefaultNetwork() {
        return this.isAllZero();
    }

    public boolean isAllZero() {
        boolean result = true;
        int i = 0;
        while (i < this.address.length) {
            if (this.address[i] != 0) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public boolean isLoopbackAddress() {
        return (this.address[0] & 0xFF) == 127;
    }

    public boolean isLinkLocalAddress() {
        return (this.address[0] & 0xFF) == 169 && (this.address[1] & 0xFF) == 254;
    }

    public boolean isLimitedBroadcastAddress() {
        boolean result = true;
        int i = 0;
        while (i < this.address.length) {
            if ((this.address[i] & 0xFF) != 255) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.address[0] & 0xFF) + ".");
        sb.append(String.valueOf(this.address[1] & 0xFF) + ".");
        sb.append(String.valueOf(this.address[2] & 0xFF) + ".");
        sb.append(this.address[3] & 0xFF);
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Assertion failure");
        }
    }

    public int hashCode() {
        return this.toInt();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof IPAddress && ((IPAddress)obj).toInt() == this.toInt();
    }

    public int compareTo(Object o) {
        IPAddress ip = (IPAddress)o;
        return this.toInt() - ip.toInt();
    }

    private void parseAddress(String address) throws UnknownHostException {
        byte[] ip = new byte[16];
        int octets = 0;
        char[] data = address.toCharArray();
        int i = 0;
        while (i < data.length) {
            char c = data[i];
            if (c < '0' || c > '9') {
                throw new UnknownHostException("Illegal character (" + c + ") in  address: " + address);
            }
            int b = 0;
            while (c != '.') {
                boolean bl = c < '0' || c > '9';
                b = b * 10 + c - 48;
                if (++i >= data.length) break;
                c = data[i];
            }
            if (b > 255) {
                throw new UnknownHostException("Illegal octet (" + b + ") in address: " + address);
            }
            ip[octets] = (byte)b;
            if (++octets >= ip.length) {
                throw new UnknownHostException("Address too large: " + address);
            }
            ++i;
        }
        if (octets < 4 || address.endsWith(".")) {
            throw new UnknownHostException("Illegal address: " + address);
        }
        this.address = new byte[octets];
        System.arraycopy(ip, 0, this.address, 0, octets);
    }

    private int toInt() {
        int a = this.address[3] & 0xFF;
        a |= this.address[2] << 8 & 0xFF00;
        a |= this.address[1] << 16 & 0xFF0000;
        return a |= this.address[0] << 24 & 0xFF000000;
    }
}

