/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.xsr.net.AbstractRequestMessage;
import com.apple.xsr.net.RequestMessage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UpdateFirmwareRequest
extends AbstractRequestMessage {
    public static final int DEFAULT_TIMEOUT = 180000;
    public static final String PROPERTY_RAID_FIRMWARE_VERSION = "X-Apple-RAID-Firmware-Version";
    protected static final String FIRMWARE_UPDATE = "/cgi-bin/firmware-update";
    protected static final String FIRMWARE_UPDATE_FULL = "/cgi-bin/firmware-update-full";
    protected static final String UPDATE_RAID_FIRMWARE = "/cgi-bin/update-raid-firmware";
    private InputStream inStream;

    public UpdateFirmwareRequest(RequestMessage.Target target, int controllerType, int flashType, InputStream inStream) {
        if (inStream == null) {
            throw new NullPointerException("InputStream cannot be null");
        }
        this.init(target, controllerType, flashType);
        this.inStream = inStream;
    }

    public UpdateFirmwareRequest(RequestMessage.Target target, int controllerType, int flashType, String imageFile) throws FileNotFoundException {
        if (imageFile == null || imageFile.length() == 0) {
            throw new IllegalArgumentException("Invalid imageFile (" + imageFile + ")");
        }
        this.init(target, controllerType, flashType);
        File f = new File(imageFile);
        if (!(f.exists() && f.isFile() && f.canRead())) {
            throw new FileNotFoundException("Failed to open " + imageFile);
        }
        this.inStream = new FileInputStream(imageFile);
    }

    public void writeTo(OutputStream out) throws IOException {
        BufferedInputStream in = null;
        try {
            int data;
            in = new BufferedInputStream(this.inStream);
            while ((data = ((InputStream)in).read()) != -1) {
                out.write(data);
            }
            out.flush();
        }
        finally {
            Object var4_4 = null;
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    public Object clone() {
        UpdateFirmwareRequest result = (UpdateFirmwareRequest)super.clone();
        return result;
    }

    private void init(RequestMessage.Target target, int controllerType, int flashType) {
        if (controllerType != 0 && controllerType != 1) {
            throw new IllegalArgumentException("Invalid controller type (" + controllerType + ")");
        }
        if (flashType != 0 && flashType != 1) {
            throw new IllegalArgumentException("Invalid flash type (" + flashType + ")");
        }
        if (controllerType == 0) {
            this.path = flashType == 0 ? FIRMWARE_UPDATE_FULL : FIRMWARE_UPDATE;
        } else if (controllerType == 1) {
            this.path = UPDATE_RAID_FIRMWARE;
        } else {
            throw new Error("assert failed");
        }
        this.setTimeout(180000);
        this.xsyncTarget = target;
    }
}

