/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;

public class Battery
extends AbstractSystemElement
implements Comparable {
    private int id;
    private int status;
    private int charge = -1;
    private boolean charging = false;

    public Battery(int id) {
        this.id = id;
    }

    public Battery(Battery battery) {
        this.id = battery.id;
        this.status = battery.status;
        this.charge = battery.charge;
        this.charging = battery.charging;
    }

    public int getNativeId() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Battery " + this.id;
    }

    void setStatus(int status) {
        if (status != 0 && status != 1 && status != 2 && status != -1) {
            throw new IllegalArgumentException("illegal status argument (" + status + ")");
        }
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    void setChargePercent(int charge) {
        this.charge = charge;
    }

    public int getChargePercent() {
        return this.charge;
    }

    void setIsCharging(boolean charging) {
        this.charging = charging;
    }

    public boolean isCharging() {
        return this.charging;
    }

    public int compareTo(Object o) {
        Battery battery = (Battery)o;
        return this.id - battery.id;
    }

    public String paramString() {
        String s = "";
        s = String.valueOf(s) + "id=" + this.id + ",";
        s = String.valueOf(s) + "status=" + this.status + ",";
        s = String.valueOf(s) + "charge=" + this.charge + ",";
        s = String.valueOf(s) + "charging=" + this.charging;
        return s;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }
}

