/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;

public class PowerSupply
extends AbstractSystemElement
implements Comparable {
    private int id;
    private int status = -1;
    private float fiveVolt = -1.0f;
    private float twelveVolt = -1.0f;

    public PowerSupply(int id) {
        this.id = id;
    }

    public PowerSupply(PowerSupply powerSupply) {
        this.id = powerSupply.id;
        this.status = powerSupply.status;
        this.fiveVolt = powerSupply.fiveVolt;
        this.twelveVolt = powerSupply.twelveVolt;
    }

    public int getNativeId() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Power Supply " + this.id;
    }

    void setStatus(int status) {
        if (status != 0 && status != 1 && status != 2 && status != -1) {
            throw new IllegalArgumentException("illegal status argument (" + status + ")");
        }
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    void setFiveVolt(float vdc) {
        this.fiveVolt = vdc;
    }

    public float getFiveVolt() {
        return this.fiveVolt;
    }

    void setTwelveVolt(float vdc) {
        this.twelveVolt = vdc;
    }

    public float getTwelveVolt() {
        return this.twelveVolt;
    }

    public int compareTo(Object o) {
        PowerSupply ps = (PowerSupply)o;
        return this.id - ps.id;
    }

    public String paramString() {
        String s = "";
        s = String.valueOf(s) + "id=" + this.id + ",";
        s = String.valueOf(s) + "status=" + this.status + ",";
        s = String.valueOf(s) + "fiveVolt=" + this.fiveVolt + ",";
        s = String.valueOf(s) + "twelveVolt=" + this.twelveVolt;
        return s;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }
}

