/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.net.acp.AcpPropertyCode;
import com.apple.net.acp.SimpleCryptCoder;
import com.apple.util.Base64Utilities;
import com.apple.util.VersionNumber;
import com.apple.util.plist.PListUtils;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.xsr.eventlog.EventLog;
import com.apple.xsr.net.AcpxCommandException;
import com.apple.xsr.net.AcpxConstants;
import com.apple.xsr.net.AcpxMessageFactory;
import com.apple.xsr.net.CommunicationHandler;
import com.apple.xsr.net.CommunicationsManager;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.Response;
import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.Battery;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.Fan;
import com.apple.xsr.som.HostInterface;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.PowerSupply;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystemAgent;
import com.apple.xsr.som.SystemController;
import com.apple.xsr.som.SystemElement;
import com.apple.xsr.som.SystemEvent;
import com.apple.xsr.som.SystemEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class RaidSystem
extends AbstractSystemElement
implements SystemEventListener {
    public static final String DEFAULT_NAME = "Unknown Xserve Raid";
    public static final int DISK_SLOT_MIN_ID = 1;
    public static final int DISK_SLOT_MAX_ID = 14;
    public static final int CONTROLLER_MODULE_TOP = 1;
    public static final int CONTROLLER_MODULE_BOTTOM = 2;
    public static final int SYSTEM_CONTROLLER_MIN_ID = 1;
    public static final int SYSTEM_CONTROLLER_MAX_ID = 2;
    public static final int SYSTEM_CONTROLLER_1 = 1;
    public static final int SYSTEM_CONTROLLER_2 = 2;
    public static final int SYSTEM_CONTROLLER_TOP = 1;
    public static final int SYSTEM_CONTROLLER_BOTTOM = 2;
    public static final int RAID_CONTROLLER_MIN_ID = 1;
    public static final int RAID_CONTROLLER_MAX_ID = 2;
    public static final int RAID_CONTROLLER_1 = 1;
    public static final int RAID_CONTROLLER_2 = 2;
    public static final int RAID_CONTROLLER_TOP = 1;
    public static final int RAID_CONTROLLER_BOTTOM = 2;
    public static final int HOST_INTERFACE_MIN_ID = 1;
    public static final int HOST_INTERFACE_MAX_ID = 2;
    public static final int NETWORK_INTERFACE_MIN_ID = 1;
    public static final int NETWORK_INTERFACE_MAX_ID = 2;
    public static final int POWER_SUPPLY_MIN_ID = 1;
    public static final int POWER_SUPPLY_MAX_ID = 2;
    public static final int POWER_SUPPLY_LEFT = 1;
    public static final int POWER_SUPPLY_RIGHT = 2;
    public static final int BATTERY_MIN_ID = 1;
    public static final int BATTERY_MAX_ID = 2;
    public static final int BATTERY_LEFT = 1;
    public static final int BATTERY_RIGHT = 2;
    public static final int FAN_MIN_ID = 1;
    public static final int FAN_MAX_ID = 2;
    public static final int FAN_TOP = 1;
    public static final int FAN_BOTTOM = 2;
    public static final int AUTO_REBOOT_DISABLED = 0;
    public static final int AUTO_REBOOT_ENABLED = 1;
    public static final int AUDIBLE_ALARM_DISABLED = 0;
    public static final int AUDIBLE_ALARM_ENABLED = 1;
    public static final int UNLOCKED = 0;
    public static final int LOCKED = 1;
    public static final int SERVICE_ID_OFF = 0;
    public static final int SERVICE_ID_ON = 1;
    public static final int UPS_POWER_FAILURE = 0;
    public static final int UPS_LOW_BATTERY = 1;
    public static final int UPS_SHUTDOWN = 2;
    public static final int POWER_OFF = 0;
    public static final int POWER_ON = 1;
    public static final int POWER_UPS_BACKUP = 2;
    public static final String NON_LEGACY_SLICE_ID_MIN_COPROCESSOR_VERSION = "1.2";
    public static final String NON_LEGACY_LUN_ID_MIN_COPROCESSOR_VERSION = "1.2";
    public static final int TRANSLATE_TO_LEGACY = 0;
    public static final int TRANSLATE_FROM_LEGACY = 1;
    private String name = "Unknown Xserve Raid";
    private String primaryHostAddress;
    private String secondaryHostAddress;
    private String currentAddress;
    private String monitoringPassword;
    private String managementPassword;
    private boolean managementPasswordSaved;
    private boolean loggedOn = false;
    private long totalCapacity = -1L;
    private String contact = "";
    private String description = "";
    private String location = "";
    private int lockState = -1;
    private int serviceIdState = -1;
    private long timeOffset = Long.MAX_VALUE;
    private int uptime = -1;
    private int autoRebootState = -1;
    private int audibleAlarmState = -1;
    private int upsStatus = -1;
    private int powerState = -1;
    private EventLog eventLog = new EventLog();
    private int userMessageIndex = 0;
    private boolean userMessageIsAsync = false;
    private Timer userMessageTimer = null;
    public static final int USER_MESSAGE_INDEX_NONE = 0;
    public static final int USER_MESSAGE_INDEX_AUTHENTICATING = 1;
    public static final int USER_MESSAGE_INDEX_CONNECTING = 2;
    public static final int USER_MESSAGE_INDEX_GATHERING = 3;
    public static final int USER_MESSAGE_INDEX_CONNECTION_FAILURE = 4;
    public static final int USER_MESSAGE_INDEX_COMMUNICATIONS_ERROR = 5;
    public static final int USER_MESSAGE_INDEX_STANDBY_POWER_MODE = 6;
    public static final int USER_MESSAGE_INDEX_RESTARTING = 7;
    public static final int USER_MESSAGE_INDEX_SHUTTING_DOWN = 8;
    public static final int USER_MESSAGE_INDEX_POWERING_ON = 9;
    public static final int USER_MESSAGE_INDEX_RAID_CONTROLLER_NOT_READY = 10;
    public static final int USER_MESSAGE_INDEX_AUTHENTICATION_FAILURE = 11;
    public static final int USER_MESSAGE_INDEX_REQUESTING_UPDATE = 12;
    public static final int USER_MESSAGE_INDEX_CLEARING_EVENT_LOG = 13;
    private Map systemControllers = Collections.synchronizedSortedMap(new TreeMap());
    private Map raidControllers = Collections.synchronizedSortedMap(new TreeMap());
    private Map powerSupplies = Collections.synchronizedSortedMap(new TreeMap());
    private Map batteries = Collections.synchronizedSortedMap(new TreeMap());
    private Map fans = Collections.synchronizedSortedMap(new TreeMap());
    private int creationInProgressControllerID = -1;
    private int creationInProgressRaidSetID = -1;
    private CommunicationsManager comms;
    private MessageFactory messageFactory;
    private RaidSystemAgent agent;
    public static final long MODULE_BOOT_TIME = 60000L;
    public static final long WAIT_FOR_UPDATE_TIMEOUT = 300000L;
    private boolean pollStarted = false;
    private boolean pollFinished = false;
    public static final long WAIT_FOR_RAID_CONTROLLER_ONLINE_TIMEOUT = 120000L;
    private boolean waitingForTopRaidControllerOnline = false;
    private boolean waitingForBottomRaidControllerOnline = false;
    public static final long WAIT_FOR_RAID_SET_ONLINE_TIMEOUT = 120000L;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$som$RaidSystem != null ? class$com$apple$xsr$som$RaidSystem : (class$com$apple$xsr$som$RaidSystem = RaidSystem.class$("com.apple.xsr.som.RaidSystem")));
    static /* synthetic */ Class class$com$apple$xsr$som$RaidSystem;

    public RaidSystem(String hostAddress) {
        if (hostAddress == null) {
            throw new NullPointerException("host address cannot be null");
        }
        this.primaryHostAddress = hostAddress;
        this.currentAddress = hostAddress;
        int i = 1;
        while (i <= 2) {
            SystemController controller = new SystemController(i, this);
            this.systemControllers.put(new Integer(i), controller);
            ++i;
        }
        int i2 = 1;
        while (i2 <= 2) {
            RaidController controller = new RaidController(i2, this);
            this.raidControllers.put(new Integer(i2), controller);
            ++i2;
        }
        int i3 = 1;
        while (i3 <= 2) {
            PowerSupply ps = new PowerSupply(i3);
            this.powerSupplies.put(new Integer(i3), ps);
            ++i3;
        }
        int i4 = 1;
        while (i4 <= 2) {
            Fan fan = new Fan(i4);
            this.addFan(fan);
            ++i4;
        }
        this.comms = new CommunicationsManager(this);
        this.messageFactory = new AcpxMessageFactory();
        this.agent = new RaidSystemAgent(this);
    }

    public RaidSystem(RaidSystem raidSystem) {
        this.name = raidSystem.name;
        this.primaryHostAddress = raidSystem.primaryHostAddress;
        this.secondaryHostAddress = raidSystem.secondaryHostAddress;
        this.currentAddress = raidSystem.currentAddress;
        this.monitoringPassword = raidSystem.monitoringPassword;
        this.managementPassword = raidSystem.managementPassword;
        this.managementPasswordSaved = raidSystem.managementPasswordSaved;
        this.loggedOn = raidSystem.loggedOn;
        this.totalCapacity = raidSystem.totalCapacity;
        this.contact = raidSystem.contact;
        this.description = raidSystem.description;
        this.location = raidSystem.location;
        this.lockState = raidSystem.lockState;
        this.serviceIdState = raidSystem.serviceIdState;
        this.timeOffset = raidSystem.timeOffset;
        this.uptime = raidSystem.uptime;
        this.autoRebootState = raidSystem.autoRebootState;
        this.audibleAlarmState = raidSystem.audibleAlarmState;
        this.upsStatus = raidSystem.upsStatus;
        this.powerState = raidSystem.powerState;
        this.userMessageIndex = raidSystem.userMessageIndex;
        this.userMessageIsAsync = raidSystem.userMessageIsAsync;
        this.eventLog = new EventLog(raidSystem.eventLog);
        Iterator iter = raidSystem.systemControllers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object value = entry.getValue();
            if (value == null) continue;
            SystemController copy = new SystemController((SystemController)value);
            copy.system = this;
            this.systemControllers.put(entry.getKey(), copy);
        }
        Iterator iter2 = raidSystem.raidControllers.entrySet().iterator();
        while (iter2.hasNext()) {
            Map.Entry entry = iter2.next();
            Object value = entry.getValue();
            if (value == null) continue;
            RaidController copy = new RaidController((RaidController)value);
            copy.system = this;
            this.raidControllers.put(entry.getKey(), copy);
        }
        Iterator iter3 = raidSystem.powerSupplies.entrySet().iterator();
        while (iter3.hasNext()) {
            Map.Entry entry = iter3.next();
            Object value = entry.getValue();
            if (value == null) continue;
            PowerSupply copy = new PowerSupply((PowerSupply)value);
            this.powerSupplies.put(entry.getKey(), copy);
        }
        Iterator iter4 = raidSystem.batteries.entrySet().iterator();
        while (iter4.hasNext()) {
            Map.Entry entry = iter4.next();
            Object value = entry.getValue();
            if (value == null) continue;
            Battery copy = new Battery((Battery)value);
            this.batteries.put(entry.getKey(), copy);
        }
        Iterator iter5 = raidSystem.fans.entrySet().iterator();
        while (iter5.hasNext()) {
            Map.Entry entry = iter5.next();
            Object value = entry.getValue();
            if (value == null) continue;
            Fan copy = new Fan((Fan)value);
            this.fans.put(entry.getKey(), copy);
        }
    }

    public int getNativeId() {
        return this.hashCode();
    }

    public int getId() {
        return this.hashCode();
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getStatus() {
        int raidSystemStatus = -1;
        int raidSetAndDiskStatus = this.getGeneralRaidSetAndDiskStatus();
        int componentStatus = this.getGeneralComponentStatus();
        int hostInterfaceStatus = this.getGeneralHostInterfaceStatus();
        int networkStatus = this.getGeneralNetworkInterfaceStatus();
        int upsStatus = this.getUpsStatus();
        raidSystemStatus = raidSetAndDiskStatus == 2 || componentStatus == 2 || hostInterfaceStatus == 2 || networkStatus == 2 ? 2 : (raidSetAndDiskStatus == 1 || componentStatus == 1 || hostInterfaceStatus == 1 || networkStatus == 1 || this.getServiceIdState() == 1 || upsStatus == 1 || upsStatus == 0 || upsStatus == 2 ? 1 : (raidSetAndDiskStatus == 0 || componentStatus == 0 || hostInterfaceStatus == 0 || networkStatus == 0 ? 0 : -1));
        return raidSystemStatus;
    }

    public int getGeneralRaidSetAndDiskStatus() {
        int status = this.getGeneralRaidSetStatus();
        int diskStatus = this.getGeneralDiskStatus();
        if (status == -1) {
            status = diskStatus;
        }
        if ((diskStatus == 1 || diskStatus == 2) && status != 2) {
            status = 1;
        }
        return status;
    }

    public int getGeneralRaidSetStatus() {
        return this.getGeneralStatus(this.getRaidSets());
    }

    public int getGeneralDiskStatus() {
        int status = this.getGeneralStatus(this.getDisks());
        if (status == -1) {
            Collection c = this.getDiskSlots();
            boolean nonePopulated = true;
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                DiskSlot slot = (DiskSlot)iter.next();
                if (!slot.isPopulated()) continue;
                nonePopulated = false;
                break;
            }
            if (nonePopulated) {
                status = 1;
            }
        }
        return status;
    }

    public int getGeneralComponentStatus() {
        int powerSupplyStatus = RaidSystem.getRedundantComponentStatus(this.getPowerSupply(1), this.getPowerSupply(2));
        int fanStatus = RaidSystem.getRedundantComponentStatus(this.getFan(1), this.getFan(2));
        int systemControllerStatus = this.getGeneralStatus(this.getSystemControllers());
        int raidControllerStatus = this.getGeneralStatus(this.getRaidControllers());
        int status = powerSupplyStatus == 2 || fanStatus == 2 || systemControllerStatus == 2 || raidControllerStatus == 2 ? 2 : (powerSupplyStatus == 1 || fanStatus == 1 || systemControllerStatus == 1 || raidControllerStatus == 1 ? 1 : (powerSupplyStatus == -1 || fanStatus == -1 || systemControllerStatus == -1 || raidControllerStatus == -1 ? -1 : 0));
        return status;
    }

    public int getGeneralNetworkInterfaceStatus() {
        int status = this.getGeneralStatus(this.getNetworkInterfaces());
        if (status == -1) {
            status = 2;
        }
        return status;
    }

    public int getGeneralHostInterfaceStatus() {
        return this.getGeneralStatus(this.getHostInterfaces());
    }

    public int getGeneralPowerSupplyStatus() {
        return this.getGeneralStatus(this.getPowerSupplies());
    }

    public int getGeneralFanStatus() {
        return this.getGeneralStatus(this.getFans());
    }

    public void setHostAddress(String address) {
        this.currentAddress = address;
    }

    public String getHostAddress() {
        return this.currentAddress;
    }

    public String getPrimaryHostAddress() {
        return this.primaryHostAddress;
    }

    void setSecondaryHostAddress(String address) {
        this.secondaryHostAddress = address;
    }

    public String getSecondaryHostAddress() {
        return this.secondaryHostAddress;
    }

    public String getMonitoringUserId() {
        return "guest";
    }

    public synchronized void setMonitoringPassword(String password) {
        this.monitoringPassword = password;
        AcpxMessageFactory mf = (AcpxMessageFactory)this.agent.getMessageFactory();
        mf.setDefaultPassword(password);
    }

    public synchronized String getMonitoringPassword() {
        return this.monitoringPassword;
    }

    public String getManagementUserId() {
        return "admin";
    }

    public void setManagementPassword(String password) {
        this.managementPassword = password;
    }

    public String getManagementPassword() {
        return this.managementPassword;
    }

    public void setManagementPasswordSaved(boolean saved) {
        this.managementPasswordSaved = saved;
        this.setChanged();
    }

    public boolean getManagementPasswordSaved() {
        return this.managementPasswordSaved;
    }

    void setLoggedOn(boolean loggedOn) {
        this.loggedOn = loggedOn;
    }

    public boolean isLoggedOn() {
        return this.loggedOn;
    }

    public void setPowerState(int newPowerState) {
        this.powerState = newPowerState;
    }

    public int getPowerState() {
        return this.powerState;
    }

    public long getCapacity() {
        return this.totalCapacity;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getContact() {
        return this.contact;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setServiceIdState(int state) {
        if (state != 0 && state != 1 && state != -1) {
            throw new IllegalArgumentException("Illegal service ID state: " + state);
        }
        this.serviceIdState = state;
    }

    public int getServiceIdState() {
        return this.serviceIdState;
    }

    void setLockState(int state) {
        if (state != 1 && state != 0 && state != -1) {
            throw new IllegalArgumentException("Illegal lock state: " + state);
        }
        this.lockState = state;
    }

    public int getLockState() {
        return this.lockState;
    }

    public void setTimeOffset(long offset) {
        this.timeOffset = offset;
    }

    public Date getTime() {
        if (this.timeOffset == Long.MAX_VALUE) {
            return null;
        }
        return new Date(new Date().getTime() - this.timeOffset);
    }

    void setUpTime(int uptime) {
        this.uptime = uptime;
    }

    public int getUpTime() {
        return this.uptime;
    }

    void setAutoRebootState(int state) {
        this.autoRebootState = state;
    }

    public int getAutoRebootState() {
        return this.autoRebootState;
    }

    void setAudibleAlarmState(int state) {
        this.audibleAlarmState = state;
    }

    public int getAudibleAlarmState() {
        return this.audibleAlarmState;
    }

    public String getNtpServerAddress() {
        String ntpServerAddress = ".";
        boolean firstController = true;
        Collection controllers = this.systemControllers.values();
        Map map = this.systemControllers;
        synchronized (map) {
            Iterator iter = controllers.iterator();
            while (iter.hasNext()) {
                SystemController aController = (SystemController)iter.next();
                if (firstController) {
                    ntpServerAddress = aController.getNtpServerAddress();
                    if (ntpServerAddress == null) {
                        ntpServerAddress = ".";
                        break;
                    }
                } else if (!ntpServerAddress.equals(aController.getNtpServerAddress())) {
                    ntpServerAddress = ".";
                    RequestMessage msg = this.getMessageFactory().newSetPropertyRequest(AcpPropertyCode.NTP_CONFIG.toString(), ".");
                    this.postMessageAsync(null, msg, 1, null);
                    this.postMessageAsync(null, msg, 2, null);
                    break;
                }
                firstController = false;
            }
        }
        return ntpServerAddress;
    }

    void setUpsStatus(int status) {
        if (status != 0 && status != 1 && status != 2 && status != -1) {
            throw new IllegalArgumentException("illegal UPS status (" + status + ")");
        }
        this.upsStatus = status;
    }

    public int getUpsStatus() {
        return this.upsStatus;
    }

    public int getBackgroundConditioningPriority() {
        int top = -1;
        int bottom = -1;
        if (this.isControllerModulePresent(1)) {
            top = this.getRaidController(1).getBackgroundConditioningPriority();
        }
        if (this.isControllerModulePresent(2)) {
            bottom = this.getRaidController(2).getBackgroundConditioningPriority();
        }
        return top == bottom ? top : -1;
    }

    public boolean isBusy() {
        Collection controllers = this.getRaidControllers();
        boolean isBusy = false;
        Iterator i = controllers.iterator();
        while (i.hasNext()) {
            RaidController controller = (RaidController)i.next();
            Collection raidSets = controller.getRaidSets();
            Iterator j = raidSets.iterator();
            while (j.hasNext()) {
                RaidSet rs = (RaidSet)j.next();
                int operation = rs.getOperation();
                if (operation != 1 && operation != 4 && operation != 3 && operation != 2 && operation != 5) continue;
                isBusy = true;
                break;
            }
            if (isBusy) break;
        }
        return isBusy;
    }

    public EventLog getEventLog() {
        return this.eventLog;
    }

    public void setUserMessageIndex(int messageIndex) {
        if (this.userMessageTimer != null) {
            this.userMessageTimer.stop();
            this.userMessageTimer = null;
        }
        if (messageIndex == 0) {
            this.userMessageTimer = new Timer(4000, new 1());
            this.userMessageTimer.start();
            return;
        }
        this.userMessageIndex = messageIndex;
        switch (messageIndex) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                this.userMessageIsAsync = true;
                break;
            }
            default: {
                this.userMessageIsAsync = false;
            }
        }
        this.setChanged();
    }

    public int getUserMessageIndex() {
        return this.userMessageIndex;
    }

    public boolean getUserMessageIsAsync() {
        return this.userMessageIsAsync;
    }

    public Collection getSystemControllers() {
        return Collections.unmodifiableCollection(this.systemControllers.values());
    }

    public SystemController getSystemController(int id) {
        if (id < 1 || id > 2) {
            throw new IllegalArgumentException("Illegal controller ID: " + id);
        }
        return (SystemController)this.systemControllers.get(new Integer(id));
    }

    public SystemController getPrimarySystemController() {
        String topAddress;
        int primaryController = this.isControllerModulePresent(1) && this.isControllerModulePresent(2) ? ((topAddress = String.valueOf(String.valueOf(this.getSystemController(1).getNetworkInterface().getAddress()))).equals(this.getPrimaryHostAddress()) ? 1 : 2) : (this.isControllerModulePresent(1) ? 1 : 2);
        return this.getSystemController(primaryController);
    }

    public boolean allSystemControllersAreAtLeastVersion(String string) {
        boolean result = true;
        try {
            VersionNumber required = VersionNumber.newAppleVersionNumber(string);
            Iterator iter = this.getSystemControllers().iterator();
            while (iter.hasNext()) {
                SystemController sc = (SystemController)iter.next();
                VersionNumber version = VersionNumber.newAppleVersionNumber(sc.getSystemVersion());
                if (version.compareTo(required) >= 0) continue;
                result = false;
            }
        }
        catch (Exception exception) {
            result = false;
        }
        return result;
    }

    public int getDriveCacheFlags() {
        int flags;
        if (!this.supportsGlobalDriveCacheFeature()) {
            throw new UnsupportedOperationException("Drive cache flags are not supported on this system.");
        }
        RequestMessage msg = this.getMessageFactory().newGetPropertyRequest(AcpPropertyCode.DRIVE_CACHE_FLAGS);
        String monitoringUser = this.getMonitoringUserId();
        String monitoringPassword = this.getMonitoringPassword();
        if (monitoringUser != null && monitoringPassword != null) {
            msg.setUser(monitoringUser);
            msg.setPassword(monitoringPassword);
        }
        try {
            Response response = this.postMessage(msg);
            PropertyList plist = (PropertyList)response.getContent();
            Map root = PListUtils.toDictionary(plist.getRootElement());
            Map dict = PListUtils.toDictionary(root.get("drCH"));
            flags = PListUtils.toInteger(dict.get("data")).intValue();
        }
        catch (IOException iOException) {
            logger.error("IOException when retrieving drive cache flags property");
            flags = -128;
        }
        catch (PropertyListException propertyListException) {
            logger.error("PropertyListException when retrieving drive cache flags property");
            flags = -128;
        }
        return flags;
    }

    public boolean supportsGlobalDriveCacheFeature() {
        boolean supported;
        RequestMessage msg = this.getMessageFactory().newGetPropertyRequest(AcpPropertyCode.FEATURES);
        String monitoringUser = this.getMonitoringUserId();
        String monitoringPassword = this.getMonitoringPassword();
        if (monitoringUser != null && monitoringPassword != null) {
            msg.setUser(monitoringUser);
            msg.setPassword(monitoringPassword);
        }
        try {
            Response response = this.postMessage(msg);
            PropertyList plist = (PropertyList)response.getContent();
            Map root = PListUtils.toDictionary(plist.getRootElement());
            Map dict = PListUtils.toDictionary(root.get("fe01"));
            Long features = PListUtils.toInteger(dict.get("data"));
            supported = (features & 0x800000L) != 0L;
        }
        catch (IOException iOException) {
            logger.error("IOException when retrieving FEATURES property");
            supported = false;
        }
        catch (PropertyListException propertyListException) {
            logger.error("PropertyListException when retrieving FEATURES property");
            supported = false;
        }
        return supported;
    }

    public int getRaidControllerCount() {
        return this.raidControllers.size();
    }

    public Collection getRaidControllers() {
        return Collections.unmodifiableCollection(this.raidControllers.values());
    }

    public RaidController getRaidController(int id) {
        if (id < 1 || id > 2) {
            throw new IllegalArgumentException("Illegal controller ID: " + id);
        }
        return (RaidController)this.raidControllers.get(new Integer(id));
    }

    public RaidController getRaidControllerForDiskSlot(int slot) {
        if (slot < 1 || slot > 14) {
            throw new IllegalArgumentException("Illegal disk slot: " + slot);
        }
        if (slot <= 7) {
            return this.getRaidController(1);
        }
        return this.getRaidController(2);
    }

    public Collection getPowerSupplies() {
        return Collections.unmodifiableCollection(this.powerSupplies.values());
    }

    public PowerSupply getPowerSupply(int id) {
        if (id < 1 || id > 2) {
            throw new IllegalArgumentException("Illegal power supply ID: " + id);
        }
        return (PowerSupply)this.powerSupplies.get(new Integer(id));
    }

    void addFan(Fan fan) {
        this.fans.put(new Integer(fan.getId()), fan);
    }

    Fan removeFan(int id) {
        return (Fan)this.fans.remove(new Integer(id));
    }

    public Collection getFans() {
        return Collections.unmodifiableCollection(this.fans.values());
    }

    public Fan getFan(int id) {
        if (id < 1 || id > 2) {
            throw new IllegalArgumentException("Illegal fan ID: " + id);
        }
        return (Fan)this.fans.get(new Integer(id));
    }

    void addBattery(Battery battery) {
        this.batteries.put(new Integer(battery.getId()), battery);
    }

    Battery removeBattery(int id) {
        return (Battery)this.batteries.remove(new Integer(id));
    }

    public Collection getBatteries() {
        return Collections.unmodifiableCollection(this.batteries.values());
    }

    public Battery getBattery(int id) {
        if (id < 1 || id > 2) {
            throw new IllegalArgumentException("Illegal battery ID: " + id);
        }
        return (Battery)this.batteries.get(new Integer(id));
    }

    public boolean isControllerModulePresent(int module) {
        if (module != 1 && module != 2) {
            throw new IllegalArgumentException("Illegal module (" + module + ")");
        }
        return true;
    }

    public int getControllerModuleStatus(int module) {
        SystemController sc;
        if (module != 1 && module != 2) {
            throw new IllegalArgumentException("Illegal module (" + module + ")");
        }
        int status = 0;
        RaidController rc = this.getRaidController(module == 1 ? 1 : 2);
        if (rc != null) {
            if (rc.getStatus() == 1) {
                int n = status = status == 2 ? 2 : 1;
            }
            if (rc.getStatus() == 2) {
                status = 2;
            }
        }
        if ((sc = this.getSystemController(module == 1 ? 1 : 2)) != null) {
            if (sc.getStatus() == 1) {
                int n = status = status == 2 ? 2 : 1;
            }
            if (sc.getStatus() == 2) {
                status = 2;
            }
        }
        return status;
    }

    public Collection getNetworkInterfaces() {
        TreeSet<NetworkInterface> networkInterfaces = new TreeSet<NetworkInterface>();
        Iterator iter = this.getSystemControllers().iterator();
        while (iter.hasNext()) {
            SystemController controller = (SystemController)iter.next();
            networkInterfaces.add(controller.getNetworkInterface());
        }
        return networkInterfaces;
    }

    public RaidSet getRaidSet(int id) {
        RaidSet rs = null;
        Iterator iter = this.getRaidSets().iterator();
        while (iter.hasNext()) {
            SystemElement element = (SystemElement)iter.next();
            if (element.getId() != id) continue;
            rs = (RaidSet)element;
            break;
        }
        return rs;
    }

    public Collection getRaidSets() {
        TreeSet raidsets = new TreeSet();
        Iterator iter = this.getRaidControllers().iterator();
        while (iter.hasNext()) {
            RaidController rc = (RaidController)iter.next();
            raidsets.addAll(rc.getRaidSets());
        }
        return raidsets;
    }

    public synchronized boolean isRaidSetBeingCreated(RaidSet raidSet) {
        if (raidSet == null) {
            throw new NullPointerException("raidSet cannot be null");
        }
        return this.creationInProgressControllerID != -1 && this.creationInProgressRaidSetID != -1 && raidSet.getController().getId() == this.creationInProgressControllerID && raidSet.getNativeId() == this.creationInProgressRaidSetID;
    }

    public synchronized void setRaidSetCreationInProgress(int raidControllerID, int raidSetID) {
        this.creationInProgressControllerID = raidControllerID;
        this.creationInProgressRaidSetID = raidSetID;
    }

    public synchronized void clearRaidSetCreationInProgress() {
        this.creationInProgressControllerID = -1;
        this.creationInProgressRaidSetID = -1;
    }

    public DiskSlot getDiskSlot(int id) {
        DiskSlot slot = null;
        if (id < 1 || id > 14) {
            throw new IllegalArgumentException("Invalid disk slot ID (" + id + ")");
        }
        Collection elements = id <= 7 ? this.getRaidController(1).getRaidSets() : this.getRaidController(2).getRaidSets();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            SystemElement element = (SystemElement)iter.next();
            if (element.getId() != id) continue;
            slot = (DiskSlot)element;
            break;
        }
        return slot;
    }

    public Collection getDiskSlots() {
        TreeSet slots = new TreeSet();
        Iterator iter = this.getRaidControllers().iterator();
        while (iter.hasNext()) {
            RaidController rc = (RaidController)iter.next();
            slots.addAll(rc.getDiskSlots());
        }
        return slots;
    }

    public Disk getDisk(int id) {
        Disk disk = null;
        if (id < 1 || id > 14) {
            throw new IllegalArgumentException("Invalid disk ID (" + id + ")");
        }
        Collection elements = id <= 7 ? this.getRaidController(1).getDisks() : this.getRaidController(2).getDisks();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            SystemElement element = (SystemElement)iter.next();
            if (element.getId() != id) continue;
            disk = (Disk)element;
            break;
        }
        return disk;
    }

    public Collection getDisks() {
        TreeSet disks = new TreeSet();
        Iterator iter = this.getRaidControllers().iterator();
        while (iter.hasNext()) {
            RaidController rc = (RaidController)iter.next();
            disks.addAll(rc.getDisks());
        }
        return disks;
    }

    public HostInterface getHostInterface(int id) {
        HostInterface hostIf = null;
        if (id < 1 || id > 2) {
            throw new IllegalArgumentException("Invalid host interface ID (" + id + ")");
        }
        Iterator iter = this.getHostInterfaces().iterator();
        while (iter.hasNext()) {
            SystemElement element = (SystemElement)iter.next();
            if (element.getId() != id) continue;
            hostIf = (HostInterface)element;
            break;
        }
        return hostIf;
    }

    public Collection getHostInterfaces() {
        TreeSet hostInterfaces = new TreeSet();
        Iterator iter = this.getRaidControllers().iterator();
        while (iter.hasNext()) {
            RaidController rc = (RaidController)iter.next();
            hostInterfaces.addAll(rc.getHostInterfaces());
        }
        return hostInterfaces;
    }

    public boolean[] getDiskCacheSettings(int controllerId) throws IOException, PropertyListException, AcpxCommandException {
        Response response;
        boolean[] cacheSettings = new boolean[7];
        int i = 0;
        while (i < 7) {
            cacheSettings[i] = false;
            ++i;
        }
        RequestMessage request = this.getMessageFactory().newGetControllerPageRequest(AcpxConstants.CONTROLLER_PAGE_1);
        String monitoringUser = this.getMonitoringUserId();
        String monitoringPassword = this.getMonitoringPassword();
        if (monitoringUser != null && monitoringPassword != null) {
            request.setUser(monitoringUser);
            request.setPassword(monitoringPassword);
        }
        if ((response = this.postMessage(request, controllerId)).getResultCode() != 0) {
            logger.error("get-page request failed (" + response.getResultCode() + ")");
            throw new AcpxCommandException("get-page request failed (" + response.getResultCode() + ")");
        }
        PropertyList plist = (PropertyList)response.getContent();
        Map root = PListUtils.toDictionary(plist.getRootElement());
        Map dict = PListUtils.toDictionary(root.get("get-page"));
        List slots = PListUtils.toArray(dict.get("slots"));
        int diskIndex = 0;
        Iterator iter = slots.iterator();
        while (iter.hasNext()) {
            Map slotDict = PListUtils.toDictionary(iter.next());
            Map statusDict = PListUtils.toDictionary(slotDict.get("status"), "status");
            boolean enabled = PListUtils.toBoolean(statusDict.get("disk-cache-enabled"));
            cacheSettings[diskIndex++] = enabled;
        }
        return cacheSettings;
    }

    public boolean getRaidControllerCacheEnabled(int controllerId) throws IOException, PropertyListException, AcpxCommandException {
        Response response;
        RequestMessage request = this.getMessageFactory().newGetControllerPageRequest(AcpxConstants.CONTROLLER_PAGE_0);
        String monitoringUser = this.getMonitoringUserId();
        String monitoringPassword = this.getMonitoringPassword();
        if (monitoringUser != null && monitoringPassword != null) {
            request.setUser(monitoringUser);
            request.setPassword(monitoringPassword);
        }
        if ((response = this.postMessage(request, controllerId)).getResultCode() != 0) {
            logger.error("get-page request failed (" + response.getResultCode() + ")");
            throw new AcpxCommandException("get-page request failed (" + response.getResultCode() + ")");
        }
        PropertyList plist = (PropertyList)response.getContent();
        Map root = PListUtils.toDictionary(plist.getRootElement());
        Map dict = PListUtils.toDictionary(root.get("get-page"));
        return PListUtils.toBoolean(dict.get("write-buffer-enabled"));
    }

    public boolean hasRaidOrJbodDisks() {
        Iterator iter = this.getDisks().iterator();
        while (iter.hasNext()) {
            int type = ((Disk)iter.next()).getType();
            if (type != 1 && type != 3) continue;
            return true;
        }
        return false;
    }

    public void stateChanged(SystemEvent e) {
        this.fireStateChanged(e);
    }

    public void connect(CommunicationHandler handler, String user, String password, boolean encryptPassword) {
        String encrypted;
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        String string = encrypted = encryptPassword ? RaidSystem.crypt(password) : password;
        if (user.equals("guest")) {
            this.setMonitoringPassword(encrypted);
        }
        this.agent.connect(handler, user, encrypted);
    }

    public void disconnect() {
        this.agent.shutdown();
        this.comms.shutdown();
    }

    public boolean isConnected() {
        return this.comms.isConnected();
    }

    public void authenticate(CommunicationHandler handler, String user, String password, boolean encryptPassword) {
        String encrypted;
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        String string = encrypted = encryptPassword ? RaidSystem.crypt(password) : password;
        if (user.equals("guest")) {
            this.setMonitoringPassword(encrypted);
        }
        if (user.equals("admin")) {
            ((AcpxMessageFactory)this.messageFactory).setDefaultUser(user);
            ((AcpxMessageFactory)this.messageFactory).setDefaultPassword(encrypted);
        }
        this.agent.authenticate(handler, user, encrypted);
    }

    public Response postMessage(RequestMessage message) throws IOException {
        return this.comms.postMessage(message);
    }

    public Response postMessage(RequestMessage message, int targetControllerId) throws IOException {
        message.setTargetController(RequestMessage.Target.getTarget(targetControllerId));
        return this.comms.postMessage(message);
    }

    public void postMessageAsync(CommunicationHandler handler, RequestMessage message) {
        this.postMessageAsync(handler, message, null);
    }

    public void postMessageAsync(CommunicationHandler handler, RequestMessage message, int targetId, Object context) {
        message.setTargetController(RequestMessage.Target.getTarget(targetId));
        this.postMessageAsync(handler, message, context);
    }

    public void postMessageAsync(CommunicationHandler handler, RequestMessage message, Object context) {
        this.comms.postMessageAsync(handler, message, context);
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void updateImmediately(boolean clearData) {
        if (this.isConnected() && !this.agent.isPolling()) {
            this.setUserMessageIndex(12);
            if (clearData) {
                this.clear();
            }
            this.agent.updateImmediately();
        }
    }

    public void setPollingEnabled(boolean enabled) {
        this.agent.setPollingEnabled(enabled);
    }

    public boolean isPollingEnabled() {
        return this.agent.isPollingEnabled();
    }

    public void setPollDelay(int seconds) {
        this.agent.setPollDelay(seconds);
    }

    public int getPollDelay() {
        return this.agent.getPollDelay();
    }

    public synchronized void waitForUpdate() throws InterruptedException {
        long start = System.currentTimeMillis();
        long waitTime = 300000L;
        this.pollStarted = false;
        this.pollFinished = false;
        while (true) {
            if (waitTime <= 0L) {
                throw new InterruptedException("Timed out waiting for update");
            }
            this.wait(waitTime);
            if (this.pollStarted && this.pollFinished) break;
            long now = System.currentTimeMillis();
            waitTime = 300000L - (now - start);
        }
    }

    public synchronized void waitForUpdateFinished() throws InterruptedException {
        long start = System.currentTimeMillis();
        long waitTime = 300000L;
        this.pollFinished = false;
        while (true) {
            if (waitTime <= 0L) {
                throw new InterruptedException("Timed out waiting for update to finish");
            }
            this.wait(waitTime);
            if (this.pollFinished) break;
            long now = System.currentTimeMillis();
            waitTime = 300000L - (now - start);
        }
        logger.info("waitForUpdateFinished: Poll cycle completed");
    }

    synchronized void notifyUpdateStarted() {
        this.pollStarted = true;
        this.notifyAll();
    }

    synchronized void notifyUpdateFinished() {
        this.pollFinished = true;
        this.notifyAll();
    }

    public void pollForRaidControllerOnline(int controllerId) throws InterruptedException {
        boolean online = false;
        long start = System.currentTimeMillis();
        long waitTime = 120000L;
        if (controllerId < 1 || controllerId > 2) {
            throw new IllegalArgumentException("Invalid RAID controller ID: " + controllerId);
        }
        RequestMessage request = this.getMessageFactory().newGetControllerPageRequest(AcpxConstants.CONTROLLER_PAGE_0);
        String monitoringUser = this.getMonitoringUserId();
        String monitoringPassword = this.getMonitoringPassword();
        if (monitoringUser != null && monitoringPassword != null) {
            request.setUser(monitoringUser);
            request.setPassword(monitoringPassword);
        }
        while (true) {
            long now;
            if ((waitTime = 120000L - ((now = System.currentTimeMillis()) - start)) <= 0L) {
                throw new InterruptedException("Timed out waiting for RAID controller " + controllerId + " to come online");
            }
            logger.info("Checking if RAID controller " + controllerId + " is online...");
            try {
                Response response = this.postMessage(request, controllerId);
                if (response.getResultCode() == 0) {
                    PropertyList plist = (PropertyList)response.getContent();
                    Map root = PListUtils.toDictionary(plist.getRootElement());
                    Map dict = PListUtils.toDictionary(root.get("get-page"));
                    online = PListUtils.toBoolean(dict.get("ready-state"));
                }
            }
            catch (Exception e) {
                logger.warn("While polling for RAID controller " + controllerId + " online: " + e);
            }
            if (online) break;
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        logger.info("RAID controller " + controllerId + " online.");
    }

    public synchronized void waitForRaidControllerOnline(int controller) throws InterruptedException {
        if (controller < 1 || controller > 2) {
            throw new IllegalArgumentException("Invalid RAID controller ID: " + controller);
        }
        long start = System.currentTimeMillis();
        long waitTime = 120000L;
        if (controller == 1) {
            this.waitingForTopRaidControllerOnline = true;
        } else {
            this.waitingForBottomRaidControllerOnline = true;
        }
        while (true) {
            if (waitTime <= 0L) {
                throw new InterruptedException("Timed out waiting for RAID controller to come online");
            }
            this.wait(waitTime);
            if (controller == 1 && !this.waitingForTopRaidControllerOnline || controller == 2 && !this.waitingForBottomRaidControllerOnline) break;
            long now = System.currentTimeMillis();
            waitTime = 120000L - (now - start);
        }
    }

    synchronized void notifyRaidControllerOnline(int controller) {
        if (controller == 1) {
            this.waitingForTopRaidControllerOnline = false;
        } else if (controller == 2) {
            this.waitingForBottomRaidControllerOnline = false;
        }
        this.notifyAll();
    }

    public synchronized void waitForRaidSetOnline(int raidControllerId, int raidSetId) throws InterruptedException {
        int status;
        RaidController raidController = this.getRaidController(raidControllerId);
        if (raidController == null) {
            throw new IllegalArgumentException("RAID controller " + raidControllerId + " does not exist");
        }
        long waitTime = 120000L;
        long start = System.currentTimeMillis();
        while (true) {
            if (waitTime <= 0L) {
                throw new InterruptedException("Timed out waiting for RAID set " + raidSetId + " to come online");
            }
            this.wait(waitTime);
            RaidSet raidSet = raidController.getRaidSet(raidSetId);
            if (raidSet != null) {
                status = raidSet.getStatus();
                if (status != 0 && status != 2) continue;
                break;
            }
            long now = System.currentTimeMillis();
            waitTime = 120000L - (now - start);
        }
        logger.info("waitForRaidSetOnline: RAID controller " + raidControllerId + " RAID set " + raidSetId + " is " + (status == 0 ? "online" : "degraded"));
    }

    synchronized void notifyRaidSetOnline(RaidSet raidSet) {
        this.notifyAll();
    }

    public int translateSliceId(int id, int module, int direction) {
        return this.translateId(id, module, direction, "1.2");
    }

    public int translateLunId(int id, int module, int direction) {
        return this.translateId(id, module, direction, "1.2");
    }

    private int translateId(int id, int module, int direction, String minVersion) {
        int result;
        block4: {
            String version;
            result = id;
            SystemController controller = this.getSystemController(module);
            if (controller == null || minVersion == null || minVersion.length() <= 0 || (version = controller.getSystemVersion()) == null) break block4;
            try {
                VersionNumber current = VersionNumber.newAppleVersionNumber(version);
                VersionNumber min = VersionNumber.newAppleVersionNumber(minVersion);
                if (current.compareTo(min) >= 0) break block4;
                if (direction == 0) {
                    result = id + 1;
                    break block4;
                }
                if (direction == 1) {
                    result = id - 1;
                    break block4;
                }
                throw new IllegalArgumentException("Unrecognized translation direction: " + direction);
            }
            catch (Exception exception) {
                logger.warn("Could not translate ID: " + id);
            }
        }
        return result;
    }

    public synchronized void clear() {
        this.loggedOn = false;
        this.totalCapacity = -1L;
        this.contact = "";
        this.description = "";
        this.location = "";
        this.serviceIdState = -1;
        this.lockState = -1;
        this.timeOffset = Long.MAX_VALUE;
        this.uptime = -1;
        this.autoRebootState = -1;
        this.audibleAlarmState = -1;
        this.upsStatus = -1;
        this.powerState = -1;
        this.eventLog = new EventLog();
        this.systemControllers.clear();
        int i = 1;
        while (i <= 2) {
            SystemController controller = new SystemController(i, this);
            this.systemControllers.put(new Integer(i), controller);
            ++i;
        }
        this.raidControllers.clear();
        int i2 = 1;
        while (i2 <= 2) {
            RaidController controller = new RaidController(i2, this);
            this.raidControllers.put(new Integer(i2), controller);
            ++i2;
        }
        this.powerSupplies.clear();
        int i3 = 1;
        while (i3 <= 2) {
            PowerSupply ps = new PowerSupply(i3);
            this.powerSupplies.put(new Integer(i3), ps);
            ++i3;
        }
        this.batteries.clear();
        this.fans.clear();
        int i4 = 1;
        while (i4 <= 2) {
            Fan fan = new Fan(i4);
            this.addFan(fan);
            ++i4;
        }
        this.setChanged();
    }

    public String paramString() {
        Iterator iter;
        String s = "";
        s = String.valueOf(s) + "name=" + this.name + ",";
        s = String.valueOf(s) + "primaryHostAddress=" + this.primaryHostAddress + ",";
        s = String.valueOf(s) + "secondaryHostAddress=" + this.secondaryHostAddress + ",";
        s = String.valueOf(s) + "currentAddress=" + this.currentAddress + ",";
        s = String.valueOf(s) + "monitoringPassword=" + this.monitoringPassword + ",";
        s = String.valueOf(s) + "managementPassword=" + this.managementPassword + ",";
        s = String.valueOf(s) + "loggedOn=" + this.loggedOn + ",";
        s = String.valueOf(s) + "powerState=" + this.powerState + ",";
        s = String.valueOf(s) + "totalCapacity=" + this.totalCapacity + ",";
        s = String.valueOf(s) + "contact=" + this.contact + ",";
        s = String.valueOf(s) + "description=" + this.description + ",";
        s = String.valueOf(s) + "location=" + this.location + ",";
        s = String.valueOf(s) + "serviceIdState=" + this.serviceIdState + ",";
        s = String.valueOf(s) + "lockState=" + this.lockState + ",";
        s = String.valueOf(s) + "timeOffset=" + this.timeOffset + ",";
        s = String.valueOf(s) + "uptime=" + this.uptime + ",";
        s = String.valueOf(s) + "autoRebootState=" + this.autoRebootState + ",";
        s = String.valueOf(s) + "audibleAlarmState=" + this.audibleAlarmState + ",";
        s = String.valueOf(s) + "upsStatus=" + this.upsStatus + ",";
        s = String.valueOf(s) + "powerState=" + this.powerState + ",";
        s = String.valueOf(s) + "userMessageIndex=" + this.userMessageIndex + ",";
        s = String.valueOf(s) + "userMessageIsAsync=" + this.userMessageIsAsync + ",";
        Collection c = this.systemControllers.values();
        Map map = this.systemControllers;
        synchronized (map) {
            iter = c.iterator();
            while (iter.hasNext()) {
                s = String.valueOf(s) + iter.next() + ",";
            }
        }
        c = this.raidControllers.values();
        map = this.raidControllers;
        synchronized (map) {
            iter = c.iterator();
            while (iter.hasNext()) {
                s = String.valueOf(s) + iter.next() + ",";
            }
        }
        c = this.powerSupplies.values();
        map = this.powerSupplies;
        synchronized (map) {
            iter = c.iterator();
            while (iter.hasNext()) {
                s = String.valueOf(s) + iter.next() + ",";
            }
        }
        c = this.batteries.values();
        map = this.batteries;
        synchronized (map) {
            iter = this.batteries.values().iterator();
            while (iter.hasNext()) {
                s = String.valueOf(s) + iter.next() + ",";
            }
        }
        c = this.fans.values();
        map = this.fans;
        synchronized (map) {
            iter = this.fans.values().iterator();
            while (iter.hasNext()) {
                s = String.valueOf(s) + iter.next();
                if (!iter.hasNext()) continue;
                s = String.valueOf(s) + ",";
            }
        }
        return s;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }

    public void setChanged() {
        super.setChanged();
        this.notifyObservers();
    }

    CommunicationsManager getCommunicationsManager() {
        return this.comms;
    }

    void updateGlobalRaidSetIdentifiers() {
        int id = 1;
        RaidSet[] sets = this.getRaidSets().toArray(new RaidSet[0]);
        int i = 0;
        while (i < sets.length) {
            RaidSet rs = sets[i];
            rs.setGlobalId(id++);
            ++i;
        }
    }

    private int getGeneralStatus(Collection c) {
        if (c.size() == 0) {
            return -1;
        }
        int generalStatus = -1;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof SystemElement)) {
                throw new ClassCastException("element " + o.getClass() + " not a SystemElement");
            }
            int status = ((SystemElement)o).getStatus();
            if (status == 0 && generalStatus == -1) {
                generalStatus = 0;
            }
            if (status == 1) {
                generalStatus = 1;
                continue;
            }
            if (status != 2) continue;
            generalStatus = 2;
            break;
        }
        return generalStatus;
    }

    private static int getRedundantComponentStatus(SystemElement componentOne, SystemElement componentTwo) {
        int statusOne = componentOne != null ? componentOne.getStatus() : -1;
        int statusTwo = componentTwo != null ? componentTwo.getStatus() : -1;
        if (statusOne == -1 || statusTwo == -1 || statusOne == 2 || statusTwo == 2) {
            return 2;
        }
        if (statusOne == 1 || statusTwo == 1) {
            return 1;
        }
        return 0;
    }

    private static String crypt(String source) {
        if (source == null) {
            throw new NullPointerException("source cannot be null");
        }
        byte[] bytes = SimpleCryptCoder.crypt(source.getBytes());
        return Base64Utilities.encode(bytes);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static /* synthetic */ int access$0(RaidSystem $0) {
        return $0.userMessageIndex;
    }

    static /* synthetic */ boolean access$2(RaidSystem $0) {
        return $0.userMessageIsAsync;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            RaidSystem.this.userMessageIndex = 0;
            RaidSystem.this.userMessageIsAsync = false;
            RaidSystem.this.setChanged();
        }

        /* synthetic */ 1() {
        }
    }
}

