/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.update;

import com.apple.gui.GUIFactory;
import com.apple.gui.IndeterminateProgressBar;
import com.apple.util.VersionNumber;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class FirmwareUpdatePane
extends JPanel {
    private static final boolean DEBUG = false;
    public static final String MODE_CONFIRM = "CONFIRM";
    public static final String MODE_UPDATE = "UPDATE";
    public static final String MODE_COMPLETE = "COMPLETE";
    public static final String ACTION_CMD_UPDATE = "ACTION_CMD_UPDATE";
    public static final String ACTION_CMD_CANCEL = "ACTION_CMD_CANCEL";
    public static final String ACTION_CMD_OK = "ACTION_CMD_OK";
    private static final int MIN_WIDTH = 350;
    private static final int MAX_NAME_DISPLAY_CHARS = 50;
    private static final String UNKNOWN = Resources.getString("componentStatus.unknown");
    private static final String STRING_UP_TO_DATE = Resources.getString("fwUpdate.upToDate");
    private static final String STRING_NEEDS_UPDATE = Resources.getString("fwUpdate.needsUpdate");
    private static final String STRING_VERSION_SEPARATOR = Resources.getString("fwUpdate.versionSeparator");
    private static final String STRING_MISMATCH = Resources.getString("fwUpdate.mismatch");
    private final int DYNAMIC_CONTENT_GRID_Y_OFFSET = 4;
    private JPanel updatePanel;
    private JPanel progressPanel;
    private JPanel completePanel;
    private JButton updateButton = GUIFactory.newButton(Resources.getString("fwUpdate.updateButton"));
    private JButton cancelButton = GUIFactory.newButton(Resources.getString("fwUpdate.cancelButton"));
    private JButton okButton = GUIFactory.newButton(Resources.getString("fwUpdate.dismissButton"));
    private JCheckBox updateAllCheckBox = GUIFactory.newCheckBox(Resources.getString("fwUpdate.updateAllCheckbox"));
    private JLabel nameLabel = new JLabel();
    private JLabel coprocessorVersionLabel = new JLabel();
    private JLabel raidControllerVersionLabel = new JLabel();
    private JLabel newCoprocessorVersionLabel = new JLabel();
    private JLabel newRaidControllerVersionLabel = new JLabel();
    private JLabel statusLabel = new JLabel();
    private JLabel completionLabel = new JLabel();
    private JTextPane errorMessage = GUIFactory.newTextPane();
    private boolean confirmCompsInitialized = false;
    private JLabel updateLabel;
    private JLabel newCoprocessorVersionTitle;
    private JLabel newRaidControllerVersionTitle;
    private Box buttonPanel;
    private JPanel restartRequiredPanel;
    private String mode = "CONFIRM";
    private String statusMessage = "";
    private boolean coprocessorNeedsUpdate;
    private boolean raidControllerNeedsUpdate;
    private static final int RT_MARGIN = 0;
    private static final int LT_MARGIN = 0;
    private static final int ICON_SIZE = 64;

    public FirmwareUpdatePane(String systemName) {
        ImageIcon icon = new ImageIcon(Resources.getImage("fwUpdate.icon"));
        if (icon.getIconWidth() != 64) {
            icon.setImage(icon.getImage().getScaledInstance(64, 64, 4));
        }
        this.init(icon, systemName);
    }

    public FirmwareUpdatePane(Icon icon, String systemName) {
        this.init(icon, systemName);
    }

    public void setMode(String mode) {
        if (this.mode == mode) {
            return;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        if (this.mode.equals(MODE_CONFIRM)) {
            this.updatePanel.remove(this.updateLabel);
            this.updatePanel.remove(this.newCoprocessorVersionTitle);
            this.updatePanel.remove(this.newCoprocessorVersionLabel);
            this.updatePanel.remove(this.newRaidControllerVersionTitle);
            this.updatePanel.remove(this.newRaidControllerVersionLabel);
            this.updatePanel.remove(this.updateAllCheckBox);
            this.updatePanel.remove(this.restartRequiredPanel);
            this.updatePanel.remove(this.buttonPanel);
        } else if (this.mode.equals(MODE_UPDATE)) {
            this.updatePanel.remove(this.progressPanel);
        } else if (this.mode.equals(MODE_COMPLETE)) {
            this.updatePanel.remove(this.completePanel);
        }
        if (mode.equals(MODE_CONFIRM)) {
            this.addConfirmModeComponents(this.updatePanel, 4, 10, 3, 5);
        } else if (mode.equals(MODE_UPDATE)) {
            if (this.progressPanel == null) {
                this.progressPanel = this.createProgressPanel();
            }
            this.updatePanel.add((Component)this.progressPanel, gbc);
        } else if (mode.equals(MODE_COMPLETE)) {
            if (this.completePanel == null) {
                this.completePanel = this.createCompletePanel();
            }
            this.updatePanel.add((Component)this.completePanel, gbc);
        }
        this.mode = mode;
        this.updateStatusLabel();
        this.validate();
    }

    public String getMode() {
        return this.mode;
    }

    public void setSystemName(String name) {
        this.nameLabel.setText(name);
    }

    public void setCurrentCoprocessorVersions(String top, String bottom) {
        if (top == null && bottom == null) {
            this.coprocessorVersionLabel.setText(UNKNOWN);
        } else if (top == null) {
            this.coprocessorVersionLabel.setText(String.valueOf(UNKNOWN) + STRING_VERSION_SEPARATOR + bottom);
        } else if (bottom == null) {
            this.coprocessorVersionLabel.setText(String.valueOf(top) + STRING_VERSION_SEPARATOR + UNKNOWN);
        } else if (top.equals(bottom)) {
            this.coprocessorVersionLabel.setText(top);
        } else {
            this.coprocessorVersionLabel.setText(String.valueOf(top) + STRING_VERSION_SEPARATOR + bottom);
        }
    }

    public void setCurrentCoprocessorVersions(VersionNumber top, VersionNumber bottom) {
        if (top == null && bottom == null) {
            this.coprocessorVersionLabel.setText(UNKNOWN);
        } else if (top == null) {
            this.coprocessorVersionLabel.setText(String.valueOf(UNKNOWN) + STRING_VERSION_SEPARATOR + bottom);
        } else if (bottom == null) {
            this.coprocessorVersionLabel.setText(String.valueOf(String.valueOf(top)) + STRING_VERSION_SEPARATOR + UNKNOWN);
        } else if (top.equals(bottom)) {
            this.coprocessorVersionLabel.setText(String.valueOf(String.valueOf(top)));
        } else {
            this.coprocessorVersionLabel.setText(String.valueOf(String.valueOf(top)) + STRING_VERSION_SEPARATOR + bottom);
        }
    }

    public void setCurrentRaidControllerVersions(String top, String bottom) {
        if (top == null && bottom == null) {
            this.raidControllerVersionLabel.setText(UNKNOWN);
        } else if (top == null) {
            this.raidControllerVersionLabel.setText(String.valueOf(UNKNOWN) + STRING_VERSION_SEPARATOR + bottom);
        } else if (bottom == null) {
            this.raidControllerVersionLabel.setText(String.valueOf(top) + STRING_VERSION_SEPARATOR + UNKNOWN);
        } else if (top.equals(bottom)) {
            this.raidControllerVersionLabel.setText(top);
        } else {
            this.raidControllerVersionLabel.setText(String.valueOf(top) + STRING_VERSION_SEPARATOR + bottom);
        }
    }

    public void setCurrentRaidControllerVersions(VersionNumber top, VersionNumber bottom) {
        if (top == null && bottom == null) {
            this.raidControllerVersionLabel.setText(UNKNOWN);
        } else if (top == null) {
            this.raidControllerVersionLabel.setText(String.valueOf(UNKNOWN) + STRING_VERSION_SEPARATOR + bottom);
        } else if (bottom == null) {
            this.raidControllerVersionLabel.setText(String.valueOf(String.valueOf(top)) + STRING_VERSION_SEPARATOR + UNKNOWN);
        } else if (top.equals(bottom)) {
            this.raidControllerVersionLabel.setText(String.valueOf(String.valueOf(top)));
        } else {
            this.raidControllerVersionLabel.setText(String.valueOf(String.valueOf(top)) + STRING_VERSION_SEPARATOR + bottom);
        }
    }

    public void setNewCoprocessorVersion(String version) {
        this.newCoprocessorVersionLabel.setText(version);
    }

    public void setNewRaidControllerVersion(String version) {
        this.newRaidControllerVersionLabel.setText(version);
    }

    public void setCoprocessorNeedsUpdate(boolean needsUpdate) {
        this.coprocessorNeedsUpdate = needsUpdate;
        this.validateUI();
    }

    public void setRaidControllerNeedsUpdate(boolean needsUpdate) {
        this.raidControllerNeedsUpdate = needsUpdate;
        this.validateUI();
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message;
        this.updateStatusLabel();
    }

    private void updateStatusLabel() {
        if (this.statusMessage == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.updateStatusLabelImpl();
        } else {
            try {
                EventQueue.invokeAndWait(new 1());
            }
            catch (Exception exception) {}
        }
    }

    private void updateStatusLabelImpl() {
        if (this.mode.equals(MODE_CONFIRM) || this.mode.equals(MODE_UPDATE)) {
            this.statusLabel.setText(this.statusMessage);
        } else if (this.mode.equals(MODE_COMPLETE)) {
            this.completionLabel.setText(this.statusMessage);
        }
    }

    public void setErrorMessage(String message) {
        if (EventQueue.isDispatchThread()) {
            this.setErrorMessageImpl(message);
        } else {
            try {
                EventQueue.invokeAndWait(new 2(message, this));
            }
            catch (Exception exception) {}
        }
    }

    private void setErrorMessageImpl(String message) {
        this.errorMessage.setVisible(message.length() > 0);
        this.errorMessage.setText(message);
    }

    public boolean isUpdateAllSelected() {
        return this.updateAllCheckBox.isSelected();
    }

    public JButton getUpdateButton() {
        return this.updateButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getDismissButton() {
        return this.okButton;
    }

    public JButton getDefaultButton() {
        if (this.mode.equals(MODE_CONFIRM)) {
            if (this.coprocessorNeedsUpdate || this.raidControllerNeedsUpdate) {
                return this.updateButton;
            }
            return this.cancelButton;
        }
        if (this.mode.equals(MODE_COMPLETE)) {
            return this.okButton;
        }
        return null;
    }

    public void addActionListener(ActionListener l) {
        this.updateButton.addActionListener(l);
        this.cancelButton.addActionListener(l);
        this.okButton.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.updateButton.removeActionListener(l);
        this.cancelButton.removeActionListener(l);
        this.okButton.removeActionListener(l);
    }

    private void validateUI() {
        if (!(this.coprocessorNeedsUpdate || this.raidControllerNeedsUpdate || this.updateAllCheckBox.isSelected())) {
            this.updateButton.setEnabled(false);
        } else {
            this.updateButton.setEnabled(true);
        }
    }

    private void init(Icon icon, String systemName) {
        this.setLayout(new BorderLayout(0, 0));
        this.updatePanel = this.createUpdatePanel(icon);
        this.add((Component)this.updatePanel, "North");
        if (systemName != null) {
            if (systemName.length() <= 50) {
                this.nameLabel.setText(systemName);
            } else {
                this.nameLabel.setText(String.valueOf(systemName.substring(0, 50)) + Resources.getString("ellipsis"));
            }
        }
    }

    private JPanel createUpdatePanel(Icon icon) {
        int cellSpace = 5;
        int rowSpace = 3;
        int tMargin = 10;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel updatePanel = GUIFactory.newPanel(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 0, 0);
        updatePanel.add(Box.createHorizontalStrut(350), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.gridheight = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 5, 5);
        JLabel iconLabel = new JLabel();
        if (icon != null) {
            iconLabel.setIcon(icon);
        }
        updatePanel.add((Component)iconLabel, gbc);
        JLabel nameTitle = new JLabel(Resources.getString("fwUpdate.systemNameTitle"));
        nameTitle.setFont(GUIFactory.FONT_SMALL);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.insets = new Insets(0, 5, 3, 5);
        updatePanel.add((Component)nameTitle, gbc);
        this.nameLabel.setFont(GUIFactory.FONT_SMALL);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 5, 3, 0);
        updatePanel.add((Component)this.nameLabel, gbc);
        JLabel coprocessorVersionTitle = new JLabel(Resources.getString("fwUpdate.coprocessorVersionTitle"), 4);
        coprocessorVersionTitle.setFont(GUIFactory.FONT_SMALL);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.insets = new Insets(3, 5, 3, 5);
        updatePanel.add((Component)coprocessorVersionTitle, gbc);
        this.coprocessorVersionLabel.setFont(GUIFactory.FONT_SMALL);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 5, 3, 0);
        updatePanel.add((Component)this.coprocessorVersionLabel, gbc);
        JLabel raidControllerVersionTitle = new JLabel(Resources.getString("fwUpdate.raidControllerVersionTitle"), 4);
        raidControllerVersionTitle.setFont(GUIFactory.FONT_SMALL);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.insets = new Insets(3, 5, 3, 5);
        updatePanel.add((Component)raidControllerVersionTitle, gbc);
        this.raidControllerVersionLabel.setFont(GUIFactory.FONT_SMALL);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 5, 3, 0);
        updatePanel.add((Component)this.raidControllerVersionLabel, gbc);
        this.addConfirmModeComponents(updatePanel, gbc.gridy, 10, 3, 5);
        return updatePanel;
    }

    private void addConfirmModeComponents(JPanel updatePanel, int beginY, int topMargin, int rowSpace, int cellSpace) {
        if (!this.confirmCompsInitialized) {
            this.updateLabel = new JLabel(Resources.getString("fwUpdate.updateLabel"));
            this.updateLabel.setFont(GUIFactory.FONT_SMALL);
            this.newCoprocessorVersionTitle = new JLabel(Resources.getString("fwUpdate.newCoprocessorVersionTitle"), 4);
            this.newCoprocessorVersionTitle.setFont(GUIFactory.FONT_SMALL);
            this.newCoprocessorVersionLabel.setFont(GUIFactory.FONT_SMALL);
            this.newRaidControllerVersionTitle = new JLabel(Resources.getString("fwUpdate.newRaidControllerVersionTitle"), 4);
            this.newRaidControllerVersionTitle.setFont(GUIFactory.FONT_SMALL);
            this.newRaidControllerVersionLabel.setFont(GUIFactory.FONT_SMALL);
            this.updateAllCheckBox.setFont(GUIFactory.FONT_SMALL);
            this.updateAllCheckBox.setHorizontalAlignment(2);
            this.updateAllCheckBox.setHorizontalTextPosition(4);
            this.updateAllCheckBox.addActionListener(new 3());
            this.restartRequiredPanel = this.createRestartRequiredPanel();
            this.buttonPanel = Box.createHorizontalBox();
            this.cancelButton.setActionCommand(ACTION_CMD_CANCEL);
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(Box.createHorizontalStrut(12));
            this.updateButton.setActionCommand(ACTION_CMD_UPDATE);
            this.buttonPanel.add(this.updateButton);
            this.confirmCompsInitialized = true;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = beginY;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(topMargin, 0, rowSpace, 0);
        updatePanel.add((Component)this.updateLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.insets = new Insets(rowSpace, 0, rowSpace, cellSpace);
        updatePanel.add((Component)this.newCoprocessorVersionTitle, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(rowSpace, cellSpace, rowSpace, 0);
        updatePanel.add((Component)this.newCoprocessorVersionLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.insets = new Insets(rowSpace, 0, rowSpace, cellSpace);
        updatePanel.add((Component)this.newRaidControllerVersionTitle, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(rowSpace, cellSpace, rowSpace, 0);
        updatePanel.add((Component)this.newRaidControllerVersionLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(topMargin, 0, rowSpace, 0);
        updatePanel.add((Component)this.updateAllCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 16;
        gbc.insets = new Insets(topMargin, 4, 0, 0);
        updatePanel.add((Component)this.restartRequiredPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(topMargin, 0, 0, 0);
        updatePanel.add((Component)this.buttonPanel, gbc);
    }

    private JPanel createProgressPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel progressPanel = GUIFactory.newPanel(gbl);
        int indent = 25;
        IndeterminateProgressBar progressBar = new IndeterminateProgressBar();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 25, 4, 25);
        progressPanel.add((Component)progressBar, gbc);
        gbc.fill = 0;
        this.statusLabel.setFont(GUIFactory.FONT_SMALL);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(4, 25, 10, 25);
        progressPanel.add((Component)this.statusLabel, gbc);
        return progressPanel;
    }

    private JPanel createCompletePanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel completePanel = GUIFactory.newPanel(gbl);
        this.completionLabel.setFont(GUIFactory.FONT_SMALL);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 11;
        gbc.insets = new Insets(10, 0, 0, 0);
        completePanel.add((Component)this.completionLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.fill = 3;
        this.errorMessage.setFont(GUIFactory.FONT_SMALL);
        this.errorMessage.setOpaque(false);
        this.errorMessage.setEditable(false);
        completePanel.add((Component)this.errorMessage, gbc);
        this.errorMessage.setVisible(this.errorMessage.getText() != null && this.errorMessage.getText().length() > 0);
        gbc.fill = 0;
        this.okButton.setActionCommand(ACTION_CMD_OK);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 12;
        gbc.insets = new Insets(10, 0, 0, 0);
        completePanel.add((Component)this.okButton, gbc);
        return completePanel;
    }

    private JPanel createRestartRequiredPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = GUIFactory.newPanel(gbl);
        JLabel restartIcon = new JLabel(new ImageIcon(Resources.getImage("icon.restart")));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 4);
        panel.add((Component)restartIcon, gbc);
        JLabel restartRequiredLabel = new JLabel(Resources.getString("fwUpdate.restartRequired"));
        restartRequiredLabel.setFont(GUIFactory.FONT_SMALL);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 0);
        panel.add((Component)restartRequiredLabel, gbc);
        JLabel warningIcon = new JLabel(new ImageIcon(Resources.getImage("icon.validate")));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 4);
        panel.add((Component)warningIcon, gbc);
        JLabel cannotBeStoppedLabel = new JLabel(Resources.getString("fwUpdate.operationCannotBeStopped"));
        cannotBeStoppedLabel.setFont(GUIFactory.FONT_SMALL);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)cannotBeStoppedLabel, gbc);
        return panel;
    }

    public static void main(String[] args) {
    }

    private final class 1
    extends Thread {
        public void run() {
            FirmwareUpdatePane.this.updateStatusLabelImpl();
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    extends Thread {
        private final /* synthetic */ FirmwareUpdatePane this$0;
        private final /* synthetic */ String val$message;

        public void run() {
            this.this$0.setErrorMessageImpl(this.val$message);
        }

        /* synthetic */ 2(String val$message, FirmwareUpdatePane this$0) {
            this.val$message = val$message;
            this.this$0 = this$0;
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FirmwareUpdatePane.this.validateUI();
        }

        /* synthetic */ 3() {
        }
    }

    private static final class 4
    implements ActionListener {
        private final /* synthetic */ AquaAlert val$dialog;
        private final /* synthetic */ JButton val$modeButton;
        private final /* synthetic */ FirmwareUpdatePane val$updatePane;

        public void actionPerformed(ActionEvent e) {
            String mode;
            String next = mode = e.getActionCommand();
            if (mode.equals(FirmwareUpdatePane.MODE_CONFIRM)) {
                next = FirmwareUpdatePane.MODE_UPDATE;
            } else if (mode.equals(FirmwareUpdatePane.MODE_UPDATE)) {
                next = FirmwareUpdatePane.MODE_COMPLETE;
                this.val$updatePane.setStatusMessage("Updating top RAID controller to 1.2.3...");
            } else if (mode.equals(FirmwareUpdatePane.MODE_COMPLETE)) {
                next = FirmwareUpdatePane.MODE_CONFIRM;
                this.val$updatePane.setStatusMessage("Firmware update complete.");
                boolean error = false;
                if (error) {
                    String err = Resources.getString("fwUpdate.statusMessage.restoreCache.failure");
                    this.val$updatePane.setErrorMessage(err);
                }
            }
            this.val$modeButton.setText("Switch to " + next + " Mode");
            this.val$modeButton.setActionCommand(next);
            this.val$updatePane.setMode(mode);
            this.val$dialog.resizeVertically(null, null);
        }

        /* synthetic */ 4(AquaAlert val$dialog, JButton val$modeButton, FirmwareUpdatePane val$updatePane) {
            this.val$dialog = val$dialog;
            this.val$modeButton = val$modeButton;
            this.val$updatePane = val$updatePane;
        }
    }
}

