/*
 * Decompiled with CFR 0.152.
 */
package com.chaotic.rendezvous;

import com.chaotic.rendezvous.BrowserListener;
import java.io.IOException;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;

public class Browser {
    public static final String DOMAIN_LOCAL = "local.";
    protected static JmDNS rendezvous = null;
    protected BrowserListener browserListener;
    protected Listener serviceListener = new Listener();

    public static synchronized JmDNS getRendezvous() throws IOException {
        if (rendezvous == null) {
            rendezvous = new JmDNS();
        }
        return rendezvous;
    }

    public Browser(BrowserListener inListener) {
        this.browserListener = inListener;
    }

    public void startServiceSearch(String inType, String inDomain) throws IOException {
        Browser browser = this;
        synchronized (browser) {
            this.stopServiceSearch();
            if (inDomain == null) {
                inDomain = DOMAIN_LOCAL;
            }
            Browser.getRendezvous().addServiceListener(String.valueOf(inType) + "." + inDomain, this.serviceListener);
        }
    }

    public void stopServiceSearch() throws IOException {
        Browser browser = this;
        synchronized (browser) {
            Browser.getRendezvous().removeServiceListener(this.serviceListener);
        }
    }

    protected final class Listener
    implements ServiceListener {
        public void addService(JmDNS inRendezvous, String inType, String inName) {
            Listener listener = this;
            synchronized (listener) {
                ServiceInfo info = new ServiceInfo(inType, inName, 0, "");
                Browser.this.browserListener.serviceAdded(Browser.this, info);
                info = inRendezvous.getServiceInfo(inType, inName);
                if (info != null) {
                    Browser.this.browserListener.serviceResolved(Browser.this, info);
                }
            }
        }

        public void removeService(JmDNS inRendezvous, String inType, String inName) {
            Listener listener = this;
            synchronized (listener) {
                ServiceInfo info = new ServiceInfo(inType, inName, 0, "");
                Browser.this.browserListener.serviceRemoved(Browser.this, info);
            }
        }

        public void resolveService(JmDNS inRendezvous, String inType, String inName, ServiceInfo inInfo) {
            Browser.this.browserListener.serviceResolved(Browser.this, inInfo);
        }

        protected Listener() {
        }
    }
}

