/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.jmdns.DNSCache;
import javax.jmdns.DNSConstants;
import javax.jmdns.DNSIncoming;
import javax.jmdns.DNSOutgoing;
import javax.jmdns.DNSQuestion;
import javax.jmdns.DNSRecord;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;

public class JmDNS
extends DNSConstants {
    public static String VERSION = "0.2";
    static int debug = Integer.parseInt(System.getProperty("jmdns.debug", "0"));
    InetAddress group;
    MulticastSocket socket;
    Vector listeners;
    Vector browsers;
    Vector typeListeners;
    DNSCache cache;
    Hashtable services;
    Thread shutdown;
    boolean done;
    boolean linklocal;
    boolean loopback;
    DNSRecord.Address host;
    Hashtable serviceTypes;

    public JmDNS() throws IOException {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.init(JmDNS.isLoopback(addr) ? null : addr, addr.getHostName());
        }
        catch (IOException iOException) {
            this.init(null, "computer");
        }
    }

    public JmDNS(InetAddress addr) throws IOException {
        this.init(addr, addr.getHostName());
    }

    void init(InetAddress intf, String name) throws IOException {
        long now;
        if (!name.endsWith(".")) {
            name = String.valueOf(name) + ".local.";
        }
        this.group = InetAddress.getByName("224.0.0.251");
        this.socket = new MulticastSocket(5353);
        if (intf != null) {
            this.socket.setInterface(intf);
        }
        this.socket.setTimeToLive(255);
        this.socket.joinGroup(this.group);
        this.loopback = JmDNS.isLoopback(intf);
        this.linklocal = JmDNS.isLinkLocal(intf);
        this.cache = new DNSCache(100);
        this.listeners = new Vector();
        this.browsers = new Vector();
        this.typeListeners = new Vector();
        this.services = new Hashtable(20);
        this.serviceTypes = new Hashtable(20);
        new Thread((Runnable)new SocketListener(), "JmDNS.SocketListener").start();
        new Thread((Runnable)new RecordReaper(), "JmDNS.RecordReaper").start();
        this.shutdown = new Thread((Runnable)new Shutdown(), "JmDNS.Shutdown");
        Runtime.getRuntime().addShutdownHook(this.shutdown);
        byte[] data = intf.getAddress();
        int ip = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        DNSRecord.Address host = new DNSRecord.Address(name, 1, 1, 3600, ip);
        long nextTime = now = System.currentTimeMillis();
        int i = 0;
        while (i < 3) {
            Iterator j = this.cache.find(host.name);
            while (j.hasNext()) {
                DNSRecord a = (DNSRecord)j.next();
                if (a.type != 1 || a.isExpired(now) || ((DNSRecord.Address)a).addr == ip) continue;
                String nm = host.name.substring(0, name.indexOf(46));
                try {
                    int l = nm.lastIndexOf(45);
                    int r = nm.lastIndexOf(46);
                    nm = l >= 0 && l < r ? String.valueOf(nm.substring(0, l)) + "-" + (Integer.parseInt(nm.substring(l + 1)) + 1) : String.valueOf(nm) + "-1";
                }
                catch (NumberFormatException numberFormatException) {
                    nm = String.valueOf(nm) + "-1";
                }
                host.name = String.valueOf(nm) + host.name.substring(name.indexOf(46));
                i = 0;
                break;
            }
            DNSOutgoing out = new DNSOutgoing(0);
            out.addQuestion(new DNSQuestion(host.name, 1, 1));
            out.addAuthorativeAnswer(host);
            this.send(out);
            ++i;
            if (now >= (nextTime += 175L)) continue;
            try {
                Thread.sleep(nextTime - now);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("init interrupted");
            }
            now = System.currentTimeMillis();
        }
        this.host = host;
    }

    static boolean isLoopback(InetAddress addr) {
        return addr != null && addr.getHostAddress().startsWith("127.0.0.1");
    }

    static boolean isLinkLocal(InetAddress addr) {
        return addr != null && addr.getHostAddress().startsWith("169.254.");
    }

    public InetAddress getInterface() throws IOException {
        return this.socket.getInterface();
    }

    public ServiceInfo getServiceInfo(String type, String name) {
        return this.getServiceInfo(type, name, 3000);
    }

    public ServiceInfo getServiceInfo(String type, String name, int timeout) {
        ServiceInfo info = new ServiceInfo(type, name);
        return info.request(this, timeout) ? info : null;
    }

    public void requestServiceInfo(String type, String name) {
        this.requestServiceInfo(type, name, 3000);
    }

    public void requestServiceInfo(String type, String name, int timeout) {
        this.registerServiceType(type);
        new Thread((Runnable)new ServiceResolver(new ServiceInfo(type, name), timeout), "JmDNS.ServiceResolver").start();
    }

    public void addServiceTypeListener(ServiceTypeListener listener) throws IOException {
        JmDNS jmDNS = this;
        synchronized (jmDNS) {
            this.removeServiceTypeListener(listener);
            this.typeListeners.addElement(listener);
            Enumeration e = this.serviceTypes.elements();
            while (e.hasMoreElements()) {
                listener.addServiceType(this, (String)e.nextElement());
            }
        }
        try {
            long now;
            long nextTime = now = System.currentTimeMillis();
            int i = 0;
            while (i < 3) {
                if (now < nextTime) {
                    Thread.sleep(nextTime - now);
                    now = System.currentTimeMillis();
                    continue;
                }
                DNSOutgoing out = new DNSOutgoing(0);
                out.addQuestion(new DNSQuestion("_services._mdns._udp.local.", 12, 1));
                Enumeration e = this.serviceTypes.elements();
                while (e.hasMoreElements()) {
                    out.addAnswer(new DNSRecord.Pointer("_services._mdns._udp.local.", 12, 1, 3600, (String)e.nextElement()), 0L);
                }
                this.send(out);
                ++i;
                nextTime += 225L;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("interrupted I/O");
        }
    }

    public synchronized void removeServiceTypeListener(ServiceTypeListener listener) {
        this.typeListeners.removeElement(listener);
    }

    public synchronized void addServiceListener(String type, ServiceListener listener) {
        this.removeServiceListener(listener);
        this.browsers.addElement(new ServiceBrowser(type, listener));
    }

    public synchronized void removeServiceListener(ServiceListener listener) {
        int i = this.browsers.size();
        while (i-- > 0) {
            ServiceBrowser browser = (ServiceBrowser)this.browsers.elementAt(i);
            if (browser.listener != listener) continue;
            this.browsers.removeElementAt(i);
            browser.close();
            return;
        }
    }

    public void registerService(ServiceInfo info) throws IOException {
        this.registerServiceType(info.type);
        info.server = this.host.name;
        info.addr = this.host.getInetAddress();
        try {
            long now;
            JmDNS jmDNS = this;
            synchronized (jmDNS) {
                this.checkService(info);
                this.services.put(info.name.toLowerCase(), info);
            }
            long nextTime = now = System.currentTimeMillis();
            int i = 0;
            while (i < 3) {
                if (now < nextTime) {
                    Thread.sleep(nextTime - now);
                    now = System.currentTimeMillis();
                    continue;
                }
                DNSOutgoing out = new DNSOutgoing(33792);
                out.addAnswer(new DNSRecord.Pointer(info.type, 12, 1, 3600, info.name), 0L);
                out.addAnswer(new DNSRecord.Service(info.name, 33, 1, 3600, info.priority, info.weight, info.port, this.host.name), 0L);
                out.addAnswer(new DNSRecord.Text(info.name, 16, 1, 3600, info.text), 0L);
                out.addAnswer(this.host, 0L);
                this.send(out);
                ++i;
                nextTime += 225L;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("interrupted I/O");
        }
    }

    public void unregisterService(ServiceInfo info) {
        try {
            long now;
            this.services.remove(info.name.toLowerCase());
            long nextTime = now = System.currentTimeMillis();
            int i = 0;
            while (i < 3) {
                if (now < nextTime) {
                    Thread.sleep(nextTime - now);
                    now = System.currentTimeMillis();
                    continue;
                }
                DNSOutgoing out = new DNSOutgoing(33792);
                out.addAnswer(new DNSRecord.Pointer(info.type, 12, 1, 0, info.name), 0L);
                out.addAnswer(new DNSRecord.Service(info.name, 33, 1, 0, info.priority, info.weight, info.port, this.host.name), 0L);
                out.addAnswer(new DNSRecord.Text(info.name, 16, 1, 0, info.text), 0L);
                this.send(out);
                ++i;
                nextTime += 125L;
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized void unregisterAllServices() {
        if (this.services.size() == 0) {
            return;
        }
        try {
            long now;
            long nextTime = now = System.currentTimeMillis();
            int i = 0;
            while (i < 3) {
                if (now < nextTime) {
                    Thread.sleep(nextTime - now);
                    now = System.currentTimeMillis();
                    continue;
                }
                DNSOutgoing out = new DNSOutgoing(33792);
                Enumeration e = this.services.elements();
                while (e.hasMoreElements()) {
                    ServiceInfo info = (ServiceInfo)e.nextElement();
                    out.addAnswer(new DNSRecord.Pointer(info.type, 12, 1, 0, info.name), 0L);
                    out.addAnswer(new DNSRecord.Service(info.name, 33, 1, 0, info.priority, info.weight, info.port, this.host.name), 0L);
                    out.addAnswer(new DNSRecord.Text(info.name, 16, 1, 0, info.text), 0L);
                }
                this.send(out);
                ++i;
                nextTime += 125L;
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized void registerServiceType(String type) {
        String name = type.toLowerCase();
        if (this.serviceTypes.get(name) == null && type.indexOf("._mdns._udp.") < 0 && !type.endsWith(".in-addr.arpa.")) {
            this.serviceTypes.put(name, type);
            Enumeration e = this.typeListeners.elements();
            while (e.hasMoreElements()) {
                ((ServiceTypeListener)e.nextElement()).addServiceType(this, type);
            }
        }
    }

    void checkService(ServiceInfo info) throws IOException, InterruptedException {
        long now;
        long nextTime = now = System.currentTimeMillis();
        int i = 0;
        while (i < 3) {
            Iterator j = this.cache.find(info.type);
            while (j.hasNext()) {
                DNSRecord a = (DNSRecord)j.next();
                if (a.type != 12 || a.isExpired(now) || !info.name.equals(((DNSRecord.Pointer)a).alias)) continue;
                String name = info.getName();
                try {
                    int l = name.lastIndexOf(91);
                    int r = name.lastIndexOf(93);
                    name = l >= 0 && l < r ? String.valueOf(name.substring(0, l)) + "[" + (Integer.parseInt(name.substring(l + 1, r)) + 1) + "]" : String.valueOf(name) + " [1]";
                }
                catch (NumberFormatException numberFormatException) {
                    name = String.valueOf(name) + " [1]";
                }
                info.name = String.valueOf(name) + "." + info.type;
                i = 0;
                break;
            }
            DNSOutgoing out = new DNSOutgoing(1024);
            out.addQuestion(new DNSQuestion(info.type, 12, 1));
            out.addAuthorativeAnswer(new DNSRecord.Pointer(info.type, 12, 1, 3600, info.name));
            this.send(out);
            ++i;
            if (now >= (nextTime += 175L)) continue;
            this.wait(nextTime - now);
            now = System.currentTimeMillis();
        }
    }

    synchronized void addListener(Listener listener, DNSQuestion question) {
        long now = System.currentTimeMillis();
        this.listeners.addElement(listener);
        if (question != null) {
            Iterator i = this.cache.find(question.name);
            while (i.hasNext()) {
                DNSRecord c = (DNSRecord)i.next();
                if (!question.answeredBy(c) || c.isExpired(now)) continue;
                listener.updateRecord(this, now, c);
            }
        }
        this.notifyAll();
    }

    synchronized void removeListener(Listener listener) {
        this.listeners.removeElement(listener);
        this.notifyAll();
    }

    synchronized void updateRecord(long now, DNSRecord rec) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            Listener listener = (Listener)e.nextElement();
            listener.updateRecord(this, now, rec);
        }
        this.notifyAll();
    }

    synchronized void handleResponse(DNSIncoming msg) throws IOException {
        long now = System.currentTimeMillis();
        Enumeration e = msg.answers.elements();
        block3: while (e.hasMoreElements()) {
            DNSRecord rec = (DNSRecord)e.nextElement();
            boolean expired = rec.isExpired(now);
            DNSRecord c = (DNSRecord)this.cache.get(rec);
            if (c != null) {
                if (expired) {
                    this.cache.remove(c);
                } else {
                    c.resetTTL(rec);
                    rec = c;
                }
            } else if (!expired) {
                this.cache.add(rec);
            }
            switch (rec.type) {
                case 12: {
                    if (rec.name.indexOf("._mdns._udp.") >= 0) {
                        if (expired || !rec.name.startsWith("_services._mdns._udp.")) continue block3;
                        this.registerServiceType(((DNSRecord.Pointer)rec).alias);
                        break;
                    }
                    this.registerServiceType(rec.name);
                }
                default: {
                    this.updateRecord(now, rec);
                }
            }
        }
    }

    DNSOutgoing addAnswer(DNSIncoming in, InetAddress addr, int port, DNSOutgoing out, DNSRecord rec) throws IOException {
        if (out == null) {
            out = new DNSOutgoing(33792);
        }
        try {
            out.addAnswer(in, rec);
        }
        catch (IOException iOException) {
            out.flags |= 0x200;
            out.id = in.id;
            out.finish();
            this.socket.send(new DatagramPacket(out.data, out.off, addr, port));
            out = new DNSOutgoing(33792);
            out.addAnswer(in, rec);
        }
        return out;
    }

    synchronized void handleQuery(DNSIncoming in, InetAddress addr, int port) throws IOException {
        Enumeration e;
        DNSOutgoing out = null;
        Vector<DNSRecord.Service> additionals = null;
        if (port != 5353) {
            out = new DNSOutgoing(33792, false);
            e = in.questions.elements();
            while (e.hasMoreElements()) {
                out.addQuestion((DNSQuestion)e.nextElement());
            }
        }
        e = in.questions.elements();
        block5: while (e.hasMoreElements()) {
            DNSQuestion q = (DNSQuestion)e.nextElement();
            switch (q.type) {
                case 1: {
                    if (this.host == null || !q.name.equals(this.host.name)) continue block5;
                    out = this.addAnswer(in, addr, port, out, this.host);
                    break;
                }
                case 12: {
                    this.registerServiceType(q.name);
                    Enumeration s = this.services.elements();
                    while (s.hasMoreElements()) {
                        ServiceInfo info = (ServiceInfo)s.nextElement();
                        if (!q.name.equals(info.type)) continue;
                        out = this.addAnswer(in, addr, port, out, new DNSRecord.Pointer(info.type, 12, 1, 3600, info.name));
                        if (additionals == null) {
                            additionals = new Vector<DNSRecord.Service>();
                            additionals.addElement((DNSRecord.Service)((Object)this.host));
                        }
                        additionals.addElement(new DNSRecord.Service(info.name, 33, 32769, 3600, info.priority, info.weight, info.port, this.host.name));
                        additionals.addElement((DNSRecord.Service)((Object)new DNSRecord.Text(info.name, 16, 32769, 3600, info.text)));
                    }
                    if (!q.name.equals("_services._mdns._udp.local.")) continue block5;
                    Enumeration t = this.serviceTypes.elements();
                    while (t.hasMoreElements()) {
                        out = this.addAnswer(in, addr, port, out, new DNSRecord.Pointer("_services._mdns._udp.local.", 12, 1, 3600, (String)t.nextElement()));
                    }
                    continue block5;
                }
                default: {
                    ServiceInfo info = (ServiceInfo)this.services.get(q.name.toLowerCase());
                    if (info == null) continue block5;
                    if (q.type == 33 || q.type == 255) {
                        out = this.addAnswer(in, addr, port, out, new DNSRecord.Service(q.name, 33, 32769, 3600, info.priority, info.weight, info.port, this.host.name));
                    }
                    if (q.type != 16 && q.type != 255) continue block5;
                    out = this.addAnswer(in, addr, port, out, new DNSRecord.Text(q.name, 16, 32769, 3600, info.text));
                }
            }
        }
        if (out != null && out.numAnswers > 0) {
            if (additionals != null) {
                Enumeration e2 = additionals.elements();
                while (e2.hasMoreElements()) {
                    out.addAdditionalAnswer(in, (DNSRecord)e2.nextElement());
                }
            }
            out.id = in.id;
            out.finish();
            this.socket.send(new DatagramPacket(out.data, out.off, addr, port));
        }
    }

    synchronized void send(DNSOutgoing out) throws IOException {
        out.finish();
        this.socket.send(new DatagramPacket(out.data, out.off, this.group, 5353));
    }

    public synchronized void close() {
        block3: {
            if (this.done) break block3;
            this.done = true;
            this.notifyAll();
            if (this.shutdown != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdown);
            }
            this.unregisterAllServices();
            try {
                this.socket.leaveGroup(this.group);
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    void print() {
        if (this.cache.count > 0) {
            System.out.println("---- cache ----");
            this.cache.print();
            System.out.println();
        }
    }

    static abstract class Listener
    extends DNSConstants {
        abstract void updateRecord(JmDNS var1, long var2, DNSRecord var4);

        Listener() {
        }
    }

    class SocketListener
    implements Runnable {
        public void run() {
            block9: {
                try {
                    byte[] buf = new byte[8972];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    while (!JmDNS.this.done) {
                        packet.setLength(buf.length);
                        JmDNS.this.socket.receive(packet);
                        if (!JmDNS.this.done) {
                            try {
                                InetAddress from = packet.getAddress();
                                if (JmDNS.this.linklocal != JmDNS.isLinkLocal(from) || JmDNS.this.loopback != JmDNS.isLoopback(from)) continue;
                                DNSIncoming msg = new DNSIncoming(packet);
                                if (debug > 0) {
                                    msg.print(debug > 1);
                                    System.out.println();
                                }
                                if (msg.isQuery()) {
                                    if (packet.getPort() != 5353) {
                                        JmDNS.this.handleQuery(msg, packet.getAddress(), packet.getPort());
                                    }
                                    JmDNS.this.handleQuery(msg, JmDNS.this.group, 5353);
                                    continue;
                                }
                                JmDNS.this.handleResponse(msg);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    if (JmDNS.this.done) break block9;
                    e.printStackTrace();
                }
            }
        }

        SocketListener() {
        }
    }

    class RecordReaper
    implements Runnable {
        public void run() {
            try {
                JmDNS jmDNS = JmDNS.this;
                synchronized (jmDNS) {
                    block5: while (true) {
                        JmDNS.this.wait(10000L);
                        if (JmDNS.this.done) {
                            Object var2_6 = null;
                            return;
                        }
                        long now = System.currentTimeMillis();
                        Iterator i = JmDNS.this.cache.all();
                        while (true) {
                            if (!i.hasNext()) continue block5;
                            DNSRecord c = (DNSRecord)i.next();
                            if (!c.isExpired(now)) continue;
                            JmDNS.this.updateRecord(now, c);
                            i.remove();
                        }
                        break;
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }

        RecordReaper() {
        }
    }

    class ServiceBrowser
    extends Listener
    implements Runnable {
        String type;
        ServiceListener listener;
        Hashtable services;
        long nextTime;
        int delay;
        boolean done;
        LinkedList list;

        ServiceBrowser(String type, ServiceListener listener) {
            this.type = type;
            this.listener = listener;
            this.services = new Hashtable();
            this.nextTime = System.currentTimeMillis();
            this.delay = 500;
            this.list = new LinkedList();
            JmDNS.this.addListener(this, new DNSQuestion(type, 12, 1));
            new Thread((Runnable)this, "JmDNS.ServiceBrowser: " + type).start();
        }

        void updateRecord(JmDNS jmdns, long now, DNSRecord rec) {
            if (rec.type == 12 && rec.name.equals(this.type)) {
                boolean expired = rec.isExpired(now);
                String name = ((DNSRecord.Pointer)rec).alias;
                DNSRecord old = (DNSRecord)this.services.get(name.toLowerCase());
                if (old == null && !expired) {
                    this.services.put(name.toLowerCase(), rec);
                    this.list.addLast(new 1(this, this, name));
                } else if (old != null && !expired) {
                    old.resetTTL(rec);
                } else if (old != null && expired) {
                    this.services.remove(name.toLowerCase());
                    this.list.addLast(new 2(this, this, name));
                    return;
                }
                long expires = rec.getExpirationTime(75);
                if (expires < this.nextTime) {
                    this.nextTime = rec.getExpirationTime(75);
                }
            }
        }

        public void run() {
            try {
                while (true) {
                    Event evt = null;
                    JmDNS jmDNS = JmDNS.this;
                    synchronized (jmDNS) {
                        long now = System.currentTimeMillis();
                        if (this.list.size() == 0 && this.nextTime > now) {
                            JmDNS.this.wait(this.nextTime - now);
                        }
                        if (this.done) {
                            Object var3_8 = null;
                            return;
                        }
                        now = System.currentTimeMillis();
                        if (this.nextTime <= now) {
                            DNSOutgoing out = new DNSOutgoing(0);
                            out.addQuestion(new DNSQuestion(this.type, 12, 1));
                            Enumeration e = this.services.elements();
                            while (e.hasMoreElements()) {
                                DNSRecord rec = (DNSRecord)e.nextElement();
                                if (rec.isExpired(now)) continue;
                                try {
                                    out.addAnswer(rec, now);
                                }
                                catch (IOException iOException) {
                                    break;
                                }
                            }
                            JmDNS.this.send(out);
                            this.nextTime = now + (long)this.delay;
                            this.delay = Math.min(20000, this.delay * 2);
                        }
                        if (this.list.size() > 0) {
                            evt = (Event)this.list.removeFirst();
                        }
                    }
                    if (evt == null) continue;
                    evt.send();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {}
        }

        void close() {
            JmDNS jmDNS = JmDNS.this;
            synchronized (jmDNS) {
                if (!this.done) {
                    this.done = true;
                    JmDNS.this.removeListener(this);
                }
            }
        }

        static /* synthetic */ JmDNS access$0(ServiceBrowser $0) {
            return $0.JmDNS.this;
        }

        abstract class Event {
            String name;

            Event(String name) {
                this.name = name;
            }

            abstract void send();
        }
    }

    class ServiceResolver
    implements Runnable {
        ServiceInfo info;
        int timeout;

        ServiceResolver(ServiceInfo info, int timeout) {
            this.info = info;
            this.timeout = timeout;
        }

        public void run() {
            ServiceInfo result = this.info;
            if (!this.info.request(JmDNS.this, this.timeout)) {
                result = null;
            }
            Enumeration e = JmDNS.this.browsers.elements();
            while (e.hasMoreElements()) {
                ServiceBrowser browser = (ServiceBrowser)e.nextElement();
                if (!browser.type.equalsIgnoreCase(this.info.type)) continue;
                browser.listener.resolveService(JmDNS.this, this.info.type, this.info.name, result);
            }
        }
    }

    class Shutdown
    implements Runnable {
        public void run() {
            JmDNS.this.shutdown = null;
            JmDNS.this.close();
        }

        Shutdown() {
        }
    }
}

